/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DialRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DialRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDialRequestBatchRequest
extends ConnectCampaignsRequest
implements ToCopyableBuilder<Builder, PutDialRequestBatchRequest> {
    private static final SdkField<List<DialRequest>> DIAL_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dialRequests").getter(PutDialRequestBatchRequest.getter(PutDialRequestBatchRequest::dialRequests)).setter(PutDialRequestBatchRequest.setter(Builder::dialRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DialRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(PutDialRequestBatchRequest.getter(PutDialRequestBatchRequest::id)).setter(PutDialRequestBatchRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIAL_REQUESTS_FIELD, ID_FIELD));
    private final List<DialRequest> dialRequests;
    private final String id;

    private PutDialRequestBatchRequest(BuilderImpl builder) {
        super(builder);
        this.dialRequests = builder.dialRequests;
        this.id = builder.id;
    }

    public final boolean hasDialRequests() {
        return this.dialRequests != null && !(this.dialRequests instanceof SdkAutoConstructList);
    }

    public final List<DialRequest> dialRequests() {
        return this.dialRequests;
    }

    public final String id() {
        return this.id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDialRequests() ? this.dialRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDialRequestBatchRequest)) {
            return false;
        }
        PutDialRequestBatchRequest other = (PutDialRequestBatchRequest)((Object)obj);
        return this.hasDialRequests() == other.hasDialRequests() && Objects.equals(this.dialRequests(), other.dialRequests()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"PutDialRequestBatchRequest").add("DialRequests", this.hasDialRequests() ? this.dialRequests() : null).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dialRequests": {
                return Optional.ofNullable(clazz.cast(this.dialRequests()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDialRequestBatchRequest, T> g) {
        return obj -> g.apply((PutDialRequestBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCampaignsRequest.BuilderImpl
    implements Builder {
        private List<DialRequest> dialRequests = DefaultSdkAutoConstructList.getInstance();
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDialRequestBatchRequest model) {
            super(model);
            this.dialRequests(model.dialRequests);
            this.id(model.id);
        }

        public final List<DialRequest.Builder> getDialRequests() {
            List<DialRequest.Builder> result = DialRequestListCopier.copyToBuilder(this.dialRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDialRequests(Collection<DialRequest.BuilderImpl> dialRequests) {
            this.dialRequests = DialRequestListCopier.copyFromBuilder(dialRequests);
        }

        @Override
        public final Builder dialRequests(Collection<DialRequest> dialRequests) {
            this.dialRequests = DialRequestListCopier.copy(dialRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dialRequests(DialRequest ... dialRequests) {
            this.dialRequests(Arrays.asList(dialRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dialRequests(Consumer<DialRequest.Builder> ... dialRequests) {
            this.dialRequests(Stream.of(dialRequests).map(c -> (DialRequest)((DialRequest.Builder)DialRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDialRequestBatchRequest build() {
            return new PutDialRequestBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCampaignsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDialRequestBatchRequest> {
        public Builder dialRequests(Collection<DialRequest> var1);

        public Builder dialRequests(DialRequest ... var1);

        public Builder dialRequests(Consumer<DialRequest.Builder> ... var1);

        public Builder id(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

