/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcampaigns.model.CampaignState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuccessfulCampaignStateResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuccessfulCampaignStateResponse> {
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("campaignId").getter(SuccessfulCampaignStateResponse.getter(SuccessfulCampaignStateResponse::campaignId)).setter(SuccessfulCampaignStateResponse.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(SuccessfulCampaignStateResponse.getter(SuccessfulCampaignStateResponse::stateAsString)).setter(SuccessfulCampaignStateResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ID_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String campaignId;
    private final String state;

    private SuccessfulCampaignStateResponse(BuilderImpl builder) {
        this.campaignId = builder.campaignId;
        this.state = builder.state;
    }

    public final String campaignId() {
        return this.campaignId;
    }

    public final CampaignState state() {
        return CampaignState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuccessfulCampaignStateResponse)) {
            return false;
        }
        SuccessfulCampaignStateResponse other = (SuccessfulCampaignStateResponse)obj;
        return Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SuccessfulCampaignStateResponse").add("CampaignId", (Object)this.campaignId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuccessfulCampaignStateResponse, T> g) {
        return obj -> g.apply((SuccessfulCampaignStateResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String campaignId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(SuccessfulCampaignStateResponse model) {
            this.campaignId(model.campaignId);
            this.state(model.state);
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public SuccessfulCampaignStateResponse build() {
            return new SuccessfulCampaignStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuccessfulCampaignStateResponse> {
        public Builder campaignId(String var1);

        public Builder state(String var1);

        public Builder state(CampaignState var1);
    }
}

