/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.DataTable;
import software.amazon.awssdk.services.connect.model.SearchDataTablesRequest;
import software.amazon.awssdk.services.connect.model.SearchDataTablesResponse;

public class SearchDataTablesPublisher
implements SdkPublisher<SearchDataTablesResponse> {
    private final ConnectAsyncClient client;
    private final SearchDataTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchDataTablesPublisher(ConnectAsyncClient client, SearchDataTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchDataTablesPublisher(ConnectAsyncClient client, SearchDataTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchDataTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchDataTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataTable> dataTables() {
        Function<SearchDataTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataTables() != null) {
                return response.dataTables().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchDataTablesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchDataTablesResponseFetcher
    implements AsyncPageFetcher<SearchDataTablesResponse> {
        private SearchDataTablesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDataTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchDataTablesResponse> nextPage(SearchDataTablesResponse previousPage) {
            if (previousPage == null) {
                return SearchDataTablesPublisher.this.client.searchDataTables(SearchDataTablesPublisher.this.firstRequest);
            }
            return SearchDataTablesPublisher.this.client.searchDataTables((SearchDataTablesRequest)((Object)SearchDataTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

