/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.connect.model.WorkspaceSummary;

public class ListWorkspacesIterable
implements SdkIterable<ListWorkspacesResponse> {
    private final ConnectClient client;
    private final ListWorkspacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkspacesIterable(ConnectClient client, ListWorkspacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkspacesResponseFetcher();
    }

    public Iterator<ListWorkspacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkspaceSummary> workspaceSummaryList() {
        Function<ListWorkspacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaceSummaryList() != null) {
                return response.workspaceSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkspacesResponseFetcher
    implements SyncPageFetcher<ListWorkspacesResponse> {
        private ListWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkspacesResponse nextPage(ListWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspacesIterable.this.client.listWorkspaces(ListWorkspacesIterable.this.firstRequest);
            }
            return ListWorkspacesIterable.this.client.listWorkspaces((ListWorkspacesRequest)((Object)ListWorkspacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

