/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.DataTableSummary;
import software.amazon.awssdk.services.connect.model.ListDataTablesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTablesResponse;

public class ListDataTablesIterable
implements SdkIterable<ListDataTablesResponse> {
    private final ConnectClient client;
    private final ListDataTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataTablesIterable(ConnectClient client, ListDataTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataTablesResponseFetcher();
    }

    public Iterator<ListDataTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataTableSummary> dataTableSummaryList() {
        Function<ListDataTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataTableSummaryList() != null) {
                return response.dataTableSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataTablesResponseFetcher
    implements SyncPageFetcher<ListDataTablesResponse> {
        private ListDataTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataTablesResponse nextPage(ListDataTablesResponse previousPage) {
            if (previousPage == null) {
                return ListDataTablesIterable.this.client.listDataTables(ListDataTablesIterable.this.firstRequest);
            }
            return ListDataTablesIterable.this.client.listDataTables((ListDataTablesRequest)((Object)ListDataTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

