/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.DataTableValueSummary;
import software.amazon.awssdk.services.connect.model.ListDataTableValuesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTableValuesResponse;

public class ListDataTableValuesIterable
implements SdkIterable<ListDataTableValuesResponse> {
    private final ConnectClient client;
    private final ListDataTableValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataTableValuesIterable(ConnectClient client, ListDataTableValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataTableValuesResponseFetcher();
    }

    public Iterator<ListDataTableValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataTableValueSummary> values() {
        Function<ListDataTableValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.values() != null) {
                return response.values().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataTableValuesResponseFetcher
    implements SyncPageFetcher<ListDataTableValuesResponse> {
        private ListDataTableValuesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataTableValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataTableValuesResponse nextPage(ListDataTableValuesResponse previousPage) {
            if (previousPage == null) {
                return ListDataTableValuesIterable.this.client.listDataTableValues(ListDataTableValuesIterable.this.firstRequest);
            }
            return ListDataTableValuesIterable.this.client.listDataTableValues((ListDataTableValuesRequest)((Object)ListDataTableValuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

