/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListDataTablePrimaryValuesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTablePrimaryValuesResponse;
import software.amazon.awssdk.services.connect.model.RecordPrimaryValue;

public class ListDataTablePrimaryValuesIterable
implements SdkIterable<ListDataTablePrimaryValuesResponse> {
    private final ConnectClient client;
    private final ListDataTablePrimaryValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataTablePrimaryValuesIterable(ConnectClient client, ListDataTablePrimaryValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataTablePrimaryValuesResponseFetcher();
    }

    public Iterator<ListDataTablePrimaryValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecordPrimaryValue> primaryValuesList() {
        Function<ListDataTablePrimaryValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.primaryValuesList() != null) {
                return response.primaryValuesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataTablePrimaryValuesResponseFetcher
    implements SyncPageFetcher<ListDataTablePrimaryValuesResponse> {
        private ListDataTablePrimaryValuesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataTablePrimaryValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataTablePrimaryValuesResponse nextPage(ListDataTablePrimaryValuesResponse previousPage) {
            if (previousPage == null) {
                return ListDataTablePrimaryValuesIterable.this.client.listDataTablePrimaryValues(ListDataTablePrimaryValuesIterable.this.firstRequest);
            }
            return ListDataTablePrimaryValuesIterable.this.client.listDataTablePrimaryValues((ListDataTablePrimaryValuesRequest)((Object)ListDataTablePrimaryValuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

