/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest;
import software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesResponse;

public class EvaluateDataTableValuesPublisher
implements SdkPublisher<EvaluateDataTableValuesResponse> {
    private final ConnectAsyncClient client;
    private final EvaluateDataTableValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public EvaluateDataTableValuesPublisher(ConnectAsyncClient client, EvaluateDataTableValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private EvaluateDataTableValuesPublisher(ConnectAsyncClient client, EvaluateDataTableValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new EvaluateDataTableValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super EvaluateDataTableValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class EvaluateDataTableValuesResponseFetcher
    implements AsyncPageFetcher<EvaluateDataTableValuesResponse> {
        private EvaluateDataTableValuesResponseFetcher() {
        }

        public boolean hasNextPage(EvaluateDataTableValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<EvaluateDataTableValuesResponse> nextPage(EvaluateDataTableValuesResponse previousPage) {
            if (previousPage == null) {
                return EvaluateDataTableValuesPublisher.this.client.evaluateDataTableValues(EvaluateDataTableValuesPublisher.this.firstRequest);
            }
            return EvaluateDataTableValuesPublisher.this.client.evaluateDataTableValues((EvaluateDataTableValuesRequest)((Object)EvaluateDataTableValuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

