/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.DataTableSummary;
import software.amazon.awssdk.services.connect.model.DataTableSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataTablesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListDataTablesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataTablesResponse.getter(ListDataTablesResponse::nextToken)).setter(ListDataTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<DataTableSummary>> DATA_TABLE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataTableSummaryList").getter(ListDataTablesResponse.getter(ListDataTablesResponse::dataTableSummaryList)).setter(ListDataTablesResponse.setter(Builder::dataTableSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataTableSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DATA_TABLE_SUMMARY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataTablesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DataTableSummary> dataTableSummaryList;

    private ListDataTablesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dataTableSummaryList = builder.dataTableSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDataTableSummaryList() {
        return this.dataTableSummaryList != null && !(this.dataTableSummaryList instanceof SdkAutoConstructList);
    }

    public final List<DataTableSummary> dataTableSummaryList() {
        return this.dataTableSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataTableSummaryList() ? this.dataTableSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataTablesResponse)) {
            return false;
        }
        ListDataTablesResponse other = (ListDataTablesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDataTableSummaryList() == other.hasDataTableSummaryList() && Objects.equals(this.dataTableSummaryList(), other.dataTableSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataTablesResponse").add("NextToken", (Object)this.nextToken()).add("DataTableSummaryList", this.hasDataTableSummaryList() ? this.dataTableSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DataTableSummaryList": {
                return Optional.ofNullable(clazz.cast(this.dataTableSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DataTableSummaryList", DATA_TABLE_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataTablesResponse, T> g) {
        return obj -> g.apply((ListDataTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DataTableSummary> dataTableSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataTablesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.dataTableSummaryList(model.dataTableSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DataTableSummary.Builder> getDataTableSummaryList() {
            List<DataTableSummary.Builder> result = DataTableSummaryListCopier.copyToBuilder(this.dataTableSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataTableSummaryList(Collection<DataTableSummary.BuilderImpl> dataTableSummaryList) {
            this.dataTableSummaryList = DataTableSummaryListCopier.copyFromBuilder(dataTableSummaryList);
        }

        @Override
        public final Builder dataTableSummaryList(Collection<DataTableSummary> dataTableSummaryList) {
            this.dataTableSummaryList = DataTableSummaryListCopier.copy(dataTableSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTableSummaryList(DataTableSummary ... dataTableSummaryList) {
            this.dataTableSummaryList(Arrays.asList(dataTableSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTableSummaryList(Consumer<DataTableSummary.Builder> ... dataTableSummaryList) {
            this.dataTableSummaryList(Stream.of(dataTableSummaryList).map(c -> (DataTableSummary)((DataTableSummary.Builder)DataTableSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDataTablesResponse build() {
            return new ListDataTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataTablesResponse> {
        public Builder nextToken(String var1);

        public Builder dataTableSummaryList(Collection<DataTableSummary> var1);

        public Builder dataTableSummaryList(DataTableSummary ... var1);

        public Builder dataTableSummaryList(Consumer<DataTableSummary.Builder> ... var1);
    }
}

