/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.EvaluationAnswerData;
import software.amazon.awssdk.services.connect.model.EvaluationQuestionAnswerAnalysisDetails;
import software.amazon.awssdk.services.connect.model.EvaluationQuestionAnswerAnalysisType;
import software.amazon.awssdk.services.connect.model.EvaluationQuestionInputDetails;
import software.amazon.awssdk.services.connect.model.EvaluationSuggestedAnswerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationSuggestedAnswer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationSuggestedAnswer> {
    private static final SdkField<EvaluationAnswerData> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(EvaluationSuggestedAnswer.getter(EvaluationSuggestedAnswer::value)).setter(EvaluationSuggestedAnswer.setter(Builder::value)).constructor(EvaluationAnswerData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EvaluationSuggestedAnswer.getter(EvaluationSuggestedAnswer::statusAsString)).setter(EvaluationSuggestedAnswer.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<EvaluationQuestionInputDetails> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(EvaluationSuggestedAnswer.getter(EvaluationSuggestedAnswer::input)).setter(EvaluationSuggestedAnswer.setter(Builder::input)).constructor(EvaluationQuestionInputDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisType").getter(EvaluationSuggestedAnswer.getter(EvaluationSuggestedAnswer::analysisTypeAsString)).setter(EvaluationSuggestedAnswer.setter(Builder::analysisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisType").build()}).build();
    private static final SdkField<EvaluationQuestionAnswerAnalysisDetails> ANALYSIS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalysisDetails").getter(EvaluationSuggestedAnswer.getter(EvaluationSuggestedAnswer::analysisDetails)).setter(EvaluationSuggestedAnswer.setter(Builder::analysisDetails)).constructor(EvaluationQuestionAnswerAnalysisDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, STATUS_FIELD, INPUT_FIELD, ANALYSIS_TYPE_FIELD, ANALYSIS_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationSuggestedAnswer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EvaluationAnswerData value;
    private final String status;
    private final EvaluationQuestionInputDetails input;
    private final String analysisType;
    private final EvaluationQuestionAnswerAnalysisDetails analysisDetails;

    private EvaluationSuggestedAnswer(BuilderImpl builder) {
        this.value = builder.value;
        this.status = builder.status;
        this.input = builder.input;
        this.analysisType = builder.analysisType;
        this.analysisDetails = builder.analysisDetails;
    }

    public final EvaluationAnswerData value() {
        return this.value;
    }

    public final EvaluationSuggestedAnswerStatus status() {
        return EvaluationSuggestedAnswerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final EvaluationQuestionInputDetails input() {
        return this.input;
    }

    public final EvaluationQuestionAnswerAnalysisType analysisType() {
        return EvaluationQuestionAnswerAnalysisType.fromValue(this.analysisType);
    }

    public final String analysisTypeAsString() {
        return this.analysisType;
    }

    public final EvaluationQuestionAnswerAnalysisDetails analysisDetails() {
        return this.analysisDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSuggestedAnswer)) {
            return false;
        }
        EvaluationSuggestedAnswer other = (EvaluationSuggestedAnswer)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.analysisTypeAsString(), other.analysisTypeAsString()) && Objects.equals(this.analysisDetails(), other.analysisDetails());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationSuggestedAnswer").add("Value", (Object)this.value()).add("Status", (Object)this.statusAsString()).add("Input", (Object)this.input()).add("AnalysisType", (Object)this.analysisTypeAsString()).add("AnalysisDetails", (Object)this.analysisDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "AnalysisType": {
                return Optional.ofNullable(clazz.cast(this.analysisTypeAsString()));
            }
            case "AnalysisDetails": {
                return Optional.ofNullable(clazz.cast(this.analysisDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("AnalysisType", ANALYSIS_TYPE_FIELD);
        map.put("AnalysisDetails", ANALYSIS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSuggestedAnswer, T> g) {
        return obj -> g.apply((EvaluationSuggestedAnswer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationAnswerData value;
        private String status;
        private EvaluationQuestionInputDetails input;
        private String analysisType;
        private EvaluationQuestionAnswerAnalysisDetails analysisDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSuggestedAnswer model) {
            this.value(model.value);
            this.status(model.status);
            this.input(model.input);
            this.analysisType(model.analysisType);
            this.analysisDetails(model.analysisDetails);
        }

        public final EvaluationAnswerData.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(EvaluationAnswerData.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(EvaluationAnswerData value) {
            this.value = value;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationSuggestedAnswerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final EvaluationQuestionInputDetails.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(EvaluationQuestionInputDetails.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(EvaluationQuestionInputDetails input) {
            this.input = input;
            return this;
        }

        public final String getAnalysisType() {
            return this.analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(EvaluationQuestionAnswerAnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final EvaluationQuestionAnswerAnalysisDetails.Builder getAnalysisDetails() {
            return this.analysisDetails != null ? this.analysisDetails.toBuilder() : null;
        }

        public final void setAnalysisDetails(EvaluationQuestionAnswerAnalysisDetails.BuilderImpl analysisDetails) {
            this.analysisDetails = analysisDetails != null ? analysisDetails.build() : null;
        }

        @Override
        public final Builder analysisDetails(EvaluationQuestionAnswerAnalysisDetails analysisDetails) {
            this.analysisDetails = analysisDetails;
            return this;
        }

        public EvaluationSuggestedAnswer build() {
            return new EvaluationSuggestedAnswer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationSuggestedAnswer> {
        public Builder value(EvaluationAnswerData var1);

        default public Builder value(Consumer<EvaluationAnswerData.Builder> value) {
            return this.value((EvaluationAnswerData)((EvaluationAnswerData.Builder)EvaluationAnswerData.builder().applyMutation(value)).build());
        }

        public Builder status(String var1);

        public Builder status(EvaluationSuggestedAnswerStatus var1);

        public Builder input(EvaluationQuestionInputDetails var1);

        default public Builder input(Consumer<EvaluationQuestionInputDetails.Builder> input) {
            return this.input((EvaluationQuestionInputDetails)((EvaluationQuestionInputDetails.Builder)EvaluationQuestionInputDetails.builder().applyMutation(input)).build());
        }

        public Builder analysisType(String var1);

        public Builder analysisType(EvaluationQuestionAnswerAnalysisType var1);

        public Builder analysisDetails(EvaluationQuestionAnswerAnalysisDetails var1);

        default public Builder analysisDetails(Consumer<EvaluationQuestionAnswerAnalysisDetails.Builder> analysisDetails) {
            return this.analysisDetails((EvaluationQuestionAnswerAnalysisDetails)((EvaluationQuestionAnswerAnalysisDetails.Builder)EvaluationQuestionAnswerAnalysisDetails.builder().applyMutation(analysisDetails)).build());
        }
    }
}

