/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionAutomation;
import software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionDisplayMode;
import software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionOption;
import software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormMultiSelectQuestionProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormMultiSelectQuestionProperties> {
    private static final SdkField<List<EvaluationFormMultiSelectQuestionOption>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(EvaluationFormMultiSelectQuestionProperties.getter(EvaluationFormMultiSelectQuestionProperties::options)).setter(EvaluationFormMultiSelectQuestionProperties.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormMultiSelectQuestionOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISPLAY_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayAs").getter(EvaluationFormMultiSelectQuestionProperties.getter(EvaluationFormMultiSelectQuestionProperties::displayAsAsString)).setter(EvaluationFormMultiSelectQuestionProperties.setter(Builder::displayAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayAs").build()}).build();
    private static final SdkField<EvaluationFormMultiSelectQuestionAutomation> AUTOMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Automation").getter(EvaluationFormMultiSelectQuestionProperties.getter(EvaluationFormMultiSelectQuestionProperties::automation)).setter(EvaluationFormMultiSelectQuestionProperties.setter(Builder::automation)).constructor(EvaluationFormMultiSelectQuestionAutomation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, DISPLAY_AS_FIELD, AUTOMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormMultiSelectQuestionProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EvaluationFormMultiSelectQuestionOption> options;
    private final String displayAs;
    private final EvaluationFormMultiSelectQuestionAutomation automation;

    private EvaluationFormMultiSelectQuestionProperties(BuilderImpl builder) {
        this.options = builder.options;
        this.displayAs = builder.displayAs;
        this.automation = builder.automation;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormMultiSelectQuestionOption> options() {
        return this.options;
    }

    public final EvaluationFormMultiSelectQuestionDisplayMode displayAs() {
        return EvaluationFormMultiSelectQuestionDisplayMode.fromValue(this.displayAs);
    }

    public final String displayAsAsString() {
        return this.displayAs;
    }

    public final EvaluationFormMultiSelectQuestionAutomation automation() {
        return this.automation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.displayAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.automation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormMultiSelectQuestionProperties)) {
            return false;
        }
        EvaluationFormMultiSelectQuestionProperties other = (EvaluationFormMultiSelectQuestionProperties)obj;
        return this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options()) && Objects.equals(this.displayAsAsString(), other.displayAsAsString()) && Objects.equals(this.automation(), other.automation());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormMultiSelectQuestionProperties").add("Options", this.hasOptions() ? this.options() : null).add("DisplayAs", (Object)this.displayAsAsString()).add("Automation", (Object)this.automation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "DisplayAs": {
                return Optional.ofNullable(clazz.cast(this.displayAsAsString()));
            }
            case "Automation": {
                return Optional.ofNullable(clazz.cast(this.automation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Options", OPTIONS_FIELD);
        map.put("DisplayAs", DISPLAY_AS_FIELD);
        map.put("Automation", AUTOMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormMultiSelectQuestionProperties, T> g) {
        return obj -> g.apply((EvaluationFormMultiSelectQuestionProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EvaluationFormMultiSelectQuestionOption> options = DefaultSdkAutoConstructList.getInstance();
        private String displayAs;
        private EvaluationFormMultiSelectQuestionAutomation automation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormMultiSelectQuestionProperties model) {
            this.options(model.options);
            this.displayAs(model.displayAs);
            this.automation(model.automation);
        }

        public final List<EvaluationFormMultiSelectQuestionOption.Builder> getOptions() {
            List<EvaluationFormMultiSelectQuestionOption.Builder> result = EvaluationFormMultiSelectQuestionOptionListCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<EvaluationFormMultiSelectQuestionOption.BuilderImpl> options) {
            this.options = EvaluationFormMultiSelectQuestionOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<EvaluationFormMultiSelectQuestionOption> options) {
            this.options = EvaluationFormMultiSelectQuestionOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(EvaluationFormMultiSelectQuestionOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<EvaluationFormMultiSelectQuestionOption.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (EvaluationFormMultiSelectQuestionOption)((EvaluationFormMultiSelectQuestionOption.Builder)EvaluationFormMultiSelectQuestionOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayAs() {
            return this.displayAs;
        }

        public final void setDisplayAs(String displayAs) {
            this.displayAs = displayAs;
        }

        @Override
        public final Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @Override
        public final Builder displayAs(EvaluationFormMultiSelectQuestionDisplayMode displayAs) {
            this.displayAs(displayAs == null ? null : displayAs.toString());
            return this;
        }

        public final EvaluationFormMultiSelectQuestionAutomation.Builder getAutomation() {
            return this.automation != null ? this.automation.toBuilder() : null;
        }

        public final void setAutomation(EvaluationFormMultiSelectQuestionAutomation.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        @Override
        public final Builder automation(EvaluationFormMultiSelectQuestionAutomation automation) {
            this.automation = automation;
            return this;
        }

        public EvaluationFormMultiSelectQuestionProperties build() {
            return new EvaluationFormMultiSelectQuestionProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormMultiSelectQuestionProperties> {
        public Builder options(Collection<EvaluationFormMultiSelectQuestionOption> var1);

        public Builder options(EvaluationFormMultiSelectQuestionOption ... var1);

        public Builder options(Consumer<EvaluationFormMultiSelectQuestionOption.Builder> ... var1);

        public Builder displayAs(String var1);

        public Builder displayAs(EvaluationFormMultiSelectQuestionDisplayMode var1);

        public Builder automation(EvaluationFormMultiSelectQuestionAutomation var1);

        default public Builder automation(Consumer<EvaluationFormMultiSelectQuestionAutomation.Builder> automation) {
            return this.automation((EvaluationFormMultiSelectQuestionAutomation)((EvaluationFormMultiSelectQuestionAutomation.Builder)EvaluationFormMultiSelectQuestionAutomation.builder().applyMutation(automation)).build());
        }
    }
}

