/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionAutomationOption;
import software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionAutomationOptionListCopier;
import software.amazon.awssdk.services.connect.model.EvaluationFormQuestionAutomationAnswerSource;
import software.amazon.awssdk.services.connect.model.ReferenceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormMultiSelectQuestionAutomation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormMultiSelectQuestionAutomation> {
    private static final SdkField<List<EvaluationFormMultiSelectQuestionAutomationOption>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(EvaluationFormMultiSelectQuestionAutomation.getter(EvaluationFormMultiSelectQuestionAutomation::options)).setter(EvaluationFormMultiSelectQuestionAutomation.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormMultiSelectQuestionAutomationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEFAULT_OPTION_REF_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultOptionRefIds").getter(EvaluationFormMultiSelectQuestionAutomation.getter(EvaluationFormMultiSelectQuestionAutomation::defaultOptionRefIds)).setter(EvaluationFormMultiSelectQuestionAutomation.setter(Builder::defaultOptionRefIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOptionRefIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EvaluationFormQuestionAutomationAnswerSource> ANSWER_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnswerSource").getter(EvaluationFormMultiSelectQuestionAutomation.getter(EvaluationFormMultiSelectQuestionAutomation::answerSource)).setter(EvaluationFormMultiSelectQuestionAutomation.setter(Builder::answerSource)).constructor(EvaluationFormQuestionAutomationAnswerSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, DEFAULT_OPTION_REF_IDS_FIELD, ANSWER_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormMultiSelectQuestionAutomation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EvaluationFormMultiSelectQuestionAutomationOption> options;
    private final List<String> defaultOptionRefIds;
    private final EvaluationFormQuestionAutomationAnswerSource answerSource;

    private EvaluationFormMultiSelectQuestionAutomation(BuilderImpl builder) {
        this.options = builder.options;
        this.defaultOptionRefIds = builder.defaultOptionRefIds;
        this.answerSource = builder.answerSource;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormMultiSelectQuestionAutomationOption> options() {
        return this.options;
    }

    public final boolean hasDefaultOptionRefIds() {
        return this.defaultOptionRefIds != null && !(this.defaultOptionRefIds instanceof SdkAutoConstructList);
    }

    public final List<String> defaultOptionRefIds() {
        return this.defaultOptionRefIds;
    }

    public final EvaluationFormQuestionAutomationAnswerSource answerSource() {
        return this.answerSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultOptionRefIds() ? this.defaultOptionRefIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.answerSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormMultiSelectQuestionAutomation)) {
            return false;
        }
        EvaluationFormMultiSelectQuestionAutomation other = (EvaluationFormMultiSelectQuestionAutomation)obj;
        return this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options()) && this.hasDefaultOptionRefIds() == other.hasDefaultOptionRefIds() && Objects.equals(this.defaultOptionRefIds(), other.defaultOptionRefIds()) && Objects.equals(this.answerSource(), other.answerSource());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormMultiSelectQuestionAutomation").add("Options", this.hasOptions() ? this.options() : null).add("DefaultOptionRefIds", this.hasDefaultOptionRefIds() ? this.defaultOptionRefIds() : null).add("AnswerSource", (Object)this.answerSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "DefaultOptionRefIds": {
                return Optional.ofNullable(clazz.cast(this.defaultOptionRefIds()));
            }
            case "AnswerSource": {
                return Optional.ofNullable(clazz.cast(this.answerSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Options", OPTIONS_FIELD);
        map.put("DefaultOptionRefIds", DEFAULT_OPTION_REF_IDS_FIELD);
        map.put("AnswerSource", ANSWER_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormMultiSelectQuestionAutomation, T> g) {
        return obj -> g.apply((EvaluationFormMultiSelectQuestionAutomation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EvaluationFormMultiSelectQuestionAutomationOption> options = DefaultSdkAutoConstructList.getInstance();
        private List<String> defaultOptionRefIds = DefaultSdkAutoConstructList.getInstance();
        private EvaluationFormQuestionAutomationAnswerSource answerSource;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormMultiSelectQuestionAutomation model) {
            this.options(model.options);
            this.defaultOptionRefIds(model.defaultOptionRefIds);
            this.answerSource(model.answerSource);
        }

        public final List<EvaluationFormMultiSelectQuestionAutomationOption.Builder> getOptions() {
            List<EvaluationFormMultiSelectQuestionAutomationOption.Builder> result = EvaluationFormMultiSelectQuestionAutomationOptionListCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<EvaluationFormMultiSelectQuestionAutomationOption.BuilderImpl> options) {
            this.options = EvaluationFormMultiSelectQuestionAutomationOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<EvaluationFormMultiSelectQuestionAutomationOption> options) {
            this.options = EvaluationFormMultiSelectQuestionAutomationOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(EvaluationFormMultiSelectQuestionAutomationOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<EvaluationFormMultiSelectQuestionAutomationOption.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (EvaluationFormMultiSelectQuestionAutomationOption)((EvaluationFormMultiSelectQuestionAutomationOption.Builder)EvaluationFormMultiSelectQuestionAutomationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDefaultOptionRefIds() {
            if (this.defaultOptionRefIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultOptionRefIds;
        }

        public final void setDefaultOptionRefIds(Collection<String> defaultOptionRefIds) {
            this.defaultOptionRefIds = ReferenceIdListCopier.copy(defaultOptionRefIds);
        }

        @Override
        public final Builder defaultOptionRefIds(Collection<String> defaultOptionRefIds) {
            this.defaultOptionRefIds = ReferenceIdListCopier.copy(defaultOptionRefIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultOptionRefIds(String ... defaultOptionRefIds) {
            this.defaultOptionRefIds(Arrays.asList(defaultOptionRefIds));
            return this;
        }

        public final EvaluationFormQuestionAutomationAnswerSource.Builder getAnswerSource() {
            return this.answerSource != null ? this.answerSource.toBuilder() : null;
        }

        public final void setAnswerSource(EvaluationFormQuestionAutomationAnswerSource.BuilderImpl answerSource) {
            this.answerSource = answerSource != null ? answerSource.build() : null;
        }

        @Override
        public final Builder answerSource(EvaluationFormQuestionAutomationAnswerSource answerSource) {
            this.answerSource = answerSource;
            return this;
        }

        public EvaluationFormMultiSelectQuestionAutomation build() {
            return new EvaluationFormMultiSelectQuestionAutomation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormMultiSelectQuestionAutomation> {
        public Builder options(Collection<EvaluationFormMultiSelectQuestionAutomationOption> var1);

        public Builder options(EvaluationFormMultiSelectQuestionAutomationOption ... var1);

        public Builder options(Consumer<EvaluationFormMultiSelectQuestionAutomationOption.Builder> ... var1);

        public Builder defaultOptionRefIds(Collection<String> var1);

        public Builder defaultOptionRefIds(String ... var1);

        public Builder answerSource(EvaluationFormQuestionAutomationAnswerSource var1);

        default public Builder answerSource(Consumer<EvaluationFormQuestionAutomationAnswerSource.Builder> answerSource) {
            return this.answerSource((EvaluationFormQuestionAutomationAnswerSource)((EvaluationFormQuestionAutomationAnswerSource.Builder)EvaluationFormQuestionAutomationAnswerSource.builder().applyMutation(answerSource)).build());
        }
    }
}

