/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EvaluationAnswerDataStringValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationAnswerData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationAnswerData> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StringValue").getter(EvaluationAnswerData.getter(EvaluationAnswerData::stringValue)).setter(EvaluationAnswerData.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()}).build();
    private static final SdkField<Double> NUMERIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("NumericValue").getter(EvaluationAnswerData.getter(EvaluationAnswerData::numericValue)).setter(EvaluationAnswerData.setter(Builder::numericValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericValue").build()}).build();
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringValues").getter(EvaluationAnswerData.getter(EvaluationAnswerData::stringValues)).setter(EvaluationAnswerData.setter(Builder::stringValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATE_TIME_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateTimeValue").getter(EvaluationAnswerData.getter(EvaluationAnswerData::dateTimeValue)).setter(EvaluationAnswerData.setter(Builder::dateTimeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeValue").build()}).build();
    private static final SdkField<Boolean> NOT_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NotApplicable").getter(EvaluationAnswerData.getter(EvaluationAnswerData::notApplicable)).setter(EvaluationAnswerData.setter(Builder::notApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotApplicable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD, NUMERIC_VALUE_FIELD, STRING_VALUES_FIELD, DATE_TIME_VALUE_FIELD, NOT_APPLICABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationAnswerData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final Double numericValue;
    private final List<String> stringValues;
    private final String dateTimeValue;
    private final Boolean notApplicable;
    private final Type type;

    private EvaluationAnswerData(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.numericValue = builder.numericValue;
        this.stringValues = builder.stringValues;
        this.dateTimeValue = builder.dateTimeValue;
        this.notApplicable = builder.notApplicable;
        this.type = builder.type;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final Double numericValue() {
        return this.numericValue;
    }

    public final boolean hasStringValues() {
        return this.stringValues != null && !(this.stringValues instanceof SdkAutoConstructList);
    }

    public final List<String> stringValues() {
        return this.stringValues;
    }

    public final String dateTimeValue() {
        return this.dateTimeValue;
    }

    public final Boolean notApplicable() {
        return this.notApplicable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringValues() ? this.stringValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dateTimeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.notApplicable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAnswerData)) {
            return false;
        }
        EvaluationAnswerData other = (EvaluationAnswerData)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.numericValue(), other.numericValue()) && this.hasStringValues() == other.hasStringValues() && Objects.equals(this.stringValues(), other.stringValues()) && Objects.equals(this.dateTimeValue(), other.dateTimeValue()) && Objects.equals(this.notApplicable(), other.notApplicable());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationAnswerData").add("StringValue", (Object)this.stringValue()).add("NumericValue", (Object)this.numericValue()).add("StringValues", this.hasStringValues() ? this.stringValues() : null).add("DateTimeValue", (Object)this.dateTimeValue()).add("NotApplicable", (Object)this.notApplicable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "NumericValue": {
                return Optional.ofNullable(clazz.cast(this.numericValue()));
            }
            case "StringValues": {
                return Optional.ofNullable(clazz.cast(this.stringValues()));
            }
            case "DateTimeValue": {
                return Optional.ofNullable(clazz.cast(this.dateTimeValue()));
            }
            case "NotApplicable": {
                return Optional.ofNullable(clazz.cast(this.notApplicable()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationAnswerData fromStringValue(String stringValue) {
        return (EvaluationAnswerData)EvaluationAnswerData.builder().stringValue(stringValue).build();
    }

    public static EvaluationAnswerData fromNumericValue(Double numericValue) {
        return (EvaluationAnswerData)EvaluationAnswerData.builder().numericValue(numericValue).build();
    }

    public static EvaluationAnswerData fromStringValues(List<String> stringValues) {
        return (EvaluationAnswerData)EvaluationAnswerData.builder().stringValues(stringValues).build();
    }

    public static EvaluationAnswerData fromDateTimeValue(String dateTimeValue) {
        return (EvaluationAnswerData)EvaluationAnswerData.builder().dateTimeValue(dateTimeValue).build();
    }

    public static EvaluationAnswerData fromNotApplicable(Boolean notApplicable) {
        return (EvaluationAnswerData)EvaluationAnswerData.builder().notApplicable(notApplicable).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringValue", STRING_VALUE_FIELD);
        map.put("NumericValue", NUMERIC_VALUE_FIELD);
        map.put("StringValues", STRING_VALUES_FIELD);
        map.put("DateTimeValue", DATE_TIME_VALUE_FIELD);
        map.put("NotApplicable", NOT_APPLICABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAnswerData, T> g) {
        return obj -> g.apply((EvaluationAnswerData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STRING_VALUE,
        NUMERIC_VALUE,
        STRING_VALUES,
        DATE_TIME_VALUE,
        NOT_APPLICABLE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private Double numericValue;
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();
        private String dateTimeValue;
        private Boolean notApplicable;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAnswerData model) {
            this.stringValue(model.stringValue);
            this.numericValue(model.numericValue);
            this.stringValues(model.stringValues);
            this.dateTimeValue(model.dateTimeValue);
            this.notApplicable(model.notApplicable);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Double getNumericValue() {
            return this.numericValue;
        }

        public final void setNumericValue(Double numericValue) {
            Double oldValue = this.numericValue;
            this.numericValue = numericValue;
            this.handleUnionValueChange(Type.NUMERIC_VALUE, oldValue, this.numericValue);
        }

        @Override
        public final Builder numericValue(Double numericValue) {
            Double oldValue = this.numericValue;
            this.numericValue = numericValue;
            this.handleUnionValueChange(Type.NUMERIC_VALUE, oldValue, this.numericValue);
            return this;
        }

        public final Collection<String> getStringValues() {
            if (this.stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            List<String> oldValue = this.stringValues;
            this.stringValues = EvaluationAnswerDataStringValueListCopier.copy(stringValues);
            this.handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            List<String> oldValue = this.stringValues;
            this.stringValues = EvaluationAnswerDataStringValueListCopier.copy(stringValues);
            this.handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String ... stringValues) {
            this.stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final String getDateTimeValue() {
            return this.dateTimeValue;
        }

        public final void setDateTimeValue(String dateTimeValue) {
            String oldValue = this.dateTimeValue;
            this.dateTimeValue = dateTimeValue;
            this.handleUnionValueChange(Type.DATE_TIME_VALUE, oldValue, this.dateTimeValue);
        }

        @Override
        public final Builder dateTimeValue(String dateTimeValue) {
            String oldValue = this.dateTimeValue;
            this.dateTimeValue = dateTimeValue;
            this.handleUnionValueChange(Type.DATE_TIME_VALUE, oldValue, this.dateTimeValue);
            return this;
        }

        public final Boolean getNotApplicable() {
            return this.notApplicable;
        }

        public final void setNotApplicable(Boolean notApplicable) {
            Boolean oldValue = this.notApplicable;
            this.notApplicable = notApplicable;
            this.handleUnionValueChange(Type.NOT_APPLICABLE, oldValue, this.notApplicable);
        }

        @Override
        public final Builder notApplicable(Boolean notApplicable) {
            Boolean oldValue = this.notApplicable;
            this.notApplicable = notApplicable;
            this.handleUnionValueChange(Type.NOT_APPLICABLE, oldValue, this.notApplicable);
            return this;
        }

        public EvaluationAnswerData build() {
            return new EvaluationAnswerData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationAnswerData> {
        public Builder stringValue(String var1);

        public Builder numericValue(Double var1);

        public Builder stringValues(Collection<String> var1);

        public Builder stringValues(String ... var1);

        public Builder dateTimeValue(String var1);

        public Builder notApplicable(Boolean var1);
    }
}

