/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.DataTableValueEvaluationSet;
import software.amazon.awssdk.services.connect.model.DataTableValueEvaluationSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateDataTableValuesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, EvaluateDataTableValuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(EvaluateDataTableValuesRequest.getter(EvaluateDataTableValuesRequest::instanceId)).setter(EvaluateDataTableValuesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableId").getter(EvaluateDataTableValuesRequest.getter(EvaluateDataTableValuesRequest::dataTableId)).setter(EvaluateDataTableValuesRequest.setter(Builder::dataTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()}).build();
    private static final SdkField<List<DataTableValueEvaluationSet>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(EvaluateDataTableValuesRequest.getter(EvaluateDataTableValuesRequest::values)).setter(EvaluateDataTableValuesRequest.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataTableValueEvaluationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZone").getter(EvaluateDataTableValuesRequest.getter(EvaluateDataTableValuesRequest::timeZone)).setter(EvaluateDataTableValuesRequest.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(EvaluateDataTableValuesRequest.getter(EvaluateDataTableValuesRequest::nextToken)).setter(EvaluateDataTableValuesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(EvaluateDataTableValuesRequest.getter(EvaluateDataTableValuesRequest::maxResults)).setter(EvaluateDataTableValuesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, DATA_TABLE_ID_FIELD, VALUES_FIELD, TIME_ZONE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluateDataTableValuesRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String dataTableId;
    private final List<DataTableValueEvaluationSet> values;
    private final String timeZone;
    private final String nextToken;
    private final Integer maxResults;

    private EvaluateDataTableValuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.values = builder.values;
        this.timeZone = builder.timeZone;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String dataTableId() {
        return this.dataTableId;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<DataTableValueEvaluationSet> values() {
        return this.values;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateDataTableValuesRequest)) {
            return false;
        }
        EvaluateDataTableValuesRequest other = (EvaluateDataTableValuesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.dataTableId(), other.dataTableId()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateDataTableValuesRequest").add("InstanceId", (Object)this.instanceId()).add("DataTableId", (Object)this.dataTableId()).add("Values", this.hasValues() ? this.values() : null).add("TimeZone", (Object)this.timeZone()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "DataTableId": {
                return Optional.ofNullable(clazz.cast(this.dataTableId()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateDataTableValuesRequest, T> g) {
        return obj -> g.apply((EvaluateDataTableValuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String dataTableId;
        private List<DataTableValueEvaluationSet> values = DefaultSdkAutoConstructList.getInstance();
        private String timeZone;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateDataTableValuesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.dataTableId(model.dataTableId);
            this.values(model.values);
            this.timeZone(model.timeZone);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return this.dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final List<DataTableValueEvaluationSet.Builder> getValues() {
            List<DataTableValueEvaluationSet.Builder> result = DataTableValueEvaluationSetListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<DataTableValueEvaluationSet.BuilderImpl> values) {
            this.values = DataTableValueEvaluationSetListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<DataTableValueEvaluationSet> values) {
            this.values = DataTableValueEvaluationSetListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(DataTableValueEvaluationSet ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<DataTableValueEvaluationSet.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (DataTableValueEvaluationSet)((DataTableValueEvaluationSet.Builder)DataTableValueEvaluationSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateDataTableValuesRequest build() {
            return new EvaluateDataTableValuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateDataTableValuesRequest> {
        public Builder instanceId(String var1);

        public Builder dataTableId(String var1);

        public Builder values(Collection<DataTableValueEvaluationSet> var1);

        public Builder values(DataTableValueEvaluationSet ... var1);

        public Builder values(Consumer<DataTableValueEvaluationSet.Builder> ... var1);

        public Builder timeZone(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

