/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.DataTableAttributeValueType;
import software.amazon.awssdk.services.connect.model.DataTableLockVersion;
import software.amazon.awssdk.services.connect.model.PrimaryValueResponse;
import software.amazon.awssdk.services.connect.model.PrimaryValuesResponseSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataTableValueSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataTableValueSummary> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordId").getter(DataTableValueSummary.getter(DataTableValueSummary::recordId)).setter(DataTableValueSummary.setter(Builder::recordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()}).build();
    private static final SdkField<String> ATTRIBUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeId").getter(DataTableValueSummary.getter(DataTableValueSummary::attributeId)).setter(DataTableValueSummary.setter(Builder::attributeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeId").build()}).build();
    private static final SdkField<List<PrimaryValueResponse>> PRIMARY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryValues").getter(DataTableValueSummary.getter(DataTableValueSummary::primaryValues)).setter(DataTableValueSummary.setter(Builder::primaryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrimaryValueResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(DataTableValueSummary.getter(DataTableValueSummary::attributeName)).setter(DataTableValueSummary.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(DataTableValueSummary.getter(DataTableValueSummary::valueTypeAsString)).setter(DataTableValueSummary.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(DataTableValueSummary.getter(DataTableValueSummary::value)).setter(DataTableValueSummary.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LockVersion").getter(DataTableValueSummary.getter(DataTableValueSummary::lockVersion)).setter(DataTableValueSummary.setter(Builder::lockVersion)).constructor(DataTableLockVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DataTableValueSummary.getter(DataTableValueSummary::lastModifiedTime)).setter(DataTableValueSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(DataTableValueSummary.getter(DataTableValueSummary::lastModifiedRegion)).setter(DataTableValueSummary.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD, ATTRIBUTE_ID_FIELD, PRIMARY_VALUES_FIELD, ATTRIBUTE_NAME_FIELD, VALUE_TYPE_FIELD, VALUE_FIELD, LOCK_VERSION_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataTableValueSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recordId;
    private final String attributeId;
    private final List<PrimaryValueResponse> primaryValues;
    private final String attributeName;
    private final String valueType;
    private final String value;
    private final DataTableLockVersion lockVersion;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private DataTableValueSummary(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.attributeId = builder.attributeId;
        this.primaryValues = builder.primaryValues;
        this.attributeName = builder.attributeName;
        this.valueType = builder.valueType;
        this.value = builder.value;
        this.lockVersion = builder.lockVersion;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String recordId() {
        return this.recordId;
    }

    public final String attributeId() {
        return this.attributeId;
    }

    public final boolean hasPrimaryValues() {
        return this.primaryValues != null && !(this.primaryValues instanceof SdkAutoConstructList);
    }

    public final List<PrimaryValueResponse> primaryValues() {
        return this.primaryValues;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final DataTableAttributeValueType valueType() {
        return DataTableAttributeValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public final String value() {
        return this.value;
    }

    public final DataTableLockVersion lockVersion() {
        return this.lockVersion;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryValues() ? this.primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableValueSummary)) {
            return false;
        }
        DataTableValueSummary other = (DataTableValueSummary)obj;
        return Objects.equals(this.recordId(), other.recordId()) && Objects.equals(this.attributeId(), other.attributeId()) && this.hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(this.primaryValues(), other.primaryValues()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.lockVersion(), other.lockVersion()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"DataTableValueSummary").add("RecordId", (Object)this.recordId()).add("AttributeId", (Object)this.attributeId()).add("PrimaryValues", this.hasPrimaryValues() ? this.primaryValues() : null).add("AttributeName", (Object)this.attributeName()).add("ValueType", (Object)this.valueTypeAsString()).add("Value", (Object)this.value()).add("LockVersion", (Object)this.lockVersion()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordId": {
                return Optional.ofNullable(clazz.cast(this.recordId()));
            }
            case "AttributeId": {
                return Optional.ofNullable(clazz.cast(this.attributeId()));
            }
            case "PrimaryValues": {
                return Optional.ofNullable(clazz.cast(this.primaryValues()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "LockVersion": {
                return Optional.ofNullable(clazz.cast(this.lockVersion()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("AttributeId", ATTRIBUTE_ID_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableValueSummary, T> g) {
        return obj -> g.apply((DataTableValueSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordId;
        private String attributeId;
        private List<PrimaryValueResponse> primaryValues = DefaultSdkAutoConstructList.getInstance();
        private String attributeName;
        private String valueType;
        private String value;
        private DataTableLockVersion lockVersion;
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableValueSummary model) {
            this.recordId(model.recordId);
            this.attributeId(model.attributeId);
            this.primaryValues(model.primaryValues);
            this.attributeName(model.attributeName);
            this.valueType(model.valueType);
            this.value(model.value);
            this.lockVersion(model.lockVersion);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getRecordId() {
            return this.recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final String getAttributeId() {
            return this.attributeId;
        }

        public final void setAttributeId(String attributeId) {
            this.attributeId = attributeId;
        }

        @Override
        public final Builder attributeId(String attributeId) {
            this.attributeId = attributeId;
            return this;
        }

        public final List<PrimaryValueResponse.Builder> getPrimaryValues() {
            List<PrimaryValueResponse.Builder> result = PrimaryValuesResponseSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValueResponse.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesResponseSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValueResponse> primaryValues) {
            this.primaryValues = PrimaryValuesResponseSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValueResponse ... primaryValues) {
            this.primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValueResponse.Builder> ... primaryValues) {
            this.primaryValues(Stream.of(primaryValues).map(c -> (PrimaryValueResponse)((PrimaryValueResponse.Builder)PrimaryValueResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DataTableAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return this.lockVersion != null ? this.lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public DataTableValueSummary build() {
            return new DataTableValueSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataTableValueSummary> {
        public Builder recordId(String var1);

        public Builder attributeId(String var1);

        public Builder primaryValues(Collection<PrimaryValueResponse> var1);

        public Builder primaryValues(PrimaryValueResponse ... var1);

        public Builder primaryValues(Consumer<PrimaryValueResponse.Builder> ... var1);

        public Builder attributeName(String var1);

        public Builder valueType(String var1);

        public Builder valueType(DataTableAttributeValueType var1);

        public Builder value(String var1);

        public Builder lockVersion(DataTableLockVersion var1);

        default public Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return this.lockVersion((DataTableLockVersion)((DataTableLockVersion.Builder)DataTableLockVersion.builder().applyMutation(lockVersion)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

