/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.DataTableAttributeValueType;
import software.amazon.awssdk.services.connect.model.DataTableLockVersion;
import software.amazon.awssdk.services.connect.model.Validation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataTableAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataTableAttribute> {
    private static final SdkField<String> ATTRIBUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeId").getter(DataTableAttribute.getter(DataTableAttribute::attributeId)).setter(DataTableAttribute.setter(Builder::attributeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataTableAttribute.getter(DataTableAttribute::name)).setter(DataTableAttribute.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(DataTableAttribute.getter(DataTableAttribute::valueTypeAsString)).setter(DataTableAttribute.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DataTableAttribute.getter(DataTableAttribute::description)).setter(DataTableAttribute.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableId").getter(DataTableAttribute.getter(DataTableAttribute::dataTableId)).setter(DataTableAttribute.setter(Builder::dataTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableId").build()}).build();
    private static final SdkField<String> DATA_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableArn").getter(DataTableAttribute.getter(DataTableAttribute::dataTableArn)).setter(DataTableAttribute.setter(Builder::dataTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableArn").build()}).build();
    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Primary").getter(DataTableAttribute.getter(DataTableAttribute::primary)).setter(DataTableAttribute.setter(Builder::primary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(DataTableAttribute.getter(DataTableAttribute::version)).setter(DataTableAttribute.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LockVersion").getter(DataTableAttribute.getter(DataTableAttribute::lockVersion)).setter(DataTableAttribute.setter(Builder::lockVersion)).constructor(DataTableLockVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DataTableAttribute.getter(DataTableAttribute::lastModifiedTime)).setter(DataTableAttribute.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(DataTableAttribute.getter(DataTableAttribute::lastModifiedRegion)).setter(DataTableAttribute.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final SdkField<Validation> VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Validation").getter(DataTableAttribute.getter(DataTableAttribute::validation)).setter(DataTableAttribute.setter(Builder::validation)).constructor(Validation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_ID_FIELD, NAME_FIELD, VALUE_TYPE_FIELD, DESCRIPTION_FIELD, DATA_TABLE_ID_FIELD, DATA_TABLE_ARN_FIELD, PRIMARY_FIELD, VERSION_FIELD, LOCK_VERSION_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD, VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataTableAttribute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeId;
    private final String name;
    private final String valueType;
    private final String description;
    private final String dataTableId;
    private final String dataTableArn;
    private final Boolean primary;
    private final String version;
    private final DataTableLockVersion lockVersion;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;
    private final Validation validation;

    private DataTableAttribute(BuilderImpl builder) {
        this.attributeId = builder.attributeId;
        this.name = builder.name;
        this.valueType = builder.valueType;
        this.description = builder.description;
        this.dataTableId = builder.dataTableId;
        this.dataTableArn = builder.dataTableArn;
        this.primary = builder.primary;
        this.version = builder.version;
        this.lockVersion = builder.lockVersion;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.validation = builder.validation;
    }

    public final String attributeId() {
        return this.attributeId;
    }

    public final String name() {
        return this.name;
    }

    public final DataTableAttributeValueType valueType() {
        return DataTableAttributeValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public final String description() {
        return this.description;
    }

    public final String dataTableId() {
        return this.dataTableId;
    }

    public final String dataTableArn() {
        return this.dataTableArn;
    }

    public final Boolean primary() {
        return this.primary;
    }

    public final String version() {
        return this.version;
    }

    public final DataTableLockVersion lockVersion() {
        return this.lockVersion;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public final Validation validation() {
        return this.validation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.primary());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.validation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableAttribute)) {
            return false;
        }
        DataTableAttribute other = (DataTableAttribute)obj;
        return Objects.equals(this.attributeId(), other.attributeId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dataTableId(), other.dataTableId()) && Objects.equals(this.dataTableArn(), other.dataTableArn()) && Objects.equals(this.primary(), other.primary()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.lockVersion(), other.lockVersion()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion()) && Objects.equals(this.validation(), other.validation());
    }

    public final String toString() {
        return ToString.builder((String)"DataTableAttribute").add("AttributeId", (Object)this.attributeId()).add("Name", (Object)this.name()).add("ValueType", (Object)this.valueTypeAsString()).add("Description", (Object)this.description()).add("DataTableId", (Object)this.dataTableId()).add("DataTableArn", (Object)this.dataTableArn()).add("Primary", (Object)this.primary()).add("Version", (Object)this.version()).add("LockVersion", (Object)this.lockVersion()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).add("Validation", (Object)this.validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeId": {
                return Optional.ofNullable(clazz.cast(this.attributeId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DataTableId": {
                return Optional.ofNullable(clazz.cast(this.dataTableId()));
            }
            case "DataTableArn": {
                return Optional.ofNullable(clazz.cast(this.dataTableArn()));
            }
            case "Primary": {
                return Optional.ofNullable(clazz.cast(this.primary()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "LockVersion": {
                return Optional.ofNullable(clazz.cast(this.lockVersion()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
            case "Validation": {
                return Optional.ofNullable(clazz.cast(this.validation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttributeId", ATTRIBUTE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("DataTableArn", DATA_TABLE_ARN_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("Validation", VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableAttribute, T> g) {
        return obj -> g.apply((DataTableAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeId;
        private String name;
        private String valueType;
        private String description;
        private String dataTableId;
        private String dataTableArn;
        private Boolean primary;
        private String version;
        private DataTableLockVersion lockVersion;
        private Instant lastModifiedTime;
        private String lastModifiedRegion;
        private Validation validation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableAttribute model) {
            this.attributeId(model.attributeId);
            this.name(model.name);
            this.valueType(model.valueType);
            this.description(model.description);
            this.dataTableId(model.dataTableId);
            this.dataTableArn(model.dataTableArn);
            this.primary(model.primary);
            this.version(model.version);
            this.lockVersion(model.lockVersion);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
            this.validation(model.validation);
        }

        public final String getAttributeId() {
            return this.attributeId;
        }

        public final void setAttributeId(String attributeId) {
            this.attributeId = attributeId;
        }

        @Override
        public final Builder attributeId(String attributeId) {
            this.attributeId = attributeId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DataTableAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDataTableId() {
            return this.dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final String getDataTableArn() {
            return this.dataTableArn;
        }

        public final void setDataTableArn(String dataTableArn) {
            this.dataTableArn = dataTableArn;
        }

        @Override
        public final Builder dataTableArn(String dataTableArn) {
            this.dataTableArn = dataTableArn;
            return this;
        }

        public final Boolean getPrimary() {
            return this.primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return this.lockVersion != null ? this.lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Validation.Builder getValidation() {
            return this.validation != null ? this.validation.toBuilder() : null;
        }

        public final void setValidation(Validation.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public final Builder validation(Validation validation) {
            this.validation = validation;
            return this;
        }

        public DataTableAttribute build() {
            return new DataTableAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataTableAttribute> {
        public Builder attributeId(String var1);

        public Builder name(String var1);

        public Builder valueType(String var1);

        public Builder valueType(DataTableAttributeValueType var1);

        public Builder description(String var1);

        public Builder dataTableId(String var1);

        public Builder dataTableArn(String var1);

        public Builder primary(Boolean var1);

        public Builder version(String var1);

        public Builder lockVersion(DataTableLockVersion var1);

        default public Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return this.lockVersion((DataTableLockVersion)((DataTableLockVersion.Builder)DataTableLockVersion.builder().applyMutation(lockVersion)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);

        public Builder validation(Validation var1);

        default public Builder validation(Consumer<Validation.Builder> validation) {
            return this.validation((Validation)((Validation.Builder)Validation.builder().applyMutation(validation)).build());
        }
    }
}

