/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleState;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleStatus;
import software.amazon.awssdk.services.connect.model.ExternalInvocationConfiguration;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactFlowModule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactFlowModule> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ContactFlowModule.getter(ContactFlowModule::arn)).setter(ContactFlowModule.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ContactFlowModule.getter(ContactFlowModule::id)).setter(ContactFlowModule.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ContactFlowModule.getter(ContactFlowModule::name)).setter(ContactFlowModule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(ContactFlowModule.getter(ContactFlowModule::content)).setter(ContactFlowModule.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ContactFlowModule.getter(ContactFlowModule::description)).setter(ContactFlowModule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ContactFlowModule.getter(ContactFlowModule::stateAsString)).setter(ContactFlowModule.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ContactFlowModule.getter(ContactFlowModule::statusAsString)).setter(ContactFlowModule.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ContactFlowModule.getter(ContactFlowModule::tags)).setter(ContactFlowModule.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FLOW_MODULE_CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowModuleContentSha256").getter(ContactFlowModule.getter(ContactFlowModule::flowModuleContentSha256)).setter(ContactFlowModule.setter(Builder::flowModuleContentSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowModuleContentSha256").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(ContactFlowModule.getter(ContactFlowModule::version)).setter(ContactFlowModule.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(ContactFlowModule.getter(ContactFlowModule::versionDescription)).setter(ContactFlowModule.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<String> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Settings").getter(ContactFlowModule.getter(ContactFlowModule::settings)).setter(ContactFlowModule.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<ExternalInvocationConfiguration> EXTERNAL_INVOCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExternalInvocationConfiguration").getter(ContactFlowModule.getter(ContactFlowModule::externalInvocationConfiguration)).setter(ContactFlowModule.setter(Builder::externalInvocationConfiguration)).constructor(ExternalInvocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalInvocationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, CONTENT_FIELD, DESCRIPTION_FIELD, STATE_FIELD, STATUS_FIELD, TAGS_FIELD, FLOW_MODULE_CONTENT_SHA256_FIELD, VERSION_FIELD, VERSION_DESCRIPTION_FIELD, SETTINGS_FIELD, EXTERNAL_INVOCATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactFlowModule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String name;
    private final String content;
    private final String description;
    private final String state;
    private final String status;
    private final Map<String, String> tags;
    private final String flowModuleContentSha256;
    private final Long version;
    private final String versionDescription;
    private final String settings;
    private final ExternalInvocationConfiguration externalInvocationConfiguration;

    private ContactFlowModule(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.content = builder.content;
        this.description = builder.description;
        this.state = builder.state;
        this.status = builder.status;
        this.tags = builder.tags;
        this.flowModuleContentSha256 = builder.flowModuleContentSha256;
        this.version = builder.version;
        this.versionDescription = builder.versionDescription;
        this.settings = builder.settings;
        this.externalInvocationConfiguration = builder.externalInvocationConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String content() {
        return this.content;
    }

    public final String description() {
        return this.description;
    }

    public final ContactFlowModuleState state() {
        return ContactFlowModuleState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final ContactFlowModuleStatus status() {
        return ContactFlowModuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String flowModuleContentSha256() {
        return this.flowModuleContentSha256;
    }

    public final Long version() {
        return this.version;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final String settings() {
        return this.settings;
    }

    public final ExternalInvocationConfiguration externalInvocationConfiguration() {
        return this.externalInvocationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.flowModuleContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalInvocationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowModule)) {
            return false;
        }
        ContactFlowModule other = (ContactFlowModule)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.flowModuleContentSha256(), other.flowModuleContentSha256()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.externalInvocationConfiguration(), other.externalInvocationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ContactFlowModule").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Content", (Object)this.content()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("FlowModuleContentSha256", (Object)this.flowModuleContentSha256()).add("Version", (Object)this.version()).add("VersionDescription", (Object)this.versionDescription()).add("Settings", (Object)this.settings()).add("ExternalInvocationConfiguration", (Object)this.externalInvocationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FlowModuleContentSha256": {
                return Optional.ofNullable(clazz.cast(this.flowModuleContentSha256()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "ExternalInvocationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.externalInvocationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("FlowModuleContentSha256", FLOW_MODULE_CONTENT_SHA256_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("ExternalInvocationConfiguration", EXTERNAL_INVOCATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowModule, T> g) {
        return obj -> g.apply((ContactFlowModule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String content;
        private String description;
        private String state;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String flowModuleContentSha256;
        private Long version;
        private String versionDescription;
        private String settings;
        private ExternalInvocationConfiguration externalInvocationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowModule model) {
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.content(model.content);
            this.description(model.description);
            this.state(model.state);
            this.status(model.status);
            this.tags(model.tags);
            this.flowModuleContentSha256(model.flowModuleContentSha256);
            this.version(model.version);
            this.versionDescription(model.versionDescription);
            this.settings(model.settings);
            this.externalInvocationConfiguration(model.externalInvocationConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ContactFlowModuleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContactFlowModuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getFlowModuleContentSha256() {
            return this.flowModuleContentSha256;
        }

        public final void setFlowModuleContentSha256(String flowModuleContentSha256) {
            this.flowModuleContentSha256 = flowModuleContentSha256;
        }

        @Override
        public final Builder flowModuleContentSha256(String flowModuleContentSha256) {
            this.flowModuleContentSha256 = flowModuleContentSha256;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final String getSettings() {
            return this.settings;
        }

        public final void setSettings(String settings) {
            this.settings = settings;
        }

        @Override
        @Transient
        public final Builder settings(String settings) {
            this.settings = settings;
            return this;
        }

        public final ExternalInvocationConfiguration.Builder getExternalInvocationConfiguration() {
            return this.externalInvocationConfiguration != null ? this.externalInvocationConfiguration.toBuilder() : null;
        }

        public final void setExternalInvocationConfiguration(ExternalInvocationConfiguration.BuilderImpl externalInvocationConfiguration) {
            this.externalInvocationConfiguration = externalInvocationConfiguration != null ? externalInvocationConfiguration.build() : null;
        }

        @Override
        public final Builder externalInvocationConfiguration(ExternalInvocationConfiguration externalInvocationConfiguration) {
            this.externalInvocationConfiguration = externalInvocationConfiguration;
            return this;
        }

        public ContactFlowModule build() {
            return new ContactFlowModule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactFlowModule> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder content(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(ContactFlowModuleState var1);

        public Builder status(String var1);

        public Builder status(ContactFlowModuleStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder flowModuleContentSha256(String var1);

        public Builder version(Long var1);

        public Builder versionDescription(String var1);

        public Builder settings(String var1);

        public Builder externalInvocationConfiguration(ExternalInvocationConfiguration var1);

        default public Builder externalInvocationConfiguration(Consumer<ExternalInvocationConfiguration.Builder> externalInvocationConfiguration) {
            return this.externalInvocationConfiguration((ExternalInvocationConfiguration)((ExternalInvocationConfiguration.Builder)ExternalInvocationConfiguration.builder().applyMutation(externalInvocationConfiguration)).build());
        }
    }
}

