/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AiUseCase;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AiAgentInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AiAgentInfo> {
    private static final SdkField<String> AI_USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AiUseCase").getter(AiAgentInfo.getter(AiAgentInfo::aiUseCaseAsString)).setter(AiAgentInfo.setter(Builder::aiUseCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AiUseCase").build()}).build();
    private static final SdkField<String> AI_AGENT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AiAgentVersionId").getter(AiAgentInfo.getter(AiAgentInfo::aiAgentVersionId)).setter(AiAgentInfo.setter(Builder::aiAgentVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AiAgentVersionId").build()}).build();
    private static final SdkField<Boolean> AI_AGENT_ESCALATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AiAgentEscalated").getter(AiAgentInfo.getter(AiAgentInfo::aiAgentEscalated)).setter(AiAgentInfo.setter(Builder::aiAgentEscalated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AiAgentEscalated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_USE_CASE_FIELD, AI_AGENT_VERSION_ID_FIELD, AI_AGENT_ESCALATED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AiAgentInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String aiUseCase;
    private final String aiAgentVersionId;
    private final Boolean aiAgentEscalated;

    private AiAgentInfo(BuilderImpl builder) {
        this.aiUseCase = builder.aiUseCase;
        this.aiAgentVersionId = builder.aiAgentVersionId;
        this.aiAgentEscalated = builder.aiAgentEscalated;
    }

    public final AiUseCase aiUseCase() {
        return AiUseCase.fromValue(this.aiUseCase);
    }

    public final String aiUseCaseAsString() {
        return this.aiUseCase;
    }

    public final String aiAgentVersionId() {
        return this.aiAgentVersionId;
    }

    public final Boolean aiAgentEscalated() {
        return this.aiAgentEscalated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aiUseCaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentEscalated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AiAgentInfo)) {
            return false;
        }
        AiAgentInfo other = (AiAgentInfo)obj;
        return Objects.equals(this.aiUseCaseAsString(), other.aiUseCaseAsString()) && Objects.equals(this.aiAgentVersionId(), other.aiAgentVersionId()) && Objects.equals(this.aiAgentEscalated(), other.aiAgentEscalated());
    }

    public final String toString() {
        return ToString.builder((String)"AiAgentInfo").add("AiUseCase", (Object)this.aiUseCaseAsString()).add("AiAgentVersionId", (Object)this.aiAgentVersionId()).add("AiAgentEscalated", (Object)this.aiAgentEscalated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AiUseCase": {
                return Optional.ofNullable(clazz.cast(this.aiUseCaseAsString()));
            }
            case "AiAgentVersionId": {
                return Optional.ofNullable(clazz.cast(this.aiAgentVersionId()));
            }
            case "AiAgentEscalated": {
                return Optional.ofNullable(clazz.cast(this.aiAgentEscalated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AiUseCase", AI_USE_CASE_FIELD);
        map.put("AiAgentVersionId", AI_AGENT_VERSION_ID_FIELD);
        map.put("AiAgentEscalated", AI_AGENT_ESCALATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AiAgentInfo, T> g) {
        return obj -> g.apply((AiAgentInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aiUseCase;
        private String aiAgentVersionId;
        private Boolean aiAgentEscalated;

        private BuilderImpl() {
        }

        private BuilderImpl(AiAgentInfo model) {
            this.aiUseCase(model.aiUseCase);
            this.aiAgentVersionId(model.aiAgentVersionId);
            this.aiAgentEscalated(model.aiAgentEscalated);
        }

        public final String getAiUseCase() {
            return this.aiUseCase;
        }

        public final void setAiUseCase(String aiUseCase) {
            this.aiUseCase = aiUseCase;
        }

        @Override
        public final Builder aiUseCase(String aiUseCase) {
            this.aiUseCase = aiUseCase;
            return this;
        }

        @Override
        public final Builder aiUseCase(AiUseCase aiUseCase) {
            this.aiUseCase(aiUseCase == null ? null : aiUseCase.toString());
            return this;
        }

        public final String getAiAgentVersionId() {
            return this.aiAgentVersionId;
        }

        public final void setAiAgentVersionId(String aiAgentVersionId) {
            this.aiAgentVersionId = aiAgentVersionId;
        }

        @Override
        public final Builder aiAgentVersionId(String aiAgentVersionId) {
            this.aiAgentVersionId = aiAgentVersionId;
            return this;
        }

        public final Boolean getAiAgentEscalated() {
            return this.aiAgentEscalated;
        }

        public final void setAiAgentEscalated(Boolean aiAgentEscalated) {
            this.aiAgentEscalated = aiAgentEscalated;
        }

        @Override
        public final Builder aiAgentEscalated(Boolean aiAgentEscalated) {
            this.aiAgentEscalated = aiAgentEscalated;
            return this;
        }

        public AiAgentInfo build() {
            return new AiAgentInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AiAgentInfo> {
        public Builder aiUseCase(String var1);

        public Builder aiUseCase(AiUseCase var1);

        public Builder aiAgentVersionId(String var1);

        public Builder aiAgentEscalated(Boolean var1);
    }
}

