/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines validation rules for data table attribute values. Based on JSON Schema Draft 2020-12 with additional
 * Connect-specific validations. Validation rules ensure data integrity and consistency across the data table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Validation implements SdkPojo, Serializable, ToCopyableBuilder<Validation.Builder, Validation> {
    private static final SdkField<Integer> MIN_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinLength").getter(getter(Validation::minLength)).setter(setter(Builder::minLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinLength").build()).build();

    private static final SdkField<Integer> MAX_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLength").getter(getter(Validation::maxLength)).setter(setter(Builder::maxLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLength").build()).build();

    private static final SdkField<Integer> MIN_VALUES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinValues").getter(getter(Validation::minValues)).setter(setter(Builder::minValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValues").build()).build();

    private static final SdkField<Integer> MAX_VALUES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxValues").getter(getter(Validation::maxValues)).setter(setter(Builder::maxValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValues").build()).build();

    private static final SdkField<Boolean> IGNORE_CASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IgnoreCase").getter(getter(Validation::ignoreCase)).setter(setter(Builder::ignoreCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreCase").build()).build();

    private static final SdkField<Double> MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Minimum")
            .getter(getter(Validation::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()).build();

    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Maximum")
            .getter(getter(Validation::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final SdkField<Double> EXCLUSIVE_MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ExclusiveMinimum").getter(getter(Validation::exclusiveMinimum))
            .setter(setter(Builder::exclusiveMinimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveMinimum").build()).build();

    private static final SdkField<Double> EXCLUSIVE_MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ExclusiveMaximum").getter(getter(Validation::exclusiveMaximum))
            .setter(setter(Builder::exclusiveMaximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveMaximum").build()).build();

    private static final SdkField<Double> MULTIPLE_OF_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MultipleOf").getter(getter(Validation::multipleOf)).setter(setter(Builder::multipleOf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultipleOf").build()).build();

    private static final SdkField<ValidationEnum> ENUM_FIELD = SdkField.<ValidationEnum> builder(MarshallingType.SDK_POJO)
            .memberName("Enum").getter(getter(Validation::enumValue)).setter(setter(Builder::enumValue))
            .constructor(ValidationEnum::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_LENGTH_FIELD,
            MAX_LENGTH_FIELD, MIN_VALUES_FIELD, MAX_VALUES_FIELD, IGNORE_CASE_FIELD, MINIMUM_FIELD, MAXIMUM_FIELD,
            EXCLUSIVE_MINIMUM_FIELD, EXCLUSIVE_MAXIMUM_FIELD, MULTIPLE_OF_FIELD, ENUM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minLength;

    private final Integer maxLength;

    private final Integer minValues;

    private final Integer maxValues;

    private final Boolean ignoreCase;

    private final Double minimum;

    private final Double maximum;

    private final Double exclusiveMinimum;

    private final Double exclusiveMaximum;

    private final Double multipleOf;

    private final ValidationEnum enumValue;

    private Validation(BuilderImpl builder) {
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.minValues = builder.minValues;
        this.maxValues = builder.maxValues;
        this.ignoreCase = builder.ignoreCase;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.exclusiveMinimum = builder.exclusiveMinimum;
        this.exclusiveMaximum = builder.exclusiveMaximum;
        this.multipleOf = builder.multipleOf;
        this.enumValue = builder.enumValue;
    }

    /**
     * <p>
     * The minimum number of characters a text value can contain. Applies to TEXT value type and values within a
     * TEXT_LIST. Must be less than or equal to MaxLength.
     * </p>
     * 
     * @return The minimum number of characters a text value can contain. Applies to TEXT value type and values within a
     *         TEXT_LIST. Must be less than or equal to MaxLength.
     */
    public final Integer minLength() {
        return minLength;
    }

    /**
     * <p>
     * The maximum number of characters a text value can contain. Applies to TEXT value type and values within a
     * TEXT_LIST. Must be greater than or equal to MinLength.
     * </p>
     * 
     * @return The maximum number of characters a text value can contain. Applies to TEXT value type and values within a
     *         TEXT_LIST. Must be greater than or equal to MinLength.
     */
    public final Integer maxLength() {
        return maxLength;
    }

    /**
     * <p>
     * The minimum number of values in a list. Must be an integer greater than or equal to 0 and less than or equal to
     * MaxValues. Applies to all list types.
     * </p>
     * 
     * @return The minimum number of values in a list. Must be an integer greater than or equal to 0 and less than or
     *         equal to MaxValues. Applies to all list types.
     */
    public final Integer minValues() {
        return minValues;
    }

    /**
     * <p>
     * The maximum number of values in a list. Must be an integer greater than or equal to 0 and greater than or equal
     * to MinValues. Applies to all list types.
     * </p>
     * 
     * @return The maximum number of values in a list. Must be an integer greater than or equal to 0 and greater than or
     *         equal to MinValues. Applies to all list types.
     */
    public final Integer maxValues() {
        return maxValues;
    }

    /**
     * <p>
     * Boolean that defaults to false. Applies to text lists and text primary attributes. When true, enforces
     * case-insensitive uniqueness for primary attributes and allows case-insensitive lookups.
     * </p>
     * 
     * @return Boolean that defaults to false. Applies to text lists and text primary attributes. When true, enforces
     *         case-insensitive uniqueness for primary attributes and allows case-insensitive lookups.
     */
    public final Boolean ignoreCase() {
        return ignoreCase;
    }

    /**
     * <p>
     * The smallest inclusive numeric value for NUMBER value type. Cannot be provided when ExclusiveMinimum is also
     * provided. Must be less than or equal to Maximum and less than ExclusiveMaximum. Applies to NUMBER and values
     * within NUMBER_LIST.
     * </p>
     * 
     * @return The smallest inclusive numeric value for NUMBER value type. Cannot be provided when ExclusiveMinimum is
     *         also provided. Must be less than or equal to Maximum and less than ExclusiveMaximum. Applies to NUMBER
     *         and values within NUMBER_LIST.
     */
    public final Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The largest inclusive numeric value for NUMBER value type. Can be provided alongside ExclusiveMaximum where both
     * operate independently. Must be greater than or equal to Minimum and greater than ExclusiveMinimum. Applies to
     * NUMBER and values within NUMBER_LIST.
     * </p>
     * 
     * @return The largest inclusive numeric value for NUMBER value type. Can be provided alongside ExclusiveMaximum
     *         where both operate independently. Must be greater than or equal to Minimum and greater than
     *         ExclusiveMinimum. Applies to NUMBER and values within NUMBER_LIST.
     */
    public final Double maximum() {
        return maximum;
    }

    /**
     * <p>
     * The smallest exclusive numeric value for NUMBER value type. Can be provided alongside Minimum where both operate
     * independently. Must be less than ExclusiveMaximum and Maximum. Applies to NUMBER and values within NUMBER_LIST.
     * </p>
     * 
     * @return The smallest exclusive numeric value for NUMBER value type. Can be provided alongside Minimum where both
     *         operate independently. Must be less than ExclusiveMaximum and Maximum. Applies to NUMBER and values
     *         within NUMBER_LIST.
     */
    public final Double exclusiveMinimum() {
        return exclusiveMinimum;
    }

    /**
     * <p>
     * The largest exclusive numeric value for NUMBER value type. Can be provided alongside Maximum where both operate
     * independently. Must be greater than ExclusiveMinimum and Minimum. Applies to NUMBER and values within
     * NUMBER_LIST.
     * </p>
     * 
     * @return The largest exclusive numeric value for NUMBER value type. Can be provided alongside Maximum where both
     *         operate independently. Must be greater than ExclusiveMinimum and Minimum. Applies to NUMBER and values
     *         within NUMBER_LIST.
     */
    public final Double exclusiveMaximum() {
        return exclusiveMaximum;
    }

    /**
     * <p>
     * Specifies that numeric values must be multiples of this number. Must be greater than 0. The result of dividing a
     * value by this multiple must result in an integer. Applies to NUMBER and values within NUMBER_LIST.
     * </p>
     * 
     * @return Specifies that numeric values must be multiples of this number. Must be greater than 0. The result of
     *         dividing a value by this multiple must result in an integer. Applies to NUMBER and values within
     *         NUMBER_LIST.
     */
    public final Double multipleOf() {
        return multipleOf;
    }

    /**
     * <p>
     * Defines enumeration constraints for attribute values. Can specify a list of allowed values and whether custom
     * values are permitted beyond the enumerated list.
     * </p>
     * 
     * @return Defines enumeration constraints for attribute values. Can specify a list of allowed values and whether
     *         custom values are permitted beyond the enumerated list.
     */
    public final ValidationEnum enumValue() {
        return enumValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minLength());
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(minValues());
        hashCode = 31 * hashCode + Objects.hashCode(maxValues());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreCase());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(multipleOf());
        hashCode = 31 * hashCode + Objects.hashCode(enumValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Validation)) {
            return false;
        }
        Validation other = (Validation) obj;
        return Objects.equals(minLength(), other.minLength()) && Objects.equals(maxLength(), other.maxLength())
                && Objects.equals(minValues(), other.minValues()) && Objects.equals(maxValues(), other.maxValues())
                && Objects.equals(ignoreCase(), other.ignoreCase()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(maximum(), other.maximum()) && Objects.equals(exclusiveMinimum(), other.exclusiveMinimum())
                && Objects.equals(exclusiveMaximum(), other.exclusiveMaximum())
                && Objects.equals(multipleOf(), other.multipleOf()) && Objects.equals(enumValue(), other.enumValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Validation").add("MinLength", minLength()).add("MaxLength", maxLength())
                .add("MinValues", minValues()).add("MaxValues", maxValues()).add("IgnoreCase", ignoreCase())
                .add("Minimum", minimum()).add("Maximum", maximum()).add("ExclusiveMinimum", exclusiveMinimum())
                .add("ExclusiveMaximum", exclusiveMaximum()).add("MultipleOf", multipleOf()).add("Enum", enumValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinLength":
            return Optional.ofNullable(clazz.cast(minLength()));
        case "MaxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        case "MinValues":
            return Optional.ofNullable(clazz.cast(minValues()));
        case "MaxValues":
            return Optional.ofNullable(clazz.cast(maxValues()));
        case "IgnoreCase":
            return Optional.ofNullable(clazz.cast(ignoreCase()));
        case "Minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "ExclusiveMinimum":
            return Optional.ofNullable(clazz.cast(exclusiveMinimum()));
        case "ExclusiveMaximum":
            return Optional.ofNullable(clazz.cast(exclusiveMaximum()));
        case "MultipleOf":
            return Optional.ofNullable(clazz.cast(multipleOf()));
        case "Enum":
            return Optional.ofNullable(clazz.cast(enumValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinLength", MIN_LENGTH_FIELD);
        map.put("MaxLength", MAX_LENGTH_FIELD);
        map.put("MinValues", MIN_VALUES_FIELD);
        map.put("MaxValues", MAX_VALUES_FIELD);
        map.put("IgnoreCase", IGNORE_CASE_FIELD);
        map.put("Minimum", MINIMUM_FIELD);
        map.put("Maximum", MAXIMUM_FIELD);
        map.put("ExclusiveMinimum", EXCLUSIVE_MINIMUM_FIELD);
        map.put("ExclusiveMaximum", EXCLUSIVE_MAXIMUM_FIELD);
        map.put("MultipleOf", MULTIPLE_OF_FIELD);
        map.put("Enum", ENUM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Validation, T> g) {
        return obj -> g.apply((Validation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Validation> {
        /**
         * <p>
         * The minimum number of characters a text value can contain. Applies to TEXT value type and values within a
         * TEXT_LIST. Must be less than or equal to MaxLength.
         * </p>
         * 
         * @param minLength
         *        The minimum number of characters a text value can contain. Applies to TEXT value type and values
         *        within a TEXT_LIST. Must be less than or equal to MaxLength.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLength(Integer minLength);

        /**
         * <p>
         * The maximum number of characters a text value can contain. Applies to TEXT value type and values within a
         * TEXT_LIST. Must be greater than or equal to MinLength.
         * </p>
         * 
         * @param maxLength
         *        The maximum number of characters a text value can contain. Applies to TEXT value type and values
         *        within a TEXT_LIST. Must be greater than or equal to MinLength.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(Integer maxLength);

        /**
         * <p>
         * The minimum number of values in a list. Must be an integer greater than or equal to 0 and less than or equal
         * to MaxValues. Applies to all list types.
         * </p>
         * 
         * @param minValues
         *        The minimum number of values in a list. Must be an integer greater than or equal to 0 and less than or
         *        equal to MaxValues. Applies to all list types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValues(Integer minValues);

        /**
         * <p>
         * The maximum number of values in a list. Must be an integer greater than or equal to 0 and greater than or
         * equal to MinValues. Applies to all list types.
         * </p>
         * 
         * @param maxValues
         *        The maximum number of values in a list. Must be an integer greater than or equal to 0 and greater than
         *        or equal to MinValues. Applies to all list types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValues(Integer maxValues);

        /**
         * <p>
         * Boolean that defaults to false. Applies to text lists and text primary attributes. When true, enforces
         * case-insensitive uniqueness for primary attributes and allows case-insensitive lookups.
         * </p>
         * 
         * @param ignoreCase
         *        Boolean that defaults to false. Applies to text lists and text primary attributes. When true, enforces
         *        case-insensitive uniqueness for primary attributes and allows case-insensitive lookups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreCase(Boolean ignoreCase);

        /**
         * <p>
         * The smallest inclusive numeric value for NUMBER value type. Cannot be provided when ExclusiveMinimum is also
         * provided. Must be less than or equal to Maximum and less than ExclusiveMaximum. Applies to NUMBER and values
         * within NUMBER_LIST.
         * </p>
         * 
         * @param minimum
         *        The smallest inclusive numeric value for NUMBER value type. Cannot be provided when ExclusiveMinimum
         *        is also provided. Must be less than or equal to Maximum and less than ExclusiveMaximum. Applies to
         *        NUMBER and values within NUMBER_LIST.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The largest inclusive numeric value for NUMBER value type. Can be provided alongside ExclusiveMaximum where
         * both operate independently. Must be greater than or equal to Minimum and greater than ExclusiveMinimum.
         * Applies to NUMBER and values within NUMBER_LIST.
         * </p>
         * 
         * @param maximum
         *        The largest inclusive numeric value for NUMBER value type. Can be provided alongside ExclusiveMaximum
         *        where both operate independently. Must be greater than or equal to Minimum and greater than
         *        ExclusiveMinimum. Applies to NUMBER and values within NUMBER_LIST.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);

        /**
         * <p>
         * The smallest exclusive numeric value for NUMBER value type. Can be provided alongside Minimum where both
         * operate independently. Must be less than ExclusiveMaximum and Maximum. Applies to NUMBER and values within
         * NUMBER_LIST.
         * </p>
         * 
         * @param exclusiveMinimum
         *        The smallest exclusive numeric value for NUMBER value type. Can be provided alongside Minimum where
         *        both operate independently. Must be less than ExclusiveMaximum and Maximum. Applies to NUMBER and
         *        values within NUMBER_LIST.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveMinimum(Double exclusiveMinimum);

        /**
         * <p>
         * The largest exclusive numeric value for NUMBER value type. Can be provided alongside Maximum where both
         * operate independently. Must be greater than ExclusiveMinimum and Minimum. Applies to NUMBER and values within
         * NUMBER_LIST.
         * </p>
         * 
         * @param exclusiveMaximum
         *        The largest exclusive numeric value for NUMBER value type. Can be provided alongside Maximum where
         *        both operate independently. Must be greater than ExclusiveMinimum and Minimum. Applies to NUMBER and
         *        values within NUMBER_LIST.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveMaximum(Double exclusiveMaximum);

        /**
         * <p>
         * Specifies that numeric values must be multiples of this number. Must be greater than 0. The result of
         * dividing a value by this multiple must result in an integer. Applies to NUMBER and values within NUMBER_LIST.
         * </p>
         * 
         * @param multipleOf
         *        Specifies that numeric values must be multiples of this number. Must be greater than 0. The result of
         *        dividing a value by this multiple must result in an integer. Applies to NUMBER and values within
         *        NUMBER_LIST.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipleOf(Double multipleOf);

        /**
         * <p>
         * Defines enumeration constraints for attribute values. Can specify a list of allowed values and whether custom
         * values are permitted beyond the enumerated list.
         * </p>
         * 
         * @param enumValue
         *        Defines enumeration constraints for attribute values. Can specify a list of allowed values and whether
         *        custom values are permitted beyond the enumerated list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumValue(ValidationEnum enumValue);

        /**
         * <p>
         * Defines enumeration constraints for attribute values. Can specify a list of allowed values and whether custom
         * values are permitted beyond the enumerated list.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationEnum.Builder} avoiding the need
         * to create one manually via {@link ValidationEnum#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationEnum.Builder#build()} is called immediately and its
         * result is passed to {@link #enumValue(ValidationEnum)}.
         * 
         * @param enumValue
         *        a consumer that will call methods on {@link ValidationEnum.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enumValue(ValidationEnum)
         */
        default Builder enumValue(Consumer<ValidationEnum.Builder> enumValue) {
            return enumValue(ValidationEnum.builder().applyMutation(enumValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer minLength;

        private Integer maxLength;

        private Integer minValues;

        private Integer maxValues;

        private Boolean ignoreCase;

        private Double minimum;

        private Double maximum;

        private Double exclusiveMinimum;

        private Double exclusiveMaximum;

        private Double multipleOf;

        private ValidationEnum enumValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Validation model) {
            minLength(model.minLength);
            maxLength(model.maxLength);
            minValues(model.minValues);
            maxValues(model.maxValues);
            ignoreCase(model.ignoreCase);
            minimum(model.minimum);
            maximum(model.maximum);
            exclusiveMinimum(model.exclusiveMinimum);
            exclusiveMaximum(model.exclusiveMaximum);
            multipleOf(model.multipleOf);
            enumValue(model.enumValue);
        }

        public final Integer getMinLength() {
            return minLength;
        }

        public final void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        @Override
        public final Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public final Integer getMaxLength() {
            return maxLength;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final Integer getMinValues() {
            return minValues;
        }

        public final void setMinValues(Integer minValues) {
            this.minValues = minValues;
        }

        @Override
        public final Builder minValues(Integer minValues) {
            this.minValues = minValues;
            return this;
        }

        public final Integer getMaxValues() {
            return maxValues;
        }

        public final void setMaxValues(Integer maxValues) {
            this.maxValues = maxValues;
        }

        @Override
        public final Builder maxValues(Integer maxValues) {
            this.maxValues = maxValues;
            return this;
        }

        public final Boolean getIgnoreCase() {
            return ignoreCase;
        }

        public final void setIgnoreCase(Boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        @Override
        public final Builder ignoreCase(Boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public final Double getMinimum() {
            return minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Double getMaximum() {
            return maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Double getExclusiveMinimum() {
            return exclusiveMinimum;
        }

        public final void setExclusiveMinimum(Double exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
        }

        @Override
        public final Builder exclusiveMinimum(Double exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
            return this;
        }

        public final Double getExclusiveMaximum() {
            return exclusiveMaximum;
        }

        public final void setExclusiveMaximum(Double exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
        }

        @Override
        public final Builder exclusiveMaximum(Double exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
            return this;
        }

        public final Double getMultipleOf() {
            return multipleOf;
        }

        public final void setMultipleOf(Double multipleOf) {
            this.multipleOf = multipleOf;
        }

        @Override
        public final Builder multipleOf(Double multipleOf) {
            this.multipleOf = multipleOf;
            return this;
        }

        public final ValidationEnum.Builder getEnumValue() {
            return enumValue != null ? enumValue.toBuilder() : null;
        }

        public final void setEnumValue(ValidationEnum.BuilderImpl enumValue) {
            this.enumValue = enumValue != null ? enumValue.build() : null;
        }

        @Override
        public final Builder enumValue(ValidationEnum enumValue) {
            this.enumValue = enumValue;
            return this;
        }

        @Override
        public Validation build() {
            return new Validation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
