/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInstanceStorageConfigRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateInstanceStorageConfigRequest.Builder, UpdateInstanceStorageConfigRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateInstanceStorageConfigRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(UpdateInstanceStorageConfigRequest::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AssociationId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(UpdateInstanceStorageConfigRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<InstanceStorageConfig> STORAGE_CONFIG_FIELD = SdkField
            .<InstanceStorageConfig> builder(MarshallingType.SDK_POJO).memberName("StorageConfig")
            .getter(getter(UpdateInstanceStorageConfigRequest::storageConfig)).setter(setter(Builder::storageConfig))
            .constructor(InstanceStorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConfig").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(UpdateInstanceStorageConfigRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            ASSOCIATION_ID_FIELD, RESOURCE_TYPE_FIELD, STORAGE_CONFIG_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String associationId;

    private final String resourceType;

    private final InstanceStorageConfig storageConfig;

    private final String clientToken;

    private UpdateInstanceStorageConfigRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.associationId = builder.associationId;
        this.resourceType = builder.resourceType;
        this.storageConfig = builder.storageConfig;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The existing association identifier that uniquely identifies the resource type and storage config for the given
     * instance ID.
     * </p>
     * 
     * @return The existing association identifier that uniquely identifies the resource type and storage config for the
     *         given instance ID.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * A valid resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link InstanceStorageResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return A valid resource type.
     * @see InstanceStorageResourceType
     */
    public final InstanceStorageResourceType resourceType() {
        return InstanceStorageResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * A valid resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link InstanceStorageResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return A valid resource type.
     * @see InstanceStorageResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Returns the value of the StorageConfig property for this object.
     * 
     * @return The value of the StorageConfig property for this object.
     */
    public final InstanceStorageConfig storageConfig() {
        return storageConfig;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceStorageConfigRequest)) {
            return false;
        }
        UpdateInstanceStorageConfigRequest other = (UpdateInstanceStorageConfigRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(storageConfig(), other.storageConfig()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInstanceStorageConfigRequest").add("InstanceId", instanceId())
                .add("AssociationId", associationId()).add("ResourceType", resourceTypeAsString())
                .add("StorageConfig", storageConfig()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "StorageConfig":
            return Optional.ofNullable(clazz.cast(storageConfig()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("StorageConfig", STORAGE_CONFIG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceStorageConfigRequest, T> g) {
        return obj -> g.apply((UpdateInstanceStorageConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInstanceStorageConfigRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The existing association identifier that uniquely identifies the resource type and storage config for the
         * given instance ID.
         * </p>
         * 
         * @param associationId
         *        The existing association identifier that uniquely identifies the resource type and storage config for
         *        the given instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * A valid resource type.
         * </p>
         * 
         * @param resourceType
         *        A valid resource type.
         * @see InstanceStorageResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStorageResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * A valid resource type.
         * </p>
         * 
         * @param resourceType
         *        A valid resource type.
         * @see InstanceStorageResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStorageResourceType
         */
        Builder resourceType(InstanceStorageResourceType resourceType);

        /**
         * Sets the value of the StorageConfig property for this object.
         *
         * @param storageConfig
         *        The new value for the StorageConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfig(InstanceStorageConfig storageConfig);

        /**
         * Sets the value of the StorageConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InstanceStorageConfig.Builder} avoiding
         * the need to create one manually via {@link InstanceStorageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceStorageConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfig(InstanceStorageConfig)}.
         * 
         * @param storageConfig
         *        a consumer that will call methods on {@link InstanceStorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfig(InstanceStorageConfig)
         */
        default Builder storageConfig(Consumer<InstanceStorageConfig.Builder> storageConfig) {
            return storageConfig(InstanceStorageConfig.builder().applyMutation(storageConfig).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String associationId;

        private String resourceType;

        private InstanceStorageConfig storageConfig;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceStorageConfigRequest model) {
            super(model);
            instanceId(model.instanceId);
            associationId(model.associationId);
            resourceType(model.resourceType);
            storageConfig(model.storageConfig);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(InstanceStorageResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final InstanceStorageConfig.Builder getStorageConfig() {
            return storageConfig != null ? storageConfig.toBuilder() : null;
        }

        public final void setStorageConfig(InstanceStorageConfig.BuilderImpl storageConfig) {
            this.storageConfig = storageConfig != null ? storageConfig.build() : null;
        }

        @Override
        public final Builder storageConfig(InstanceStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceStorageConfigRequest build() {
            return new UpdateInstanceStorageConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
