/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateContactRequest.Builder, UpdateContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(UpdateContactRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateContactRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateContactRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField
            .<Map<String, Reference>> builder(MarshallingType.MAP)
            .memberName("References")
            .getter(getter(UpdateContactRequest::references))
            .setter(setter(Builder::references))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Reference> builder(MarshallingType.SDK_POJO)
                                            .constructor(Reference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField
            .<Map<String, SegmentAttributeValue>> builder(MarshallingType.MAP)
            .memberName("SegmentAttributes")
            .getter(getter(UpdateContactRequest::segmentAttributes))
            .setter(setter(Builder::segmentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SegmentAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<QueueInfoInput> QUEUE_INFO_FIELD = SdkField.<QueueInfoInput> builder(MarshallingType.SDK_POJO)
            .memberName("QueueInfo").getter(getter(UpdateContactRequest::queueInfo)).setter(setter(Builder::queueInfo))
            .constructor(QueueInfoInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueInfo").build()).build();

    private static final SdkField<UserInfo> USER_INFO_FIELD = SdkField.<UserInfo> builder(MarshallingType.SDK_POJO)
            .memberName("UserInfo").getter(getter(UpdateContactRequest::userInfo)).setter(setter(Builder::userInfo))
            .constructor(UserInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfo").build()).build();

    private static final SdkField<Endpoint> CUSTOMER_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerEndpoint").getter(getter(UpdateContactRequest::customerEndpoint))
            .setter(setter(Builder::customerEndpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerEndpoint").build()).build();

    private static final SdkField<Endpoint> SYSTEM_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("SystemEndpoint").getter(getter(UpdateContactRequest::systemEndpoint))
            .setter(setter(Builder::systemEndpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, REFERENCES_FIELD, SEGMENT_ATTRIBUTES_FIELD, QUEUE_INFO_FIELD,
            USER_INFO_FIELD, CUSTOMER_ENDPOINT_FIELD, SYSTEM_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String contactId;

    private final String name;

    private final String description;

    private final Map<String, Reference> references;

    private final Map<String, SegmentAttributeValue> segmentAttributes;

    private final QueueInfoInput queueInfo;

    private final UserInfo userInfo;

    private final Endpoint customerEndpoint;

    private final Endpoint systemEndpoint;

    private UpdateContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.name = builder.name;
        this.description = builder.description;
        this.references = builder.references;
        this.segmentAttributes = builder.segmentAttributes;
        this.queueInfo = builder.queueInfo;
        this.userInfo = builder.userInfo;
        this.customerEndpoint = builder.customerEndpoint;
        this.systemEndpoint = builder.systemEndpoint;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the contact. This is the identifier of the contact associated with the first interaction with
     * your contact center.
     * </p>
     * 
     * @return The identifier of the contact. This is the identifier of the contact associated with the first
     *         interaction with your contact center.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The name of the contact.
     * </p>
     * 
     * @return The name of the contact.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the contact.
     * </p>
     * 
     * @return The description of the contact.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the References property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReferences() {
        return references != null && !(references instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Well-formed data on contact, shown to agents on Contact Control Panel (CCP).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferences} method.
     * </p>
     * 
     * @return Well-formed data on contact, shown to agents on Contact Control Panel (CCP).
     */
    public final Map<String, Reference> references() {
        return references;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSegmentAttributes() {
        return segmentAttributes != null && !(segmentAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using an
     * attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
     * </p>
     * <p>
     * Attribute keys can include only alphanumeric, -, and _.
     * </p>
     * <p>
     * This field can be used to show channel subtype, such as <code>connect:Guide</code>.
     * </p>
     * <p>
     * Contact Expiry, and user-defined attributes (String - String) that are defined in predefined attributes, can be
     * updated by using the UpdateContact API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentAttributes} method.
     * </p>
     * 
     * @return A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using
     *         an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in
     *         flows.</p>
     *         <p>
     *         Attribute keys can include only alphanumeric, -, and _.
     *         </p>
     *         <p>
     *         This field can be used to show channel subtype, such as <code>connect:Guide</code>.
     *         </p>
     *         <p>
     *         Contact Expiry, and user-defined attributes (String - String) that are defined in predefined attributes,
     *         can be updated by using the UpdateContact API.
     */
    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return segmentAttributes;
    }

    /**
     * <p>
     * Information about the queue associated with a contact. This parameter can only be updated for external audio
     * contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect Contact
     * Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return Information about the queue associated with a contact. This parameter can only be updated for external
     *         audio contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
     *         Contact Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
     */
    public final QueueInfoInput queueInfo() {
        return queueInfo;
    }

    /**
     * <p>
     * Information about the agent associated with a contact. This parameter can only be updated for external audio
     * contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect Contact
     * Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return Information about the agent associated with a contact. This parameter can only be updated for external
     *         audio contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
     *         Contact Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
     */
    public final UserInfo userInfo() {
        return userInfo;
    }

    /**
     * <p>
     * The endpoint of the customer for which the contact was initiated. For external audio contacts, this is usually
     * the end customer's phone number. This value can only be updated for external audio contacts. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect Contact
     * Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return The endpoint of the customer for which the contact was initiated. For external audio contacts, this is
     *         usually the end customer's phone number. This value can only be updated for external audio contacts. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
     *         Contact Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final Endpoint customerEndpoint() {
        return customerEndpoint;
    }

    /**
     * <p>
     * External system endpoint for the contact was initiated. For external audio contacts, this is the phone number of
     * the external system such as the contact center. This value can only be updated for external audio contacts. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect Contact
     * Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return External system endpoint for the contact was initiated. For external audio contacts, this is the phone
     *         number of the external system such as the contact center. This value can only be updated for external
     *         audio contacts. For more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
     *         Contact Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final Endpoint systemEndpoint() {
        return systemEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferences() ? references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentAttributes() ? segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(userInfo());
        hashCode = 31 * hashCode + Objects.hashCode(customerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(systemEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRequest)) {
            return false;
        }
        UpdateContactRequest other = (UpdateContactRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasReferences() == other.hasReferences() && Objects.equals(references(), other.references())
                && hasSegmentAttributes() == other.hasSegmentAttributes()
                && Objects.equals(segmentAttributes(), other.segmentAttributes())
                && Objects.equals(queueInfo(), other.queueInfo()) && Objects.equals(userInfo(), other.userInfo())
                && Objects.equals(customerEndpoint(), other.customerEndpoint())
                && Objects.equals(systemEndpoint(), other.systemEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactRequest").add("InstanceId", instanceId()).add("ContactId", contactId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("References", hasReferences() ? references() : null)
                .add("SegmentAttributes", hasSegmentAttributes() ? segmentAttributes() : null).add("QueueInfo", queueInfo())
                .add("UserInfo", userInfo()).add("CustomerEndpoint", customerEndpoint()).add("SystemEndpoint", systemEndpoint())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "References":
            return Optional.ofNullable(clazz.cast(references()));
        case "SegmentAttributes":
            return Optional.ofNullable(clazz.cast(segmentAttributes()));
        case "QueueInfo":
            return Optional.ofNullable(clazz.cast(queueInfo()));
        case "UserInfo":
            return Optional.ofNullable(clazz.cast(userInfo()));
        case "CustomerEndpoint":
            return Optional.ofNullable(clazz.cast(customerEndpoint()));
        case "SystemEndpoint":
            return Optional.ofNullable(clazz.cast(systemEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        map.put("QueueInfo", QUEUE_INFO_FIELD);
        map.put("UserInfo", USER_INFO_FIELD);
        map.put("CustomerEndpoint", CUSTOMER_ENDPOINT_FIELD);
        map.put("SystemEndpoint", SYSTEM_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactRequest, T> g) {
        return obj -> g.apply((UpdateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the contact. This is the identifier of the contact associated with the first interaction
         * with your contact center.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact. This is the identifier of the contact associated with the first
         *        interaction with your contact center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The name of the contact.
         * </p>
         * 
         * @param name
         *        The name of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the contact.
         * </p>
         * 
         * @param description
         *        The description of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Well-formed data on contact, shown to agents on Contact Control Panel (CCP).
         * </p>
         * 
         * @param references
         *        Well-formed data on contact, shown to agents on Contact Control Panel (CCP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(Map<String, Reference> references);

        /**
         * <p>
         * A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using an
         * attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
         * </p>
         * <p>
         * Attribute keys can include only alphanumeric, -, and _.
         * </p>
         * <p>
         * This field can be used to show channel subtype, such as <code>connect:Guide</code>.
         * </p>
         * <p>
         * Contact Expiry, and user-defined attributes (String - String) that are defined in predefined attributes, can
         * be updated by using the UpdateContact API.
         * </p>
         * 
         * @param segmentAttributes
         *        A set of system defined key-value pairs stored on individual contact segments (unique contact ID)
         *        using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in
         *        flows.</p>
         *        <p>
         *        Attribute keys can include only alphanumeric, -, and _.
         *        </p>
         *        <p>
         *        This field can be used to show channel subtype, such as <code>connect:Guide</code>.
         *        </p>
         *        <p>
         *        Contact Expiry, and user-defined attributes (String - String) that are defined in predefined
         *        attributes, can be updated by using the UpdateContact API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes);

        /**
         * <p>
         * Information about the queue associated with a contact. This parameter can only be updated for external audio
         * contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
         * Contact Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param queueInfo
         *        Information about the queue associated with a contact. This parameter can only be updated for external
         *        audio contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon
         *        Connect Contact Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueInfo(QueueInfoInput queueInfo);

        /**
         * <p>
         * Information about the queue associated with a contact. This parameter can only be updated for external audio
         * contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
         * Contact Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueueInfoInput.Builder} avoiding the need
         * to create one manually via {@link QueueInfoInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueueInfoInput.Builder#build()} is called immediately and its
         * result is passed to {@link #queueInfo(QueueInfoInput)}.
         * 
         * @param queueInfo
         *        a consumer that will call methods on {@link QueueInfoInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueInfo(QueueInfoInput)
         */
        default Builder queueInfo(Consumer<QueueInfoInput.Builder> queueInfo) {
            return queueInfo(QueueInfoInput.builder().applyMutation(queueInfo).build());
        }

        /**
         * <p>
         * Information about the agent associated with a contact. This parameter can only be updated for external audio
         * contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
         * Contact Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param userInfo
         *        Information about the agent associated with a contact. This parameter can only be updated for external
         *        audio contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon
         *        Connect Contact Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInfo(UserInfo userInfo);

        /**
         * <p>
         * Information about the agent associated with a contact. This parameter can only be updated for external audio
         * contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
         * Contact Lens integration</a> in the <i> Amazon Connect Administrator Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserInfo.Builder} avoiding the need to
         * create one manually via {@link UserInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #userInfo(UserInfo)}.
         * 
         * @param userInfo
         *        a consumer that will call methods on {@link UserInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userInfo(UserInfo)
         */
        default Builder userInfo(Consumer<UserInfo.Builder> userInfo) {
            return userInfo(UserInfo.builder().applyMutation(userInfo).build());
        }

        /**
         * <p>
         * The endpoint of the customer for which the contact was initiated. For external audio contacts, this is
         * usually the end customer's phone number. This value can only be updated for external audio contacts. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
         * Contact Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param customerEndpoint
         *        The endpoint of the customer for which the contact was initiated. For external audio contacts, this is
         *        usually the end customer's phone number. This value can only be updated for external audio contacts.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon
         *        Connect Contact Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEndpoint(Endpoint customerEndpoint);

        /**
         * <p>
         * The endpoint of the customer for which the contact was initiated. For external audio contacts, this is
         * usually the end customer's phone number. This value can only be updated for external audio contacts. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
         * Contact Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #customerEndpoint(Endpoint)}.
         * 
         * @param customerEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerEndpoint(Endpoint)
         */
        default Builder customerEndpoint(Consumer<Endpoint.Builder> customerEndpoint) {
            return customerEndpoint(Endpoint.builder().applyMutation(customerEndpoint).build());
        }

        /**
         * <p>
         * External system endpoint for the contact was initiated. For external audio contacts, this is the phone number
         * of the external system such as the contact center. This value can only be updated for external audio
         * contacts. For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
         * Contact Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param systemEndpoint
         *        External system endpoint for the contact was initiated. For external audio contacts, this is the phone
         *        number of the external system such as the contact center. This value can only be updated for external
         *        audio contacts. For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon
         *        Connect Contact Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemEndpoint(Endpoint systemEndpoint);

        /**
         * <p>
         * External system endpoint for the contact was initiated. For external audio contacts, this is the phone number
         * of the external system such as the contact center. This value can only be updated for external audio
         * contacts. For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html">Amazon Connect
         * Contact Lens integration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #systemEndpoint(Endpoint)}.
         * 
         * @param systemEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemEndpoint(Endpoint)
         */
        default Builder systemEndpoint(Consumer<Endpoint.Builder> systemEndpoint) {
            return systemEndpoint(Endpoint.builder().applyMutation(systemEndpoint).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactId;

        private String name;

        private String description;

        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();

        private QueueInfoInput queueInfo;

        private UserInfo userInfo;

        private Endpoint customerEndpoint;

        private Endpoint systemEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactId(model.contactId);
            name(model.name);
            description(model.description);
            references(model.references);
            segmentAttributes(model.segmentAttributes);
            queueInfo(model.queueInfo);
            userInfo(model.userInfo);
            customerEndpoint(model.customerEndpoint);
            systemEndpoint(model.systemEndpoint);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final QueueInfoInput.Builder getQueueInfo() {
            return queueInfo != null ? queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(QueueInfoInput.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(QueueInfoInput queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final UserInfo.Builder getUserInfo() {
            return userInfo != null ? userInfo.toBuilder() : null;
        }

        public final void setUserInfo(UserInfo.BuilderImpl userInfo) {
            this.userInfo = userInfo != null ? userInfo.build() : null;
        }

        @Override
        public final Builder userInfo(UserInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public final Endpoint.Builder getCustomerEndpoint() {
            return customerEndpoint != null ? customerEndpoint.toBuilder() : null;
        }

        public final void setCustomerEndpoint(Endpoint.BuilderImpl customerEndpoint) {
            this.customerEndpoint = customerEndpoint != null ? customerEndpoint.build() : null;
        }

        @Override
        public final Builder customerEndpoint(Endpoint customerEndpoint) {
            this.customerEndpoint = customerEndpoint;
            return this;
        }

        public final Endpoint.Builder getSystemEndpoint() {
            return systemEndpoint != null ? systemEndpoint.toBuilder() : null;
        }

        public final void setSystemEndpoint(Endpoint.BuilderImpl systemEndpoint) {
            this.systemEndpoint = systemEndpoint != null ? systemEndpoint.build() : null;
        }

        @Override
        public final Builder systemEndpoint(Endpoint systemEndpoint) {
            this.systemEndpoint = systemEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
