/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Routing criteria of the contact to match on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchableRoutingCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchableRoutingCriteria.Builder, SearchableRoutingCriteria> {
    private static final SdkField<List<SearchableRoutingCriteriaStep>> STEPS_FIELD = SdkField
            .<List<SearchableRoutingCriteriaStep>> builder(MarshallingType.LIST)
            .memberName("Steps")
            .getter(getter(SearchableRoutingCriteria::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchableRoutingCriteriaStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchableRoutingCriteriaStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SearchableRoutingCriteriaStep> steps;

    private SearchableRoutingCriteria(BuilderImpl builder) {
        this.steps = builder.steps;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Routing criteria steps of the contact routing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return The list of Routing criteria steps of the contact routing.
     */
    public final List<SearchableRoutingCriteriaStep> steps() {
        return steps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchableRoutingCriteria)) {
            return false;
        }
        SearchableRoutingCriteria other = (SearchableRoutingCriteria) obj;
        return hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchableRoutingCriteria").add("Steps", hasSteps() ? steps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Steps":
            return Optional.ofNullable(clazz.cast(steps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Steps", STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchableRoutingCriteria, T> g) {
        return obj -> g.apply((SearchableRoutingCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchableRoutingCriteria> {
        /**
         * <p>
         * The list of Routing criteria steps of the contact routing.
         * </p>
         * 
         * @param steps
         *        The list of Routing criteria steps of the contact routing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<SearchableRoutingCriteriaStep> steps);

        /**
         * <p>
         * The list of Routing criteria steps of the contact routing.
         * </p>
         * 
         * @param steps
         *        The list of Routing criteria steps of the contact routing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(SearchableRoutingCriteriaStep... steps);

        /**
         * <p>
         * The list of Routing criteria steps of the contact routing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.SearchableRoutingCriteriaStep.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.SearchableRoutingCriteriaStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.SearchableRoutingCriteriaStep.Builder#build()} is called
         * immediately and its result is passed to {@link #steps(List<SearchableRoutingCriteriaStep>)}.
         * 
         * @param steps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.SearchableRoutingCriteriaStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(java.util.Collection<SearchableRoutingCriteriaStep>)
         */
        Builder steps(Consumer<SearchableRoutingCriteriaStep.Builder>... steps);
    }

    static final class BuilderImpl implements Builder {
        private List<SearchableRoutingCriteriaStep> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchableRoutingCriteria model) {
            steps(model.steps);
        }

        public final List<SearchableRoutingCriteriaStep.Builder> getSteps() {
            List<SearchableRoutingCriteriaStep.Builder> result = SearchableRoutingCriteriaStepListCopier
                    .copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<SearchableRoutingCriteriaStep.BuilderImpl> steps) {
            this.steps = SearchableRoutingCriteriaStepListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<SearchableRoutingCriteriaStep> steps) {
            this.steps = SearchableRoutingCriteriaStepListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(SearchableRoutingCriteriaStep... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<SearchableRoutingCriteriaStep.Builder>... steps) {
            steps(Stream.of(steps).map(c -> SearchableRoutingCriteriaStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchableRoutingCriteria build() {
            return new SearchableRoutingCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
