/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchWorkspaceAssociationsResponse extends ConnectResponse implements
        ToCopyableBuilder<SearchWorkspaceAssociationsResponse.Builder, SearchWorkspaceAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchWorkspaceAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<WorkspaceAssociationSearchSummary>> WORKSPACE_ASSOCIATIONS_FIELD = SdkField
            .<List<WorkspaceAssociationSearchSummary>> builder(MarshallingType.LIST)
            .memberName("WorkspaceAssociations")
            .getter(getter(SearchWorkspaceAssociationsResponse::workspaceAssociations))
            .setter(setter(Builder::workspaceAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceAssociationSearchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceAssociationSearchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApproximateTotalCount").getter(getter(SearchWorkspaceAssociationsResponse::approximateTotalCount))
            .setter(setter(Builder::approximateTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKSPACE_ASSOCIATIONS_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<WorkspaceAssociationSearchSummary> workspaceAssociations;

    private final Long approximateTotalCount;

    private SearchWorkspaceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workspaceAssociations = builder.workspaceAssociations;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkspaceAssociations() {
        return workspaceAssociations != null && !(workspaceAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of workspace associations that match the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceAssociations} method.
     * </p>
     * 
     * @return A list of workspace associations that match the search criteria.
     */
    public final List<WorkspaceAssociationSearchSummary> workspaceAssociations() {
        return workspaceAssociations;
    }

    /**
     * <p>
     * The approximate total number of workspace associations that match the search criteria.
     * </p>
     * 
     * @return The approximate total number of workspace associations that match the search criteria.
     */
    public final Long approximateTotalCount() {
        return approximateTotalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceAssociations() ? workspaceAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(approximateTotalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchWorkspaceAssociationsResponse)) {
            return false;
        }
        SearchWorkspaceAssociationsResponse other = (SearchWorkspaceAssociationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWorkspaceAssociations() == other.hasWorkspaceAssociations()
                && Objects.equals(workspaceAssociations(), other.workspaceAssociations())
                && Objects.equals(approximateTotalCount(), other.approximateTotalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchWorkspaceAssociationsResponse").add("NextToken", nextToken())
                .add("WorkspaceAssociations", hasWorkspaceAssociations() ? workspaceAssociations() : null)
                .add("ApproximateTotalCount", approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WorkspaceAssociations":
            return Optional.ofNullable(clazz.cast(workspaceAssociations()));
        case "ApproximateTotalCount":
            return Optional.ofNullable(clazz.cast(approximateTotalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WorkspaceAssociations", WORKSPACE_ASSOCIATIONS_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchWorkspaceAssociationsResponse, T> g) {
        return obj -> g.apply((SearchWorkspaceAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchWorkspaceAssociationsResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of workspace associations that match the search criteria.
         * </p>
         * 
         * @param workspaceAssociations
         *        A list of workspace associations that match the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceAssociations(Collection<WorkspaceAssociationSearchSummary> workspaceAssociations);

        /**
         * <p>
         * A list of workspace associations that match the search criteria.
         * </p>
         * 
         * @param workspaceAssociations
         *        A list of workspace associations that match the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceAssociations(WorkspaceAssociationSearchSummary... workspaceAssociations);

        /**
         * <p>
         * A list of workspace associations that match the search criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #workspaceAssociations(List<WorkspaceAssociationSearchSummary>)}.
         * 
         * @param workspaceAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceAssociations(java.util.Collection<WorkspaceAssociationSearchSummary>)
         */
        Builder workspaceAssociations(Consumer<WorkspaceAssociationSearchSummary.Builder>... workspaceAssociations);

        /**
         * <p>
         * The approximate total number of workspace associations that match the search criteria.
         * </p>
         * 
         * @param approximateTotalCount
         *        The approximate total number of workspace associations that match the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateTotalCount(Long approximateTotalCount);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WorkspaceAssociationSearchSummary> workspaceAssociations = DefaultSdkAutoConstructList.getInstance();

        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchWorkspaceAssociationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            workspaceAssociations(model.workspaceAssociations);
            approximateTotalCount(model.approximateTotalCount);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkspaceAssociationSearchSummary.Builder> getWorkspaceAssociations() {
            List<WorkspaceAssociationSearchSummary.Builder> result = WorkspaceAssociationSearchSummaryListCopier
                    .copyToBuilder(this.workspaceAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaceAssociations(Collection<WorkspaceAssociationSearchSummary.BuilderImpl> workspaceAssociations) {
            this.workspaceAssociations = WorkspaceAssociationSearchSummaryListCopier.copyFromBuilder(workspaceAssociations);
        }

        @Override
        public final Builder workspaceAssociations(Collection<WorkspaceAssociationSearchSummary> workspaceAssociations) {
            this.workspaceAssociations = WorkspaceAssociationSearchSummaryListCopier.copy(workspaceAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceAssociations(WorkspaceAssociationSearchSummary... workspaceAssociations) {
            workspaceAssociations(Arrays.asList(workspaceAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceAssociations(Consumer<WorkspaceAssociationSearchSummary.Builder>... workspaceAssociations) {
            workspaceAssociations(Stream.of(workspaceAssociations)
                    .map(c -> WorkspaceAssociationSearchSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getApproximateTotalCount() {
            return approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchWorkspaceAssociationsResponse build() {
            return new SearchWorkspaceAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
