/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchDataTablesResponse extends ConnectResponse implements
        ToCopyableBuilder<SearchDataTablesResponse.Builder, SearchDataTablesResponse> {
    private static final SdkField<List<DataTable>> DATA_TABLES_FIELD = SdkField
            .<List<DataTable>> builder(MarshallingType.LIST)
            .memberName("DataTables")
            .getter(getter(SearchDataTablesResponse::dataTables))
            .setter(setter(Builder::dataTables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchDataTablesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApproximateTotalCount").getter(getter(SearchDataTablesResponse::approximateTotalCount))
            .setter(setter(Builder::approximateTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TABLES_FIELD,
            NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataTable> dataTables;

    private final String nextToken;

    private final Long approximateTotalCount;

    private SearchDataTablesResponse(BuilderImpl builder) {
        super(builder);
        this.dataTables = builder.dataTables;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataTables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataTables() {
        return dataTables != null && !(dataTables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of data tables matching the search criteria with the same structure as DescribeTable except Version,
     * VersionDescription, and LockVersion are omitted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataTables} method.
     * </p>
     * 
     * @return An array of data tables matching the search criteria with the same structure as DescribeTable except
     *         Version, VersionDescription, and LockVersion are omitted.
     */
    public final List<DataTable> dataTables() {
        return dataTables;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The approximate number of data tables that matched the search criteria.
     * </p>
     * 
     * @return The approximate number of data tables that matched the search criteria.
     */
    public final Long approximateTotalCount() {
        return approximateTotalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataTables() ? dataTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(approximateTotalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDataTablesResponse)) {
            return false;
        }
        SearchDataTablesResponse other = (SearchDataTablesResponse) obj;
        return hasDataTables() == other.hasDataTables() && Objects.equals(dataTables(), other.dataTables())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(approximateTotalCount(), other.approximateTotalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchDataTablesResponse").add("DataTables", hasDataTables() ? dataTables() : null)
                .add("NextToken", nextToken()).add("ApproximateTotalCount", approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTables":
            return Optional.ofNullable(clazz.cast(dataTables()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ApproximateTotalCount":
            return Optional.ofNullable(clazz.cast(approximateTotalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataTables", DATA_TABLES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchDataTablesResponse, T> g) {
        return obj -> g.apply((SearchDataTablesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchDataTablesResponse> {
        /**
         * <p>
         * An array of data tables matching the search criteria with the same structure as DescribeTable except Version,
         * VersionDescription, and LockVersion are omitted.
         * </p>
         * 
         * @param dataTables
         *        An array of data tables matching the search criteria with the same structure as DescribeTable except
         *        Version, VersionDescription, and LockVersion are omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTables(Collection<DataTable> dataTables);

        /**
         * <p>
         * An array of data tables matching the search criteria with the same structure as DescribeTable except Version,
         * VersionDescription, and LockVersion are omitted.
         * </p>
         * 
         * @param dataTables
         *        An array of data tables matching the search criteria with the same structure as DescribeTable except
         *        Version, VersionDescription, and LockVersion are omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTables(DataTable... dataTables);

        /**
         * <p>
         * An array of data tables matching the search criteria with the same structure as DescribeTable except Version,
         * VersionDescription, and LockVersion are omitted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.DataTable.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.DataTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.DataTable.Builder#build()} is called immediately and its
         * result is passed to {@link #dataTables(List<DataTable>)}.
         * 
         * @param dataTables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.DataTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataTables(java.util.Collection<DataTable>)
         */
        Builder dataTables(Consumer<DataTable.Builder>... dataTables);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The approximate number of data tables that matched the search criteria.
         * </p>
         * 
         * @param approximateTotalCount
         *        The approximate number of data tables that matched the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateTotalCount(Long approximateTotalCount);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<DataTable> dataTables = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDataTablesResponse model) {
            super(model);
            dataTables(model.dataTables);
            nextToken(model.nextToken);
            approximateTotalCount(model.approximateTotalCount);
        }

        public final List<DataTable.Builder> getDataTables() {
            List<DataTable.Builder> result = DataTableListCopier.copyToBuilder(this.dataTables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataTables(Collection<DataTable.BuilderImpl> dataTables) {
            this.dataTables = DataTableListCopier.copyFromBuilder(dataTables);
        }

        @Override
        public final Builder dataTables(Collection<DataTable> dataTables) {
            this.dataTables = DataTableListCopier.copy(dataTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTables(DataTable... dataTables) {
            dataTables(Arrays.asList(dataTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTables(Consumer<DataTable.Builder>... dataTables) {
            dataTables(Stream.of(dataTables).map(c -> DataTable.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchDataTablesResponse build() {
            return new SearchDataTablesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
