/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchContactsRequest extends ConnectRequest implements
        ToCopyableBuilder<SearchContactsRequest.Builder, SearchContactsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SearchContactsRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<SearchContactsTimeRange> TIME_RANGE_FIELD = SdkField
            .<SearchContactsTimeRange> builder(MarshallingType.SDK_POJO).memberName("TimeRange")
            .getter(getter(SearchContactsRequest::timeRange)).setter(setter(Builder::timeRange))
            .constructor(SearchContactsTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()).build();

    private static final SdkField<SearchCriteria> SEARCH_CRITERIA_FIELD = SdkField
            .<SearchCriteria> builder(MarshallingType.SDK_POJO).memberName("SearchCriteria")
            .getter(getter(SearchContactsRequest::searchCriteria)).setter(setter(Builder::searchCriteria))
            .constructor(SearchCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchContactsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchContactsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Sort> SORT_FIELD = SdkField.<Sort> builder(MarshallingType.SDK_POJO).memberName("Sort")
            .getter(getter(SearchContactsRequest::sort)).setter(setter(Builder::sort)).constructor(Sort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            TIME_RANGE_FIELD, SEARCH_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final SearchContactsTimeRange timeRange;

    private final SearchCriteria searchCriteria;

    private final Integer maxResults;

    private final String nextToken;

    private final Sort sort;

    private SearchContactsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.timeRange = builder.timeRange;
        this.searchCriteria = builder.searchCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
    }

    /**
     * <p>
     * The identifier of Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the
     * instance.
     * </p>
     * 
     * @return The identifier of Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN)
     *         of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Time range that you want to search results.
     * </p>
     * 
     * @return Time range that you want to search results.
     */
    public final SearchContactsTimeRange timeRange() {
        return timeRange;
    }

    /**
     * <p>
     * The search criteria to be used to return contacts.
     * </p>
     * 
     * @return The search criteria to be used to return contacts.
     */
    public final SearchCriteria searchCriteria() {
        return searchCriteria;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies a field to sort by and a sort order.
     * </p>
     * 
     * @return Specifies a field to sort by and a sort order.
     */
    public final Sort sort() {
        return sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(searchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsRequest)) {
            return false;
        }
        SearchContactsRequest other = (SearchContactsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(timeRange(), other.timeRange())
                && Objects.equals(searchCriteria(), other.searchCriteria()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sort(), other.sort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchContactsRequest").add("InstanceId", instanceId()).add("TimeRange", timeRange())
                .add("SearchCriteria", searchCriteria()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Sort", sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "TimeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        case "SearchCriteria":
            return Optional.ofNullable(clazz.cast(searchCriteria()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("TimeRange", TIME_RANGE_FIELD);
        map.put("SearchCriteria", SEARCH_CRITERIA_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsRequest, T> g) {
        return obj -> g.apply((SearchContactsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchContactsRequest> {
        /**
         * <p>
         * The identifier of Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of
         * the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of Amazon Connect instance. You can find the instance ID in the Amazon Resource Name
         *        (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Time range that you want to search results.
         * </p>
         * 
         * @param timeRange
         *        Time range that you want to search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(SearchContactsTimeRange timeRange);

        /**
         * <p>
         * Time range that you want to search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchContactsTimeRange.Builder} avoiding
         * the need to create one manually via {@link SearchContactsTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchContactsTimeRange.Builder#build()} is called immediately
         * and its result is passed to {@link #timeRange(SearchContactsTimeRange)}.
         * 
         * @param timeRange
         *        a consumer that will call methods on {@link SearchContactsTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRange(SearchContactsTimeRange)
         */
        default Builder timeRange(Consumer<SearchContactsTimeRange.Builder> timeRange) {
            return timeRange(SearchContactsTimeRange.builder().applyMutation(timeRange).build());
        }

        /**
         * <p>
         * The search criteria to be used to return contacts.
         * </p>
         * 
         * @param searchCriteria
         *        The search criteria to be used to return contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCriteria(SearchCriteria searchCriteria);

        /**
         * <p>
         * The search criteria to be used to return contacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchCriteria.Builder} avoiding the need
         * to create one manually via {@link SearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #searchCriteria(SearchCriteria)}.
         * 
         * @param searchCriteria
         *        a consumer that will call methods on {@link SearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchCriteria(SearchCriteria)
         */
        default Builder searchCriteria(Consumer<SearchCriteria.Builder> searchCriteria) {
            return searchCriteria(SearchCriteria.builder().applyMutation(searchCriteria).build());
        }

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies a field to sort by and a sort order.
         * </p>
         * 
         * @param sort
         *        Specifies a field to sort by and a sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(Sort sort);

        /**
         * <p>
         * Specifies a field to sort by and a sort order.
         * </p>
         * This is a convenience method that creates an instance of the {@link Sort.Builder} avoiding the need to create
         * one manually via {@link Sort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sort.Builder#build()} is called immediately and its result is
         * passed to {@link #sort(Sort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link Sort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(Sort)
         */
        default Builder sort(Consumer<Sort.Builder> sort) {
            return sort(Sort.builder().applyMutation(sort).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private SearchContactsTimeRange timeRange;

        private SearchCriteria searchCriteria;

        private Integer maxResults;

        private String nextToken;

        private Sort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsRequest model) {
            super(model);
            instanceId(model.instanceId);
            timeRange(model.timeRange);
            searchCriteria(model.searchCriteria);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sort(model.sort);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final SearchContactsTimeRange.Builder getTimeRange() {
            return timeRange != null ? timeRange.toBuilder() : null;
        }

        public final void setTimeRange(SearchContactsTimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(SearchContactsTimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final SearchCriteria.Builder getSearchCriteria() {
            return searchCriteria != null ? searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(SearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(SearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Sort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(Sort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchContactsRequest build() {
            return new SearchContactsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
