/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAvailablePhoneNumbersRequest extends ConnectRequest implements
        ToCopyableBuilder<SearchAvailablePhoneNumbersRequest.Builder, SearchAvailablePhoneNumbersRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(SearchAvailablePhoneNumbersRequest::targetArn))
            .setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SearchAvailablePhoneNumbersRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> PHONE_NUMBER_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberCountryCode")
            .getter(getter(SearchAvailablePhoneNumbersRequest::phoneNumberCountryCodeAsString))
            .setter(setter(Builder::phoneNumberCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountryCode").build())
            .build();

    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberType").getter(getter(SearchAvailablePhoneNumbersRequest::phoneNumberTypeAsString))
            .setter(setter(Builder::phoneNumberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()).build();

    private static final SdkField<String> PHONE_NUMBER_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberPrefix").getter(getter(SearchAvailablePhoneNumbersRequest::phoneNumberPrefix))
            .setter(setter(Builder::phoneNumberPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberPrefix").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchAvailablePhoneNumbersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchAvailablePhoneNumbersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            INSTANCE_ID_FIELD, PHONE_NUMBER_COUNTRY_CODE_FIELD, PHONE_NUMBER_TYPE_FIELD, PHONE_NUMBER_PREFIX_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetArn;

    private final String instanceId;

    private final String phoneNumberCountryCode;

    private final String phoneNumberType;

    private final String phoneNumberPrefix;

    private final Integer maxResults;

    private final String nextToken;

    private SearchAvailablePhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.instanceId = builder.instanceId;
        this.phoneNumberCountryCode = builder.phoneNumberCountryCode;
        this.phoneNumberType = builder.phoneNumberType;
        this.phoneNumberPrefix = builder.phoneNumberPrefix;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number
     * inbound traffic is routed through. You must enter <code>InstanceId</code> or <code>TargetArn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone
     *         number inbound traffic is routed through. You must enter <code>InstanceId</code> or
     *         <code>TargetArn</code>.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or <code>TargetArn</code>.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or
     *         <code>TargetArn</code>.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #phoneNumberCountryCode} will return {@link PhoneNumberCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #phoneNumberCountryCodeAsString}.
     * </p>
     * 
     * @return The ISO country code.
     * @see PhoneNumberCountryCode
     */
    public final PhoneNumberCountryCode phoneNumberCountryCode() {
        return PhoneNumberCountryCode.fromValue(phoneNumberCountryCode);
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #phoneNumberCountryCode} will return {@link PhoneNumberCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #phoneNumberCountryCodeAsString}.
     * </p>
     * 
     * @return The ISO country code.
     * @see PhoneNumberCountryCode
     */
    public final String phoneNumberCountryCodeAsString() {
        return phoneNumberCountryCode;
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number.
     * @see PhoneNumberType
     */
    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(phoneNumberType);
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number.
     * @see PhoneNumberType
     */
    public final String phoneNumberTypeAsString() {
        return phoneNumberType;
    }

    /**
     * <p>
     * The prefix of the phone number. If provided, it must contain <code>+</code> as part of the country code.
     * </p>
     * 
     * @return The prefix of the phone number. If provided, it must contain <code>+</code> as part of the country code.
     */
    public final String phoneNumberPrefix() {
        return phoneNumberPrefix;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberCountryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersRequest)) {
            return false;
        }
        SearchAvailablePhoneNumbersRequest other = (SearchAvailablePhoneNumbersRequest) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(phoneNumberCountryCodeAsString(), other.phoneNumberCountryCodeAsString())
                && Objects.equals(phoneNumberTypeAsString(), other.phoneNumberTypeAsString())
                && Objects.equals(phoneNumberPrefix(), other.phoneNumberPrefix())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAvailablePhoneNumbersRequest").add("TargetArn", targetArn())
                .add("InstanceId", instanceId()).add("PhoneNumberCountryCode", phoneNumberCountryCodeAsString())
                .add("PhoneNumberType", phoneNumberTypeAsString()).add("PhoneNumberPrefix", phoneNumberPrefix())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PhoneNumberCountryCode":
            return Optional.ofNullable(clazz.cast(phoneNumberCountryCodeAsString()));
        case "PhoneNumberType":
            return Optional.ofNullable(clazz.cast(phoneNumberTypeAsString()));
        case "PhoneNumberPrefix":
            return Optional.ofNullable(clazz.cast(phoneNumberPrefix()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetArn", TARGET_ARN_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("PhoneNumberCountryCode", PHONE_NUMBER_COUNTRY_CODE_FIELD);
        map.put("PhoneNumberType", PHONE_NUMBER_TYPE_FIELD);
        map.put("PhoneNumberPrefix", PHONE_NUMBER_PREFIX_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersRequest, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchAvailablePhoneNumbersRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number
         * inbound traffic is routed through. You must enter <code>InstanceId</code> or <code>TargetArn</code>.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone
         *        number inbound traffic is routed through. You must enter <code>InstanceId</code> or
         *        <code>TargetArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or
         * <code>TargetArn</code>.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or
         *        <code>TargetArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCode
         *        The ISO country code.
         * @see PhoneNumberCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberCountryCode
         */
        Builder phoneNumberCountryCode(String phoneNumberCountryCode);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCode
         *        The ISO country code.
         * @see PhoneNumberCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberCountryCode
         */
        Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberType
         *        The type of phone number.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(String phoneNumberType);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberType
         *        The type of phone number.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(PhoneNumberType phoneNumberType);

        /**
         * <p>
         * The prefix of the phone number. If provided, it must contain <code>+</code> as part of the country code.
         * </p>
         * 
         * @param phoneNumberPrefix
         *        The prefix of the phone number. If provided, it must contain <code>+</code> as part of the country
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberPrefix(String phoneNumberPrefix);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String targetArn;

        private String instanceId;

        private String phoneNumberCountryCode;

        private String phoneNumberType;

        private String phoneNumberPrefix;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersRequest model) {
            super(model);
            targetArn(model.targetArn);
            instanceId(model.instanceId);
            phoneNumberCountryCode(model.phoneNumberCountryCode);
            phoneNumberType(model.phoneNumberType);
            phoneNumberPrefix(model.phoneNumberPrefix);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPhoneNumberCountryCode() {
            return phoneNumberCountryCode;
        }

        public final void setPhoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
        }

        @Override
        public final Builder phoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode) {
            this.phoneNumberCountryCode(phoneNumberCountryCode == null ? null : phoneNumberCountryCode.toString());
            return this;
        }

        public final String getPhoneNumberType() {
            return phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        public final String getPhoneNumberPrefix() {
            return phoneNumberPrefix;
        }

        public final void setPhoneNumberPrefix(String phoneNumberPrefix) {
            this.phoneNumberPrefix = phoneNumberPrefix;
        }

        @Override
        public final Builder phoneNumberPrefix(String phoneNumberPrefix) {
            this.phoneNumberPrefix = phoneNumberPrefix;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAvailablePhoneNumbersRequest build() {
            return new SearchAvailablePhoneNumbersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
