/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a queue for a quick connect. The flow must be of type Transfer to Queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueQuickConnectConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<QueueQuickConnectConfig.Builder, QueueQuickConnectConfig> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueId").getter(getter(QueueQuickConnectConfig::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(QueueQuickConnectConfig::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD,
            CONTACT_FLOW_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queueId;

    private final String contactFlowId;

    private QueueQuickConnectConfig(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.contactFlowId = builder.contactFlowId;
    }

    /**
     * <p>
     * The identifier for the queue.
     * </p>
     * 
     * @return The identifier for the queue.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The identifier of the flow.
     * </p>
     * 
     * @return The identifier of the flow.
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueQuickConnectConfig)) {
            return false;
        }
        QueueQuickConnectConfig other = (QueueQuickConnectConfig) obj;
        return Objects.equals(queueId(), other.queueId()) && Objects.equals(contactFlowId(), other.contactFlowId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueueQuickConnectConfig").add("QueueId", queueId()).add("ContactFlowId", contactFlowId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueueQuickConnectConfig, T> g) {
        return obj -> g.apply((QueueQuickConnectConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueQuickConnectConfig> {
        /**
         * <p>
         * The identifier for the queue.
         * </p>
         * 
         * @param queueId
         *        The identifier for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The identifier of the flow.
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);
    }

    static final class BuilderImpl implements Builder {
        private String queueId;

        private String contactFlowId;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueQuickConnectConfig model) {
            queueId(model.queueId);
            contactFlowId(model.contactFlowId);
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        @Override
        public QueueQuickConnectConfig build() {
            return new QueueQuickConnectConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
