/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A primary attribute access control configuration item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrimaryAttributeAccessControlConfigurationItem implements SdkPojo, Serializable,
        ToCopyableBuilder<PrimaryAttributeAccessControlConfigurationItem.Builder, PrimaryAttributeAccessControlConfigurationItem> {
    private static final SdkField<List<PrimaryAttributeValue>> PRIMARY_ATTRIBUTE_VALUES_FIELD = SdkField
            .<List<PrimaryAttributeValue>> builder(MarshallingType.LIST)
            .memberName("PrimaryAttributeValues")
            .getter(getter(PrimaryAttributeAccessControlConfigurationItem::primaryAttributeValues))
            .setter(setter(Builder::primaryAttributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAttributeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrimaryAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrimaryAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRIMARY_ATTRIBUTE_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PrimaryAttributeValue> primaryAttributeValues;

    private PrimaryAttributeAccessControlConfigurationItem(BuilderImpl builder) {
        this.primaryAttributeValues = builder.primaryAttributeValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryAttributeValues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrimaryAttributeValues() {
        return primaryAttributeValues != null && !(primaryAttributeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The item's primary attribute values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryAttributeValues} method.
     * </p>
     * 
     * @return The item's primary attribute values.
     */
    public final List<PrimaryAttributeValue> primaryAttributeValues() {
        return primaryAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryAttributeValues() ? primaryAttributeValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrimaryAttributeAccessControlConfigurationItem)) {
            return false;
        }
        PrimaryAttributeAccessControlConfigurationItem other = (PrimaryAttributeAccessControlConfigurationItem) obj;
        return hasPrimaryAttributeValues() == other.hasPrimaryAttributeValues()
                && Objects.equals(primaryAttributeValues(), other.primaryAttributeValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrimaryAttributeAccessControlConfigurationItem")
                .add("PrimaryAttributeValues", hasPrimaryAttributeValues() ? primaryAttributeValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryAttributeValues":
            return Optional.ofNullable(clazz.cast(primaryAttributeValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryAttributeValues", PRIMARY_ATTRIBUTE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrimaryAttributeAccessControlConfigurationItem, T> g) {
        return obj -> g.apply((PrimaryAttributeAccessControlConfigurationItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrimaryAttributeAccessControlConfigurationItem> {
        /**
         * <p>
         * The item's primary attribute values.
         * </p>
         * 
         * @param primaryAttributeValues
         *        The item's primary attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAttributeValues(Collection<PrimaryAttributeValue> primaryAttributeValues);

        /**
         * <p>
         * The item's primary attribute values.
         * </p>
         * 
         * @param primaryAttributeValues
         *        The item's primary attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAttributeValues(PrimaryAttributeValue... primaryAttributeValues);

        /**
         * <p>
         * The item's primary attribute values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PrimaryAttributeValue.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.PrimaryAttributeValue#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PrimaryAttributeValue.Builder#build()} is called
         * immediately and its result is passed to {@link #primaryAttributeValues(List<PrimaryAttributeValue>)}.
         * 
         * @param primaryAttributeValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PrimaryAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryAttributeValues(java.util.Collection<PrimaryAttributeValue>)
         */
        Builder primaryAttributeValues(Consumer<PrimaryAttributeValue.Builder>... primaryAttributeValues);
    }

    static final class BuilderImpl implements Builder {
        private List<PrimaryAttributeValue> primaryAttributeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrimaryAttributeAccessControlConfigurationItem model) {
            primaryAttributeValues(model.primaryAttributeValues);
        }

        public final List<PrimaryAttributeValue.Builder> getPrimaryAttributeValues() {
            List<PrimaryAttributeValue.Builder> result = PrimaryAttributeValuesSetCopier
                    .copyToBuilder(this.primaryAttributeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryAttributeValues(Collection<PrimaryAttributeValue.BuilderImpl> primaryAttributeValues) {
            this.primaryAttributeValues = PrimaryAttributeValuesSetCopier.copyFromBuilder(primaryAttributeValues);
        }

        @Override
        public final Builder primaryAttributeValues(Collection<PrimaryAttributeValue> primaryAttributeValues) {
            this.primaryAttributeValues = PrimaryAttributeValuesSetCopier.copy(primaryAttributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryAttributeValues(PrimaryAttributeValue... primaryAttributeValues) {
            primaryAttributeValues(Arrays.asList(primaryAttributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryAttributeValues(Consumer<PrimaryAttributeValue.Builder>... primaryAttributeValues) {
            primaryAttributeValues(Stream.of(primaryAttributeValues)
                    .map(c -> PrimaryAttributeValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PrimaryAttributeAccessControlConfigurationItem build() {
            return new PrimaryAttributeAccessControlConfigurationItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
