/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about agent-first preview mode outbound strategy configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Preview implements SdkPojo, Serializable, ToCopyableBuilder<Preview.Builder, Preview> {
    private static final SdkField<PostAcceptTimeoutConfig> POST_ACCEPT_TIMEOUT_CONFIG_FIELD = SdkField
            .<PostAcceptTimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("PostAcceptTimeoutConfig")
            .getter(getter(Preview::postAcceptTimeoutConfig)).setter(setter(Builder::postAcceptTimeoutConfig))
            .constructor(PostAcceptTimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAcceptTimeoutConfig").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_USER_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedUserActions")
            .getter(getter(Preview::allowedUserActionsAsStrings))
            .setter(setter(Builder::allowedUserActionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedUserActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POST_ACCEPT_TIMEOUT_CONFIG_FIELD, ALLOWED_USER_ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PostAcceptTimeoutConfig postAcceptTimeoutConfig;

    private final List<String> allowedUserActions;

    private Preview(BuilderImpl builder) {
        this.postAcceptTimeoutConfig = builder.postAcceptTimeoutConfig;
        this.allowedUserActions = builder.allowedUserActions;
    }

    /**
     * <p>
     * Countdown timer configuration after the agent accepted the preview outbound contact.
     * </p>
     * 
     * @return Countdown timer configuration after the agent accepted the preview outbound contact.
     */
    public final PostAcceptTimeoutConfig postAcceptTimeoutConfig() {
        return postAcceptTimeoutConfig;
    }

    /**
     * <p>
     * The actions the agent can perform after accepting the preview outbound contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedUserActions} method.
     * </p>
     * 
     * @return The actions the agent can perform after accepting the preview outbound contact.
     */
    public final List<AllowedUserAction> allowedUserActions() {
        return AllowedUserActionsCopier.copyStringToEnum(allowedUserActions);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedUserActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedUserActions() {
        return allowedUserActions != null && !(allowedUserActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions the agent can perform after accepting the preview outbound contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedUserActions} method.
     * </p>
     * 
     * @return The actions the agent can perform after accepting the preview outbound contact.
     */
    public final List<String> allowedUserActionsAsStrings() {
        return allowedUserActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(postAcceptTimeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedUserActions() ? allowedUserActionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preview)) {
            return false;
        }
        Preview other = (Preview) obj;
        return Objects.equals(postAcceptTimeoutConfig(), other.postAcceptTimeoutConfig())
                && hasAllowedUserActions() == other.hasAllowedUserActions()
                && Objects.equals(allowedUserActionsAsStrings(), other.allowedUserActionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Preview").add("PostAcceptTimeoutConfig", postAcceptTimeoutConfig())
                .add("AllowedUserActions", hasAllowedUserActions() ? allowedUserActionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PostAcceptTimeoutConfig":
            return Optional.ofNullable(clazz.cast(postAcceptTimeoutConfig()));
        case "AllowedUserActions":
            return Optional.ofNullable(clazz.cast(allowedUserActionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PostAcceptTimeoutConfig", POST_ACCEPT_TIMEOUT_CONFIG_FIELD);
        map.put("AllowedUserActions", ALLOWED_USER_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Preview, T> g) {
        return obj -> g.apply((Preview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Preview> {
        /**
         * <p>
         * Countdown timer configuration after the agent accepted the preview outbound contact.
         * </p>
         * 
         * @param postAcceptTimeoutConfig
         *        Countdown timer configuration after the agent accepted the preview outbound contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postAcceptTimeoutConfig(PostAcceptTimeoutConfig postAcceptTimeoutConfig);

        /**
         * <p>
         * Countdown timer configuration after the agent accepted the preview outbound contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostAcceptTimeoutConfig.Builder} avoiding
         * the need to create one manually via {@link PostAcceptTimeoutConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostAcceptTimeoutConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #postAcceptTimeoutConfig(PostAcceptTimeoutConfig)}.
         * 
         * @param postAcceptTimeoutConfig
         *        a consumer that will call methods on {@link PostAcceptTimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postAcceptTimeoutConfig(PostAcceptTimeoutConfig)
         */
        default Builder postAcceptTimeoutConfig(Consumer<PostAcceptTimeoutConfig.Builder> postAcceptTimeoutConfig) {
            return postAcceptTimeoutConfig(PostAcceptTimeoutConfig.builder().applyMutation(postAcceptTimeoutConfig).build());
        }

        /**
         * <p>
         * The actions the agent can perform after accepting the preview outbound contact.
         * </p>
         * 
         * @param allowedUserActions
         *        The actions the agent can perform after accepting the preview outbound contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedUserActionsWithStrings(Collection<String> allowedUserActions);

        /**
         * <p>
         * The actions the agent can perform after accepting the preview outbound contact.
         * </p>
         * 
         * @param allowedUserActions
         *        The actions the agent can perform after accepting the preview outbound contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedUserActionsWithStrings(String... allowedUserActions);

        /**
         * <p>
         * The actions the agent can perform after accepting the preview outbound contact.
         * </p>
         * 
         * @param allowedUserActions
         *        The actions the agent can perform after accepting the preview outbound contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedUserActions(Collection<AllowedUserAction> allowedUserActions);

        /**
         * <p>
         * The actions the agent can perform after accepting the preview outbound contact.
         * </p>
         * 
         * @param allowedUserActions
         *        The actions the agent can perform after accepting the preview outbound contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedUserActions(AllowedUserAction... allowedUserActions);
    }

    static final class BuilderImpl implements Builder {
        private PostAcceptTimeoutConfig postAcceptTimeoutConfig;

        private List<String> allowedUserActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Preview model) {
            postAcceptTimeoutConfig(model.postAcceptTimeoutConfig);
            allowedUserActionsWithStrings(model.allowedUserActions);
        }

        public final PostAcceptTimeoutConfig.Builder getPostAcceptTimeoutConfig() {
            return postAcceptTimeoutConfig != null ? postAcceptTimeoutConfig.toBuilder() : null;
        }

        public final void setPostAcceptTimeoutConfig(PostAcceptTimeoutConfig.BuilderImpl postAcceptTimeoutConfig) {
            this.postAcceptTimeoutConfig = postAcceptTimeoutConfig != null ? postAcceptTimeoutConfig.build() : null;
        }

        @Override
        public final Builder postAcceptTimeoutConfig(PostAcceptTimeoutConfig postAcceptTimeoutConfig) {
            this.postAcceptTimeoutConfig = postAcceptTimeoutConfig;
            return this;
        }

        public final Collection<String> getAllowedUserActions() {
            if (allowedUserActions instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedUserActions;
        }

        public final void setAllowedUserActions(Collection<String> allowedUserActions) {
            this.allowedUserActions = AllowedUserActionsCopier.copy(allowedUserActions);
        }

        @Override
        public final Builder allowedUserActionsWithStrings(Collection<String> allowedUserActions) {
            this.allowedUserActions = AllowedUserActionsCopier.copy(allowedUserActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedUserActionsWithStrings(String... allowedUserActions) {
            allowedUserActionsWithStrings(Arrays.asList(allowedUserActions));
            return this;
        }

        @Override
        public final Builder allowedUserActions(Collection<AllowedUserAction> allowedUserActions) {
            this.allowedUserActions = AllowedUserActionsCopier.copyEnumToString(allowedUserActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedUserActions(AllowedUserAction... allowedUserActions) {
            allowedUserActions(Arrays.asList(allowedUserActions));
            return this;
        }

        @Override
        public Preview build() {
            return new Preview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
