/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a participant's interactions in a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantMetrics.Builder, ParticipantMetrics> {
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(ParticipantMetrics::participantId)).setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantType").getter(getter(ParticipantMetrics::participantTypeAsString))
            .setter(setter(Builder::participantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()).build();

    private static final SdkField<Boolean> CONVERSATION_ABANDON_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConversationAbandon").getter(getter(ParticipantMetrics::conversationAbandon))
            .setter(setter(Builder::conversationAbandon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversationAbandon").build())
            .build();

    private static final SdkField<Integer> MESSAGES_SENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MessagesSent").getter(getter(ParticipantMetrics::messagesSent)).setter(setter(Builder::messagesSent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagesSent").build()).build();

    private static final SdkField<Integer> NUM_RESPONSES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumResponses").getter(getter(ParticipantMetrics::numResponses)).setter(setter(Builder::numResponses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResponses").build()).build();

    private static final SdkField<Integer> MESSAGE_LENGTH_IN_CHARS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MessageLengthInChars").getter(getter(ParticipantMetrics::messageLengthInChars))
            .setter(setter(Builder::messageLengthInChars))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageLengthInChars").build())
            .build();

    private static final SdkField<Long> TOTAL_RESPONSE_TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalResponseTimeInMillis").getter(getter(ParticipantMetrics::totalResponseTimeInMillis))
            .setter(setter(Builder::totalResponseTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResponseTimeInMillis").build())
            .build();

    private static final SdkField<Long> MAX_RESPONSE_TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxResponseTimeInMillis").getter(getter(ParticipantMetrics::maxResponseTimeInMillis))
            .setter(setter(Builder::maxResponseTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResponseTimeInMillis").build())
            .build();

    private static final SdkField<Instant> LAST_MESSAGE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastMessageTimestamp").getter(getter(ParticipantMetrics::lastMessageTimestamp))
            .setter(setter(Builder::lastMessageTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMessageTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ID_FIELD,
            PARTICIPANT_TYPE_FIELD, CONVERSATION_ABANDON_FIELD, MESSAGES_SENT_FIELD, NUM_RESPONSES_FIELD,
            MESSAGE_LENGTH_IN_CHARS_FIELD, TOTAL_RESPONSE_TIME_IN_MILLIS_FIELD, MAX_RESPONSE_TIME_IN_MILLIS_FIELD,
            LAST_MESSAGE_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String participantId;

    private final String participantType;

    private final Boolean conversationAbandon;

    private final Integer messagesSent;

    private final Integer numResponses;

    private final Integer messageLengthInChars;

    private final Long totalResponseTimeInMillis;

    private final Long maxResponseTimeInMillis;

    private final Instant lastMessageTimestamp;

    private ParticipantMetrics(BuilderImpl builder) {
        this.participantId = builder.participantId;
        this.participantType = builder.participantType;
        this.conversationAbandon = builder.conversationAbandon;
        this.messagesSent = builder.messagesSent;
        this.numResponses = builder.numResponses;
        this.messageLengthInChars = builder.messageLengthInChars;
        this.totalResponseTimeInMillis = builder.totalResponseTimeInMillis;
        this.maxResponseTimeInMillis = builder.maxResponseTimeInMillis;
        this.lastMessageTimestamp = builder.lastMessageTimestamp;
    }

    /**
     * <p>
     * The Participant's ID.
     * </p>
     * 
     * @return The Participant's ID.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * Information about the conversation participant. Following are the participant types: [Agent, Customer,
     * Supervisor].
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Information about the conversation participant. Following are the participant types: [Agent, Customer,
     *         Supervisor].
     * @see ParticipantType
     */
    public final ParticipantType participantType() {
        return ParticipantType.fromValue(participantType);
    }

    /**
     * <p>
     * Information about the conversation participant. Following are the participant types: [Agent, Customer,
     * Supervisor].
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Information about the conversation participant. Following are the participant types: [Agent, Customer,
     *         Supervisor].
     * @see ParticipantType
     */
    public final String participantTypeAsString() {
        return participantType;
    }

    /**
     * <p>
     * A boolean flag indicating whether the chat conversation was abandoned by a Participant.
     * </p>
     * 
     * @return A boolean flag indicating whether the chat conversation was abandoned by a Participant.
     */
    public final Boolean conversationAbandon() {
        return conversationAbandon;
    }

    /**
     * <p>
     * Number of chat messages sent by Participant.
     * </p>
     * 
     * @return Number of chat messages sent by Participant.
     */
    public final Integer messagesSent() {
        return messagesSent;
    }

    /**
     * <p>
     * Number of chat messages sent by Participant.
     * </p>
     * 
     * @return Number of chat messages sent by Participant.
     */
    public final Integer numResponses() {
        return numResponses;
    }

    /**
     * <p>
     * Number of chat characters sent by Participant.
     * </p>
     * 
     * @return Number of chat characters sent by Participant.
     */
    public final Integer messageLengthInChars() {
        return messageLengthInChars;
    }

    /**
     * <p>
     * Total chat response time by Participant.
     * </p>
     * 
     * @return Total chat response time by Participant.
     */
    public final Long totalResponseTimeInMillis() {
        return totalResponseTimeInMillis;
    }

    /**
     * <p>
     * Maximum chat response time by Participant.
     * </p>
     * 
     * @return Maximum chat response time by Participant.
     */
    public final Long maxResponseTimeInMillis() {
        return maxResponseTimeInMillis;
    }

    /**
     * <p>
     * Timestamp of last chat message by Participant.
     * </p>
     * 
     * @return Timestamp of last chat message by Participant.
     */
    public final Instant lastMessageTimestamp() {
        return lastMessageTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conversationAbandon());
        hashCode = 31 * hashCode + Objects.hashCode(messagesSent());
        hashCode = 31 * hashCode + Objects.hashCode(numResponses());
        hashCode = 31 * hashCode + Objects.hashCode(messageLengthInChars());
        hashCode = 31 * hashCode + Objects.hashCode(totalResponseTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(maxResponseTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(lastMessageTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantMetrics)) {
            return false;
        }
        ParticipantMetrics other = (ParticipantMetrics) obj;
        return Objects.equals(participantId(), other.participantId())
                && Objects.equals(participantTypeAsString(), other.participantTypeAsString())
                && Objects.equals(conversationAbandon(), other.conversationAbandon())
                && Objects.equals(messagesSent(), other.messagesSent()) && Objects.equals(numResponses(), other.numResponses())
                && Objects.equals(messageLengthInChars(), other.messageLengthInChars())
                && Objects.equals(totalResponseTimeInMillis(), other.totalResponseTimeInMillis())
                && Objects.equals(maxResponseTimeInMillis(), other.maxResponseTimeInMillis())
                && Objects.equals(lastMessageTimestamp(), other.lastMessageTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantMetrics").add("ParticipantId", participantId())
                .add("ParticipantType", participantTypeAsString()).add("ConversationAbandon", conversationAbandon())
                .add("MessagesSent", messagesSent()).add("NumResponses", numResponses())
                .add("MessageLengthInChars", messageLengthInChars())
                .add("TotalResponseTimeInMillis", totalResponseTimeInMillis())
                .add("MaxResponseTimeInMillis", maxResponseTimeInMillis()).add("LastMessageTimestamp", lastMessageTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "ParticipantType":
            return Optional.ofNullable(clazz.cast(participantTypeAsString()));
        case "ConversationAbandon":
            return Optional.ofNullable(clazz.cast(conversationAbandon()));
        case "MessagesSent":
            return Optional.ofNullable(clazz.cast(messagesSent()));
        case "NumResponses":
            return Optional.ofNullable(clazz.cast(numResponses()));
        case "MessageLengthInChars":
            return Optional.ofNullable(clazz.cast(messageLengthInChars()));
        case "TotalResponseTimeInMillis":
            return Optional.ofNullable(clazz.cast(totalResponseTimeInMillis()));
        case "MaxResponseTimeInMillis":
            return Optional.ofNullable(clazz.cast(maxResponseTimeInMillis()));
        case "LastMessageTimestamp":
            return Optional.ofNullable(clazz.cast(lastMessageTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParticipantId", PARTICIPANT_ID_FIELD);
        map.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
        map.put("ConversationAbandon", CONVERSATION_ABANDON_FIELD);
        map.put("MessagesSent", MESSAGES_SENT_FIELD);
        map.put("NumResponses", NUM_RESPONSES_FIELD);
        map.put("MessageLengthInChars", MESSAGE_LENGTH_IN_CHARS_FIELD);
        map.put("TotalResponseTimeInMillis", TOTAL_RESPONSE_TIME_IN_MILLIS_FIELD);
        map.put("MaxResponseTimeInMillis", MAX_RESPONSE_TIME_IN_MILLIS_FIELD);
        map.put("LastMessageTimestamp", LAST_MESSAGE_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantMetrics, T> g) {
        return obj -> g.apply((ParticipantMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantMetrics> {
        /**
         * <p>
         * The Participant's ID.
         * </p>
         * 
         * @param participantId
         *        The Participant's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * Information about the conversation participant. Following are the participant types: [Agent, Customer,
         * Supervisor].
         * </p>
         * 
         * @param participantType
         *        Information about the conversation participant. Following are the participant types: [Agent, Customer,
         *        Supervisor].
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(String participantType);

        /**
         * <p>
         * Information about the conversation participant. Following are the participant types: [Agent, Customer,
         * Supervisor].
         * </p>
         * 
         * @param participantType
         *        Information about the conversation participant. Following are the participant types: [Agent, Customer,
         *        Supervisor].
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(ParticipantType participantType);

        /**
         * <p>
         * A boolean flag indicating whether the chat conversation was abandoned by a Participant.
         * </p>
         * 
         * @param conversationAbandon
         *        A boolean flag indicating whether the chat conversation was abandoned by a Participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationAbandon(Boolean conversationAbandon);

        /**
         * <p>
         * Number of chat messages sent by Participant.
         * </p>
         * 
         * @param messagesSent
         *        Number of chat messages sent by Participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messagesSent(Integer messagesSent);

        /**
         * <p>
         * Number of chat messages sent by Participant.
         * </p>
         * 
         * @param numResponses
         *        Number of chat messages sent by Participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResponses(Integer numResponses);

        /**
         * <p>
         * Number of chat characters sent by Participant.
         * </p>
         * 
         * @param messageLengthInChars
         *        Number of chat characters sent by Participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageLengthInChars(Integer messageLengthInChars);

        /**
         * <p>
         * Total chat response time by Participant.
         * </p>
         * 
         * @param totalResponseTimeInMillis
         *        Total chat response time by Participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResponseTimeInMillis(Long totalResponseTimeInMillis);

        /**
         * <p>
         * Maximum chat response time by Participant.
         * </p>
         * 
         * @param maxResponseTimeInMillis
         *        Maximum chat response time by Participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResponseTimeInMillis(Long maxResponseTimeInMillis);

        /**
         * <p>
         * Timestamp of last chat message by Participant.
         * </p>
         * 
         * @param lastMessageTimestamp
         *        Timestamp of last chat message by Participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMessageTimestamp(Instant lastMessageTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String participantId;

        private String participantType;

        private Boolean conversationAbandon;

        private Integer messagesSent;

        private Integer numResponses;

        private Integer messageLengthInChars;

        private Long totalResponseTimeInMillis;

        private Long maxResponseTimeInMillis;

        private Instant lastMessageTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantMetrics model) {
            participantId(model.participantId);
            participantType(model.participantType);
            conversationAbandon(model.conversationAbandon);
            messagesSent(model.messagesSent);
            numResponses(model.numResponses);
            messageLengthInChars(model.messageLengthInChars);
            totalResponseTimeInMillis(model.totalResponseTimeInMillis);
            maxResponseTimeInMillis(model.maxResponseTimeInMillis);
            lastMessageTimestamp(model.lastMessageTimestamp);
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantType() {
            return participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final Boolean getConversationAbandon() {
            return conversationAbandon;
        }

        public final void setConversationAbandon(Boolean conversationAbandon) {
            this.conversationAbandon = conversationAbandon;
        }

        @Override
        public final Builder conversationAbandon(Boolean conversationAbandon) {
            this.conversationAbandon = conversationAbandon;
            return this;
        }

        public final Integer getMessagesSent() {
            return messagesSent;
        }

        public final void setMessagesSent(Integer messagesSent) {
            this.messagesSent = messagesSent;
        }

        @Override
        public final Builder messagesSent(Integer messagesSent) {
            this.messagesSent = messagesSent;
            return this;
        }

        public final Integer getNumResponses() {
            return numResponses;
        }

        public final void setNumResponses(Integer numResponses) {
            this.numResponses = numResponses;
        }

        @Override
        public final Builder numResponses(Integer numResponses) {
            this.numResponses = numResponses;
            return this;
        }

        public final Integer getMessageLengthInChars() {
            return messageLengthInChars;
        }

        public final void setMessageLengthInChars(Integer messageLengthInChars) {
            this.messageLengthInChars = messageLengthInChars;
        }

        @Override
        public final Builder messageLengthInChars(Integer messageLengthInChars) {
            this.messageLengthInChars = messageLengthInChars;
            return this;
        }

        public final Long getTotalResponseTimeInMillis() {
            return totalResponseTimeInMillis;
        }

        public final void setTotalResponseTimeInMillis(Long totalResponseTimeInMillis) {
            this.totalResponseTimeInMillis = totalResponseTimeInMillis;
        }

        @Override
        public final Builder totalResponseTimeInMillis(Long totalResponseTimeInMillis) {
            this.totalResponseTimeInMillis = totalResponseTimeInMillis;
            return this;
        }

        public final Long getMaxResponseTimeInMillis() {
            return maxResponseTimeInMillis;
        }

        public final void setMaxResponseTimeInMillis(Long maxResponseTimeInMillis) {
            this.maxResponseTimeInMillis = maxResponseTimeInMillis;
        }

        @Override
        public final Builder maxResponseTimeInMillis(Long maxResponseTimeInMillis) {
            this.maxResponseTimeInMillis = maxResponseTimeInMillis;
            return this;
        }

        public final Instant getLastMessageTimestamp() {
            return lastMessageTimestamp;
        }

        public final void setLastMessageTimestamp(Instant lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
        }

        @Override
        public final Builder lastMessageTimestamp(Instant lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
            return this;
        }

        @Override
        public ParticipantMetrics build() {
            return new ParticipantMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
