/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entry representing the next contact in a sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NextContactEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<NextContactEntry.Builder, NextContactEntry> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(NextContactEntry::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<NextContactMetadata> NEXT_CONTACT_METADATA_FIELD = SdkField
            .<NextContactMetadata> builder(MarshallingType.SDK_POJO).memberName("NextContactMetadata")
            .getter(getter(NextContactEntry::nextContactMetadata)).setter(setter(Builder::nextContactMetadata))
            .constructor(NextContactMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextContactMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            NEXT_CONTACT_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final NextContactMetadata nextContactMetadata;

    private NextContactEntry(BuilderImpl builder) {
        this.type = builder.type;
        this.nextContactMetadata = builder.nextContactMetadata;
    }

    /**
     * <p>
     * The type of the next contact entry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NextContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the next contact entry.
     * @see NextContactType
     */
    public final NextContactType type() {
        return NextContactType.fromValue(type);
    }

    /**
     * <p>
     * The type of the next contact entry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NextContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the next contact entry.
     * @see NextContactType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Metadata for the next contact entry.
     * </p>
     * 
     * @return Metadata for the next contact entry.
     */
    public final NextContactMetadata nextContactMetadata() {
        return nextContactMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextContactMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NextContactEntry)) {
            return false;
        }
        NextContactEntry other = (NextContactEntry) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(nextContactMetadata(), other.nextContactMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NextContactEntry").add("Type", typeAsString()).add("NextContactMetadata", nextContactMetadata())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "NextContactMetadata":
            return Optional.ofNullable(clazz.cast(nextContactMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("NextContactMetadata", NEXT_CONTACT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NextContactEntry, T> g) {
        return obj -> g.apply((NextContactEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NextContactEntry> {
        /**
         * <p>
         * The type of the next contact entry.
         * </p>
         * 
         * @param type
         *        The type of the next contact entry.
         * @see NextContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NextContactType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the next contact entry.
         * </p>
         * 
         * @param type
         *        The type of the next contact entry.
         * @see NextContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NextContactType
         */
        Builder type(NextContactType type);

        /**
         * <p>
         * Metadata for the next contact entry.
         * </p>
         * 
         * @param nextContactMetadata
         *        Metadata for the next contact entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextContactMetadata(NextContactMetadata nextContactMetadata);

        /**
         * <p>
         * Metadata for the next contact entry.
         * </p>
         * This is a convenience method that creates an instance of the {@link NextContactMetadata.Builder} avoiding the
         * need to create one manually via {@link NextContactMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NextContactMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #nextContactMetadata(NextContactMetadata)}.
         * 
         * @param nextContactMetadata
         *        a consumer that will call methods on {@link NextContactMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextContactMetadata(NextContactMetadata)
         */
        default Builder nextContactMetadata(Consumer<NextContactMetadata.Builder> nextContactMetadata) {
            return nextContactMetadata(NextContactMetadata.builder().applyMutation(nextContactMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private NextContactMetadata nextContactMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(NextContactEntry model) {
            type(model.type);
            nextContactMetadata(model.nextContactMetadata);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NextContactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final NextContactMetadata.Builder getNextContactMetadata() {
            return nextContactMetadata != null ? nextContactMetadata.toBuilder() : null;
        }

        public final void setNextContactMetadata(NextContactMetadata.BuilderImpl nextContactMetadata) {
            this.nextContactMetadata = nextContactMetadata != null ? nextContactMetadata.build() : null;
        }

        @Override
        public final Builder nextContactMetadata(NextContactMetadata nextContactMetadata) {
            this.nextContactMetadata = nextContactMetadata;
            return this;
        }

        @Override
        public NextContactEntry build() {
            return new NextContactEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
