/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MetricsV2Copier {
    static List<MetricV2> copy(Collection<? extends MetricV2> metricsV2Param) {
        List<MetricV2> list;
        if (metricsV2Param == null || metricsV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricV2> modifiableList = new ArrayList<>(metricsV2Param.size());
            metricsV2Param.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MetricV2> copyFromBuilder(Collection<? extends MetricV2.Builder> metricsV2Param) {
        List<MetricV2> list;
        if (metricsV2Param == null || metricsV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricV2> modifiableList = new ArrayList<>(metricsV2Param.size());
            metricsV2Param.forEach(entry -> {
                MetricV2 member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MetricV2.Builder> copyToBuilder(Collection<? extends MetricV2> metricsV2Param) {
        List<MetricV2.Builder> list;
        if (metricsV2Param == null || metricsV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricV2.Builder> modifiableList = new ArrayList<>(metricsV2Param.size());
            metricsV2Param.forEach(entry -> {
                MetricV2.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
