/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about properties for a text question in an evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormTextQuestionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormTextQuestionProperties.Builder, EvaluationFormTextQuestionProperties> {
    private static final SdkField<EvaluationFormTextQuestionAutomation> AUTOMATION_FIELD = SdkField
            .<EvaluationFormTextQuestionAutomation> builder(MarshallingType.SDK_POJO).memberName("Automation")
            .getter(getter(EvaluationFormTextQuestionProperties::automation)).setter(setter(Builder::automation))
            .constructor(EvaluationFormTextQuestionAutomation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationFormTextQuestionAutomation automation;

    private EvaluationFormTextQuestionProperties(BuilderImpl builder) {
        this.automation = builder.automation;
    }

    /**
     * <p>
     * The automation properties of the text question.
     * </p>
     * 
     * @return The automation properties of the text question.
     */
    public final EvaluationFormTextQuestionAutomation automation() {
        return automation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormTextQuestionProperties)) {
            return false;
        }
        EvaluationFormTextQuestionProperties other = (EvaluationFormTextQuestionProperties) obj;
        return Objects.equals(automation(), other.automation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormTextQuestionProperties").add("Automation", automation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Automation":
            return Optional.ofNullable(clazz.cast(automation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Automation", AUTOMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormTextQuestionProperties, T> g) {
        return obj -> g.apply((EvaluationFormTextQuestionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormTextQuestionProperties> {
        /**
         * <p>
         * The automation properties of the text question.
         * </p>
         * 
         * @param automation
         *        The automation properties of the text question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automation(EvaluationFormTextQuestionAutomation automation);

        /**
         * <p>
         * The automation properties of the text question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormTextQuestionAutomation.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormTextQuestionAutomation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormTextQuestionAutomation.Builder#build()} is called
         * immediately and its result is passed to {@link #automation(EvaluationFormTextQuestionAutomation)}.
         * 
         * @param automation
         *        a consumer that will call methods on {@link EvaluationFormTextQuestionAutomation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automation(EvaluationFormTextQuestionAutomation)
         */
        default Builder automation(Consumer<EvaluationFormTextQuestionAutomation.Builder> automation) {
            return automation(EvaluationFormTextQuestionAutomation.builder().applyMutation(automation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationFormTextQuestionAutomation automation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormTextQuestionProperties model) {
            automation(model.automation);
        }

        public final EvaluationFormTextQuestionAutomation.Builder getAutomation() {
            return automation != null ? automation.toBuilder() : null;
        }

        public final void setAutomation(EvaluationFormTextQuestionAutomation.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        @Override
        public final Builder automation(EvaluationFormTextQuestionAutomation automation) {
            this.automation = automation;
            return this;
        }

        @Override
        public EvaluationFormTextQuestionProperties build() {
            return new EvaluationFormTextQuestionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
