/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An expression that defines a basic building block of conditional enablement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormItemEnablementExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormItemEnablementExpression.Builder, EvaluationFormItemEnablementExpression> {
    private static final SdkField<EvaluationFormItemEnablementSource> SOURCE_FIELD = SdkField
            .<EvaluationFormItemEnablementSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(EvaluationFormItemEnablementExpression::source)).setter(setter(Builder::source))
            .constructor(EvaluationFormItemEnablementSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<EvaluationFormItemEnablementSourceValue>> VALUES_FIELD = SdkField
            .<List<EvaluationFormItemEnablementSourceValue>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(EvaluationFormItemEnablementExpression::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormItemEnablementSourceValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormItemEnablementSourceValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Comparator").getter(getter(EvaluationFormItemEnablementExpression::comparatorAsString))
            .setter(setter(Builder::comparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, VALUES_FIELD,
            COMPARATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationFormItemEnablementSource source;

    private final List<EvaluationFormItemEnablementSourceValue> values;

    private final String comparator;

    private EvaluationFormItemEnablementExpression(BuilderImpl builder) {
        this.source = builder.source;
        this.values = builder.values;
        this.comparator = builder.comparator;
    }

    /**
     * <p>
     * A source item of enablement expression.
     * </p>
     * 
     * @return A source item of enablement expression.
     */
    public final EvaluationFormItemEnablementSource source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of values from source item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of values from source item.
     */
    public final List<EvaluationFormItemEnablementSourceValue> values() {
        return values;
    }

    /**
     * <p>
     * A comparator to be used against list of values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link EvaluationFormItemSourceValuesComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #comparatorAsString}.
     * </p>
     * 
     * @return A comparator to be used against list of values.
     * @see EvaluationFormItemSourceValuesComparator
     */
    public final EvaluationFormItemSourceValuesComparator comparator() {
        return EvaluationFormItemSourceValuesComparator.fromValue(comparator);
    }

    /**
     * <p>
     * A comparator to be used against list of values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link EvaluationFormItemSourceValuesComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #comparatorAsString}.
     * </p>
     * 
     * @return A comparator to be used against list of values.
     * @see EvaluationFormItemSourceValuesComparator
     */
    public final String comparatorAsString() {
        return comparator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(comparatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItemEnablementExpression)) {
            return false;
        }
        EvaluationFormItemEnablementExpression other = (EvaluationFormItemEnablementExpression) obj;
        return Objects.equals(source(), other.source()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(comparatorAsString(), other.comparatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormItemEnablementExpression").add("Source", source())
                .add("Values", hasValues() ? values() : null).add("Comparator", comparatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Comparator":
            return Optional.ofNullable(clazz.cast(comparatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Source", SOURCE_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("Comparator", COMPARATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItemEnablementExpression, T> g) {
        return obj -> g.apply((EvaluationFormItemEnablementExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormItemEnablementExpression> {
        /**
         * <p>
         * A source item of enablement expression.
         * </p>
         * 
         * @param source
         *        A source item of enablement expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(EvaluationFormItemEnablementSource source);

        /**
         * <p>
         * A source item of enablement expression.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormItemEnablementSource.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormItemEnablementSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormItemEnablementSource.Builder#build()} is called
         * immediately and its result is passed to {@link #source(EvaluationFormItemEnablementSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link EvaluationFormItemEnablementSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(EvaluationFormItemEnablementSource)
         */
        default Builder source(Consumer<EvaluationFormItemEnablementSource.Builder> source) {
            return source(EvaluationFormItemEnablementSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * A list of values from source item.
         * </p>
         * 
         * @param values
         *        A list of values from source item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<EvaluationFormItemEnablementSourceValue> values);

        /**
         * <p>
         * A list of values from source item.
         * </p>
         * 
         * @param values
         *        A list of values from source item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(EvaluationFormItemEnablementSourceValue... values);

        /**
         * <p>
         * A list of values from source item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementSourceValue.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementSourceValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementSourceValue.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #values(List<EvaluationFormItemEnablementSourceValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementSourceValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<EvaluationFormItemEnablementSourceValue>)
         */
        Builder values(Consumer<EvaluationFormItemEnablementSourceValue.Builder>... values);

        /**
         * <p>
         * A comparator to be used against list of values.
         * </p>
         * 
         * @param comparator
         *        A comparator to be used against list of values.
         * @see EvaluationFormItemSourceValuesComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemSourceValuesComparator
         */
        Builder comparator(String comparator);

        /**
         * <p>
         * A comparator to be used against list of values.
         * </p>
         * 
         * @param comparator
         *        A comparator to be used against list of values.
         * @see EvaluationFormItemSourceValuesComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemSourceValuesComparator
         */
        Builder comparator(EvaluationFormItemSourceValuesComparator comparator);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationFormItemEnablementSource source;

        private List<EvaluationFormItemEnablementSourceValue> values = DefaultSdkAutoConstructList.getInstance();

        private String comparator;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItemEnablementExpression model) {
            source(model.source);
            values(model.values);
            comparator(model.comparator);
        }

        public final EvaluationFormItemEnablementSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(EvaluationFormItemEnablementSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(EvaluationFormItemEnablementSource source) {
            this.source = source;
            return this;
        }

        public final List<EvaluationFormItemEnablementSourceValue.Builder> getValues() {
            List<EvaluationFormItemEnablementSourceValue.Builder> result = EvaluationFormItemEnablementSourceValueListCopier
                    .copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<EvaluationFormItemEnablementSourceValue.BuilderImpl> values) {
            this.values = EvaluationFormItemEnablementSourceValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<EvaluationFormItemEnablementSourceValue> values) {
            this.values = EvaluationFormItemEnablementSourceValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(EvaluationFormItemEnablementSourceValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<EvaluationFormItemEnablementSourceValue.Builder>... values) {
            values(Stream.of(values).map(c -> EvaluationFormItemEnablementSourceValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getComparator() {
            return comparator;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(EvaluationFormItemSourceValuesComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        @Override
        public EvaluationFormItemEnablementExpression build() {
            return new EvaluationFormItemEnablementExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
