/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about answer data for a contact evaluation. Answer data must be either string, numeric, or not
 * applicable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationAnswerData implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationAnswerData.Builder, EvaluationAnswerData> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StringValue").getter(getter(EvaluationAnswerData::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final SdkField<Double> NUMERIC_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("NumericValue").getter(getter(EvaluationAnswerData::numericValue)).setter(setter(Builder::numericValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericValue").build()).build();

    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StringValues")
            .getter(getter(EvaluationAnswerData::stringValues))
            .setter(setter(Builder::stringValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATE_TIME_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateTimeValue").getter(getter(EvaluationAnswerData::dateTimeValue))
            .setter(setter(Builder::dateTimeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeValue").build()).build();

    private static final SdkField<Boolean> NOT_APPLICABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NotApplicable").getter(getter(EvaluationAnswerData::notApplicable))
            .setter(setter(Builder::notApplicable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotApplicable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            NUMERIC_VALUE_FIELD, STRING_VALUES_FIELD, DATE_TIME_VALUE_FIELD, NOT_APPLICABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final Double numericValue;

    private final List<String> stringValues;

    private final String dateTimeValue;

    private final Boolean notApplicable;

    private final Type type;

    private EvaluationAnswerData(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.numericValue = builder.numericValue;
        this.stringValues = builder.stringValues;
        this.dateTimeValue = builder.dateTimeValue;
        this.notApplicable = builder.notApplicable;
        this.type = builder.type;
    }

    /**
     * <p>
     * The string value for an answer in a contact evaluation.
     * </p>
     * 
     * @return The string value for an answer in a contact evaluation.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * The numeric value for an answer in a contact evaluation.
     * </p>
     * 
     * @return The numeric value for an answer in a contact evaluation.
     */
    public final Double numericValue() {
        return numericValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringValues() {
        return stringValues != null && !(stringValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * String values provided as answers to evaluation questions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringValues} method.
     * </p>
     * 
     * @return String values provided as answers to evaluation questions.
     */
    public final List<String> stringValues() {
        return stringValues;
    }

    /**
     * <p>
     * Date and time value provided as an answer to an evaluation question.
     * </p>
     * 
     * @return Date and time value provided as an answer to an evaluation question.
     */
    public final String dateTimeValue() {
        return dateTimeValue;
    }

    /**
     * <p>
     * The flag to mark the question as not applicable.
     * </p>
     * 
     * @return The flag to mark the question as not applicable.
     */
    public final Boolean notApplicable() {
        return notApplicable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(numericValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasStringValues() ? stringValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeValue());
        hashCode = 31 * hashCode + Objects.hashCode(notApplicable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAnswerData)) {
            return false;
        }
        EvaluationAnswerData other = (EvaluationAnswerData) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(numericValue(), other.numericValue())
                && hasStringValues() == other.hasStringValues() && Objects.equals(stringValues(), other.stringValues())
                && Objects.equals(dateTimeValue(), other.dateTimeValue())
                && Objects.equals(notApplicable(), other.notApplicable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationAnswerData").add("StringValue", stringValue()).add("NumericValue", numericValue())
                .add("StringValues", hasStringValues() ? stringValues() : null).add("DateTimeValue", dateTimeValue())
                .add("NotApplicable", notApplicable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "NumericValue":
            return Optional.ofNullable(clazz.cast(numericValue()));
        case "StringValues":
            return Optional.ofNullable(clazz.cast(stringValues()));
        case "DateTimeValue":
            return Optional.ofNullable(clazz.cast(dateTimeValue()));
        case "NotApplicable":
            return Optional.ofNullable(clazz.cast(notApplicable()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * The string value for an answer in a contact evaluation.
     * </p>
     * 
     * @param stringValue
     *        The string value for an answer in a contact evaluation.
     */
    public static EvaluationAnswerData fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #numericValue()} initialized to the given value.
     *
     * <p>
     * The numeric value for an answer in a contact evaluation.
     * </p>
     * 
     * @param numericValue
     *        The numeric value for an answer in a contact evaluation.
     */
    public static EvaluationAnswerData fromNumericValue(Double numericValue) {
        return builder().numericValue(numericValue).build();
    }

    /**
     * Create an instance of this class with {@link #stringValues()} initialized to the given value.
     *
     * <p>
     * String values provided as answers to evaluation questions.
     * </p>
     * 
     * @param stringValues
     *        String values provided as answers to evaluation questions.
     */
    public static EvaluationAnswerData fromStringValues(List<String> stringValues) {
        return builder().stringValues(stringValues).build();
    }

    /**
     * Create an instance of this class with {@link #dateTimeValue()} initialized to the given value.
     *
     * <p>
     * Date and time value provided as an answer to an evaluation question.
     * </p>
     * 
     * @param dateTimeValue
     *        Date and time value provided as an answer to an evaluation question.
     */
    public static EvaluationAnswerData fromDateTimeValue(String dateTimeValue) {
        return builder().dateTimeValue(dateTimeValue).build();
    }

    /**
     * Create an instance of this class with {@link #notApplicable()} initialized to the given value.
     *
     * <p>
     * The flag to mark the question as not applicable.
     * </p>
     * 
     * @param notApplicable
     *        The flag to mark the question as not applicable.
     */
    public static EvaluationAnswerData fromNotApplicable(Boolean notApplicable) {
        return builder().notApplicable(notApplicable).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringValue", STRING_VALUE_FIELD);
        map.put("NumericValue", NUMERIC_VALUE_FIELD);
        map.put("StringValues", STRING_VALUES_FIELD);
        map.put("DateTimeValue", DATE_TIME_VALUE_FIELD);
        map.put("NotApplicable", NOT_APPLICABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAnswerData, T> g) {
        return obj -> g.apply((EvaluationAnswerData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationAnswerData> {
        /**
         * <p>
         * The string value for an answer in a contact evaluation.
         * </p>
         * 
         * @param stringValue
         *        The string value for an answer in a contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * The numeric value for an answer in a contact evaluation.
         * </p>
         * 
         * @param numericValue
         *        The numeric value for an answer in a contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericValue(Double numericValue);

        /**
         * <p>
         * String values provided as answers to evaluation questions.
         * </p>
         * 
         * @param stringValues
         *        String values provided as answers to evaluation questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(Collection<String> stringValues);

        /**
         * <p>
         * String values provided as answers to evaluation questions.
         * </p>
         * 
         * @param stringValues
         *        String values provided as answers to evaluation questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(String... stringValues);

        /**
         * <p>
         * Date and time value provided as an answer to an evaluation question.
         * </p>
         * 
         * @param dateTimeValue
         *        Date and time value provided as an answer to an evaluation question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeValue(String dateTimeValue);

        /**
         * <p>
         * The flag to mark the question as not applicable.
         * </p>
         * 
         * @param notApplicable
         *        The flag to mark the question as not applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notApplicable(Boolean notApplicable);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private Double numericValue;

        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private String dateTimeValue;

        private Boolean notApplicable;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAnswerData model) {
            stringValue(model.stringValue);
            numericValue(model.numericValue);
            stringValues(model.stringValues);
            dateTimeValue(model.dateTimeValue);
            notApplicable(model.notApplicable);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Double getNumericValue() {
            return numericValue;
        }

        public final void setNumericValue(Double numericValue) {
            Object oldValue = this.numericValue;
            this.numericValue = numericValue;
            handleUnionValueChange(Type.NUMERIC_VALUE, oldValue, this.numericValue);
        }

        @Override
        public final Builder numericValue(Double numericValue) {
            Object oldValue = this.numericValue;
            this.numericValue = numericValue;
            handleUnionValueChange(Type.NUMERIC_VALUE, oldValue, this.numericValue);
            return this;
        }

        public final Collection<String> getStringValues() {
            if (stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            Object oldValue = this.stringValues;
            this.stringValues = EvaluationAnswerDataStringValueListCopier.copy(stringValues);
            handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            Object oldValue = this.stringValues;
            this.stringValues = EvaluationAnswerDataStringValueListCopier.copy(stringValues);
            handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String... stringValues) {
            stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final String getDateTimeValue() {
            return dateTimeValue;
        }

        public final void setDateTimeValue(String dateTimeValue) {
            Object oldValue = this.dateTimeValue;
            this.dateTimeValue = dateTimeValue;
            handleUnionValueChange(Type.DATE_TIME_VALUE, oldValue, this.dateTimeValue);
        }

        @Override
        public final Builder dateTimeValue(String dateTimeValue) {
            Object oldValue = this.dateTimeValue;
            this.dateTimeValue = dateTimeValue;
            handleUnionValueChange(Type.DATE_TIME_VALUE, oldValue, this.dateTimeValue);
            return this;
        }

        public final Boolean getNotApplicable() {
            return notApplicable;
        }

        public final void setNotApplicable(Boolean notApplicable) {
            Object oldValue = this.notApplicable;
            this.notApplicable = notApplicable;
            handleUnionValueChange(Type.NOT_APPLICABLE, oldValue, this.notApplicable);
        }

        @Override
        public final Builder notApplicable(Boolean notApplicable) {
            Object oldValue = this.notApplicable;
            this.notApplicable = notApplicable;
            handleUnionValueChange(Type.NOT_APPLICABLE, oldValue, this.notApplicable);
            return this;
        }

        @Override
        public EvaluationAnswerData build() {
            return new EvaluationAnswerData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationAnswerData#type()
     */
    public enum Type {
        STRING_VALUE,

        NUMERIC_VALUE,

        STRING_VALUES,

        DATE_TIME_VALUE,

        NOT_APPLICABLE,

        UNKNOWN_TO_SDK_VERSION
    }
}
