/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an email address for a contact center.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailAddressMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailAddressMetadata.Builder, EmailAddressMetadata> {
    private static final SdkField<String> EMAIL_ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddressId").getter(getter(EmailAddressMetadata::emailAddressId))
            .setter(setter(Builder::emailAddressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressId").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddressArn").getter(getter(EmailAddressMetadata::emailAddressArn))
            .setter(setter(Builder::emailAddressArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressArn").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(EmailAddressMetadata::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EmailAddressMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(EmailAddressMetadata::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<List<AliasConfiguration>> ALIAS_CONFIGURATIONS_FIELD = SdkField
            .<List<AliasConfiguration>> builder(MarshallingType.LIST)
            .memberName("AliasConfigurations")
            .getter(getter(EmailAddressMetadata::aliasConfigurations))
            .setter(setter(Builder::aliasConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AliasConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AliasConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_ID_FIELD,
            EMAIL_ADDRESS_ARN_FIELD, EMAIL_ADDRESS_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, ALIAS_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String emailAddressId;

    private final String emailAddressArn;

    private final String emailAddress;

    private final String description;

    private final String displayName;

    private final List<AliasConfiguration> aliasConfigurations;

    private EmailAddressMetadata(BuilderImpl builder) {
        this.emailAddressId = builder.emailAddressId;
        this.emailAddressArn = builder.emailAddressArn;
        this.emailAddress = builder.emailAddress;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.aliasConfigurations = builder.aliasConfigurations;
    }

    /**
     * <p>
     * The identifier of the email address.
     * </p>
     * 
     * @return The identifier of the email address.
     */
    public final String emailAddressId() {
        return emailAddressId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the email address.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the email address.
     */
    public final String emailAddressArn() {
        return emailAddressArn;
    }

    /**
     * <p>
     * The email address, including the domain.
     * </p>
     * 
     * @return The email address, including the domain.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The description of the email address.
     * </p>
     * 
     * @return The description of the email address.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of email address.
     * </p>
     * 
     * @return The display name of email address.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AliasConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAliasConfigurations() {
        return aliasConfigurations != null && !(aliasConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of alias configurations for this email address, showing which email addresses forward to this primary
     * address. Each configuration contains the email address ID of an alias that forwards emails to this address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliasConfigurations} method.
     * </p>
     * 
     * @return A list of alias configurations for this email address, showing which email addresses forward to this
     *         primary address. Each configuration contains the email address ID of an alias that forwards emails to
     *         this address.
     */
    public final List<AliasConfiguration> aliasConfigurations() {
        return aliasConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddressArn());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAliasConfigurations() ? aliasConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailAddressMetadata)) {
            return false;
        }
        EmailAddressMetadata other = (EmailAddressMetadata) obj;
        return Objects.equals(emailAddressId(), other.emailAddressId())
                && Objects.equals(emailAddressArn(), other.emailAddressArn())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && hasAliasConfigurations() == other.hasAliasConfigurations()
                && Objects.equals(aliasConfigurations(), other.aliasConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailAddressMetadata").add("EmailAddressId", emailAddressId())
                .add("EmailAddressArn", emailAddressArn())
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AliasConfigurations", hasAliasConfigurations() ? aliasConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddressId":
            return Optional.ofNullable(clazz.cast(emailAddressId()));
        case "EmailAddressArn":
            return Optional.ofNullable(clazz.cast(emailAddressArn()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "AliasConfigurations":
            return Optional.ofNullable(clazz.cast(aliasConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmailAddressId", EMAIL_ADDRESS_ID_FIELD);
        map.put("EmailAddressArn", EMAIL_ADDRESS_ARN_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("AliasConfigurations", ALIAS_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailAddressMetadata, T> g) {
        return obj -> g.apply((EmailAddressMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailAddressMetadata> {
        /**
         * <p>
         * The identifier of the email address.
         * </p>
         * 
         * @param emailAddressId
         *        The identifier of the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddressId(String emailAddressId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the email address.
         * </p>
         * 
         * @param emailAddressArn
         *        The Amazon Resource Name (ARN) of the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddressArn(String emailAddressArn);

        /**
         * <p>
         * The email address, including the domain.
         * </p>
         * 
         * @param emailAddress
         *        The email address, including the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The description of the email address.
         * </p>
         * 
         * @param description
         *        The description of the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of email address.
         * </p>
         * 
         * @param displayName
         *        The display name of email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A list of alias configurations for this email address, showing which email addresses forward to this primary
         * address. Each configuration contains the email address ID of an alias that forwards emails to this address.
         * </p>
         * 
         * @param aliasConfigurations
         *        A list of alias configurations for this email address, showing which email addresses forward to this
         *        primary address. Each configuration contains the email address ID of an alias that forwards emails to
         *        this address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasConfigurations(Collection<AliasConfiguration> aliasConfigurations);

        /**
         * <p>
         * A list of alias configurations for this email address, showing which email addresses forward to this primary
         * address. Each configuration contains the email address ID of an alias that forwards emails to this address.
         * </p>
         * 
         * @param aliasConfigurations
         *        A list of alias configurations for this email address, showing which email addresses forward to this
         *        primary address. Each configuration contains the email address ID of an alias that forwards emails to
         *        this address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasConfigurations(AliasConfiguration... aliasConfigurations);

        /**
         * <p>
         * A list of alias configurations for this email address, showing which email addresses forward to this primary
         * address. Each configuration contains the email address ID of an alias that forwards emails to this address.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.AliasConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.AliasConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.AliasConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #aliasConfigurations(List<AliasConfiguration>)}.
         * 
         * @param aliasConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.AliasConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliasConfigurations(java.util.Collection<AliasConfiguration>)
         */
        Builder aliasConfigurations(Consumer<AliasConfiguration.Builder>... aliasConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String emailAddressId;

        private String emailAddressArn;

        private String emailAddress;

        private String description;

        private String displayName;

        private List<AliasConfiguration> aliasConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailAddressMetadata model) {
            emailAddressId(model.emailAddressId);
            emailAddressArn(model.emailAddressArn);
            emailAddress(model.emailAddress);
            description(model.description);
            displayName(model.displayName);
            aliasConfigurations(model.aliasConfigurations);
        }

        public final String getEmailAddressId() {
            return emailAddressId;
        }

        public final void setEmailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
        }

        @Override
        public final Builder emailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
            return this;
        }

        public final String getEmailAddressArn() {
            return emailAddressArn;
        }

        public final void setEmailAddressArn(String emailAddressArn) {
            this.emailAddressArn = emailAddressArn;
        }

        @Override
        public final Builder emailAddressArn(String emailAddressArn) {
            this.emailAddressArn = emailAddressArn;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<AliasConfiguration.Builder> getAliasConfigurations() {
            List<AliasConfiguration.Builder> result = AliasConfigurationListCopier.copyToBuilder(this.aliasConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliasConfigurations(Collection<AliasConfiguration.BuilderImpl> aliasConfigurations) {
            this.aliasConfigurations = AliasConfigurationListCopier.copyFromBuilder(aliasConfigurations);
        }

        @Override
        public final Builder aliasConfigurations(Collection<AliasConfiguration> aliasConfigurations) {
            this.aliasConfigurations = AliasConfigurationListCopier.copy(aliasConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasConfigurations(AliasConfiguration... aliasConfigurations) {
            aliasConfigurations(Arrays.asList(aliasConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasConfigurations(Consumer<AliasConfiguration.Builder>... aliasConfigurations) {
            aliasConfigurations(Stream.of(aliasConfigurations).map(c -> AliasConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EmailAddressMetadata build() {
            return new EmailAddressMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
