/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A decimal search condition for Search APIs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecimalCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DecimalCondition.Builder, DecimalCondition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(DecimalCondition::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<Double> MIN_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinValue").getter(getter(DecimalCondition::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final SdkField<Double> MAX_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxValue").getter(getter(DecimalCondition::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final SdkField<String> COMPARISON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonType").getter(getter(DecimalCondition::comparisonTypeAsString))
            .setter(setter(Builder::comparisonType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            MIN_VALUE_FIELD, MAX_VALUE_FIELD, COMPARISON_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final Double minValue;

    private final Double maxValue;

    private final String comparisonType;

    private DecimalCondition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.comparisonType = builder.comparisonType;
    }

    /**
     * <p>
     * A name of the decimal property to be searched.
     * </p>
     * 
     * @return A name of the decimal property to be searched.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * A minimum value of the decimal property.
     * </p>
     * 
     * @return A minimum value of the decimal property.
     */
    public final Double minValue() {
        return minValue;
    }

    /**
     * <p>
     * A maximum value of the decimal property.
     * </p>
     * 
     * @return A maximum value of the decimal property.
     */
    public final Double maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the decimal condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link DecimalComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the decimal condition.
     * @see DecimalComparisonType
     */
    public final DecimalComparisonType comparisonType() {
        return DecimalComparisonType.fromValue(comparisonType);
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the decimal condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link DecimalComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the decimal condition.
     * @see DecimalComparisonType
     */
    public final String comparisonTypeAsString() {
        return comparisonType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalCondition)) {
            return false;
        }
        DecimalCondition other = (DecimalCondition) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(maxValue(), other.maxValue())
                && Objects.equals(comparisonTypeAsString(), other.comparisonTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecimalCondition").add("FieldName", fieldName()).add("MinValue", minValue())
                .add("MaxValue", maxValue()).add("ComparisonType", comparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "ComparisonType":
            return Optional.ofNullable(clazz.cast(comparisonTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("MinValue", MIN_VALUE_FIELD);
        map.put("MaxValue", MAX_VALUE_FIELD);
        map.put("ComparisonType", COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecimalCondition, T> g) {
        return obj -> g.apply((DecimalCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecimalCondition> {
        /**
         * <p>
         * A name of the decimal property to be searched.
         * </p>
         * 
         * @param fieldName
         *        A name of the decimal property to be searched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * A minimum value of the decimal property.
         * </p>
         * 
         * @param minValue
         *        A minimum value of the decimal property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Double minValue);

        /**
         * <p>
         * A maximum value of the decimal property.
         * </p>
         * 
         * @param maxValue
         *        A maximum value of the decimal property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Double maxValue);

        /**
         * <p>
         * The type of comparison to be made when evaluating the decimal condition.
         * </p>
         * 
         * @param comparisonType
         *        The type of comparison to be made when evaluating the decimal condition.
         * @see DecimalComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecimalComparisonType
         */
        Builder comparisonType(String comparisonType);

        /**
         * <p>
         * The type of comparison to be made when evaluating the decimal condition.
         * </p>
         * 
         * @param comparisonType
         *        The type of comparison to be made when evaluating the decimal condition.
         * @see DecimalComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecimalComparisonType
         */
        Builder comparisonType(DecimalComparisonType comparisonType);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private Double minValue;

        private Double maxValue;

        private String comparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalCondition model) {
            fieldName(model.fieldName);
            minValue(model.minValue);
            maxValue(model.maxValue);
            comparisonType(model.comparisonType);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final Double getMinValue() {
            return minValue;
        }

        public final void setMinValue(Double minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Double minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Double getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(Double maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final String getComparisonType() {
            return comparisonType;
        }

        public final void setComparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public final Builder comparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
            return this;
        }

        @Override
        public final Builder comparisonType(DecimalComparisonType comparisonType) {
            this.comparisonType(comparisonType == null ? null : comparisonType.toString());
            return this;
        }

        @Override
        public DecimalCondition build() {
            return new DecimalCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
