/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data table value summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTableValueSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataTableValueSummary.Builder, DataTableValueSummary> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordId").getter(getter(DataTableValueSummary::recordId)).setter(setter(Builder::recordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()).build();

    private static final SdkField<String> ATTRIBUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeId").getter(getter(DataTableValueSummary::attributeId)).setter(setter(Builder::attributeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeId").build()).build();

    private static final SdkField<List<PrimaryValueResponse>> PRIMARY_VALUES_FIELD = SdkField
            .<List<PrimaryValueResponse>> builder(MarshallingType.LIST)
            .memberName("PrimaryValues")
            .getter(getter(DataTableValueSummary::primaryValues))
            .setter(setter(Builder::primaryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrimaryValueResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrimaryValueResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(DataTableValueSummary::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(DataTableValueSummary::valueTypeAsString)).setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(DataTableValueSummary::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField
            .<DataTableLockVersion> builder(MarshallingType.SDK_POJO).memberName("LockVersion")
            .getter(getter(DataTableValueSummary::lockVersion)).setter(setter(Builder::lockVersion))
            .constructor(DataTableLockVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DataTableValueSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(DataTableValueSummary::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD,
            ATTRIBUTE_ID_FIELD, PRIMARY_VALUES_FIELD, ATTRIBUTE_NAME_FIELD, VALUE_TYPE_FIELD, VALUE_FIELD, LOCK_VERSION_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recordId;

    private final String attributeId;

    private final List<PrimaryValueResponse> primaryValues;

    private final String attributeName;

    private final String valueType;

    private final String value;

    private final DataTableLockVersion lockVersion;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private DataTableValueSummary(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.attributeId = builder.attributeId;
        this.primaryValues = builder.primaryValues;
        this.attributeName = builder.attributeName;
        this.valueType = builder.valueType;
        this.value = builder.value;
        this.lockVersion = builder.lockVersion;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * The summary's record ID.
     * </p>
     * 
     * @return The summary's record ID.
     */
    public final String recordId() {
        return recordId;
    }

    /**
     * <p>
     * The summary's attribute ID.
     * </p>
     * 
     * @return The summary's attribute ID.
     */
    public final String attributeId() {
        return attributeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryValues() {
        return primaryValues != null && !(primaryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary's primary values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryValues} method.
     * </p>
     * 
     * @return The summary's primary values.
     */
    public final List<PrimaryValueResponse> primaryValues() {
        return primaryValues;
    }

    /**
     * <p>
     * The summary's attribute name.
     * </p>
     * 
     * @return The summary's attribute name.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The summary's value type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DataTableAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The summary's value type.
     * @see DataTableAttributeValueType
     */
    public final DataTableAttributeValueType valueType() {
        return DataTableAttributeValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The summary's value type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DataTableAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The summary's value type.
     * @see DataTableAttributeValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    /**
     * <p>
     * The summary's value.
     * </p>
     * 
     * @return The summary's value.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The summary's lock version.
     * </p>
     * 
     * @return The summary's lock version.
     */
    public final DataTableLockVersion lockVersion() {
        return lockVersion;
    }

    /**
     * <p>
     * The summary's last modified time.
     * </p>
     * 
     * @return The summary's last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The summary's last modified region.
     * </p>
     * 
     * @return The summary's last modified region.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryValues() ? primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(lockVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableValueSummary)) {
            return false;
        }
        DataTableValueSummary other = (DataTableValueSummary) obj;
        return Objects.equals(recordId(), other.recordId()) && Objects.equals(attributeId(), other.attributeId())
                && hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(primaryValues(), other.primaryValues())
                && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(value(), other.value())
                && Objects.equals(lockVersion(), other.lockVersion())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataTableValueSummary").add("RecordId", recordId()).add("AttributeId", attributeId())
                .add("PrimaryValues", hasPrimaryValues() ? primaryValues() : null).add("AttributeName", attributeName())
                .add("ValueType", valueTypeAsString()).add("Value", value()).add("LockVersion", lockVersion())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordId":
            return Optional.ofNullable(clazz.cast(recordId()));
        case "AttributeId":
            return Optional.ofNullable(clazz.cast(attributeId()));
        case "PrimaryValues":
            return Optional.ofNullable(clazz.cast(primaryValues()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "LockVersion":
            return Optional.ofNullable(clazz.cast(lockVersion()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("AttributeId", ATTRIBUTE_ID_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableValueSummary, T> g) {
        return obj -> g.apply((DataTableValueSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTableValueSummary> {
        /**
         * <p>
         * The summary's record ID.
         * </p>
         * 
         * @param recordId
         *        The summary's record ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);

        /**
         * <p>
         * The summary's attribute ID.
         * </p>
         * 
         * @param attributeId
         *        The summary's attribute ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeId(String attributeId);

        /**
         * <p>
         * The summary's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The summary's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(Collection<PrimaryValueResponse> primaryValues);

        /**
         * <p>
         * The summary's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The summary's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(PrimaryValueResponse... primaryValues);

        /**
         * <p>
         * The summary's primary values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValueResponse.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.PrimaryValueResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValueResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #primaryValues(List<PrimaryValueResponse>)}.
         * 
         * @param primaryValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PrimaryValueResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValues(java.util.Collection<PrimaryValueResponse>)
         */
        Builder primaryValues(Consumer<PrimaryValueResponse.Builder>... primaryValues);

        /**
         * <p>
         * The summary's attribute name.
         * </p>
         * 
         * @param attributeName
         *        The summary's attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The summary's value type.
         * </p>
         * 
         * @param valueType
         *        The summary's value type.
         * @see DataTableAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableAttributeValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The summary's value type.
         * </p>
         * 
         * @param valueType
         *        The summary's value type.
         * @see DataTableAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableAttributeValueType
         */
        Builder valueType(DataTableAttributeValueType valueType);

        /**
         * <p>
         * The summary's value.
         * </p>
         * 
         * @param value
         *        The summary's value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The summary's lock version.
         * </p>
         * 
         * @param lockVersion
         *        The summary's lock version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockVersion(DataTableLockVersion lockVersion);

        /**
         * <p>
         * The summary's lock version.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableLockVersion.Builder} avoiding
         * the need to create one manually via {@link DataTableLockVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableLockVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #lockVersion(DataTableLockVersion)}.
         * 
         * @param lockVersion
         *        a consumer that will call methods on {@link DataTableLockVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockVersion(DataTableLockVersion)
         */
        default Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return lockVersion(DataTableLockVersion.builder().applyMutation(lockVersion).build());
        }

        /**
         * <p>
         * The summary's last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The summary's last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The summary's last modified region.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The summary's last modified region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);
    }

    static final class BuilderImpl implements Builder {
        private String recordId;

        private String attributeId;

        private List<PrimaryValueResponse> primaryValues = DefaultSdkAutoConstructList.getInstance();

        private String attributeName;

        private String valueType;

        private String value;

        private DataTableLockVersion lockVersion;

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableValueSummary model) {
            recordId(model.recordId);
            attributeId(model.attributeId);
            primaryValues(model.primaryValues);
            attributeName(model.attributeName);
            valueType(model.valueType);
            value(model.value);
            lockVersion(model.lockVersion);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getRecordId() {
            return recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final String getAttributeId() {
            return attributeId;
        }

        public final void setAttributeId(String attributeId) {
            this.attributeId = attributeId;
        }

        @Override
        public final Builder attributeId(String attributeId) {
            this.attributeId = attributeId;
            return this;
        }

        public final List<PrimaryValueResponse.Builder> getPrimaryValues() {
            List<PrimaryValueResponse.Builder> result = PrimaryValuesResponseSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValueResponse.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesResponseSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValueResponse> primaryValues) {
            this.primaryValues = PrimaryValuesResponseSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValueResponse... primaryValues) {
            primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValueResponse.Builder>... primaryValues) {
            primaryValues(Stream.of(primaryValues).map(c -> PrimaryValueResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DataTableAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return lockVersion != null ? lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public DataTableValueSummary build() {
            return new DataTableValueSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
