/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data table value evaluation set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTableValueEvaluationSet implements SdkPojo, Serializable,
        ToCopyableBuilder<DataTableValueEvaluationSet.Builder, DataTableValueEvaluationSet> {
    private static final SdkField<List<PrimaryValue>> PRIMARY_VALUES_FIELD = SdkField
            .<List<PrimaryValue>> builder(MarshallingType.LIST)
            .memberName("PrimaryValues")
            .getter(getter(DataTableValueEvaluationSet::primaryValues))
            .setter(setter(Builder::primaryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrimaryValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrimaryValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributeNames")
            .getter(getter(DataTableValueEvaluationSet::attributeNames))
            .setter(setter(Builder::attributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_VALUES_FIELD,
            ATTRIBUTE_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PrimaryValue> primaryValues;

    private final List<String> attributeNames;

    private DataTableValueEvaluationSet(BuilderImpl builder) {
        this.primaryValues = builder.primaryValues;
        this.attributeNames = builder.attributeNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryValues() {
        return primaryValues != null && !(primaryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set's primary values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryValues} method.
     * </p>
     * 
     * @return The set's primary values.
     */
    public final List<PrimaryValue> primaryValues() {
        return primaryValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeNames() {
        return attributeNames != null && !(attributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set's attribute names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return The set's attribute names.
     */
    public final List<String> attributeNames() {
        return attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryValues() ? primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeNames() ? attributeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableValueEvaluationSet)) {
            return false;
        }
        DataTableValueEvaluationSet other = (DataTableValueEvaluationSet) obj;
        return hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(primaryValues(), other.primaryValues())
                && hasAttributeNames() == other.hasAttributeNames() && Objects.equals(attributeNames(), other.attributeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataTableValueEvaluationSet").add("PrimaryValues", hasPrimaryValues() ? primaryValues() : null)
                .add("AttributeNames", hasAttributeNames() ? attributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryValues":
            return Optional.ofNullable(clazz.cast(primaryValues()));
        case "AttributeNames":
            return Optional.ofNullable(clazz.cast(attributeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("AttributeNames", ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableValueEvaluationSet, T> g) {
        return obj -> g.apply((DataTableValueEvaluationSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTableValueEvaluationSet> {
        /**
         * <p>
         * The set's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The set's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(Collection<PrimaryValue> primaryValues);

        /**
         * <p>
         * The set's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The set's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(PrimaryValue... primaryValues);

        /**
         * <p>
         * The set's primary values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.PrimaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryValues(List<PrimaryValue>)}.
         * 
         * @param primaryValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValues(java.util.Collection<PrimaryValue>)
         */
        Builder primaryValues(Consumer<PrimaryValue.Builder>... primaryValues);

        /**
         * <p>
         * The set's attribute names.
         * </p>
         * 
         * @param attributeNames
         *        The set's attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<String> attributeNames);

        /**
         * <p>
         * The set's attribute names.
         * </p>
         * 
         * @param attributeNames
         *        The set's attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(String... attributeNames);
    }

    static final class BuilderImpl implements Builder {
        private List<PrimaryValue> primaryValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableValueEvaluationSet model) {
            primaryValues(model.primaryValues);
            attributeNames(model.attributeNames);
        }

        public final List<PrimaryValue.Builder> getPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValue.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValue> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValue... primaryValues) {
            primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValue.Builder>... primaryValues) {
            primaryValues(Stream.of(primaryValues).map(c -> PrimaryValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public DataTableValueEvaluationSet build() {
            return new DataTableValueEvaluationSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
