/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data table evaluated value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTableEvaluatedValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DataTableEvaluatedValue.Builder, DataTableEvaluatedValue> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordId").getter(getter(DataTableEvaluatedValue::recordId)).setter(setter(Builder::recordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()).build();

    private static final SdkField<List<PrimaryValue>> PRIMARY_VALUES_FIELD = SdkField
            .<List<PrimaryValue>> builder(MarshallingType.LIST)
            .memberName("PrimaryValues")
            .getter(getter(DataTableEvaluatedValue::primaryValues))
            .setter(setter(Builder::primaryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrimaryValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrimaryValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(DataTableEvaluatedValue::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(DataTableEvaluatedValue::valueTypeAsString))
            .setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final SdkField<Boolean> FOUND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Found")
            .getter(getter(DataTableEvaluatedValue::found)).setter(setter(Builder::found))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Found").build()).build();

    private static final SdkField<Boolean> ERROR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Error")
            .getter(getter(DataTableEvaluatedValue::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> EVALUATED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluatedValue").getter(getter(DataTableEvaluatedValue::evaluatedValue))
            .setter(setter(Builder::evaluatedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD,
            PRIMARY_VALUES_FIELD, ATTRIBUTE_NAME_FIELD, VALUE_TYPE_FIELD, FOUND_FIELD, ERROR_FIELD, EVALUATED_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recordId;

    private final List<PrimaryValue> primaryValues;

    private final String attributeName;

    private final String valueType;

    private final Boolean found;

    private final Boolean error;

    private final String evaluatedValue;

    private DataTableEvaluatedValue(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.primaryValues = builder.primaryValues;
        this.attributeName = builder.attributeName;
        this.valueType = builder.valueType;
        this.found = builder.found;
        this.error = builder.error;
        this.evaluatedValue = builder.evaluatedValue;
    }

    /**
     * <p>
     * The value's record ID.
     * </p>
     * 
     * @return The value's record ID.
     */
    public final String recordId() {
        return recordId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryValues() {
        return primaryValues != null && !(primaryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value's primary values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryValues} method.
     * </p>
     * 
     * @return The value's primary values.
     */
    public final List<PrimaryValue> primaryValues() {
        return primaryValues;
    }

    /**
     * <p>
     * The value's attribute name.
     * </p>
     * 
     * @return The value's attribute name.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The value's value type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DataTableAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The value's value type.
     * @see DataTableAttributeValueType
     */
    public final DataTableAttributeValueType valueType() {
        return DataTableAttributeValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The value's value type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DataTableAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The value's value type.
     * @see DataTableAttributeValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    /**
     * <p>
     * The value's found.
     * </p>
     * 
     * @return The value's found.
     */
    public final Boolean found() {
        return found;
    }

    /**
     * <p>
     * The value's error.
     * </p>
     * 
     * @return The value's error.
     */
    public final Boolean error() {
        return error;
    }

    /**
     * <p>
     * The value's evaluated value.
     * </p>
     * 
     * @return The value's evaluated value.
     */
    public final String evaluatedValue() {
        return evaluatedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryValues() ? primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(found());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(evaluatedValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableEvaluatedValue)) {
            return false;
        }
        DataTableEvaluatedValue other = (DataTableEvaluatedValue) obj;
        return Objects.equals(recordId(), other.recordId()) && hasPrimaryValues() == other.hasPrimaryValues()
                && Objects.equals(primaryValues(), other.primaryValues())
                && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(found(), other.found())
                && Objects.equals(error(), other.error()) && Objects.equals(evaluatedValue(), other.evaluatedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataTableEvaluatedValue").add("RecordId", recordId())
                .add("PrimaryValues", hasPrimaryValues() ? primaryValues() : null).add("AttributeName", attributeName())
                .add("ValueType", valueTypeAsString()).add("Found", found()).add("Error", error())
                .add("EvaluatedValue", evaluatedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordId":
            return Optional.ofNullable(clazz.cast(recordId()));
        case "PrimaryValues":
            return Optional.ofNullable(clazz.cast(primaryValues()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        case "Found":
            return Optional.ofNullable(clazz.cast(found()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "EvaluatedValue":
            return Optional.ofNullable(clazz.cast(evaluatedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Found", FOUND_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("EvaluatedValue", EVALUATED_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableEvaluatedValue, T> g) {
        return obj -> g.apply((DataTableEvaluatedValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTableEvaluatedValue> {
        /**
         * <p>
         * The value's record ID.
         * </p>
         * 
         * @param recordId
         *        The value's record ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);

        /**
         * <p>
         * The value's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The value's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(Collection<PrimaryValue> primaryValues);

        /**
         * <p>
         * The value's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The value's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(PrimaryValue... primaryValues);

        /**
         * <p>
         * The value's primary values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.PrimaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryValues(List<PrimaryValue>)}.
         * 
         * @param primaryValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValues(java.util.Collection<PrimaryValue>)
         */
        Builder primaryValues(Consumer<PrimaryValue.Builder>... primaryValues);

        /**
         * <p>
         * The value's attribute name.
         * </p>
         * 
         * @param attributeName
         *        The value's attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The value's value type.
         * </p>
         * 
         * @param valueType
         *        The value's value type.
         * @see DataTableAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableAttributeValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The value's value type.
         * </p>
         * 
         * @param valueType
         *        The value's value type.
         * @see DataTableAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableAttributeValueType
         */
        Builder valueType(DataTableAttributeValueType valueType);

        /**
         * <p>
         * The value's found.
         * </p>
         * 
         * @param found
         *        The value's found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder found(Boolean found);

        /**
         * <p>
         * The value's error.
         * </p>
         * 
         * @param error
         *        The value's error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(Boolean error);

        /**
         * <p>
         * The value's evaluated value.
         * </p>
         * 
         * @param evaluatedValue
         *        The value's evaluated value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedValue(String evaluatedValue);
    }

    static final class BuilderImpl implements Builder {
        private String recordId;

        private List<PrimaryValue> primaryValues = DefaultSdkAutoConstructList.getInstance();

        private String attributeName;

        private String valueType;

        private Boolean found;

        private Boolean error;

        private String evaluatedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableEvaluatedValue model) {
            recordId(model.recordId);
            primaryValues(model.primaryValues);
            attributeName(model.attributeName);
            valueType(model.valueType);
            found(model.found);
            error(model.error);
            evaluatedValue(model.evaluatedValue);
        }

        public final String getRecordId() {
            return recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final List<PrimaryValue.Builder> getPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValue.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValue> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValue... primaryValues) {
            primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValue.Builder>... primaryValues) {
            primaryValues(Stream.of(primaryValues).map(c -> PrimaryValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DataTableAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final Boolean getFound() {
            return found;
        }

        public final void setFound(Boolean found) {
            this.found = found;
        }

        @Override
        public final Builder found(Boolean found) {
            this.found = found;
            return this;
        }

        public final Boolean getError() {
            return error;
        }

        public final void setError(Boolean error) {
            this.error = error;
        }

        @Override
        public final Builder error(Boolean error) {
            this.error = error;
            return this;
        }

        public final String getEvaluatedValue() {
            return evaluatedValue;
        }

        public final void setEvaluatedValue(String evaluatedValue) {
            this.evaluatedValue = evaluatedValue;
        }

        @Override
        public final Builder evaluatedValue(String evaluatedValue) {
            this.evaluatedValue = evaluatedValue;
            return this;
        }

        @Override
        public DataTableEvaluatedValue build() {
            return new DataTableEvaluatedValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
