/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactFlowModuleVersionResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateContactFlowModuleVersionResponse.Builder, CreateContactFlowModuleVersionResponse> {
    private static final SdkField<String> CONTACT_FLOW_MODULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleArn").getter(getter(CreateContactFlowModuleVersionResponse::contactFlowModuleArn))
            .setter(setter(Builder::contactFlowModuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowModuleArn").build())
            .build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(CreateContactFlowModuleVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOW_MODULE_ARN_FIELD,
            VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contactFlowModuleArn;

    private final Long version;

    private CreateContactFlowModuleVersionResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlowModuleArn = builder.contactFlowModuleArn;
        this.version = builder.version;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow module.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow module.
     */
    public final String contactFlowModuleArn() {
        return contactFlowModuleArn;
    }

    /**
     * <p>
     * The version of the flow module.
     * </p>
     * 
     * @return The version of the flow module.
     */
    public final Long version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactFlowModuleVersionResponse)) {
            return false;
        }
        CreateContactFlowModuleVersionResponse other = (CreateContactFlowModuleVersionResponse) obj;
        return Objects.equals(contactFlowModuleArn(), other.contactFlowModuleArn()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactFlowModuleVersionResponse").add("ContactFlowModuleArn", contactFlowModuleArn())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactFlowModuleArn":
            return Optional.ofNullable(clazz.cast(contactFlowModuleArn()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactFlowModuleArn", CONTACT_FLOW_MODULE_ARN_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContactFlowModuleVersionResponse, T> g) {
        return obj -> g.apply((CreateContactFlowModuleVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateContactFlowModuleVersionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow module.
         * </p>
         * 
         * @param contactFlowModuleArn
         *        The Amazon Resource Name (ARN) of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleArn(String contactFlowModuleArn);

        /**
         * <p>
         * The version of the flow module.
         * </p>
         * 
         * @param version
         *        The version of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String contactFlowModuleArn;

        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactFlowModuleVersionResponse model) {
            super(model);
            contactFlowModuleArn(model.contactFlowModuleArn);
            version(model.version);
        }

        public final String getContactFlowModuleArn() {
            return contactFlowModuleArn;
        }

        public final void setContactFlowModuleArn(String contactFlowModuleArn) {
            this.contactFlowModuleArn = contactFlowModuleArn;
        }

        @Override
        public final Builder contactFlowModuleArn(String contactFlowModuleArn) {
            this.contactFlowModuleArn = contactFlowModuleArn;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        @Override
        public CreateContactFlowModuleVersionResponse build() {
            return new CreateContactFlowModuleVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
