/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactFlowModuleVersionRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateContactFlowModuleVersionRequest.Builder, CreateContactFlowModuleVersionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateContactFlowModuleVersionRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateContactFlowModuleVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTACT_FLOW_MODULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleId").getter(getter(CreateContactFlowModuleVersionRequest::contactFlowModuleId))
            .setter(setter(Builder::contactFlowModuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowModuleId").build()).build();

    private static final SdkField<String> FLOW_MODULE_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowModuleContentSha256").getter(getter(CreateContactFlowModuleVersionRequest::flowModuleContentSha256))
            .setter(setter(Builder::flowModuleContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowModuleContentSha256").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DESCRIPTION_FIELD, CONTACT_FLOW_MODULE_ID_FIELD, FLOW_MODULE_CONTENT_SHA256_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String description;

    private final String contactFlowModuleId;

    private final String flowModuleContentSha256;

    private CreateContactFlowModuleVersionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.description = builder.description;
        this.contactFlowModuleId = builder.contactFlowModuleId;
        this.flowModuleContentSha256 = builder.flowModuleContentSha256;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The description of the flow module version.
     * </p>
     * 
     * @return The description of the flow module version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @return The identifier of the flow module.
     */
    public final String contactFlowModuleId() {
        return contactFlowModuleId;
    }

    /**
     * <p>
     * Indicates the checksum value of the flow module content.
     * </p>
     * 
     * @return Indicates the checksum value of the flow module content.
     */
    public final String flowModuleContentSha256() {
        return flowModuleContentSha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleId());
        hashCode = 31 * hashCode + Objects.hashCode(flowModuleContentSha256());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactFlowModuleVersionRequest)) {
            return false;
        }
        CreateContactFlowModuleVersionRequest other = (CreateContactFlowModuleVersionRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(description(), other.description())
                && Objects.equals(contactFlowModuleId(), other.contactFlowModuleId())
                && Objects.equals(flowModuleContentSha256(), other.flowModuleContentSha256());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactFlowModuleVersionRequest").add("InstanceId", instanceId())
                .add("Description", description()).add("ContactFlowModuleId", contactFlowModuleId())
                .add("FlowModuleContentSha256", flowModuleContentSha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ContactFlowModuleId":
            return Optional.ofNullable(clazz.cast(contactFlowModuleId()));
        case "FlowModuleContentSha256":
            return Optional.ofNullable(clazz.cast(flowModuleContentSha256()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ContactFlowModuleId", CONTACT_FLOW_MODULE_ID_FIELD);
        map.put("FlowModuleContentSha256", FLOW_MODULE_CONTENT_SHA256_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContactFlowModuleVersionRequest, T> g) {
        return obj -> g.apply((CreateContactFlowModuleVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateContactFlowModuleVersionRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The description of the flow module version.
         * </p>
         * 
         * @param description
         *        The description of the flow module version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the flow module.
         * </p>
         * 
         * @param contactFlowModuleId
         *        The identifier of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleId(String contactFlowModuleId);

        /**
         * <p>
         * Indicates the checksum value of the flow module content.
         * </p>
         * 
         * @param flowModuleContentSha256
         *        Indicates the checksum value of the flow module content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowModuleContentSha256(String flowModuleContentSha256);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String description;

        private String contactFlowModuleId;

        private String flowModuleContentSha256;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactFlowModuleVersionRequest model) {
            super(model);
            instanceId(model.instanceId);
            description(model.description);
            contactFlowModuleId(model.contactFlowModuleId);
            flowModuleContentSha256(model.flowModuleContentSha256);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowModuleId() {
            return contactFlowModuleId;
        }

        public final void setContactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
        }

        @Override
        public final Builder contactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
            return this;
        }

        public final String getFlowModuleContentSha256() {
            return flowModuleContentSha256;
        }

        public final void setFlowModuleContentSha256(String flowModuleContentSha256) {
            this.flowModuleContentSha256 = flowModuleContentSha256;
        }

        @Override
        public final Builder flowModuleContentSha256(String flowModuleContentSha256) {
            this.flowModuleContentSha256 = flowModuleContentSha256;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactFlowModuleVersionRequest build() {
            return new CreateContactFlowModuleVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
