/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing information about metric requested for the contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactMetricResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactMetricResult.Builder, ContactMetricResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ContactMetricResult::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ContactMetricValue> VALUE_FIELD = SdkField
            .<ContactMetricValue> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(ContactMetricResult::value)).setter(setter(Builder::value)).constructor(ContactMetricValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ContactMetricValue value;

    private ContactMetricResult(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the metric being retrieved in type String.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ContactMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the metric being retrieved in type String.
     * @see ContactMetricName
     */
    public final ContactMetricName name() {
        return ContactMetricName.fromValue(name);
    }

    /**
     * <p>
     * The name of the metric being retrieved in type String.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ContactMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the metric being retrieved in type String.
     * @see ContactMetricName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * Object result associated with the metric received.
     * </p>
     * 
     * @return Object result associated with the metric received.
     */
    public final ContactMetricValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactMetricResult)) {
            return false;
        }
        ContactMetricResult other = (ContactMetricResult) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactMetricResult").add("Name", nameAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactMetricResult, T> g) {
        return obj -> g.apply((ContactMetricResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactMetricResult> {
        /**
         * <p>
         * The name of the metric being retrieved in type String.
         * </p>
         * 
         * @param name
         *        The name of the metric being retrieved in type String.
         * @see ContactMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactMetricName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the metric being retrieved in type String.
         * </p>
         * 
         * @param name
         *        The name of the metric being retrieved in type String.
         * @see ContactMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactMetricName
         */
        Builder name(ContactMetricName name);

        /**
         * <p>
         * Object result associated with the metric received.
         * </p>
         * 
         * @param value
         *        Object result associated with the metric received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(ContactMetricValue value);

        /**
         * <p>
         * Object result associated with the metric received.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactMetricValue.Builder} avoiding the
         * need to create one manually via {@link ContactMetricValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactMetricValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(ContactMetricValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link ContactMetricValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(ContactMetricValue)
         */
        default Builder value(Consumer<ContactMetricValue.Builder> value) {
            return value(ContactMetricValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ContactMetricValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactMetricResult model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ContactMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final ContactMetricValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(ContactMetricValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(ContactMetricValue value) {
            this.value = value;
            return this;
        }

        @Override
        public ContactMetricResult build() {
            return new ContactMetricResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
