/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowModuleAliasSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowModuleAliasSummary.Builder, ContactFlowModuleAliasSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ContactFlowModuleAliasSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasId").getter(getter(ContactFlowModuleAliasSummary::aliasId)).setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(ContactFlowModuleAliasSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasName").getter(getter(ContactFlowModuleAliasSummary::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()).build();

    private static final SdkField<String> ALIAS_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasDescription").getter(getter(ContactFlowModuleAliasSummary::aliasDescription))
            .setter(setter(Builder::aliasDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasDescription").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ContactFlowModuleAliasSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ALIAS_ID_FIELD,
            VERSION_FIELD, ALIAS_NAME_FIELD, ALIAS_DESCRIPTION_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String aliasId;

    private final Long version;

    private final String aliasName;

    private final String aliasDescription;

    private final Instant lastModifiedTime;

    private ContactFlowModuleAliasSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.aliasId = builder.aliasId;
        this.version = builder.version;
        this.aliasName = builder.aliasName;
        this.aliasDescription = builder.aliasDescription;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow module alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow module alias.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The identifier of the alias.
     * </p>
     * 
     * @return The identifier of the alias.
     */
    public final String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * The version of the flow module.
     * </p>
     * 
     * @return The version of the flow module.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The name of the alias.
     * </p>
     * 
     * @return The name of the alias.
     */
    public final String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * The description of the alias.
     * </p>
     * 
     * @return The description of the alias.
     */
    public final String aliasDescription() {
        return aliasDescription;
    }

    /**
     * <p>
     * The timestamp when this resource was last modified.
     * </p>
     * 
     * @return The timestamp when this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(aliasDescription());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowModuleAliasSummary)) {
            return false;
        }
        ContactFlowModuleAliasSummary other = (ContactFlowModuleAliasSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(aliasId(), other.aliasId())
                && Objects.equals(version(), other.version()) && Objects.equals(aliasName(), other.aliasName())
                && Objects.equals(aliasDescription(), other.aliasDescription())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowModuleAliasSummary").add("Arn", arn()).add("AliasId", aliasId())
                .add("Version", version()).add("AliasName", aliasName()).add("AliasDescription", aliasDescription())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "AliasDescription":
            return Optional.ofNullable(clazz.cast(aliasDescription()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("AliasId", ALIAS_ID_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("AliasName", ALIAS_NAME_FIELD);
        map.put("AliasDescription", ALIAS_DESCRIPTION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowModuleAliasSummary, T> g) {
        return obj -> g.apply((ContactFlowModuleAliasSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowModuleAliasSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow module alias.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the flow module alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identifier of the alias.
         * </p>
         * 
         * @param aliasId
         *        The identifier of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * The version of the flow module.
         * </p>
         * 
         * @param version
         *        The version of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The name of the alias.
         * </p>
         * 
         * @param aliasName
         *        The name of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * The description of the alias.
         * </p>
         * 
         * @param aliasDescription
         *        The description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasDescription(String aliasDescription);

        /**
         * <p>
         * The timestamp when this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String aliasId;

        private Long version;

        private String aliasName;

        private String aliasDescription;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowModuleAliasSummary model) {
            arn(model.arn);
            aliasId(model.aliasId);
            version(model.version);
            aliasName(model.aliasName);
            aliasDescription(model.aliasDescription);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAliasId() {
            return aliasId;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getAliasName() {
            return aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final String getAliasDescription() {
            return aliasDescription;
        }

        public final void setAliasDescription(String aliasDescription) {
            this.aliasDescription = aliasDescription;
        }

        @Override
        public final Builder aliasDescription(String aliasDescription) {
            this.aliasDescription = aliasDescription;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public ContactFlowModuleAliasSummary build() {
            return new ContactFlowModuleAliasSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
