/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A batch describe data table value failure result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeDataTableValueFailureResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDescribeDataTableValueFailureResult.Builder, BatchDescribeDataTableValueFailureResult> {
    private static final SdkField<List<PrimaryValue>> PRIMARY_VALUES_FIELD = SdkField
            .<List<PrimaryValue>> builder(MarshallingType.LIST)
            .memberName("PrimaryValues")
            .getter(getter(BatchDescribeDataTableValueFailureResult::primaryValues))
            .setter(setter(Builder::primaryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrimaryValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrimaryValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(BatchDescribeDataTableValueFailureResult::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(BatchDescribeDataTableValueFailureResult::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_VALUES_FIELD,
            ATTRIBUTE_NAME_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PrimaryValue> primaryValues;

    private final String attributeName;

    private final String message;

    private BatchDescribeDataTableValueFailureResult(BuilderImpl builder) {
        this.primaryValues = builder.primaryValues;
        this.attributeName = builder.attributeName;
        this.message = builder.message;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryValues() {
        return primaryValues != null && !(primaryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The result's primary values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryValues} method.
     * </p>
     * 
     * @return The result's primary values.
     */
    public final List<PrimaryValue> primaryValues() {
        return primaryValues;
    }

    /**
     * <p>
     * The result's attribute name.
     * </p>
     * 
     * @return The result's attribute name.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The result's message.
     * </p>
     * 
     * @return The result's message.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryValues() ? primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeDataTableValueFailureResult)) {
            return false;
        }
        BatchDescribeDataTableValueFailureResult other = (BatchDescribeDataTableValueFailureResult) obj;
        return hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(primaryValues(), other.primaryValues())
                && Objects.equals(attributeName(), other.attributeName()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDescribeDataTableValueFailureResult")
                .add("PrimaryValues", hasPrimaryValues() ? primaryValues() : null).add("AttributeName", attributeName())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryValues":
            return Optional.ofNullable(clazz.cast(primaryValues()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeDataTableValueFailureResult, T> g) {
        return obj -> g.apply((BatchDescribeDataTableValueFailureResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDescribeDataTableValueFailureResult> {
        /**
         * <p>
         * The result's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The result's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(Collection<PrimaryValue> primaryValues);

        /**
         * <p>
         * The result's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The result's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(PrimaryValue... primaryValues);

        /**
         * <p>
         * The result's primary values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.PrimaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryValues(List<PrimaryValue>)}.
         * 
         * @param primaryValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValues(java.util.Collection<PrimaryValue>)
         */
        Builder primaryValues(Consumer<PrimaryValue.Builder>... primaryValues);

        /**
         * <p>
         * The result's attribute name.
         * </p>
         * 
         * @param attributeName
         *        The result's attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The result's message.
         * </p>
         * 
         * @param message
         *        The result's message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private List<PrimaryValue> primaryValues = DefaultSdkAutoConstructList.getInstance();

        private String attributeName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeDataTableValueFailureResult model) {
            primaryValues(model.primaryValues);
            attributeName(model.attributeName);
            message(model.message);
        }

        public final List<PrimaryValue.Builder> getPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValue.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValue> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValue... primaryValues) {
            primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValue.Builder>... primaryValues) {
            primaryValues(Stream.of(primaryValues).map(c -> PrimaryValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchDescribeDataTableValueFailureResult build() {
            return new BatchDescribeDataTableValueFailureResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
