/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateAnalyticsDataSetRequest extends ConnectRequest implements
        ToCopyableBuilder<BatchAssociateAnalyticsDataSetRequest.Builder, BatchAssociateAnalyticsDataSetRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(BatchAssociateAnalyticsDataSetRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<List<String>> DATA_SET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DataSetIds")
            .getter(getter(BatchAssociateAnalyticsDataSetRequest::dataSetIds))
            .setter(setter(Builder::dataSetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetAccountId").getter(getter(BatchAssociateAnalyticsDataSetRequest::targetAccountId))
            .setter(setter(Builder::targetAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DATA_SET_IDS_FIELD, TARGET_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final List<String> dataSetIds;

    private final String targetAccountId;

    private BatchAssociateAnalyticsDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataSetIds = builder.dataSetIds;
        this.targetAccountId = builder.targetAccountId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSetIds() {
        return dataSetIds != null && !(dataSetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of dataset identifiers to associate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSetIds} method.
     * </p>
     * 
     * @return An array of dataset identifiers to associate.
     */
    public final List<String> dataSetIds() {
        return dataSetIds;
    }

    /**
     * <p>
     * The identifier of the target account. Use to associate a dataset to a different account than the one containing
     * the Amazon Connect instance. If not specified, by default this value is the Amazon Web Services account that has
     * the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the target account. Use to associate a dataset to a different account than the one
     *         containing the Amazon Connect instance. If not specified, by default this value is the Amazon Web
     *         Services account that has the Amazon Connect instance.
     */
    public final String targetAccountId() {
        return targetAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSetIds() ? dataSetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateAnalyticsDataSetRequest)) {
            return false;
        }
        BatchAssociateAnalyticsDataSetRequest other = (BatchAssociateAnalyticsDataSetRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && hasDataSetIds() == other.hasDataSetIds()
                && Objects.equals(dataSetIds(), other.dataSetIds()) && Objects.equals(targetAccountId(), other.targetAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateAnalyticsDataSetRequest").add("InstanceId", instanceId())
                .add("DataSetIds", hasDataSetIds() ? dataSetIds() : null).add("TargetAccountId", targetAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DataSetIds":
            return Optional.ofNullable(clazz.cast(dataSetIds()));
        case "TargetAccountId":
            return Optional.ofNullable(clazz.cast(targetAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataSetIds", DATA_SET_IDS_FIELD);
        map.put("TargetAccountId", TARGET_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateAnalyticsDataSetRequest, T> g) {
        return obj -> g.apply((BatchAssociateAnalyticsDataSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateAnalyticsDataSetRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * An array of dataset identifiers to associate.
         * </p>
         * 
         * @param dataSetIds
         *        An array of dataset identifiers to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIds(Collection<String> dataSetIds);

        /**
         * <p>
         * An array of dataset identifiers to associate.
         * </p>
         * 
         * @param dataSetIds
         *        An array of dataset identifiers to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIds(String... dataSetIds);

        /**
         * <p>
         * The identifier of the target account. Use to associate a dataset to a different account than the one
         * containing the Amazon Connect instance. If not specified, by default this value is the Amazon Web Services
         * account that has the Amazon Connect instance.
         * </p>
         * 
         * @param targetAccountId
         *        The identifier of the target account. Use to associate a dataset to a different account than the one
         *        containing the Amazon Connect instance. If not specified, by default this value is the Amazon Web
         *        Services account that has the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountId(String targetAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<String> dataSetIds = DefaultSdkAutoConstructList.getInstance();

        private String targetAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateAnalyticsDataSetRequest model) {
            super(model);
            instanceId(model.instanceId);
            dataSetIds(model.dataSetIds);
            targetAccountId(model.targetAccountId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Collection<String> getDataSetIds() {
            if (dataSetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return dataSetIds;
        }

        public final void setDataSetIds(Collection<String> dataSetIds) {
            this.dataSetIds = DataSetIdsCopier.copy(dataSetIds);
        }

        @Override
        public final Builder dataSetIds(Collection<String> dataSetIds) {
            this.dataSetIds = DataSetIdsCopier.copy(dataSetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetIds(String... dataSetIds) {
            dataSetIds(Arrays.asList(dataSetIds));
            return this;
        }

        public final String getTargetAccountId() {
            return targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateAnalyticsDataSetRequest build() {
            return new BatchAssociateAnalyticsDataSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
