/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the attached file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachedFile implements SdkPojo, Serializable, ToCopyableBuilder<AttachedFile.Builder, AttachedFile> {
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(AttachedFile::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileArn").getter(getter(AttachedFile::fileArn)).setter(setter(Builder::fileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileArn").build()).build();

    private static final SdkField<String> FILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FileId")
            .getter(getter(AttachedFile::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileId").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(AttachedFile::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()).build();

    private static final SdkField<Long> FILE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FileSizeInBytes").getter(getter(AttachedFile::fileSizeInBytes)).setter(setter(Builder::fileSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSizeInBytes").build()).build();

    private static final SdkField<String> FILE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileStatus").getter(getter(AttachedFile::fileStatusAsString)).setter(setter(Builder::fileStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileStatus").build()).build();

    private static final SdkField<CreatedByInfo> CREATED_BY_FIELD = SdkField.<CreatedByInfo> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(AttachedFile::createdBy)).setter(setter(Builder::createdBy))
            .constructor(CreatedByInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> FILE_USE_CASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileUseCaseType").getter(getter(AttachedFile::fileUseCaseTypeAsString))
            .setter(setter(Builder::fileUseCaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileUseCaseType").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResourceArn").getter(getter(AttachedFile::associatedResourceArn))
            .setter(setter(Builder::associatedResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceArn").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(AttachedFile::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            FILE_ARN_FIELD, FILE_ID_FIELD, FILE_NAME_FIELD, FILE_SIZE_IN_BYTES_FIELD, FILE_STATUS_FIELD, CREATED_BY_FIELD,
            FILE_USE_CASE_TYPE_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String creationTime;

    private final String fileArn;

    private final String fileId;

    private final String fileName;

    private final Long fileSizeInBytes;

    private final String fileStatus;

    private final CreatedByInfo createdBy;

    private final String fileUseCaseType;

    private final String associatedResourceArn;

    private final Map<String, String> tags;

    private AttachedFile(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.fileArn = builder.fileArn;
        this.fileId = builder.fileId;
        this.fileName = builder.fileName;
        this.fileSizeInBytes = builder.fileSizeInBytes;
        this.fileStatus = builder.fileStatus;
        this.createdBy = builder.createdBy;
        this.fileUseCaseType = builder.fileUseCaseType;
        this.associatedResourceArn = builder.associatedResourceArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format:
     * <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.
     * </p>
     * 
     * @return The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format:
     *         <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The unique identifier of the attached file resource (ARN).
     * </p>
     * 
     * @return The unique identifier of the attached file resource (ARN).
     */
    public final String fileArn() {
        return fileArn;
    }

    /**
     * <p>
     * The unique identifier of the attached file resource.
     * </p>
     * 
     * @return The unique identifier of the attached file resource.
     */
    public final String fileId() {
        return fileId;
    }

    /**
     * <p>
     * A case-sensitive name of the attached file being uploaded.
     * </p>
     * 
     * @return A case-sensitive name of the attached file being uploaded.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The size of the attached file in bytes.
     * </p>
     * 
     * @return The size of the attached file in bytes.
     */
    public final Long fileSizeInBytes() {
        return fileSizeInBytes;
    }

    /**
     * <p>
     * The current status of the attached file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileStatus} will
     * return {@link FileStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileStatusAsString}.
     * </p>
     * 
     * @return The current status of the attached file.
     * @see FileStatusType
     */
    public final FileStatusType fileStatus() {
        return FileStatusType.fromValue(fileStatus);
    }

    /**
     * <p>
     * The current status of the attached file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileStatus} will
     * return {@link FileStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileStatusAsString}.
     * </p>
     * 
     * @return The current status of the attached file.
     * @see FileStatusType
     */
    public final String fileStatusAsString() {
        return fileStatus;
    }

    /**
     * <p>
     * Represents the identity that created the file.
     * </p>
     * 
     * @return Represents the identity that created the file.
     */
    public final CreatedByInfo createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The use case for the file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileUseCaseType}
     * will return {@link FileUseCaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileUseCaseTypeAsString}.
     * </p>
     * 
     * @return The use case for the file.
     * @see FileUseCaseType
     */
    public final FileUseCaseType fileUseCaseType() {
        return FileUseCaseType.fromValue(fileUseCaseType);
    }

    /**
     * <p>
     * The use case for the file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileUseCaseType}
     * will return {@link FileUseCaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileUseCaseTypeAsString}.
     * </p>
     * 
     * @return The use case for the file.
     * @see FileUseCaseType
     */
    public final String fileUseCaseTypeAsString() {
        return fileUseCaseType;
    }

    /**
     * <p>
     * The resource to which the attached file is (being) uploaded to. <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are
     * the only current supported resource.
     * </p>
     * <note>
     * <p>
     * This value must be a valid ARN.
     * </p>
     * </note>
     * 
     * @return The resource to which the attached file is (being) uploaded to. <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html"
     *         >Cases</a> are the only current supported resource.</p> <note>
     *         <p>
     *         This value must be a valid ARN.
     *         </p>
     */
    public final String associatedResourceArn() {
        return associatedResourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example,
     * <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example,
     *         <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(fileArn());
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(fileSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(fileStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(fileUseCaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachedFile)) {
            return false;
        }
        AttachedFile other = (AttachedFile) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(fileArn(), other.fileArn())
                && Objects.equals(fileId(), other.fileId()) && Objects.equals(fileName(), other.fileName())
                && Objects.equals(fileSizeInBytes(), other.fileSizeInBytes())
                && Objects.equals(fileStatusAsString(), other.fileStatusAsString())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(fileUseCaseTypeAsString(), other.fileUseCaseTypeAsString())
                && Objects.equals(associatedResourceArn(), other.associatedResourceArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachedFile").add("CreationTime", creationTime()).add("FileArn", fileArn())
                .add("FileId", fileId()).add("FileName", fileName()).add("FileSizeInBytes", fileSizeInBytes())
                .add("FileStatus", fileStatusAsString()).add("CreatedBy", createdBy())
                .add("FileUseCaseType", fileUseCaseTypeAsString()).add("AssociatedResourceArn", associatedResourceArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FileArn":
            return Optional.ofNullable(clazz.cast(fileArn()));
        case "FileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "FileSizeInBytes":
            return Optional.ofNullable(clazz.cast(fileSizeInBytes()));
        case "FileStatus":
            return Optional.ofNullable(clazz.cast(fileStatusAsString()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "FileUseCaseType":
            return Optional.ofNullable(clazz.cast(fileUseCaseTypeAsString()));
        case "AssociatedResourceArn":
            return Optional.ofNullable(clazz.cast(associatedResourceArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FileArn", FILE_ARN_FIELD);
        map.put("FileId", FILE_ID_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("FileSizeInBytes", FILE_SIZE_IN_BYTES_FIELD);
        map.put("FileStatus", FILE_STATUS_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("FileUseCaseType", FILE_USE_CASE_TYPE_FIELD);
        map.put("AssociatedResourceArn", ASSOCIATED_RESOURCE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachedFile, T> g) {
        return obj -> g.apply((AttachedFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachedFile> {
        /**
         * <p>
         * The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format:
         * <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.
         * </p>
         * 
         * @param creationTime
         *        The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format:
         *        <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The unique identifier of the attached file resource (ARN).
         * </p>
         * 
         * @param fileArn
         *        The unique identifier of the attached file resource (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileArn(String fileArn);

        /**
         * <p>
         * The unique identifier of the attached file resource.
         * </p>
         * 
         * @param fileId
         *        The unique identifier of the attached file resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(String fileId);

        /**
         * <p>
         * A case-sensitive name of the attached file being uploaded.
         * </p>
         * 
         * @param fileName
         *        A case-sensitive name of the attached file being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The size of the attached file in bytes.
         * </p>
         * 
         * @param fileSizeInBytes
         *        The size of the attached file in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSizeInBytes(Long fileSizeInBytes);

        /**
         * <p>
         * The current status of the attached file.
         * </p>
         * 
         * @param fileStatus
         *        The current status of the attached file.
         * @see FileStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileStatusType
         */
        Builder fileStatus(String fileStatus);

        /**
         * <p>
         * The current status of the attached file.
         * </p>
         * 
         * @param fileStatus
         *        The current status of the attached file.
         * @see FileStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileStatusType
         */
        Builder fileStatus(FileStatusType fileStatus);

        /**
         * <p>
         * Represents the identity that created the file.
         * </p>
         * 
         * @param createdBy
         *        Represents the identity that created the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(CreatedByInfo createdBy);

        /**
         * <p>
         * Represents the identity that created the file.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreatedByInfo.Builder} avoiding the need
         * to create one manually via {@link CreatedByInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreatedByInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #createdBy(CreatedByInfo)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link CreatedByInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(CreatedByInfo)
         */
        default Builder createdBy(Consumer<CreatedByInfo.Builder> createdBy) {
            return createdBy(CreatedByInfo.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The use case for the file.
         * </p>
         * 
         * @param fileUseCaseType
         *        The use case for the file.
         * @see FileUseCaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileUseCaseType
         */
        Builder fileUseCaseType(String fileUseCaseType);

        /**
         * <p>
         * The use case for the file.
         * </p>
         * 
         * @param fileUseCaseType
         *        The use case for the file.
         * @see FileUseCaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileUseCaseType
         */
        Builder fileUseCaseType(FileUseCaseType fileUseCaseType);

        /**
         * <p>
         * The resource to which the attached file is (being) uploaded to. <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a>
         * are the only current supported resource.
         * </p>
         * <note>
         * <p>
         * This value must be a valid ARN.
         * </p>
         * </note>
         * 
         * @param associatedResourceArn
         *        The resource to which the attached file is (being) uploaded to. <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html"
         *        >Cases</a> are the only current supported resource.</p> <note>
         *        <p>
         *        This value must be a valid ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArn(String associatedResourceArn);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example,
         * <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example,
         *        <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String creationTime;

        private String fileArn;

        private String fileId;

        private String fileName;

        private Long fileSizeInBytes;

        private String fileStatus;

        private CreatedByInfo createdBy;

        private String fileUseCaseType;

        private String associatedResourceArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttachedFile model) {
            creationTime(model.creationTime);
            fileArn(model.fileArn);
            fileId(model.fileId);
            fileName(model.fileName);
            fileSizeInBytes(model.fileSizeInBytes);
            fileStatus(model.fileStatus);
            createdBy(model.createdBy);
            fileUseCaseType(model.fileUseCaseType);
            associatedResourceArn(model.associatedResourceArn);
            tags(model.tags);
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileArn() {
            return fileArn;
        }

        public final void setFileArn(String fileArn) {
            this.fileArn = fileArn;
        }

        @Override
        public final Builder fileArn(String fileArn) {
            this.fileArn = fileArn;
            return this;
        }

        public final String getFileId() {
            return fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final Long getFileSizeInBytes() {
            return fileSizeInBytes;
        }

        public final void setFileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
        }

        @Override
        public final Builder fileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            return this;
        }

        public final String getFileStatus() {
            return fileStatus;
        }

        public final void setFileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
        }

        @Override
        public final Builder fileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
            return this;
        }

        @Override
        public final Builder fileStatus(FileStatusType fileStatus) {
            this.fileStatus(fileStatus == null ? null : fileStatus.toString());
            return this;
        }

        public final CreatedByInfo.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(CreatedByInfo.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(CreatedByInfo createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getFileUseCaseType() {
            return fileUseCaseType;
        }

        public final void setFileUseCaseType(String fileUseCaseType) {
            this.fileUseCaseType = fileUseCaseType;
        }

        @Override
        public final Builder fileUseCaseType(String fileUseCaseType) {
            this.fileUseCaseType = fileUseCaseType;
            return this;
        }

        @Override
        public final Builder fileUseCaseType(FileUseCaseType fileUseCaseType) {
            this.fileUseCaseType(fileUseCaseType == null ? null : fileUseCaseType.toString());
            return this;
        }

        public final String getAssociatedResourceArn() {
            return associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public AttachedFile build() {
            return new AttachedFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
