/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.ActivateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.AssociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.AssociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.AssociateApprovedOriginRequest;
import software.amazon.awssdk.services.connect.model.AssociateApprovedOriginResponse;
import software.amazon.awssdk.services.connect.model.AssociateBotRequest;
import software.amazon.awssdk.services.connect.model.AssociateBotResponse;
import software.amazon.awssdk.services.connect.model.AssociateContactWithUserRequest;
import software.amazon.awssdk.services.connect.model.AssociateContactWithUserResponse;
import software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest;
import software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyResponse;
import software.amazon.awssdk.services.connect.model.AssociateEmailAddressAliasRequest;
import software.amazon.awssdk.services.connect.model.AssociateEmailAddressAliasResponse;
import software.amazon.awssdk.services.connect.model.AssociateFlowRequest;
import software.amazon.awssdk.services.connect.model.AssociateFlowResponse;
import software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest;
import software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionResponse;
import software.amazon.awssdk.services.connect.model.AssociateLexBotRequest;
import software.amazon.awssdk.services.connect.model.AssociateLexBotResponse;
import software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest;
import software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowResponse;
import software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest;
import software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse;
import software.amazon.awssdk.services.connect.model.AssociateSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.AssociateSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.AssociateTrafficDistributionGroupUserRequest;
import software.amazon.awssdk.services.connect.model.AssociateTrafficDistributionGroupUserResponse;
import software.amazon.awssdk.services.connect.model.AssociateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.AssociateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.AssociateWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.AssociateWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.BatchAssociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.BatchAssociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueRequest;
import software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueResponse;
import software.amazon.awssdk.services.connect.model.BatchDeleteDataTableValueRequest;
import software.amazon.awssdk.services.connect.model.BatchDeleteDataTableValueResponse;
import software.amazon.awssdk.services.connect.model.BatchDescribeDataTableValueRequest;
import software.amazon.awssdk.services.connect.model.BatchDescribeDataTableValueResponse;
import software.amazon.awssdk.services.connect.model.BatchDisassociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.BatchDisassociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.BatchGetAttachedFileMetadataRequest;
import software.amazon.awssdk.services.connect.model.BatchGetAttachedFileMetadataResponse;
import software.amazon.awssdk.services.connect.model.BatchGetFlowAssociationRequest;
import software.amazon.awssdk.services.connect.model.BatchGetFlowAssociationResponse;
import software.amazon.awssdk.services.connect.model.BatchPutContactRequest;
import software.amazon.awssdk.services.connect.model.BatchPutContactResponse;
import software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueRequest;
import software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueResponse;
import software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ClaimPhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.CompleteAttachedFileUploadRequest;
import software.amazon.awssdk.services.connect.model.CompleteAttachedFileUploadResponse;
import software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleAliasRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleAliasResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleVersionRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleVersionResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowVersionRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowVersionResponse;
import software.amazon.awssdk.services.connect.model.CreateContactRequest;
import software.amazon.awssdk.services.connect.model.CreateContactResponse;
import software.amazon.awssdk.services.connect.model.CreateDataTableAttributeRequest;
import software.amazon.awssdk.services.connect.model.CreateDataTableAttributeResponse;
import software.amazon.awssdk.services.connect.model.CreateDataTableRequest;
import software.amazon.awssdk.services.connect.model.CreateDataTableResponse;
import software.amazon.awssdk.services.connect.model.CreateEmailAddressRequest;
import software.amazon.awssdk.services.connect.model.CreateEmailAddressResponse;
import software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.CreateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationOverrideRequest;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationOverrideResponse;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.CreateInstanceRequest;
import software.amazon.awssdk.services.connect.model.CreateInstanceResponse;
import software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest;
import software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse;
import software.amazon.awssdk.services.connect.model.CreateParticipantRequest;
import software.amazon.awssdk.services.connect.model.CreateParticipantResponse;
import software.amazon.awssdk.services.connect.model.CreatePersistentContactAssociationRequest;
import software.amazon.awssdk.services.connect.model.CreatePersistentContactAssociationResponse;
import software.amazon.awssdk.services.connect.model.CreatePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.CreatePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.CreatePromptRequest;
import software.amazon.awssdk.services.connect.model.CreatePromptResponse;
import software.amazon.awssdk.services.connect.model.CreatePushNotificationRegistrationRequest;
import software.amazon.awssdk.services.connect.model.CreatePushNotificationRegistrationResponse;
import software.amazon.awssdk.services.connect.model.CreateQueueRequest;
import software.amazon.awssdk.services.connect.model.CreateQueueResponse;
import software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.CreateRuleRequest;
import software.amazon.awssdk.services.connect.model.CreateRuleResponse;
import software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.CreateTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.CreateUseCaseRequest;
import software.amazon.awssdk.services.connect.model.CreateUseCaseResponse;
import software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.CreateUserRequest;
import software.amazon.awssdk.services.connect.model.CreateUserResponse;
import software.amazon.awssdk.services.connect.model.CreateViewRequest;
import software.amazon.awssdk.services.connect.model.CreateViewResponse;
import software.amazon.awssdk.services.connect.model.CreateViewVersionRequest;
import software.amazon.awssdk.services.connect.model.CreateViewVersionResponse;
import software.amazon.awssdk.services.connect.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.connect.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.connect.model.CreateWorkspacePageRequest;
import software.amazon.awssdk.services.connect.model.CreateWorkspacePageResponse;
import software.amazon.awssdk.services.connect.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.DeactivateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DeactivateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DeleteAttachedFileRequest;
import software.amazon.awssdk.services.connect.model.DeleteAttachedFileResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleAliasRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleAliasResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleVersionRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleVersionResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowVersionRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowVersionResponse;
import software.amazon.awssdk.services.connect.model.DeleteDataTableAttributeRequest;
import software.amazon.awssdk.services.connect.model.DeleteDataTableAttributeResponse;
import software.amazon.awssdk.services.connect.model.DeleteDataTableRequest;
import software.amazon.awssdk.services.connect.model.DeleteDataTableResponse;
import software.amazon.awssdk.services.connect.model.DeleteEmailAddressRequest;
import software.amazon.awssdk.services.connect.model.DeleteEmailAddressResponse;
import software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DeleteEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationOverrideRequest;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationOverrideResponse;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.connect.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest;
import software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationResponse;
import software.amazon.awssdk.services.connect.model.DeletePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.DeletePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.DeletePromptRequest;
import software.amazon.awssdk.services.connect.model.DeletePromptResponse;
import software.amazon.awssdk.services.connect.model.DeletePushNotificationRegistrationRequest;
import software.amazon.awssdk.services.connect.model.DeletePushNotificationRegistrationResponse;
import software.amazon.awssdk.services.connect.model.DeleteQueueRequest;
import software.amazon.awssdk.services.connect.model.DeleteQueueResponse;
import software.amazon.awssdk.services.connect.model.DeleteQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.DeleteQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.DeleteRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.DeleteRuleRequest;
import software.amazon.awssdk.services.connect.model.DeleteRuleResponse;
import software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.DeleteTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest;
import software.amazon.awssdk.services.connect.model.DeleteUseCaseResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserResponse;
import software.amazon.awssdk.services.connect.model.DeleteViewRequest;
import software.amazon.awssdk.services.connect.model.DeleteViewResponse;
import software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest;
import software.amazon.awssdk.services.connect.model.DeleteViewVersionResponse;
import software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DeleteWorkspaceMediaRequest;
import software.amazon.awssdk.services.connect.model.DeleteWorkspaceMediaResponse;
import software.amazon.awssdk.services.connect.model.DeleteWorkspacePageRequest;
import software.amazon.awssdk.services.connect.model.DeleteWorkspacePageResponse;
import software.amazon.awssdk.services.connect.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.DescribeAuthenticationProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeAuthenticationProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleAliasRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleAliasResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactResponse;
import software.amazon.awssdk.services.connect.model.DescribeDataTableAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribeDataTableAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribeDataTableRequest;
import software.amazon.awssdk.services.connect.model.DescribeDataTableResponse;
import software.amazon.awssdk.services.connect.model.DescribeEmailAddressRequest;
import software.amazon.awssdk.services.connect.model.DescribeEmailAddressResponse;
import software.amazon.awssdk.services.connect.model.DescribeEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DescribeEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationOverrideRequest;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationOverrideResponse;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.DescribePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribePromptRequest;
import software.amazon.awssdk.services.connect.model.DescribePromptResponse;
import software.amazon.awssdk.services.connect.model.DescribeQueueRequest;
import software.amazon.awssdk.services.connect.model.DescribeQueueResponse;
import software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.DescribeRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeRuleRequest;
import software.amazon.awssdk.services.connect.model.DescribeRuleResponse;
import software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserResponse;
import software.amazon.awssdk.services.connect.model.DescribeViewRequest;
import software.amazon.awssdk.services.connect.model.DescribeViewResponse;
import software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest;
import software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DescribeWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.DescribeWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.DisassociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.DisassociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest;
import software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginResponse;
import software.amazon.awssdk.services.connect.model.DisassociateBotRequest;
import software.amazon.awssdk.services.connect.model.DisassociateBotResponse;
import software.amazon.awssdk.services.connect.model.DisassociateEmailAddressAliasRequest;
import software.amazon.awssdk.services.connect.model.DisassociateEmailAddressAliasResponse;
import software.amazon.awssdk.services.connect.model.DisassociateFlowRequest;
import software.amazon.awssdk.services.connect.model.DisassociateFlowResponse;
import software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest;
import software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionResponse;
import software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest;
import software.amazon.awssdk.services.connect.model.DisassociateLexBotResponse;
import software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyResponse;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest;
import software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserResponse;
import software.amazon.awssdk.services.connect.model.DisassociateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.DisassociateWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.DisassociateWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.DismissUserContactRequest;
import software.amazon.awssdk.services.connect.model.DismissUserContactResponse;
import software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest;
import software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesResponse;
import software.amazon.awssdk.services.connect.model.GetAttachedFileRequest;
import software.amazon.awssdk.services.connect.model.GetAttachedFileResponse;
import software.amazon.awssdk.services.connect.model.GetContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.GetContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.GetContactMetricsRequest;
import software.amazon.awssdk.services.connect.model.GetContactMetricsResponse;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse;
import software.amazon.awssdk.services.connect.model.GetEffectiveHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.GetEffectiveHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.connect.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.connect.model.GetFlowAssociationRequest;
import software.amazon.awssdk.services.connect.model.GetFlowAssociationResponse;
import software.amazon.awssdk.services.connect.model.GetMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetMetricDataResponse;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Request;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Response;
import software.amazon.awssdk.services.connect.model.GetPromptFileRequest;
import software.amazon.awssdk.services.connect.model.GetPromptFileResponse;
import software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.GetTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest;
import software.amazon.awssdk.services.connect.model.GetTrafficDistributionResponse;
import software.amazon.awssdk.services.connect.model.ImportPhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ImportPhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.ImportWorkspaceMediaRequest;
import software.amazon.awssdk.services.connect.model.ImportWorkspaceMediaResponse;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataLakeDataSetsRequest;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataLakeDataSetsResponse;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse;
import software.amazon.awssdk.services.connect.model.ListAssociatedContactsRequest;
import software.amazon.awssdk.services.connect.model.ListAssociatedContactsResponse;
import software.amazon.awssdk.services.connect.model.ListAuthenticationProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListAuthenticationProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListBotsRequest;
import software.amazon.awssdk.services.connect.model.ListBotsResponse;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleAliasesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleAliasesResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowsResponse;
import software.amazon.awssdk.services.connect.model.ListContactReferencesRequest;
import software.amazon.awssdk.services.connect.model.ListContactReferencesResponse;
import software.amazon.awssdk.services.connect.model.ListDataTableAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTableAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListDataTablePrimaryValuesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTablePrimaryValuesResponse;
import software.amazon.awssdk.services.connect.model.ListDataTableValuesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTableValuesResponse;
import software.amazon.awssdk.services.connect.model.ListDataTablesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTablesResponse;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.ListEntitySecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListEntitySecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationOverridesRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationOverridesResponse;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse;
import software.amazon.awssdk.services.connect.model.ListInstancesRequest;
import software.amazon.awssdk.services.connect.model.ListInstancesResponse;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse;
import software.amazon.awssdk.services.connect.model.ListLexBotsRequest;
import software.amazon.awssdk.services.connect.model.ListLexBotsResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListPromptsRequest;
import software.amazon.awssdk.services.connect.model.ListPromptsResponse;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.ListQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Request;
import software.amazon.awssdk.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Response;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileManualAssignmentQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileManualAssignmentQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListRulesRequest;
import software.amazon.awssdk.services.connect.model.ListRulesResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse;
import software.amazon.awssdk.services.connect.model.ListUseCasesRequest;
import software.amazon.awssdk.services.connect.model.ListUseCasesResponse;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.ListUsersRequest;
import software.amazon.awssdk.services.connect.model.ListUsersResponse;
import software.amazon.awssdk.services.connect.model.ListViewVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListViewVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListViewsRequest;
import software.amazon.awssdk.services.connect.model.ListViewsResponse;
import software.amazon.awssdk.services.connect.model.ListWorkspaceMediaRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspaceMediaResponse;
import software.amazon.awssdk.services.connect.model.ListWorkspacePagesRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspacePagesResponse;
import software.amazon.awssdk.services.connect.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.connect.model.MonitorContactRequest;
import software.amazon.awssdk.services.connect.model.MonitorContactResponse;
import software.amazon.awssdk.services.connect.model.PauseContactRequest;
import software.amazon.awssdk.services.connect.model.PauseContactResponse;
import software.amazon.awssdk.services.connect.model.PutUserStatusRequest;
import software.amazon.awssdk.services.connect.model.PutUserStatusResponse;
import software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ReleasePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest;
import software.amazon.awssdk.services.connect.model.ReplicateInstanceResponse;
import software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.ResumeContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.ResumeContactRequest;
import software.amazon.awssdk.services.connect.model.ResumeContactResponse;
import software.amazon.awssdk.services.connect.model.SearchAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.SearchAgentStatusesResponse;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.SearchContactEvaluationsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactEvaluationsResponse;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsResponse;
import software.amazon.awssdk.services.connect.model.SearchContactsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactsResponse;
import software.amazon.awssdk.services.connect.model.SearchDataTablesRequest;
import software.amazon.awssdk.services.connect.model.SearchDataTablesResponse;
import software.amazon.awssdk.services.connect.model.SearchEmailAddressesRequest;
import software.amazon.awssdk.services.connect.model.SearchEmailAddressesResponse;
import software.amazon.awssdk.services.connect.model.SearchEvaluationFormsRequest;
import software.amazon.awssdk.services.connect.model.SearchEvaluationFormsResponse;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationOverridesRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationOverridesResponse;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesResponse;
import software.amazon.awssdk.services.connect.model.SearchPromptsRequest;
import software.amazon.awssdk.services.connect.model.SearchPromptsResponse;
import software.amazon.awssdk.services.connect.model.SearchQueuesRequest;
import software.amazon.awssdk.services.connect.model.SearchQueuesResponse;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.SearchUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.SearchUserHierarchyGroupsResponse;
import software.amazon.awssdk.services.connect.model.SearchUsersRequest;
import software.amazon.awssdk.services.connect.model.SearchUsersResponse;
import software.amazon.awssdk.services.connect.model.SearchViewsRequest;
import software.amazon.awssdk.services.connect.model.SearchViewsResponse;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.SearchWorkspaceAssociationsRequest;
import software.amazon.awssdk.services.connect.model.SearchWorkspaceAssociationsResponse;
import software.amazon.awssdk.services.connect.model.SearchWorkspacesRequest;
import software.amazon.awssdk.services.connect.model.SearchWorkspacesResponse;
import software.amazon.awssdk.services.connect.model.SendChatIntegrationEventRequest;
import software.amazon.awssdk.services.connect.model.SendChatIntegrationEventResponse;
import software.amazon.awssdk.services.connect.model.SendOutboundEmailRequest;
import software.amazon.awssdk.services.connect.model.SendOutboundEmailResponse;
import software.amazon.awssdk.services.connect.model.StartAttachedFileUploadRequest;
import software.amazon.awssdk.services.connect.model.StartAttachedFileUploadResponse;
import software.amazon.awssdk.services.connect.model.StartChatContactRequest;
import software.amazon.awssdk.services.connect.model.StartChatContactResponse;
import software.amazon.awssdk.services.connect.model.StartContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.StartContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.StartContactMediaProcessingRequest;
import software.amazon.awssdk.services.connect.model.StartContactMediaProcessingResponse;
import software.amazon.awssdk.services.connect.model.StartContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.StartContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.StartContactStreamingRequest;
import software.amazon.awssdk.services.connect.model.StartContactStreamingResponse;
import software.amazon.awssdk.services.connect.model.StartEmailContactRequest;
import software.amazon.awssdk.services.connect.model.StartEmailContactResponse;
import software.amazon.awssdk.services.connect.model.StartOutboundChatContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundChatContactResponse;
import software.amazon.awssdk.services.connect.model.StartOutboundEmailContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundEmailContactResponse;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse;
import software.amazon.awssdk.services.connect.model.StartScreenSharingRequest;
import software.amazon.awssdk.services.connect.model.StartScreenSharingResponse;
import software.amazon.awssdk.services.connect.model.StartTaskContactRequest;
import software.amazon.awssdk.services.connect.model.StartTaskContactResponse;
import software.amazon.awssdk.services.connect.model.StartWebRtcContactRequest;
import software.amazon.awssdk.services.connect.model.StartWebRtcContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactMediaProcessingRequest;
import software.amazon.awssdk.services.connect.model.StopContactMediaProcessingResponse;
import software.amazon.awssdk.services.connect.model.StopContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.StopContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.StopContactRequest;
import software.amazon.awssdk.services.connect.model.StopContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactStreamingRequest;
import software.amazon.awssdk.services.connect.model.StopContactStreamingResponse;
import software.amazon.awssdk.services.connect.model.SubmitContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.SubmitContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.SuspendContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.SuspendContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.TagContactRequest;
import software.amazon.awssdk.services.connect.model.TagContactResponse;
import software.amazon.awssdk.services.connect.model.TagResourceRequest;
import software.amazon.awssdk.services.connect.model.TagResourceResponse;
import software.amazon.awssdk.services.connect.model.TransferContactRequest;
import software.amazon.awssdk.services.connect.model.TransferContactResponse;
import software.amazon.awssdk.services.connect.model.UntagContactRequest;
import software.amazon.awssdk.services.connect.model.UntagContactResponse;
import software.amazon.awssdk.services.connect.model.UntagResourceRequest;
import software.amazon.awssdk.services.connect.model.UntagResourceResponse;
import software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.UpdateAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.UpdateAuthenticationProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateAuthenticationProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleAliasRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleAliasResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactRoutingDataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactRoutingDataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactScheduleResponse;
import software.amazon.awssdk.services.connect.model.UpdateDataTableAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdateDataTableAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdateDataTableMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateDataTableMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateDataTablePrimaryValuesRequest;
import software.amazon.awssdk.services.connect.model.UpdateDataTablePrimaryValuesResponse;
import software.amazon.awssdk.services.connect.model.UpdateEmailAddressMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateEmailAddressMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.UpdateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationOverrideRequest;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationOverrideResponse;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateParticipantAuthenticationRequest;
import software.amazon.awssdk.services.connect.model.UpdateParticipantAuthenticationResponse;
import software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.UpdatePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdatePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdatePromptRequest;
import software.amazon.awssdk.services.connect.model.UpdatePromptResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundEmailConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundEmailConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueStatusResponse;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.UpdateRuleRequest;
import software.amazon.awssdk.services.connect.model.UpdateRuleResponse;
import software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.UpdateTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest;
import software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.UpdateViewContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateViewContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateViewMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateViewMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateWorkspacePageRequest;
import software.amazon.awssdk.services.connect.model.UpdateWorkspacePageResponse;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceThemeRequest;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceThemeResponse;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceVisibilityRequest;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceVisibilityResponse;
import software.amazon.awssdk.services.connect.paginators.EvaluateDataTableValuesPublisher;
import software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataPublisher;
import software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataPublisher;
import software.amazon.awssdk.services.connect.paginators.GetMetricDataPublisher;
import software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Publisher;
import software.amazon.awssdk.services.connect.paginators.ListAgentStatusesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListAuthenticationProfilesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListBotsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListContactEvaluationsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowModuleAliasesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowModuleVersionsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowVersionsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListContactReferencesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListDataTableAttributesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListDataTablePrimaryValuesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListDataTableValuesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListDataTablesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListEvaluationFormVersionsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListEvaluationFormsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListFlowAssociationsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationOverridesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListInstancesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListLexBotsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersPublisher;
import software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Publisher;
import software.amazon.awssdk.services.connect.paginators.ListPredefinedAttributesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListPromptsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListQueuesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListQuickConnectsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListRealtimeContactAnalysisSegmentsV2Publisher;
import software.amazon.awssdk.services.connect.paginators.ListRoutingProfileManualAssignmentQueuesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListRulesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListSecurityKeysPublisher;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfileApplicationsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListTaskTemplatesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListTrafficDistributionGroupUsersPublisher;
import software.amazon.awssdk.services.connect.paginators.ListTrafficDistributionGroupsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListUseCasesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListUserProficienciesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListUsersPublisher;
import software.amazon.awssdk.services.connect.paginators.ListViewVersionsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListViewsPublisher;
import software.amazon.awssdk.services.connect.paginators.ListWorkspacePagesPublisher;
import software.amazon.awssdk.services.connect.paginators.ListWorkspacesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchAgentStatusesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchContactFlowModulesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchContactFlowsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchContactsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchDataTablesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchHoursOfOperationOverridesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchHoursOfOperationsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchPredefinedAttributesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchPromptsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchQueuesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchQuickConnectsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchResourceTagsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchRoutingProfilesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchSecurityProfilesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchUserHierarchyGroupsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchUsersPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchViewsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchVocabulariesPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchWorkspaceAssociationsPublisher;
import software.amazon.awssdk.services.connect.paginators.SearchWorkspacesPublisher;

/**
 * Service client for accessing Amazon Connect asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Operations_Amazon_Connect_Service.html">Amazon
 * Connect actions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Types_Amazon_Connect_Service.html">Amazon
 * Connect data types</a>
 * </p>
 * </li>
 * </ul>
 * <p>
 * Amazon Connect is a cloud-based contact center solution that you use to set up and manage a customer contact center
 * and provide reliable customer engagement at any scale.
 * </p>
 * <p>
 * Amazon Connect provides metrics and real-time reporting that enable you to optimize contact routing. You can also
 * resolve customer issues more efficiently by getting customers in touch with the appropriate agents.
 * </p>
 * <p>
 * There are limits to the number of Amazon Connect resources that you can create. There are also limits to the number
 * of requests that you can make per second. For more information, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect
 * Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 * <p>
 * You can use an endpoint to connect programmatically to an Amazon Web Services service. For a list of Amazon Connect
 * endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
 * Endpoints</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConnectAsyncClient extends AwsClient {
    String SERVICE_NAME = "connect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "connect";

    /**
     * <p>
     * Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it
     * is available to start new evaluations based on the form.
     * </p>
     *
     * @param activateEvaluationFormRequest
     * @return A Java Future containing the result of the ActivateEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.ActivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ActivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateEvaluationFormResponse> activateEvaluationForm(
            ActivateEvaluationFormRequest activateEvaluationFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it
     * is available to start new evaluations based on the form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateEvaluationFormRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateEvaluationFormRequest#builder()}
     * </p>
     *
     * @param activateEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ActivateEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.ActivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ActivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateEvaluationFormResponse> activateEvaluationForm(
            Consumer<ActivateEvaluationFormRequest.Builder> activateEvaluationFormRequest) {
        return activateEvaluationForm(ActivateEvaluationFormRequest.builder().applyMutation(activateEvaluationFormRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified dataset for a Amazon Connect instance with the target account. You can associate only
     * one dataset in a single call.
     * </p>
     *
     * @param associateAnalyticsDataSetRequest
     * @return A Java Future containing the result of the AssociateAnalyticsDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAnalyticsDataSetResponse> associateAnalyticsDataSet(
            AssociateAnalyticsDataSetRequest associateAnalyticsDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified dataset for a Amazon Connect instance with the target account. You can associate only
     * one dataset in a single call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAnalyticsDataSetRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateAnalyticsDataSetRequest#builder()}
     * </p>
     *
     * @param associateAnalyticsDataSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateAnalyticsDataSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateAnalyticsDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAnalyticsDataSetResponse> associateAnalyticsDataSet(
            Consumer<AssociateAnalyticsDataSetRequest.Builder> associateAnalyticsDataSetRequest) {
        return associateAnalyticsDataSet(AssociateAnalyticsDataSetRequest.builder()
                .applyMutation(associateAnalyticsDataSetRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates an approved origin to an Amazon Connect instance.
     * </p>
     *
     * @param associateApprovedOriginRequest
     * @return A Java Future containing the result of the AssociateApprovedOrigin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateApprovedOriginResponse> associateApprovedOrigin(
            AssociateApprovedOriginRequest associateApprovedOriginRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates an approved origin to an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApprovedOriginRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateApprovedOriginRequest#builder()}
     * </p>
     *
     * @param associateApprovedOriginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateApprovedOriginRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateApprovedOrigin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateApprovedOriginResponse> associateApprovedOrigin(
            Consumer<AssociateApprovedOriginRequest.Builder> associateApprovedOriginRequest) {
        return associateApprovedOrigin(AssociateApprovedOriginRequest.builder().applyMutation(associateApprovedOriginRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     *
     * @param associateBotRequest
     * @return A Java Future containing the result of the AssociateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateBotResponse> associateBot(AssociateBotRequest associateBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBotRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateBotRequest#builder()}
     * </p>
     *
     * @param associateBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateBotResponse> associateBot(Consumer<AssociateBotRequest.Builder> associateBotRequest) {
        return associateBot(AssociateBotRequest.builder().applyMutation(associateBotRequest).build());
    }

    /**
     * <p>
     * Associates a queued contact with an agent.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Programmatically assign queued contacts to available users.
     * </p>
     * </li>
     * <li>
     * <p>
     * Leverage the IAM context key <code>connect:PreferredUserArn</code> to restrict contact association to specific
     * preferred user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use this API with chat, email, and task contacts. It does not support voice contacts.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use it to associate contacts with users regardless of their current state, including custom states. Ensure your
     * application logic accounts for user availability before making associations.
     * </p>
     * </li>
     * <li>
     * <p>
     * It honors the IAM context key <code>connect:PreferredUserArn</code> to prevent unauthorized contact associations.
     * </p>
     * </li>
     * <li>
     * <p>
     * It respects the IAM context key <code>connect:PreferredUserArn</code> to enforce authorization controls and
     * prevent unauthorized contact associations. Verify that your IAM policies are properly configured to support your
     * intended use cases.
     * </p>
     * </li>
     * <li>
     * <p>
     * The service quota <i>Queues per routing profile per instance</i> applies to manually assigned queues, too. For
     * more information about this quota, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas"
     * >Amazon Connect quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     *
     * @param associateContactWithUserRequest
     * @return A Java Future containing the result of the AssociateContactWithUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateContactWithUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateContactWithUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateContactWithUserResponse> associateContactWithUser(
            AssociateContactWithUserRequest associateContactWithUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a queued contact with an agent.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Programmatically assign queued contacts to available users.
     * </p>
     * </li>
     * <li>
     * <p>
     * Leverage the IAM context key <code>connect:PreferredUserArn</code> to restrict contact association to specific
     * preferred user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use this API with chat, email, and task contacts. It does not support voice contacts.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use it to associate contacts with users regardless of their current state, including custom states. Ensure your
     * application logic accounts for user availability before making associations.
     * </p>
     * </li>
     * <li>
     * <p>
     * It honors the IAM context key <code>connect:PreferredUserArn</code> to prevent unauthorized contact associations.
     * </p>
     * </li>
     * <li>
     * <p>
     * It respects the IAM context key <code>connect:PreferredUserArn</code> to enforce authorization controls and
     * prevent unauthorized contact associations. Verify that your IAM policies are properly configured to support your
     * intended use cases.
     * </p>
     * </li>
     * <li>
     * <p>
     * The service quota <i>Queues per routing profile per instance</i> applies to manually assigned queues, too. For
     * more information about this quota, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas"
     * >Amazon Connect quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateContactWithUserRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateContactWithUserRequest#builder()}
     * </p>
     *
     * @param associateContactWithUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateContactWithUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateContactWithUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateContactWithUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateContactWithUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateContactWithUserResponse> associateContactWithUser(
            Consumer<AssociateContactWithUserRequest.Builder> associateContactWithUserRequest) {
        return associateContactWithUser(AssociateContactWithUserRequest.builder().applyMutation(associateContactWithUserRequest)
                .build());
    }

    /**
     * <p>
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in
     * post-call and real-time analysis sessions for the given language.
     * </p>
     *
     * @param associateDefaultVocabularyRequest
     * @return A Java Future containing the result of the AssociateDefaultVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateDefaultVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDefaultVocabularyResponse> associateDefaultVocabulary(
            AssociateDefaultVocabularyRequest associateDefaultVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in
     * post-call and real-time analysis sessions for the given language.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDefaultVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateDefaultVocabularyRequest#builder()}
     * </p>
     *
     * @param associateDefaultVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateDefaultVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateDefaultVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDefaultVocabularyResponse> associateDefaultVocabulary(
            Consumer<AssociateDefaultVocabularyRequest.Builder> associateDefaultVocabularyRequest) {
        return associateDefaultVocabulary(AssociateDefaultVocabularyRequest.builder()
                .applyMutation(associateDefaultVocabularyRequest).build());
    }

    /**
     * <p>
     * Associates an email address alias with an existing email address in an Amazon Connect instance. This creates a
     * forwarding relationship where emails sent to the alias email address are automatically forwarded to the primary
     * email address.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Unified customer support</b>: Create multiple entry points (for example, support@example.com,
     * help@example.com, customercare@example.com) that all forward to a single agent queue for streamlined management.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Department consolidation</b>: Forward emails from legacy department addresses (for example, sales@example.com,
     * info@example.com) to a centralized customer service email during organizational restructuring.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Brand management</b>: Enable you to use familiar brand-specific email addresses that forward to the
     * appropriate Amazon Connect instance email address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each email address can have a maximum of one alias. You cannot create multiple aliases for the same email
     * address.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the alias email address already receives direct emails, it continues to receive direct emails plus forwarded
     * emails.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot chain email aliases together (that is, create an alias of an alias).
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>AssociateEmailAddressAlias</code> does not return the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A confirmation of the alias relationship details (you must call <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html"
     * >DescribeEmailAddress</a> to verify).
     * </p>
     * </li>
     * <li>
     * <p>
     * The timestamp of when the association occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * The status of the forwarding configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <p>
     * <b>Related operations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateEmailAddressAlias.html">
     * DisassociateEmailAddressAlias</a>: Removes the alias association between two email addresses in an Amazon Connect
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html">
     * DescribeEmailAddress</a>: View current alias configurations for an email address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchEmailAddresses.html">
     * SearchEmailAddresses</a>: Find email addresses and their alias relationships across an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateEmailAddress.html">CreateEmailAddress</
     * a>: Create new email addresses that can participate in alias relationships.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteEmailAddress.html">DeleteEmailAddress</
     * a>: Remove email addresses (automatically removes any alias relationships).
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateEmailAddressMetadata.html">
     * UpdateEmailAddressMetadata</a>: Modify email address properties (does not affect alias relationships).
     * </p>
     * </li>
     * </ul>
     *
     * @param associateEmailAddressAliasRequest
     * @return A Java Future containing the result of the AssociateEmailAddressAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateEmailAddressAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateEmailAddressAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEmailAddressAliasResponse> associateEmailAddressAlias(
            AssociateEmailAddressAliasRequest associateEmailAddressAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an email address alias with an existing email address in an Amazon Connect instance. This creates a
     * forwarding relationship where emails sent to the alias email address are automatically forwarded to the primary
     * email address.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Unified customer support</b>: Create multiple entry points (for example, support@example.com,
     * help@example.com, customercare@example.com) that all forward to a single agent queue for streamlined management.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Department consolidation</b>: Forward emails from legacy department addresses (for example, sales@example.com,
     * info@example.com) to a centralized customer service email during organizational restructuring.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Brand management</b>: Enable you to use familiar brand-specific email addresses that forward to the
     * appropriate Amazon Connect instance email address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each email address can have a maximum of one alias. You cannot create multiple aliases for the same email
     * address.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the alias email address already receives direct emails, it continues to receive direct emails plus forwarded
     * emails.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot chain email aliases together (that is, create an alias of an alias).
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>AssociateEmailAddressAlias</code> does not return the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A confirmation of the alias relationship details (you must call <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html"
     * >DescribeEmailAddress</a> to verify).
     * </p>
     * </li>
     * <li>
     * <p>
     * The timestamp of when the association occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * The status of the forwarding configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <p>
     * <b>Related operations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateEmailAddressAlias.html">
     * DisassociateEmailAddressAlias</a>: Removes the alias association between two email addresses in an Amazon Connect
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html">
     * DescribeEmailAddress</a>: View current alias configurations for an email address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchEmailAddresses.html">
     * SearchEmailAddresses</a>: Find email addresses and their alias relationships across an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateEmailAddress.html">CreateEmailAddress</
     * a>: Create new email addresses that can participate in alias relationships.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteEmailAddress.html">DeleteEmailAddress</
     * a>: Remove email addresses (automatically removes any alias relationships).
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateEmailAddressMetadata.html">
     * UpdateEmailAddressMetadata</a>: Modify email address properties (does not affect alias relationships).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEmailAddressAliasRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateEmailAddressAliasRequest#builder()}
     * </p>
     *
     * @param associateEmailAddressAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateEmailAddressAliasRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateEmailAddressAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateEmailAddressAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateEmailAddressAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEmailAddressAliasResponse> associateEmailAddressAlias(
            Consumer<AssociateEmailAddressAliasRequest.Builder> associateEmailAddressAliasRequest) {
        return associateEmailAddressAlias(AssociateEmailAddressAliasRequest.builder()
                .applyMutation(associateEmailAddressAliasRequest).build());
    }

    /**
     * <p>
     * Associates a connect resource to a flow.
     * </p>
     *
     * @param associateFlowRequest
     * @return A Java Future containing the result of the AssociateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateFlowResponse> associateFlow(AssociateFlowRequest associateFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a connect resource to a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateFlowRequest#builder()}
     * </p>
     *
     * @param associateFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateFlowResponse> associateFlow(Consumer<AssociateFlowRequest.Builder> associateFlowRequest) {
        return associateFlow(AssociateFlowRequest.builder().applyMutation(associateFlowRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration
     * in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing
     * chat transcripts.
     * </p>
     * <p>
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the
     * resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     * </p>
     *
     * @param associateInstanceStorageConfigRequest
     * @return A Java Future containing the result of the AssociateInstanceStorageConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateInstanceStorageConfigResponse> associateInstanceStorageConfig(
            AssociateInstanceStorageConfigRequest associateInstanceStorageConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration
     * in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing
     * chat transcripts.
     * </p>
     * <p>
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the
     * resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param associateInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateInstanceStorageConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateInstanceStorageConfigResponse> associateInstanceStorageConfig(
            Consumer<AssociateInstanceStorageConfigRequest.Builder> associateInstanceStorageConfigRequest) {
        return associateInstanceStorageConfig(AssociateInstanceStorageConfigRequest.builder()
                .applyMutation(associateInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     * </p>
     *
     * @param associateLambdaFunctionRequest
     * @return A Java Future containing the result of the AssociateLambdaFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateLambdaFunctionResponse> associateLambdaFunction(
            AssociateLambdaFunctionRequest associateLambdaFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLambdaFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateLambdaFunctionRequest#builder()}
     * </p>
     *
     * @param associateLambdaFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateLambdaFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateLambdaFunctionResponse> associateLambdaFunction(
            Consumer<AssociateLambdaFunctionRequest.Builder> associateLambdaFunctionRequest) {
        return associateLambdaFunction(AssociateLambdaFunctionRequest.builder().applyMutation(associateLambdaFunctionRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports
     * the association of Amazon Lex V1 bots.
     * </p>
     *
     * @param associateLexBotRequest
     * @return A Java Future containing the result of the AssociateLexBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateLexBotResponse> associateLexBot(AssociateLexBotRequest associateLexBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports
     * the association of Amazon Lex V1 bots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLexBotRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateLexBotRequest#builder()}
     * </p>
     *
     * @param associateLexBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateLexBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateLexBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateLexBotResponse> associateLexBot(
            Consumer<AssociateLexBotRequest.Builder> associateLexBotRequest) {
        return associateLexBot(AssociateLexBotRequest.builder().applyMutation(associateLexBotRequest).build());
    }

    /**
     * <p>
     * Associates a flow with a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important>
     *
     * @param associatePhoneNumberContactFlowRequest
     * @return A Java Future containing the result of the AssociatePhoneNumberContactFlow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumberContactFlowResponse> associatePhoneNumberContactFlow(
            AssociatePhoneNumberContactFlowRequest associatePhoneNumberContactFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a flow with a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePhoneNumberContactFlowRequest.Builder}
     * avoiding the need to create one manually via {@link AssociatePhoneNumberContactFlowRequest#builder()}
     * </p>
     *
     * @param associatePhoneNumberContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociatePhoneNumberContactFlow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumberContactFlowResponse> associatePhoneNumberContactFlow(
            Consumer<AssociatePhoneNumberContactFlowRequest.Builder> associatePhoneNumberContactFlowRequest) {
        return associatePhoneNumberContactFlow(AssociatePhoneNumberContactFlowRequest.builder()
                .applyMutation(associatePhoneNumberContactFlowRequest).build());
    }

    /**
     * <p>
     * Associates a set of quick connects with a queue.
     * </p>
     *
     * @param associateQueueQuickConnectsRequest
     * @return A Java Future containing the result of the AssociateQueueQuickConnects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateQueueQuickConnectsResponse> associateQueueQuickConnects(
            AssociateQueueQuickConnectsRequest associateQueueQuickConnectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of quick connects with a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateQueueQuickConnectsRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param associateQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateQueueQuickConnects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateQueueQuickConnectsResponse> associateQueueQuickConnects(
            Consumer<AssociateQueueQuickConnectsRequest.Builder> associateQueueQuickConnectsRequest) {
        return associateQueueQuickConnects(AssociateQueueQuickConnectsRequest.builder()
                .applyMutation(associateQueueQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Associates a set of queues with a routing profile.
     * </p>
     *
     * @param associateRoutingProfileQueuesRequest
     * @return A Java Future containing the result of the AssociateRoutingProfileQueues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateRoutingProfileQueuesResponse> associateRoutingProfileQueues(
            AssociateRoutingProfileQueuesRequest associateRoutingProfileQueuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of queues with a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateRoutingProfileQueuesRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param associateRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateRoutingProfileQueues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateRoutingProfileQueuesResponse> associateRoutingProfileQueues(
            Consumer<AssociateRoutingProfileQueuesRequest.Builder> associateRoutingProfileQueuesRequest) {
        return associateRoutingProfileQueues(AssociateRoutingProfileQueuesRequest.builder()
                .applyMutation(associateRoutingProfileQueuesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a security key to the instance.
     * </p>
     *
     * @param associateSecurityKeyRequest
     * @return A Java Future containing the result of the AssociateSecurityKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateSecurityKeyResponse> associateSecurityKey(
            AssociateSecurityKeyRequest associateSecurityKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a security key to the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSecurityKeyRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSecurityKeyRequest#builder()}
     * </p>
     *
     * @param associateSecurityKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateSecurityKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateSecurityKeyResponse> associateSecurityKey(
            Consumer<AssociateSecurityKeyRequest.Builder> associateSecurityKeyRequest) {
        return associateSecurityKey(AssociateSecurityKeyRequest.builder().applyMutation(associateSecurityKeyRequest).build());
    }

    /**
     * <p>
     * Associate security profiles with an Entity in an Amazon Connect instance.
     * </p>
     *
     * @param associateSecurityProfilesRequest
     * @return A Java Future containing the result of the AssociateSecurityProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ConditionalOperationFailedException Request processing failed because dependent condition failed.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSecurityProfilesResponse> associateSecurityProfiles(
            AssociateSecurityProfilesRequest associateSecurityProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate security profiles with an Entity in an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSecurityProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateSecurityProfilesRequest#builder()}
     * </p>
     *
     * @param associateSecurityProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateSecurityProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateSecurityProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ConditionalOperationFailedException Request processing failed because dependent condition failed.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSecurityProfilesResponse> associateSecurityProfiles(
            Consumer<AssociateSecurityProfilesRequest.Builder> associateSecurityProfilesRequest) {
        return associateSecurityProfiles(AssociateSecurityProfilesRequest.builder()
                .applyMutation(associateSecurityProfilesRequest).build());
    }

    /**
     * <p>
     * Associates an agent with a traffic distribution group. This API can be called only in the Region where the
     * traffic distribution group is created.
     * </p>
     *
     * @param associateTrafficDistributionGroupUserRequest
     * @return A Java Future containing the result of the AssociateTrafficDistributionGroupUser operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateTrafficDistributionGroupUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTrafficDistributionGroupUserResponse> associateTrafficDistributionGroupUser(
            AssociateTrafficDistributionGroupUserRequest associateTrafficDistributionGroupUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an agent with a traffic distribution group. This API can be called only in the Region where the
     * traffic distribution group is created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateTrafficDistributionGroupUserRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateTrafficDistributionGroupUserRequest#builder()}
     * </p>
     *
     * @param associateTrafficDistributionGroupUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateTrafficDistributionGroupUserRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateTrafficDistributionGroupUser operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateTrafficDistributionGroupUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTrafficDistributionGroupUserResponse> associateTrafficDistributionGroupUser(
            Consumer<AssociateTrafficDistributionGroupUserRequest.Builder> associateTrafficDistributionGroupUserRequest) {
        return associateTrafficDistributionGroupUser(AssociateTrafficDistributionGroupUserRequest.builder()
                .applyMutation(associateTrafficDistributionGroupUserRequest).build());
    }

    /**
     * <p>
     * Associates a set of proficiencies with a user.
     * </p>
     *
     * @param associateUserProficienciesRequest
     * @return A Java Future containing the result of the AssociateUserProficiencies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateUserProficienciesResponse> associateUserProficiencies(
            AssociateUserProficienciesRequest associateUserProficienciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of proficiencies with a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateUserProficienciesRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateUserProficienciesRequest#builder()}
     * </p>
     *
     * @param associateUserProficienciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateUserProficienciesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateUserProficiencies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateUserProficienciesResponse> associateUserProficiencies(
            Consumer<AssociateUserProficienciesRequest.Builder> associateUserProficienciesRequest) {
        return associateUserProficiencies(AssociateUserProficienciesRequest.builder()
                .applyMutation(associateUserProficienciesRequest).build());
    }

    /**
     * <p>
     * Associates a workspace with one or more users or routing profiles, allowing them to access the workspace's
     * configured views and pages.
     * </p>
     *
     * @param associateWorkspaceRequest
     * @return A Java Future containing the result of the AssociateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateWorkspaceResponse> associateWorkspace(AssociateWorkspaceRequest associateWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a workspace with one or more users or routing profiles, allowing them to access the workspace's
     * configured views and pages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWorkspaceRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateWorkspaceRequest#builder()}
     * </p>
     *
     * @param associateWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.AssociateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateWorkspaceResponse> associateWorkspace(
            Consumer<AssociateWorkspaceRequest.Builder> associateWorkspaceRequest) {
        return associateWorkspace(AssociateWorkspaceRequest.builder().applyMutation(associateWorkspaceRequest).build());
    }

    /**
     * <p>
     * Associates a list of analytics datasets for a given Amazon Connect instance to a target account. You can
     * associate multiple datasets in a single call.
     * </p>
     *
     * @param batchAssociateAnalyticsDataSetRequest
     * @return A Java Future containing the result of the BatchAssociateAnalyticsDataSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchAssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchAssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateAnalyticsDataSetResponse> batchAssociateAnalyticsDataSet(
            BatchAssociateAnalyticsDataSetRequest batchAssociateAnalyticsDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a list of analytics datasets for a given Amazon Connect instance to a target account. You can
     * associate multiple datasets in a single call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAssociateAnalyticsDataSetRequest.Builder}
     * avoiding the need to create one manually via {@link BatchAssociateAnalyticsDataSetRequest#builder()}
     * </p>
     *
     * @param batchAssociateAnalyticsDataSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchAssociateAnalyticsDataSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchAssociateAnalyticsDataSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchAssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchAssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateAnalyticsDataSetResponse> batchAssociateAnalyticsDataSet(
            Consumer<BatchAssociateAnalyticsDataSetRequest.Builder> batchAssociateAnalyticsDataSetRequest) {
        return batchAssociateAnalyticsDataSet(BatchAssociateAnalyticsDataSetRequest.builder()
                .applyMutation(batchAssociateAnalyticsDataSetRequest).build());
    }

    /**
     * <p>
     * Creates values for attributes in a data table. The value may be a default or it may be associated with a primary
     * value. The value must pass all customer defined validation as well as the default validation for the value type.
     * The operation must conform to Batch Operation API Standards. Although the standard specifies that successful and
     * failed entities are listed separately in the response, authorization fails if any primary values or attributes
     * are unauthorized. The combination of primary values and the attribute name serve as the identifier for the
     * individual item request.
     * </p>
     *
     * @param batchCreateDataTableValueRequest
     * @return A Java Future containing the result of the BatchCreateDataTableValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchCreateDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchCreateDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateDataTableValueResponse> batchCreateDataTableValue(
            BatchCreateDataTableValueRequest batchCreateDataTableValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates values for attributes in a data table. The value may be a default or it may be associated with a primary
     * value. The value must pass all customer defined validation as well as the default validation for the value type.
     * The operation must conform to Batch Operation API Standards. Although the standard specifies that successful and
     * failed entities are listed separately in the response, authorization fails if any primary values or attributes
     * are unauthorized. The combination of primary values and the attribute name serve as the identifier for the
     * individual item request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateDataTableValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchCreateDataTableValueRequest#builder()}
     * </p>
     *
     * @param batchCreateDataTableValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreateDataTableValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchCreateDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchCreateDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateDataTableValueResponse> batchCreateDataTableValue(
            Consumer<BatchCreateDataTableValueRequest.Builder> batchCreateDataTableValueRequest) {
        return batchCreateDataTableValue(BatchCreateDataTableValueRequest.builder()
                .applyMutation(batchCreateDataTableValueRequest).build());
    }

    /**
     * <p>
     * Deletes multiple values from a data table. API users may delete values at any time. When deletion is requested
     * from the admin website, a warning is shown alerting the user of the most recent time the attribute and its values
     * were accessed. System managed values are not deletable by customers.
     * </p>
     *
     * @param batchDeleteDataTableValueRequest
     * @return A Java Future containing the result of the BatchDeleteDataTableValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchDeleteDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDeleteDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDataTableValueResponse> batchDeleteDataTableValue(
            BatchDeleteDataTableValueRequest batchDeleteDataTableValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes multiple values from a data table. API users may delete values at any time. When deletion is requested
     * from the admin website, a warning is shown alerting the user of the most recent time the attribute and its values
     * were accessed. System managed values are not deletable by customers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDataTableValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteDataTableValueRequest#builder()}
     * </p>
     *
     * @param batchDeleteDataTableValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchDeleteDataTableValueRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteDataTableValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchDeleteDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDeleteDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDataTableValueResponse> batchDeleteDataTableValue(
            Consumer<BatchDeleteDataTableValueRequest.Builder> batchDeleteDataTableValueRequest) {
        return batchDeleteDataTableValue(BatchDeleteDataTableValueRequest.builder()
                .applyMutation(batchDeleteDataTableValueRequest).build());
    }

    /**
     * <p>
     * Retrieves multiple values from a data table without evaluating expressions. Returns the raw stored values along
     * with metadata such as lock versions and modification timestamps. "Describe" is a deprecated term but is allowed
     * to maintain consistency with existing operations.
     * </p>
     *
     * @param batchDescribeDataTableValueRequest
     * @return A Java Future containing the result of the BatchDescribeDataTableValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchDescribeDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDescribeDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeDataTableValueResponse> batchDescribeDataTableValue(
            BatchDescribeDataTableValueRequest batchDescribeDataTableValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves multiple values from a data table without evaluating expressions. Returns the raw stored values along
     * with metadata such as lock versions and modification timestamps. "Describe" is a deprecated term but is allowed
     * to maintain consistency with existing operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeDataTableValueRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDescribeDataTableValueRequest#builder()}
     * </p>
     *
     * @param batchDescribeDataTableValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchDescribeDataTableValueRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the BatchDescribeDataTableValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchDescribeDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDescribeDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeDataTableValueResponse> batchDescribeDataTableValue(
            Consumer<BatchDescribeDataTableValueRequest.Builder> batchDescribeDataTableValueRequest) {
        return batchDescribeDataTableValue(BatchDescribeDataTableValueRequest.builder()
                .applyMutation(batchDescribeDataTableValueRequest).build());
    }

    /**
     * <p>
     * Removes a list of analytics datasets associated with a given Amazon Connect instance. You can disassociate
     * multiple datasets in a single call.
     * </p>
     *
     * @param batchDisassociateAnalyticsDataSetRequest
     * @return A Java Future containing the result of the BatchDisassociateAnalyticsDataSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchDisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateAnalyticsDataSetResponse> batchDisassociateAnalyticsDataSet(
            BatchDisassociateAnalyticsDataSetRequest batchDisassociateAnalyticsDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a list of analytics datasets associated with a given Amazon Connect instance. You can disassociate
     * multiple datasets in a single call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisassociateAnalyticsDataSetRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDisassociateAnalyticsDataSetRequest#builder()}
     * </p>
     *
     * @param batchDisassociateAnalyticsDataSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchDisassociateAnalyticsDataSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchDisassociateAnalyticsDataSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchDisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateAnalyticsDataSetResponse> batchDisassociateAnalyticsDataSet(
            Consumer<BatchDisassociateAnalyticsDataSetRequest.Builder> batchDisassociateAnalyticsDataSetRequest) {
        return batchDisassociateAnalyticsDataSet(BatchDisassociateAnalyticsDataSetRequest.builder()
                .applyMutation(batchDisassociateAnalyticsDataSetRequest).build());
    }

    /**
     * <p>
     * Allows you to retrieve metadata about multiple attached files on an associated resource. Each attached file
     * provided in the input list must be associated with the input AssociatedResourceArn.
     * </p>
     *
     * @param batchGetAttachedFileMetadataRequest
     * @return A Java Future containing the result of the BatchGetAttachedFileMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchGetAttachedFileMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetAttachedFileMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAttachedFileMetadataResponse> batchGetAttachedFileMetadata(
            BatchGetAttachedFileMetadataRequest batchGetAttachedFileMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to retrieve metadata about multiple attached files on an associated resource. Each attached file
     * provided in the input list must be associated with the input AssociatedResourceArn.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAttachedFileMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAttachedFileMetadataRequest#builder()}
     * </p>
     *
     * @param batchGetAttachedFileMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchGetAttachedFileMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchGetAttachedFileMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchGetAttachedFileMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetAttachedFileMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAttachedFileMetadataResponse> batchGetAttachedFileMetadata(
            Consumer<BatchGetAttachedFileMetadataRequest.Builder> batchGetAttachedFileMetadataRequest) {
        return batchGetAttachedFileMetadata(BatchGetAttachedFileMetadataRequest.builder()
                .applyMutation(batchGetAttachedFileMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieve the flow associations for the given resources.
     * </p>
     *
     * @param batchGetFlowAssociationRequest
     * @return A Java Future containing the result of the BatchGetFlowAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchGetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetFlowAssociationResponse> batchGetFlowAssociation(
            BatchGetFlowAssociationRequest batchGetFlowAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the flow associations for the given resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFlowAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetFlowAssociationRequest#builder()}
     * </p>
     *
     * @param batchGetFlowAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchGetFlowAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetFlowAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchGetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetFlowAssociationResponse> batchGetFlowAssociation(
            Consumer<BatchGetFlowAssociationRequest.Builder> batchGetFlowAssociationRequest) {
        return batchGetFlowAssociation(BatchGetFlowAssociationRequest.builder().applyMutation(batchGetFlowAssociationRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call
     * this API.
     * </p>
     * </note>
     * <p>
     * Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial
     * requests via the <a
     * href="https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html"
     * >PutDialRequestBatch</a> API. It then uses BatchPutContact to create contacts corresponding to those dial
     * requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting
     * voice call uses the same contactId that was created by BatchPutContact.
     * </p>
     *
     * @param batchPutContactRequest
     * @return A Java Future containing the result of the BatchPutContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchPutContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchPutContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchPutContactResponse> batchPutContact(BatchPutContactRequest batchPutContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call
     * this API.
     * </p>
     * </note>
     * <p>
     * Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial
     * requests via the <a
     * href="https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html"
     * >PutDialRequestBatch</a> API. It then uses BatchPutContact to create contacts corresponding to those dial
     * requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting
     * voice call uses the same contactId that was created by BatchPutContact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutContactRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutContactRequest#builder()}
     * </p>
     *
     * @param batchPutContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchPutContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchPutContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchPutContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchPutContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchPutContactResponse> batchPutContact(
            Consumer<BatchPutContactRequest.Builder> batchPutContactRequest) {
        return batchPutContact(BatchPutContactRequest.builder().applyMutation(batchPutContactRequest).build());
    }

    /**
     * <p>
     * Updates multiple data table values using all properties from BatchCreateDataTableValue. System managed values are
     * not modifiable by customers. The operation requires proper lock versions to prevent concurrent modification
     * conflicts.
     * </p>
     *
     * @param batchUpdateDataTableValueRequest
     * @return A Java Future containing the result of the BatchUpdateDataTableValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchUpdateDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchUpdateDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateDataTableValueResponse> batchUpdateDataTableValue(
            BatchUpdateDataTableValueRequest batchUpdateDataTableValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple data table values using all properties from BatchCreateDataTableValue. System managed values are
     * not modifiable by customers. The operation requires proper lock versions to prevent concurrent modification
     * conflicts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateDataTableValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchUpdateDataTableValueRequest#builder()}
     * </p>
     *
     * @param batchUpdateDataTableValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateDataTableValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.BatchUpdateDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchUpdateDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateDataTableValueResponse> batchUpdateDataTableValue(
            Consumer<BatchUpdateDataTableValueRequest.Builder> batchUpdateDataTableValueRequest) {
        return batchUpdateDataTableValue(BatchUpdateDataTableValueRequest.builder()
                .applyMutation(batchUpdateDataTableValueRequest).build());
    }

    /**
     * <p>
     * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this
     * API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group
     * was created.
     * </p>
     * <p>
     * For more information about how to use this operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html">Claim a phone number in your
     * country</a> and <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html"
     * >Claim phone numbers to traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * You can call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html"
     * >SearchAvailablePhoneNumbers</a> API for available phone numbers that you can claim. Call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html"
     * >DescribePhoneNumber</a> API to verify the status of a previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a>
     * operation.
     * </p>
     * </important>
     * <p>
     * If you plan to claim and release numbers frequently, contact us for a service quota exception. Otherwise, it is
     * possible you will be blocked from claiming and releasing any more numbers until up to 180 days past the oldest
     * number released has expired.
     * </p>
     * <p>
     * By default you can claim and release up to 200% of your maximum number of active phone numbers. If you claim and
     * release phone numbers using the UI or API during a rolling 180 day cycle that exceeds 200% of your phone number
     * service level quota, you will be blocked from claiming any more numbers until 180 days past the oldest number
     * released has expired.
     * </p>
     * <p>
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 180
     * day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point
     * you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     * </p>
     *
     * @param claimPhoneNumberRequest
     * @return A Java Future containing the result of the ClaimPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.ClaimPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ClaimPhoneNumberResponse> claimPhoneNumber(ClaimPhoneNumberRequest claimPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this
     * API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group
     * was created.
     * </p>
     * <p>
     * For more information about how to use this operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html">Claim a phone number in your
     * country</a> and <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html"
     * >Claim phone numbers to traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * You can call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html"
     * >SearchAvailablePhoneNumbers</a> API for available phone numbers that you can claim. Call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html"
     * >DescribePhoneNumber</a> API to verify the status of a previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a>
     * operation.
     * </p>
     * </important>
     * <p>
     * If you plan to claim and release numbers frequently, contact us for a service quota exception. Otherwise, it is
     * possible you will be blocked from claiming and releasing any more numbers until up to 180 days past the oldest
     * number released has expired.
     * </p>
     * <p>
     * By default you can claim and release up to 200% of your maximum number of active phone numbers. If you claim and
     * release phone numbers using the UI or API during a rolling 180 day cycle that exceeds 200% of your phone number
     * service level quota, you will be blocked from claiming any more numbers until 180 days past the oldest number
     * released has expired.
     * </p>
     * <p>
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 180
     * day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point
     * you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimPhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link ClaimPhoneNumberRequest#builder()}
     * </p>
     *
     * @param claimPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ClaimPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.ClaimPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ClaimPhoneNumberResponse> claimPhoneNumber(
            Consumer<ClaimPhoneNumberRequest.Builder> claimPhoneNumberRequest) {
        return claimPhoneNumber(ClaimPhoneNumberRequest.builder().applyMutation(claimPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Allows you to confirm that the attached file has been uploaded using the pre-signed URL provided in the
     * StartAttachedFileUpload API.
     * </p>
     *
     * @param completeAttachedFileUploadRequest
     *        Request to CompleteAttachedFileUpload API
     * @return A Java Future containing the result of the CompleteAttachedFileUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CompleteAttachedFileUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CompleteAttachedFileUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CompleteAttachedFileUploadResponse> completeAttachedFileUpload(
            CompleteAttachedFileUploadRequest completeAttachedFileUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to confirm that the attached file has been uploaded using the pre-signed URL provided in the
     * StartAttachedFileUpload API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteAttachedFileUploadRequest.Builder} avoiding
     * the need to create one manually via {@link CompleteAttachedFileUploadRequest#builder()}
     * </p>
     *
     * @param completeAttachedFileUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CompleteAttachedFileUploadRequest.Builder} to create
     *        a request. Request to CompleteAttachedFileUpload API
     * @return A Java Future containing the result of the CompleteAttachedFileUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CompleteAttachedFileUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CompleteAttachedFileUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CompleteAttachedFileUploadResponse> completeAttachedFileUpload(
            Consumer<CompleteAttachedFileUploadRequest.Builder> completeAttachedFileUploadRequest) {
        return completeAttachedFileUpload(CompleteAttachedFileUploadRequest.builder()
                .applyMutation(completeAttachedFileUploadRequest).build());
    }

    /**
     * <p>
     * Creates an agent status for the specified Amazon Connect instance.
     * </p>
     *
     * @param createAgentStatusRequest
     * @return A Java Future containing the result of the CreateAgentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAgentStatusResponse> createAgentStatus(CreateAgentStatusRequest createAgentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an agent status for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentStatusRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAgentStatusRequest#builder()}
     * </p>
     *
     * @param createAgentStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAgentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAgentStatusResponse> createAgentStatus(
            Consumer<CreateAgentStatusRequest.Builder> createAgentStatusRequest) {
        return createAgentStatus(CreateAgentStatusRequest.builder().applyMutation(createAgentStatusRequest).build());
    }

    /**
     * <important>
     * <p>
     * Only the VOICE, EMAIL, and TASK channels are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For VOICE: The supported initiation method is <code>TRANSFER</code>. The contacts created with this initiation
     * method have a subtype <code>connect:ExternalAudio</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For EMAIL: The supported initiation methods are <code>OUTBOUND</code>, <code>AGENT_REPLY</code>, and
     * <code>FLOW</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For TASK: The supported initiation method is <code>API</code>. Contacts created with this API have a sub-type of
     * <code>connect:ExternalTask</code>.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * Creates a new VOICE, EMAIL, or TASK contact.
     * </p>
     * <p>
     * After a contact is created, you can move it to the desired state by using the <code>InitiateAs</code> parameter.
     * While you can use API to create task contacts that are in the <code>COMPLETED</code> state, you must contact
     * Amazon Web Services Support before using it for bulk import use cases. Bulk import causes your requests to be
     * throttled or fail if your CreateContact limits aren't high enough.
     * </p>
     *
     * @param createContactRequest
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContactResponse> createContact(CreateContactRequest createContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * Only the VOICE, EMAIL, and TASK channels are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For VOICE: The supported initiation method is <code>TRANSFER</code>. The contacts created with this initiation
     * method have a subtype <code>connect:ExternalAudio</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For EMAIL: The supported initiation methods are <code>OUTBOUND</code>, <code>AGENT_REPLY</code>, and
     * <code>FLOW</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For TASK: The supported initiation method is <code>API</code>. Contacts created with this API have a sub-type of
     * <code>connect:ExternalTask</code>.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * Creates a new VOICE, EMAIL, or TASK contact.
     * </p>
     * <p>
     * After a contact is created, you can move it to the desired state by using the <code>InitiateAs</code> parameter.
     * While you can use API to create task contacts that are in the <code>COMPLETED</code> state, you must contact
     * Amazon Web Services Support before using it for bulk import use cases. Bulk import causes your requests to be
     * throttled or fail if your CreateContact limits aren't high enough.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContactRequest#builder()}
     * </p>
     *
     * @param createContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContactResponse> createContact(Consumer<CreateContactRequest.Builder> createContactRequest) {
        return createContact(CreateContactRequest.builder().applyMutation(createContactRequest).build());
    }

    /**
     * <p>
     * Creates a flow for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     *
     * @param createContactFlowRequest
     * @return A Java Future containing the result of the CreateContactFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidContactFlowException The flow is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContactFlowResponse> createContactFlow(CreateContactFlowRequest createContactFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a flow for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowRequest.Builder} avoiding the need
     * to create one manually via {@link CreateContactFlowRequest#builder()}
     * </p>
     *
     * @param createContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateContactFlowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateContactFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidContactFlowException The flow is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContactFlowResponse> createContactFlow(
            Consumer<CreateContactFlowRequest.Builder> createContactFlowRequest) {
        return createContactFlow(CreateContactFlowRequest.builder().applyMutation(createContactFlowRequest).build());
    }

    /**
     * <p>
     * Creates a flow module for the specified Amazon Connect instance.
     * </p>
     *
     * @param createContactFlowModuleRequest
     * @return A Java Future containing the result of the CreateContactFlowModule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidContactFlowModuleException The problems with the module. Please fix before trying again.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactFlowModuleResponse> createContactFlowModule(
            CreateContactFlowModuleRequest createContactFlowModuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a flow module for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link CreateContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param createContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateContactFlowModule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidContactFlowModuleException The problems with the module. Please fix before trying again.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactFlowModuleResponse> createContactFlowModule(
            Consumer<CreateContactFlowModuleRequest.Builder> createContactFlowModuleRequest) {
        return createContactFlowModule(CreateContactFlowModuleRequest.builder().applyMutation(createContactFlowModuleRequest)
                .build());
    }

    /**
     * <p>
     * Creates a named alias that points to a specific version of a contact flow module.
     * </p>
     *
     * @param createContactFlowModuleAliasRequest
     * @return A Java Future containing the result of the CreateContactFlowModuleAlias operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlowModuleAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModuleAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactFlowModuleAliasResponse> createContactFlowModuleAlias(
            CreateContactFlowModuleAliasRequest createContactFlowModuleAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a named alias that points to a specific version of a contact flow module.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowModuleAliasRequest.Builder}
     * avoiding the need to create one manually via {@link CreateContactFlowModuleAliasRequest#builder()}
     * </p>
     *
     * @param createContactFlowModuleAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateContactFlowModuleAliasRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateContactFlowModuleAlias operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlowModuleAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModuleAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactFlowModuleAliasResponse> createContactFlowModuleAlias(
            Consumer<CreateContactFlowModuleAliasRequest.Builder> createContactFlowModuleAliasRequest) {
        return createContactFlowModuleAlias(CreateContactFlowModuleAliasRequest.builder()
                .applyMutation(createContactFlowModuleAliasRequest).build());
    }

    /**
     * <p>
     * Creates an immutable snapshot of a contact flow module, preserving its content and settings at a specific point
     * in time for version control and rollback capabilities.
     * </p>
     *
     * @param createContactFlowModuleVersionRequest
     * @return A Java Future containing the result of the CreateContactFlowModuleVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlowModuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactFlowModuleVersionResponse> createContactFlowModuleVersion(
            CreateContactFlowModuleVersionRequest createContactFlowModuleVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an immutable snapshot of a contact flow module, preserving its content and settings at a specific point
     * in time for version control and rollback capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowModuleVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateContactFlowModuleVersionRequest#builder()}
     * </p>
     *
     * @param createContactFlowModuleVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateContactFlowModuleVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateContactFlowModuleVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlowModuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactFlowModuleVersionResponse> createContactFlowModuleVersion(
            Consumer<CreateContactFlowModuleVersionRequest.Builder> createContactFlowModuleVersionRequest) {
        return createContactFlowModuleVersion(CreateContactFlowModuleVersionRequest.builder()
                .applyMutation(createContactFlowModuleVersionRequest).build());
    }

    /**
     * <p>
     * Publishes a new version of the flow provided. Versions are immutable and monotonically increasing. If the
     * <code>FlowContentSha256</code> provided is different from the <code>FlowContentSha256</code> of the
     * <code>&#36LATEST</code> published flow content, then an error is returned. This API only supports creating
     * versions for flows of type <code>Campaign</code>.
     * </p>
     *
     * @param createContactFlowVersionRequest
     * @return A Java Future containing the result of the CreateContactFlowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactFlowVersionResponse> createContactFlowVersion(
            CreateContactFlowVersionRequest createContactFlowVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a new version of the flow provided. Versions are immutable and monotonically increasing. If the
     * <code>FlowContentSha256</code> provided is different from the <code>FlowContentSha256</code> of the
     * <code>&#36LATEST</code> published flow content, then an error is returned. This API only supports creating
     * versions for flows of type <code>Campaign</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateContactFlowVersionRequest#builder()}
     * </p>
     *
     * @param createContactFlowVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateContactFlowVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateContactFlowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateContactFlowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactFlowVersionResponse> createContactFlowVersion(
            Consumer<CreateContactFlowVersionRequest.Builder> createContactFlowVersionRequest) {
        return createContactFlowVersion(CreateContactFlowVersionRequest.builder().applyMutation(createContactFlowVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new data table with the specified properties. Supports the creation of all table properties except for
     * attributes and values. A table with no attributes and values is a valid state for a table. The number of tables
     * per instance is limited to 100 per instance. Customers can request an increase by using AWS Service Quotas.
     * </p>
     *
     * @param createDataTableRequest
     * @return A Java Future containing the result of the CreateDataTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateDataTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateDataTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataTableResponse> createDataTable(CreateDataTableRequest createDataTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new data table with the specified properties. Supports the creation of all table properties except for
     * attributes and values. A table with no attributes and values is a valid state for a table. The number of tables
     * per instance is limited to 100 per instance. Customers can request an increase by using AWS Service Quotas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataTableRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataTableRequest#builder()}
     * </p>
     *
     * @param createDataTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateDataTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDataTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateDataTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateDataTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataTableResponse> createDataTable(
            Consumer<CreateDataTableRequest.Builder> createDataTableRequest) {
        return createDataTable(CreateDataTableRequest.builder().applyMutation(createDataTableRequest).build());
    }

    /**
     * <p>
     * Adds an attribute to an existing data table. Creating a new primary attribute uses the empty value for the
     * specified value type for all existing records. This should not affect uniqueness of published data tables since
     * the existing primary values will already be unique. Creating attributes does not create any values. System
     * managed tables may not allow customers to create new attributes.
     * </p>
     *
     * @param createDataTableAttributeRequest
     * @return A Java Future containing the result of the CreateDataTableAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateDataTableAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateDataTableAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataTableAttributeResponse> createDataTableAttribute(
            CreateDataTableAttributeRequest createDataTableAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an attribute to an existing data table. Creating a new primary attribute uses the empty value for the
     * specified value type for all existing records. This should not affect uniqueness of published data tables since
     * the existing primary values will already be unique. Creating attributes does not create any values. System
     * managed tables may not allow customers to create new attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataTableAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataTableAttributeRequest#builder()}
     * </p>
     *
     * @param createDataTableAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateDataTableAttributeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataTableAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateDataTableAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateDataTableAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataTableAttributeResponse> createDataTableAttribute(
            Consumer<CreateDataTableAttributeRequest.Builder> createDataTableAttributeRequest) {
        return createDataTableAttribute(CreateDataTableAttributeRequest.builder().applyMutation(createDataTableAttributeRequest)
                .build());
    }

    /**
     * <p>
     * Create new email address in the specified Amazon Connect instance. For more information about email addresses,
     * see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-email-address1.html">Create email
     * addresses</a> in the Amazon Connect Administrator Guide.
     * </p>
     *
     * @param createEmailAddressRequest
     * @return A Java Future containing the result of the CreateEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEmailAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEmailAddressResponse> createEmailAddress(CreateEmailAddressRequest createEmailAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create new email address in the specified Amazon Connect instance. For more information about email addresses,
     * see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-email-address1.html">Create email
     * addresses</a> in the Amazon Connect Administrator Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailAddressRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailAddressRequest#builder()}
     * </p>
     *
     * @param createEmailAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateEmailAddressRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEmailAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEmailAddressResponse> createEmailAddress(
            Consumer<CreateEmailAddressRequest.Builder> createEmailAddressRequest) {
        return createEmailAddress(CreateEmailAddressRequest.builder().applyMutation(createEmailAddressRequest).build());
    }

    /**
     * <p>
     * Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions
     * related to agent performance, and create sections to organize such questions. Question and section identifiers
     * cannot be duplicated within the same evaluation form.
     * </p>
     *
     * @param createEvaluationFormRequest
     * @return A Java Future containing the result of the CreateEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEvaluationFormResponse> createEvaluationForm(
            CreateEvaluationFormRequest createEvaluationFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions
     * related to agent performance, and create sections to organize such questions. Question and section identifiers
     * cannot be duplicated within the same evaluation form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEvaluationFormRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEvaluationFormRequest#builder()}
     * </p>
     *
     * @param createEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEvaluationFormResponse> createEvaluationForm(
            Consumer<CreateEvaluationFormRequest.Builder> createEvaluationFormRequest) {
        return createEvaluationForm(CreateEvaluationFormRequest.builder().applyMutation(createEvaluationFormRequest).build());
    }

    /**
     * <p>
     * Creates hours of operation.
     * </p>
     *
     * @param createHoursOfOperationRequest
     * @return A Java Future containing the result of the CreateHoursOfOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHoursOfOperationResponse> createHoursOfOperation(
            CreateHoursOfOperationRequest createHoursOfOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHoursOfOperationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param createHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateHoursOfOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHoursOfOperationResponse> createHoursOfOperation(
            Consumer<CreateHoursOfOperationRequest.Builder> createHoursOfOperationRequest) {
        return createHoursOfOperation(CreateHoursOfOperationRequest.builder().applyMutation(createHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * Creates an hours of operation override in an Amazon Connect hours of operation resource.
     * </p>
     *
     * @param createHoursOfOperationOverrideRequest
     * @return A Java Future containing the result of the CreateHoursOfOperationOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateHoursOfOperationOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperationOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHoursOfOperationOverrideResponse> createHoursOfOperationOverride(
            CreateHoursOfOperationOverrideRequest createHoursOfOperationOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an hours of operation override in an Amazon Connect hours of operation resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHoursOfOperationOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link CreateHoursOfOperationOverrideRequest#builder()}
     * </p>
     *
     * @param createHoursOfOperationOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateHoursOfOperationOverrideRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateHoursOfOperationOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateHoursOfOperationOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperationOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHoursOfOperationOverrideResponse> createHoursOfOperationOverride(
            Consumer<CreateHoursOfOperationOverrideRequest.Builder> createHoursOfOperationOverrideRequest) {
        return createHoursOfOperationOverride(CreateHoursOfOperationOverrideRequest.builder()
                .applyMutation(createHoursOfOperationOverrideRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage,
     * such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any
     * configurations on features, such as Contact Lens for Amazon Connect.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Create an Amazon
     * Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     *
     * @param createInstanceRequest
     * @return A Java Future containing the result of the CreateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstanceResponse> createInstance(CreateInstanceRequest createInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage,
     * such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any
     * configurations on features, such as Contact Lens for Amazon Connect.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Create an Amazon
     * Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInstanceRequest#builder()}
     * </p>
     *
     * @param createInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstanceResponse> createInstance(Consumer<CreateInstanceRequest.Builder> createInstanceRequest) {
        return createInstance(CreateInstanceRequest.builder().applyMutation(createInstanceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     * </p>
     *
     * @param createIntegrationAssociationRequest
     * @return A Java Future containing the result of the CreateIntegrationAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIntegrationAssociationResponse> createIntegrationAssociation(
            CreateIntegrationAssociationRequest createIntegrationAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateIntegrationAssociationRequest#builder()}
     * </p>
     *
     * @param createIntegrationAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateIntegrationAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIntegrationAssociationResponse> createIntegrationAssociation(
            Consumer<CreateIntegrationAssociationRequest.Builder> createIntegrationAssociationRequest) {
        return createIntegrationAssociation(CreateIntegrationAssociationRequest.builder()
                .applyMutation(createIntegrationAssociationRequest).build());
    }

    /**
     * <p>
     * Adds a new participant into an on-going chat contact or webRTC call. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html">Customize chat flow
     * experiences by integrating custom participants</a> or <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-multiuser-inapp.html">Enable multi-user web,
     * in-app, and video calling</a>.
     * </p>
     *
     * @param createParticipantRequest
     * @return A Java Future containing the result of the CreateParticipant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateParticipant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateParticipantResponse> createParticipant(CreateParticipantRequest createParticipantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new participant into an on-going chat contact or webRTC call. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html">Customize chat flow
     * experiences by integrating custom participants</a> or <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-multiuser-inapp.html">Enable multi-user web,
     * in-app, and video calling</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateParticipantRequest.Builder} avoiding the need
     * to create one manually via {@link CreateParticipantRequest#builder()}
     * </p>
     *
     * @param createParticipantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateParticipantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateParticipant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateParticipant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateParticipantResponse> createParticipant(
            Consumer<CreateParticipantRequest.Builder> createParticipantRequest) {
        return createParticipant(CreateParticipantRequest.builder().applyMutation(createParticipantRequest).build());
    }

    /**
     * <p>
     * Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createPersistentContactAssociationRequest
     * @return A Java Future containing the result of the CreatePersistentContactAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreatePersistentContactAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePersistentContactAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePersistentContactAssociationResponse> createPersistentContactAssociation(
            CreatePersistentContactAssociationRequest createPersistentContactAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePersistentContactAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePersistentContactAssociationRequest#builder()}
     * </p>
     *
     * @param createPersistentContactAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreatePersistentContactAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreatePersistentContactAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreatePersistentContactAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePersistentContactAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePersistentContactAssociationResponse> createPersistentContactAssociation(
            Consumer<CreatePersistentContactAssociationRequest.Builder> createPersistentContactAssociationRequest) {
        return createPersistentContactAssociation(CreatePersistentContactAssociationRequest.builder()
                .applyMutation(createPersistentContactAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a new predefined attribute for the specified Amazon Connect instance. A <i>predefined attribute</i> is
     * made up of a name and a value.
     * </p>
     * <p>
     * For the predefined attributes per instance quota, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas"
     * >Amazon Connect quotas</a>.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create an attribute for routing proficiency (for example, agent certification) that has predefined values (for
     * example, a list of possible certifications). For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined
     * attributes for routing contacts to agents</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create an attribute for business unit name that has a list of predefined business unit names used in your
     * organization. This is a use case where information for a contact varies between transfers or conferences. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-contact-segment-attributes.html">Use contact
     * segment attributes</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     *
     * @param createPredefinedAttributeRequest
     * @return A Java Future containing the result of the CreatePredefinedAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreatePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePredefinedAttributeResponse> createPredefinedAttribute(
            CreatePredefinedAttributeRequest createPredefinedAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new predefined attribute for the specified Amazon Connect instance. A <i>predefined attribute</i> is
     * made up of a name and a value.
     * </p>
     * <p>
     * For the predefined attributes per instance quota, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas"
     * >Amazon Connect quotas</a>.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create an attribute for routing proficiency (for example, agent certification) that has predefined values (for
     * example, a list of possible certifications). For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined
     * attributes for routing contacts to agents</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create an attribute for business unit name that has a list of predefined business unit names used in your
     * organization. This is a use case where information for a contact varies between transfers or conferences. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-contact-segment-attributes.html">Use contact
     * segment attributes</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePredefinedAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePredefinedAttributeRequest#builder()}
     * </p>
     *
     * @param createPredefinedAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreatePredefinedAttributeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePredefinedAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreatePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePredefinedAttributeResponse> createPredefinedAttribute(
            Consumer<CreatePredefinedAttributeRequest.Builder> createPredefinedAttributeRequest) {
        return createPredefinedAttribute(CreatePredefinedAttributeRequest.builder()
                .applyMutation(createPredefinedAttributeRequest).build());
    }

    /**
     * <p>
     * Creates a prompt. For more information about prompts, such as supported file types and maximum length, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html">Create prompts</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     *
     * @param createPromptRequest
     * @return A Java Future containing the result of the CreatePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreatePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePromptResponse> createPrompt(CreatePromptRequest createPromptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a prompt. For more information about prompts, such as supported file types and maximum length, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html">Create prompts</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePromptRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePromptRequest#builder()}
     * </p>
     *
     * @param createPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreatePromptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreatePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePromptResponse> createPrompt(Consumer<CreatePromptRequest.Builder> createPromptRequest) {
        return createPrompt(CreatePromptRequest.builder().applyMutation(createPromptRequest).build());
    }

    /**
     * <p>
     * Creates registration for a device token and a chat contact to receive real-time push notifications. For more
     * information about push notifications, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-push-notifications-for-mobile-chat.html">Set
     * up push notifications in Amazon Connect for mobile chat</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createPushNotificationRegistrationRequest
     * @return A Java Future containing the result of the CreatePushNotificationRegistration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreatePushNotificationRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePushNotificationRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePushNotificationRegistrationResponse> createPushNotificationRegistration(
            CreatePushNotificationRegistrationRequest createPushNotificationRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates registration for a device token and a chat contact to receive real-time push notifications. For more
     * information about push notifications, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-push-notifications-for-mobile-chat.html">Set
     * up push notifications in Amazon Connect for mobile chat</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePushNotificationRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePushNotificationRegistrationRequest#builder()}
     * </p>
     *
     * @param createPushNotificationRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreatePushNotificationRegistrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreatePushNotificationRegistration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreatePushNotificationRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePushNotificationRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePushNotificationRegistrationResponse> createPushNotificationRegistration(
            Consumer<CreatePushNotificationRegistrationRequest.Builder> createPushNotificationRegistrationRequest) {
        return createPushNotificationRegistration(CreatePushNotificationRegistrationRequest.builder()
                .applyMutation(createPushNotificationRegistrationRequest).build());
    }

    /**
     * <p>
     * Creates a new queue for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon
     * Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for
     * <code>OutboundCallerIdNumberId</code>. However, if the phone number is claimed to a traffic distribution group
     * that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that
     * is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is
     * provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Only use the phone number ARN format that doesn't contain <code>instance</code> in the path, for example,
     * <code>arn:aws:connect:us-east-1:1234567890:phone-number/uuid</code>. This is the same ARN format that is returned
     * when you call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic
     * distribution group, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region"
     * >Allow or Deny queue API actions for phone numbers in a replica Region</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param createQueueRequest
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQueueResponse> createQueue(CreateQueueRequest createQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new queue for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon
     * Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for
     * <code>OutboundCallerIdNumberId</code>. However, if the phone number is claimed to a traffic distribution group
     * that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that
     * is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is
     * provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Only use the phone number ARN format that doesn't contain <code>instance</code> in the path, for example,
     * <code>arn:aws:connect:us-east-1:1234567890:phone-number/uuid</code>. This is the same ARN format that is returned
     * when you call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic
     * distribution group, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region"
     * >Allow or Deny queue API actions for phone numbers in a replica Region</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQueueRequest#builder()}
     * </p>
     *
     * @param createQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQueueResponse> createQueue(Consumer<CreateQueueRequest.Builder> createQueueRequest) {
        return createQueue(CreateQueueRequest.builder().applyMutation(createQueueRequest).build());
    }

    /**
     * <p>
     * Creates a quick connect for the specified Amazon Connect instance.
     * </p>
     *
     * @param createQuickConnectRequest
     * @return A Java Future containing the result of the CreateQuickConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateQuickConnectResponse> createQuickConnect(CreateQuickConnectRequest createQuickConnectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a quick connect for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link CreateQuickConnectRequest#builder()}
     * </p>
     *
     * @param createQuickConnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateQuickConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateQuickConnectResponse> createQuickConnect(
            Consumer<CreateQuickConnectRequest.Builder> createQuickConnectRequest) {
        return createQuickConnect(CreateQuickConnectRequest.builder().applyMutation(createQuickConnectRequest).build());
    }

    /**
     * <p>
     * Creates a new routing profile.
     * </p>
     *
     * @param createRoutingProfileRequest
     * @return A Java Future containing the result of the CreateRoutingProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRoutingProfileResponse> createRoutingProfile(
            CreateRoutingProfileRequest createRoutingProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoutingProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRoutingProfileRequest#builder()}
     * </p>
     *
     * @param createRoutingProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRoutingProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRoutingProfileResponse> createRoutingProfile(
            Consumer<CreateRoutingProfileRequest.Builder> createRoutingProfileRequest) {
        return createRoutingProfile(CreateRoutingProfileRequest.builder().applyMutation(createRoutingProfileRequest).build());
    }

    /**
     * <p>
     * Creates a rule for the specified Amazon Connect instance.
     * </p>
     * <p>
     * Use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html">Rules
     * Function language</a> to code conditions for the rule.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule for the specified Amazon Connect instance.
     * </p>
     * <p>
     * Use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html">Rules
     * Function language</a> to code conditions for the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a security profile.
     * </p>
     * <p>
     * For information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the
     * security profile permissions, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile
     * permissions</a>.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return A Java Future containing the result of the CreateSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSecurityProfileResponse> createSecurityProfile(
            CreateSecurityProfileRequest createSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a security profile.
     * </p>
     * <p>
     * For information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the
     * security profile permissions, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile
     * permissions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityProfileRequest#builder()}
     * </p>
     *
     * @param createSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSecurityProfileResponse> createSecurityProfile(
            Consumer<CreateSecurityProfileRequest.Builder> createSecurityProfileRequest) {
        return createSecurityProfile(CreateSecurityProfileRequest.builder().applyMutation(createSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new task template in the specified Amazon Connect instance.
     * </p>
     *
     * @param createTaskTemplateRequest
     * @return A Java Future containing the result of the CreateTaskTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PropertyValidationException The property is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTaskTemplateResponse> createTaskTemplate(CreateTaskTemplateRequest createTaskTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new task template in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTaskTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTaskTemplateRequest#builder()}
     * </p>
     *
     * @param createTaskTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTaskTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PropertyValidationException The property is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTaskTemplateResponse> createTaskTemplate(
            Consumer<CreateTaskTemplateRequest.Builder> createTaskTemplateRequest) {
        return createTaskTemplate(CreateTaskTemplateRequest.builder().applyMutation(createTaskTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
     * </p>
     * <note>
     * <p>
     * The <code>SignInConfig</code> distribution is available only on a default <code>TrafficDistributionGroup</code>
     * (see the <code>IsDefault</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html"
     * >TrafficDistributionGroup</a> data type). If you call <code>UpdateTrafficDistribution</code> with a modified
     * <code>SignInConfig</code> and a non-default <code>TrafficDistributionGroup</code>, an
     * <code>InvalidRequestException</code> is returned.
     * </p>
     * </note>
     * <p>
     * For more information about creating traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html">Set up
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createTrafficDistributionGroupRequest
     * @return A Java Future containing the result of the CreateTrafficDistributionGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>ResourceNotReadyException The resource is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficDistributionGroupResponse> createTrafficDistributionGroup(
            CreateTrafficDistributionGroupRequest createTrafficDistributionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
     * </p>
     * <note>
     * <p>
     * The <code>SignInConfig</code> distribution is available only on a default <code>TrafficDistributionGroup</code>
     * (see the <code>IsDefault</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html"
     * >TrafficDistributionGroup</a> data type). If you call <code>UpdateTrafficDistribution</code> with a modified
     * <code>SignInConfig</code> and a non-default <code>TrafficDistributionGroup</code>, an
     * <code>InvalidRequestException</code> is returned.
     * </p>
     * </note>
     * <p>
     * For more information about creating traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html">Set up
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficDistributionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTrafficDistributionGroupRequest#builder()}
     * </p>
     *
     * @param createTrafficDistributionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTrafficDistributionGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>ResourceNotReadyException The resource is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficDistributionGroupResponse> createTrafficDistributionGroup(
            Consumer<CreateTrafficDistributionGroupRequest.Builder> createTrafficDistributionGroupRequest) {
        return createTrafficDistributionGroup(CreateTrafficDistributionGroupRequest.builder()
                .applyMutation(createTrafficDistributionGroupRequest).build());
    }

    /**
     * <p>
     * Creates a use case for an integration association.
     * </p>
     *
     * @param createUseCaseRequest
     * @return A Java Future containing the result of the CreateUseCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUseCaseResponse> createUseCase(CreateUseCaseRequest createUseCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a use case for an integration association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUseCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUseCaseRequest#builder()}
     * </p>
     *
     * @param createUseCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateUseCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUseCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUseCaseResponse> createUseCase(Consumer<CreateUseCaseRequest.Builder> createUseCaseRequest) {
        return createUseCase(CreateUseCaseRequest.builder().applyMutation(createUseCaseRequest).build());
    }

    /**
     * <p>
     * Creates a user account for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * Certain <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html">UserIdentityInfo</a>
     * parameters are required in some situations. For example, <code>Email</code>, <code>FirstName</code> and
     * <code>LastName</code> are required if you are using Amazon Connect or SAML for identity management.
     * </p>
     * </important>
     * <p>
     * For information about how to create users using the Amazon Connect admin website, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user account for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * Certain <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html">UserIdentityInfo</a>
     * parameters are required in some situations. For example, <code>Email</code>, <code>FirstName</code> and
     * <code>LastName</code> are required if you are using Amazon Connect or SAML for identity management.
     * </p>
     * </important>
     * <p>
     * For information about how to create users using the Amazon Connect admin website, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Creates a new user hierarchy group.
     * </p>
     *
     * @param createUserHierarchyGroupRequest
     * @return A Java Future containing the result of the CreateUserHierarchyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserHierarchyGroupResponse> createUserHierarchyGroup(
            CreateUserHierarchyGroupRequest createUserHierarchyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new user hierarchy group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param createUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUserHierarchyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserHierarchyGroupResponse> createUserHierarchyGroup(
            Consumer<CreateUserHierarchyGroupRequest.Builder> createUserHierarchyGroupRequest) {
        return createUserHierarchyGroup(CreateUserHierarchyGroupRequest.builder().applyMutation(createUserHierarchyGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new view with the possible status of <code>SAVED</code> or <code>PUBLISHED</code>.
     * </p>
     * <p>
     * The views will have a unique name for each connect instance.
     * </p>
     * <p>
     * It performs basic content validation if the status is <code>SAVED</code> or full content validation if the status
     * is set to <code>PUBLISHED</code>. An error is returned if validation fails. It associates either the
     * <code>&#36SAVED</code> qualifier or both of the <code>&#36SAVED</code> and <code>&#36LATEST</code> qualifiers
     * with the provided view content based on the status. The view is idempotent if ClientToken is provided.
     * </p>
     *
     * @param createViewRequest
     * @return A Java Future containing the result of the CreateView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateViewResponse> createView(CreateViewRequest createViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new view with the possible status of <code>SAVED</code> or <code>PUBLISHED</code>.
     * </p>
     * <p>
     * The views will have a unique name for each connect instance.
     * </p>
     * <p>
     * It performs basic content validation if the status is <code>SAVED</code> or full content validation if the status
     * is set to <code>PUBLISHED</code>. An error is returned if validation fails. It associates either the
     * <code>&#36SAVED</code> qualifier or both of the <code>&#36SAVED</code> and <code>&#36LATEST</code> qualifiers
     * with the provided view content based on the status. The view is idempotent if ClientToken is provided.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateViewRequest.Builder} avoiding the need to
     * create one manually via {@link CreateViewRequest#builder()}
     * </p>
     *
     * @param createViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateViewRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateViewResponse> createView(Consumer<CreateViewRequest.Builder> createViewRequest) {
        return createView(CreateViewRequest.builder().applyMutation(createViewRequest).build());
    }

    /**
     * <p>
     * Publishes a new version of the view identifier.
     * </p>
     * <p>
     * Versions are immutable and monotonically increasing.
     * </p>
     * <p>
     * It returns the highest version if there is no change in content compared to that version. An error is displayed
     * if the supplied ViewContentSha256 is different from the ViewContentSha256 of the <code>&#36LATEST</code> alias.
     * </p>
     *
     * @param createViewVersionRequest
     * @return A Java Future containing the result of the CreateViewVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateViewVersionResponse> createViewVersion(CreateViewVersionRequest createViewVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a new version of the view identifier.
     * </p>
     * <p>
     * Versions are immutable and monotonically increasing.
     * </p>
     * <p>
     * It returns the highest version if there is no change in content compared to that version. An error is displayed
     * if the supplied ViewContentSha256 is different from the ViewContentSha256 of the <code>&#36LATEST</code> alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateViewVersionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateViewVersionRequest#builder()}
     * </p>
     *
     * @param createViewVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateViewVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateViewVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateViewVersionResponse> createViewVersion(
            Consumer<CreateViewVersionRequest.Builder> createViewVersionRequest) {
        return createViewVersion(CreateViewVersionRequest.builder().applyMutation(createViewVersionRequest).build());
    }

    /**
     * <p>
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be
     * your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in
     * post-call and real-time contact analysis sessions for that language.
     * </p>
     *
     * @param createVocabularyRequest
     * @return A Java Future containing the result of the CreateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVocabularyResponse> createVocabulary(CreateVocabularyRequest createVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be
     * your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in
     * post-call and real-time contact analysis sessions for that language.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVocabularyRequest#builder()}
     * </p>
     *
     * @param createVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVocabularyResponse> createVocabulary(
            Consumer<CreateVocabularyRequest.Builder> createVocabularyRequest) {
        return createVocabulary(CreateVocabularyRequest.builder().applyMutation(createVocabularyRequest).build());
    }

    /**
     * <p>
     * Creates a workspace that defines the user experience by mapping views to pages. Workspaces can be assigned to
     * users or routing profiles.
     * </p>
     *
     * @param createWorkspaceRequest
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceResponse> createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a workspace that defines the user experience by mapping views to pages. Workspaces can be assigned to
     * users or routing profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspaceRequest#builder()}
     * </p>
     *
     * @param createWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateWorkspaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceResponse> createWorkspace(
            Consumer<CreateWorkspaceRequest.Builder> createWorkspaceRequest) {
        return createWorkspace(CreateWorkspaceRequest.builder().applyMutation(createWorkspaceRequest).build());
    }

    /**
     * <p>
     * Associates a view with a page in a workspace, defining what users see when they navigate to that page.
     * </p>
     *
     * @param createWorkspacePageRequest
     * @return A Java Future containing the result of the CreateWorkspacePage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateWorkspacePage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateWorkspacePage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkspacePageResponse> createWorkspacePage(
            CreateWorkspacePageRequest createWorkspacePageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a view with a page in a workspace, defining what users see when they navigate to that page.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspacePageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkspacePageRequest#builder()}
     * </p>
     *
     * @param createWorkspacePageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateWorkspacePageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkspacePage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>LimitExceededException The allowed limit for the resource has been exceeded.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.CreateWorkspacePage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateWorkspacePage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkspacePageResponse> createWorkspacePage(
            Consumer<CreateWorkspacePageRequest.Builder> createWorkspacePageRequest) {
        return createWorkspacePage(CreateWorkspacePageRequest.builder().applyMutation(createWorkspacePageRequest).build());
    }

    /**
     * <p>
     * Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no
     * longer available for users to start new evaluations based on the form.
     * </p>
     *
     * @param deactivateEvaluationFormRequest
     * @return A Java Future containing the result of the DeactivateEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeactivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeactivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateEvaluationFormResponse> deactivateEvaluationForm(
            DeactivateEvaluationFormRequest deactivateEvaluationFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no
     * longer available for users to start new evaluations based on the form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateEvaluationFormRequest.Builder} avoiding
     * the need to create one manually via {@link DeactivateEvaluationFormRequest#builder()}
     * </p>
     *
     * @param deactivateEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeactivateEvaluationFormRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeactivateEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeactivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeactivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateEvaluationFormResponse> deactivateEvaluationForm(
            Consumer<DeactivateEvaluationFormRequest.Builder> deactivateEvaluationFormRequest) {
        return deactivateEvaluationForm(DeactivateEvaluationFormRequest.builder().applyMutation(deactivateEvaluationFormRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an attached file along with the underlying S3 Object.
     * </p>
     * <important>
     * <p>
     * The attached file is <b>permanently deleted</b> if S3 bucket versioning is not enabled.
     * </p>
     * </important>
     *
     * @param deleteAttachedFileRequest
     *        Request to DeleteAttachedFile API
     * @return A Java Future containing the result of the DeleteAttachedFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteAttachedFile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAttachedFileResponse> deleteAttachedFile(DeleteAttachedFileRequest deleteAttachedFileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attached file along with the underlying S3 Object.
     * </p>
     * <important>
     * <p>
     * The attached file is <b>permanently deleted</b> if S3 bucket versioning is not enabled.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttachedFileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAttachedFileRequest#builder()}
     * </p>
     *
     * @param deleteAttachedFileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteAttachedFileRequest.Builder} to create a
     *        request. Request to DeleteAttachedFile API
     * @return A Java Future containing the result of the DeleteAttachedFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteAttachedFile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAttachedFileResponse> deleteAttachedFile(
            Consumer<DeleteAttachedFileRequest.Builder> deleteAttachedFileRequest) {
        return deleteAttachedFile(DeleteAttachedFileRequest.builder().applyMutation(deleteAttachedFileRequest).build());
    }

    /**
     * <p>
     * Deletes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteContactEvaluationRequest
     * @return A Java Future containing the result of the DeleteContactEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactEvaluationResponse> deleteContactEvaluation(
            DeleteContactEvaluationRequest deleteContactEvaluationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactEvaluationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteContactEvaluationRequest#builder()}
     * </p>
     *
     * @param deleteContactEvaluationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteContactEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactEvaluationResponse> deleteContactEvaluation(
            Consumer<DeleteContactEvaluationRequest.Builder> deleteContactEvaluationRequest) {
        return deleteContactEvaluation(DeleteContactEvaluationRequest.builder().applyMutation(deleteContactEvaluationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a flow for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteContactFlowRequest
     * @return A Java Future containing the result of the DeleteContactFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowResponse> deleteContactFlow(DeleteContactFlowRequest deleteContactFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a flow for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteContactFlowRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteContactFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowResponse> deleteContactFlow(
            Consumer<DeleteContactFlowRequest.Builder> deleteContactFlowRequest) {
        return deleteContactFlow(DeleteContactFlowRequest.builder().applyMutation(deleteContactFlowRequest).build());
    }

    /**
     * <p>
     * Deletes the specified flow module.
     * </p>
     *
     * @param deleteContactFlowModuleRequest
     * @return A Java Future containing the result of the DeleteContactFlowModule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowModuleResponse> deleteContactFlowModule(
            DeleteContactFlowModuleRequest deleteContactFlowModuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified flow module.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteContactFlowModule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowModuleResponse> deleteContactFlowModule(
            Consumer<DeleteContactFlowModuleRequest.Builder> deleteContactFlowModuleRequest) {
        return deleteContactFlowModule(DeleteContactFlowModuleRequest.builder().applyMutation(deleteContactFlowModuleRequest)
                .build());
    }

    /**
     * <p>
     * Removes an alias reference, breaking the named connection to the underlying module version without affecting the
     * version itself.
     * </p>
     *
     * @param deleteContactFlowModuleAliasRequest
     * @return A Java Future containing the result of the DeleteContactFlowModuleAlias operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlowModuleAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModuleAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowModuleAliasResponse> deleteContactFlowModuleAlias(
            DeleteContactFlowModuleAliasRequest deleteContactFlowModuleAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an alias reference, breaking the named connection to the underlying module version without affecting the
     * version itself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowModuleAliasRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteContactFlowModuleAliasRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowModuleAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleAliasRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteContactFlowModuleAlias operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlowModuleAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModuleAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowModuleAliasResponse> deleteContactFlowModuleAlias(
            Consumer<DeleteContactFlowModuleAliasRequest.Builder> deleteContactFlowModuleAliasRequest) {
        return deleteContactFlowModuleAlias(DeleteContactFlowModuleAliasRequest.builder()
                .applyMutation(deleteContactFlowModuleAliasRequest).build());
    }

    /**
     * <p>
     * Removes a specific version of a contact flow module.
     * </p>
     *
     * @param deleteContactFlowModuleVersionRequest
     * @return A Java Future containing the result of the DeleteContactFlowModuleVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlowModuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowModuleVersionResponse> deleteContactFlowModuleVersion(
            DeleteContactFlowModuleVersionRequest deleteContactFlowModuleVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specific version of a contact flow module.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowModuleVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteContactFlowModuleVersionRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowModuleVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteContactFlowModuleVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlowModuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowModuleVersionResponse> deleteContactFlowModuleVersion(
            Consumer<DeleteContactFlowModuleVersionRequest.Builder> deleteContactFlowModuleVersionRequest) {
        return deleteContactFlowModuleVersion(DeleteContactFlowModuleVersionRequest.builder()
                .applyMutation(deleteContactFlowModuleVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the particular version specified in flow version identifier.
     * </p>
     *
     * @param deleteContactFlowVersionRequest
     * @return A Java Future containing the result of the DeleteContactFlowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowVersionResponse> deleteContactFlowVersion(
            DeleteContactFlowVersionRequest deleteContactFlowVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the particular version specified in flow version identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteContactFlowVersionRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactFlowVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteContactFlowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteContactFlowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactFlowVersionResponse> deleteContactFlowVersion(
            Consumer<DeleteContactFlowVersionRequest.Builder> deleteContactFlowVersionRequest) {
        return deleteContactFlowVersion(DeleteContactFlowVersionRequest.builder().applyMutation(deleteContactFlowVersionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a data table and all associated attributes, versions, audits, and values. Does not update any references
     * to the data table, even from other data tables. This includes dynamic values and conditional validations. System
     * managed data tables are not deletable by customers. API users may delete the table at any time. When deletion is
     * requested from the admin website, a warning is shown alerting the user of the most recent time the table and its
     * values were accessed.
     * </p>
     *
     * @param deleteDataTableRequest
     * @return A Java Future containing the result of the DeleteDataTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteDataTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteDataTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataTableResponse> deleteDataTable(DeleteDataTableRequest deleteDataTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data table and all associated attributes, versions, audits, and values. Does not update any references
     * to the data table, even from other data tables. This includes dynamic values and conditional validations. System
     * managed data tables are not deletable by customers. API users may delete the table at any time. When deletion is
     * requested from the admin website, a warning is shown alerting the user of the most recent time the table and its
     * values were accessed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataTableRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataTableRequest#builder()}
     * </p>
     *
     * @param deleteDataTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteDataTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDataTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteDataTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteDataTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataTableResponse> deleteDataTable(
            Consumer<DeleteDataTableRequest.Builder> deleteDataTableRequest) {
        return deleteDataTable(DeleteDataTableRequest.builder().applyMutation(deleteDataTableRequest).build());
    }

    /**
     * <p>
     * Deletes an attribute and all its values from a data table.
     * </p>
     *
     * @param deleteDataTableAttributeRequest
     * @return A Java Future containing the result of the DeleteDataTableAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteDataTableAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteDataTableAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataTableAttributeResponse> deleteDataTableAttribute(
            DeleteDataTableAttributeRequest deleteDataTableAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attribute and all its values from a data table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataTableAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDataTableAttributeRequest#builder()}
     * </p>
     *
     * @param deleteDataTableAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteDataTableAttributeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataTableAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ConflictException Operation cannot be performed at this time as there is a conflict with another
     *         operation or contact state.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteDataTableAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteDataTableAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataTableAttributeResponse> deleteDataTableAttribute(
            Consumer<DeleteDataTableAttributeRequest.Builder> deleteDataTableAttributeRequest) {
        return deleteDataTableAttribute(DeleteDataTableAttributeRequest.builder().applyMutation(deleteDataTableAttributeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes email address from the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteEmailAddressRequest
     * @return A Java Future containing the result of the DeleteEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEmailAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEmailAddressResponse> deleteEmailAddress(DeleteEmailAddressRequest deleteEmailAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes email address from the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailAddressRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailAddressRequest#builder()}
     * </p>
     *
     * @param deleteEmailAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteEmailAddressRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEmailAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEmailAddressResponse> deleteEmailAddress(
            Consumer<DeleteEmailAddressRequest.Builder> deleteEmailAddressRequest) {
        return deleteEmailAddress(DeleteEmailAddressRequest.builder().applyMutation(deleteEmailAddressRequest).build());
    }

    /**
     * <p>
     * Deletes an evaluation form in the specified Amazon Connect instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the version property is provided, only the specified version of the evaluation form is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * If no version is provided, then the full form (all versions) is deleted.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteEvaluationFormRequest
     * @return A Java Future containing the result of the DeleteEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEvaluationFormResponse> deleteEvaluationForm(
            DeleteEvaluationFormRequest deleteEvaluationFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an evaluation form in the specified Amazon Connect instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the version property is provided, only the specified version of the evaluation form is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * If no version is provided, then the full form (all versions) is deleted.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEvaluationFormRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEvaluationFormRequest#builder()}
     * </p>
     *
     * @param deleteEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEvaluationFormResponse> deleteEvaluationForm(
            Consumer<DeleteEvaluationFormRequest.Builder> deleteEvaluationFormRequest) {
        return deleteEvaluationForm(DeleteEvaluationFormRequest.builder().applyMutation(deleteEvaluationFormRequest).build());
    }

    /**
     * <p>
     * Deletes an hours of operation.
     * </p>
     *
     * @param deleteHoursOfOperationRequest
     * @return A Java Future containing the result of the DeleteHoursOfOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHoursOfOperationResponse> deleteHoursOfOperation(
            DeleteHoursOfOperationRequest deleteHoursOfOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHoursOfOperationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param deleteHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteHoursOfOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHoursOfOperationResponse> deleteHoursOfOperation(
            Consumer<DeleteHoursOfOperationRequest.Builder> deleteHoursOfOperationRequest) {
        return deleteHoursOfOperation(DeleteHoursOfOperationRequest.builder().applyMutation(deleteHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an hours of operation override in an Amazon Connect hours of operation resource.
     * </p>
     *
     * @param deleteHoursOfOperationOverrideRequest
     * @return A Java Future containing the result of the DeleteHoursOfOperationOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteHoursOfOperationOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperationOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHoursOfOperationOverrideResponse> deleteHoursOfOperationOverride(
            DeleteHoursOfOperationOverrideRequest deleteHoursOfOperationOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an hours of operation override in an Amazon Connect hours of operation resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHoursOfOperationOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteHoursOfOperationOverrideRequest#builder()}
     * </p>
     *
     * @param deleteHoursOfOperationOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationOverrideRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteHoursOfOperationOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteHoursOfOperationOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperationOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHoursOfOperationOverrideResponse> deleteHoursOfOperationOverride(
            Consumer<DeleteHoursOfOperationOverrideRequest.Builder> deleteHoursOfOperationOverrideRequest) {
        return deleteHoursOfOperationOverride(DeleteHoursOfOperationOverrideRequest.builder()
                .applyMutation(deleteHoursOfOperationOverrideRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the Amazon Connect instance. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-connect-instance.html">Delete your Amazon
     * Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the Amazon Connect instance. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-connect-instance.html">Delete your Amazon
     * Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInstanceRequest#builder()}
     * </p>
     *
     * @param deleteInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceResponse> deleteInstance(Consumer<DeleteInstanceRequest.Builder> deleteInstanceRequest) {
        return deleteInstance(DeleteInstanceRequest.builder().applyMutation(deleteInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not
     * have any use cases associated with it.
     * </p>
     *
     * @param deleteIntegrationAssociationRequest
     * @return A Java Future containing the result of the DeleteIntegrationAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIntegrationAssociationResponse> deleteIntegrationAssociation(
            DeleteIntegrationAssociationRequest deleteIntegrationAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not
     * have any use cases associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteIntegrationAssociationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteIntegrationAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIntegrationAssociationResponse> deleteIntegrationAssociation(
            Consumer<DeleteIntegrationAssociationRequest.Builder> deleteIntegrationAssociationRequest) {
        return deleteIntegrationAssociation(DeleteIntegrationAssociationRequest.builder()
                .applyMutation(deleteIntegrationAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a predefined attribute from the specified Amazon Connect instance.
     * </p>
     *
     * @param deletePredefinedAttributeRequest
     * @return A Java Future containing the result of the DeletePredefinedAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeletePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePredefinedAttributeResponse> deletePredefinedAttribute(
            DeletePredefinedAttributeRequest deletePredefinedAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a predefined attribute from the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePredefinedAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePredefinedAttributeRequest#builder()}
     * </p>
     *
     * @param deletePredefinedAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeletePredefinedAttributeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePredefinedAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeletePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePredefinedAttributeResponse> deletePredefinedAttribute(
            Consumer<DeletePredefinedAttributeRequest.Builder> deletePredefinedAttributeRequest) {
        return deletePredefinedAttribute(DeletePredefinedAttributeRequest.builder()
                .applyMutation(deletePredefinedAttributeRequest).build());
    }

    /**
     * <p>
     * Deletes a prompt.
     * </p>
     *
     * @param deletePromptRequest
     * @return A Java Future containing the result of the DeletePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeletePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePromptResponse> deletePrompt(DeletePromptRequest deletePromptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePromptRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePromptRequest#builder()}
     * </p>
     *
     * @param deletePromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeletePromptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeletePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePromptResponse> deletePrompt(Consumer<DeletePromptRequest.Builder> deletePromptRequest) {
        return deletePrompt(DeletePromptRequest.builder().applyMutation(deletePromptRequest).build());
    }

    /**
     * <p>
     * Deletes registration for a device token and a chat contact.
     * </p>
     *
     * @param deletePushNotificationRegistrationRequest
     * @return A Java Future containing the result of the DeletePushNotificationRegistration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeletePushNotificationRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePushNotificationRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePushNotificationRegistrationResponse> deletePushNotificationRegistration(
            DeletePushNotificationRegistrationRequest deletePushNotificationRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes registration for a device token and a chat contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePushNotificationRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePushNotificationRegistrationRequest#builder()}
     * </p>
     *
     * @param deletePushNotificationRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeletePushNotificationRegistrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeletePushNotificationRegistration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeletePushNotificationRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePushNotificationRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePushNotificationRegistrationResponse> deletePushNotificationRegistration(
            Consumer<DeletePushNotificationRegistrationRequest.Builder> deletePushNotificationRegistrationRequest) {
        return deletePushNotificationRegistration(DeletePushNotificationRegistrationRequest.builder()
                .applyMutation(deletePushNotificationRegistrationRequest).build());
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     *
     * @param deleteQueueRequest
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQueueResponse> deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQueueRequest#builder()}
     * </p>
     *
     * @param deleteQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQueueResponse> deleteQueue(Consumer<DeleteQueueRequest.Builder> deleteQueueRequest) {
        return deleteQueue(DeleteQueueRequest.builder().applyMutation(deleteQueueRequest).build());
    }

    /**
     * <p>
     * Deletes a quick connect.
     * </p>
     * <important>
     * <p>
     * After calling <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html">DeleteUser</a>, it's important
     * to call <code>DeleteQuickConnect</code> to delete any records related to the deleted users. This will help you:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Avoid dangling resources that impact your service quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove deleted users so they don't appear to agents as transfer options.
     * </p>
     * </li>
     * <li>
     * <p>
     * Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using
     * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon
     * Connect Global Resiliency</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param deleteQuickConnectRequest
     * @return A Java Future containing the result of the DeleteQuickConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteQuickConnectResponse> deleteQuickConnect(DeleteQuickConnectRequest deleteQuickConnectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a quick connect.
     * </p>
     * <important>
     * <p>
     * After calling <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html">DeleteUser</a>, it's important
     * to call <code>DeleteQuickConnect</code> to delete any records related to the deleted users. This will help you:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Avoid dangling resources that impact your service quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove deleted users so they don't appear to agents as transfer options.
     * </p>
     * </li>
     * <li>
     * <p>
     * Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using
     * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon
     * Connect Global Resiliency</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQuickConnectRequest#builder()}
     * </p>
     *
     * @param deleteQuickConnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteQuickConnectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteQuickConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteQuickConnectResponse> deleteQuickConnect(
            Consumer<DeleteQuickConnectRequest.Builder> deleteQuickConnectRequest) {
        return deleteQuickConnect(DeleteQuickConnectRequest.builder().applyMutation(deleteQuickConnectRequest).build());
    }

    /**
     * <p>
     * Deletes a routing profile.
     * </p>
     *
     * @param deleteRoutingProfileRequest
     * @return A Java Future containing the result of the DeleteRoutingProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRoutingProfileResponse> deleteRoutingProfile(
            DeleteRoutingProfileRequest deleteRoutingProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoutingProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRoutingProfileRequest#builder()}
     * </p>
     *
     * @param deleteRoutingProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRoutingProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRoutingProfileResponse> deleteRoutingProfile(
            Consumer<DeleteRoutingProfileRequest.Builder> deleteRoutingProfileRequest) {
        return deleteRoutingProfile(DeleteRoutingProfileRequest.builder().applyMutation(deleteRoutingProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a rule for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a rule for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a security profile.
     * </p>
     *
     * @param deleteSecurityProfileRequest
     * @return A Java Future containing the result of the DeleteSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityProfileResponse> deleteSecurityProfile(
            DeleteSecurityProfileRequest deleteSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityProfileRequest#builder()}
     * </p>
     *
     * @param deleteSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityProfileResponse> deleteSecurityProfile(
            Consumer<DeleteSecurityProfileRequest.Builder> deleteSecurityProfileRequest) {
        return deleteSecurityProfile(DeleteSecurityProfileRequest.builder().applyMutation(deleteSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the task template.
     * </p>
     *
     * @param deleteTaskTemplateRequest
     * @return A Java Future containing the result of the DeleteTaskTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTaskTemplateResponse> deleteTaskTemplate(DeleteTaskTemplateRequest deleteTaskTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the task template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTaskTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTaskTemplateRequest#builder()}
     * </p>
     *
     * @param deleteTaskTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTaskTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTaskTemplateResponse> deleteTaskTemplate(
            Consumer<DeleteTaskTemplateRequest.Builder> deleteTaskTemplateRequest) {
        return deleteTaskTemplate(DeleteTaskTemplateRequest.builder().applyMutation(deleteTaskTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution
     * group is created.
     * </p>
     * <p>
     * For more information about deleting traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html">Delete
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param deleteTrafficDistributionGroupRequest
     * @return A Java Future containing the result of the DeleteTrafficDistributionGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficDistributionGroupResponse> deleteTrafficDistributionGroup(
            DeleteTrafficDistributionGroupRequest deleteTrafficDistributionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution
     * group is created.
     * </p>
     * <p>
     * For more information about deleting traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html">Delete
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficDistributionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTrafficDistributionGroupRequest#builder()}
     * </p>
     *
     * @param deleteTrafficDistributionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTrafficDistributionGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficDistributionGroupResponse> deleteTrafficDistributionGroup(
            Consumer<DeleteTrafficDistributionGroupRequest.Builder> deleteTrafficDistributionGroupRequest) {
        return deleteTrafficDistributionGroup(DeleteTrafficDistributionGroupRequest.builder()
                .applyMutation(deleteTrafficDistributionGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a use case from an integration association.
     * </p>
     *
     * @param deleteUseCaseRequest
     * @return A Java Future containing the result of the DeleteUseCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUseCaseResponse> deleteUseCase(DeleteUseCaseRequest deleteUseCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a use case from an integration association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUseCaseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUseCaseRequest#builder()}
     * </p>
     *
     * @param deleteUseCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUseCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUseCaseResponse> deleteUseCase(Consumer<DeleteUseCaseRequest.Builder> deleteUseCaseRequest) {
        return deleteUseCase(DeleteUseCaseRequest.builder().applyMutation(deleteUseCaseRequest).build());
    }

    /**
     * <p>
     * Deletes a user account from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For information about what happens to a user's data when their account is deleted, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon
     * Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * After calling DeleteUser, call <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html">DeleteQuickConnect</a>
     * to delete any records related to the deleted users. This will help you:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Avoid dangling resources that impact your service quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove deleted users so they don't appear to agents as transfer options.
     * </p>
     * </li>
     * <li>
     * <p>
     * Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using
     * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon
     * Connect Global Resiliency</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user account from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For information about what happens to a user's data when their account is deleted, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon
     * Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * After calling DeleteUser, call <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html">DeleteQuickConnect</a>
     * to delete any records related to the deleted users. This will help you:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Avoid dangling resources that impact your service quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove deleted users so they don't appear to agents as transfer options.
     * </p>
     * </li>
     * <li>
     * <p>
     * Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using
     * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon
     * Connect Global Resiliency</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child
     * groups.
     * </p>
     *
     * @param deleteUserHierarchyGroupRequest
     * @return A Java Future containing the result of the DeleteUserHierarchyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserHierarchyGroupResponse> deleteUserHierarchyGroup(
            DeleteUserHierarchyGroupRequest deleteUserHierarchyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child
     * groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param deleteUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUserHierarchyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserHierarchyGroupResponse> deleteUserHierarchyGroup(
            Consumer<DeleteUserHierarchyGroupRequest.Builder> deleteUserHierarchyGroupRequest) {
        return deleteUserHierarchyGroup(DeleteUserHierarchyGroupRequest.builder().applyMutation(deleteUserHierarchyGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).
     * </p>
     *
     * @param deleteViewRequest
     * @return A Java Future containing the result of the DeleteView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteViewResponse> deleteView(DeleteViewRequest deleteViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteViewRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteViewRequest#builder()}
     * </p>
     *
     * @param deleteViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteViewRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteViewResponse> deleteView(Consumer<DeleteViewRequest.Builder> deleteViewRequest) {
        return deleteView(DeleteViewRequest.builder().applyMutation(deleteViewRequest).build());
    }

    /**
     * <p>
     * Deletes the particular version specified in <code>ViewVersion</code> identifier.
     * </p>
     *
     * @param deleteViewVersionRequest
     * @return A Java Future containing the result of the DeleteViewVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteViewVersionResponse> deleteViewVersion(DeleteViewVersionRequest deleteViewVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the particular version specified in <code>ViewVersion</code> identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteViewVersionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteViewVersionRequest#builder()}
     * </p>
     *
     * @param deleteViewVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteViewVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteViewVersionResponse> deleteViewVersion(
            Consumer<DeleteViewVersionRequest.Builder> deleteViewVersionRequest) {
        return deleteViewVersion(DeleteViewVersionRequest.builder().applyMutation(deleteViewVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the vocabulary that has the given identifier.
     * </p>
     *
     * @param deleteVocabularyRequest
     * @return A Java Future containing the result of the DeleteVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyResponse> deleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the vocabulary that has the given identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceInUseException That resource is already in use (for example, you're trying to add a record
     *         with the same name as an existing record). If you are trying to delete a resource (for example,
     *         DeleteHoursOfOperation or DeletePredefinedAttribute), remove its reference from related resources and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyResponse> deleteVocabulary(
            Consumer<DeleteVocabularyRequest.Builder> deleteVocabularyRequest) {
        return deleteVocabulary(DeleteVocabularyRequest.builder().applyMutation(deleteVocabularyRequest).build());
    }

    /**
     * <p>
     * Deletes a workspace and removes all associated view and resource assignments.
     * </p>
     *
     * @param deleteWorkspaceRequest
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workspace and removes all associated view and resource assignments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkspaceRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteWorkspaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(
            Consumer<DeleteWorkspaceRequest.Builder> deleteWorkspaceRequest) {
        return deleteWorkspace(DeleteWorkspaceRequest.builder().applyMutation(deleteWorkspaceRequest).build());
    }

    /**
     * <p>
     * Deletes a media asset (such as a logo) from a workspace.
     * </p>
     *
     * @param deleteWorkspaceMediaRequest
     * @return A Java Future containing the result of the DeleteWorkspaceMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteWorkspaceMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteWorkspaceMedia" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceMediaResponse> deleteWorkspaceMedia(
            DeleteWorkspaceMediaRequest deleteWorkspaceMediaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a media asset (such as a logo) from a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceMediaRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkspaceMediaRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteWorkspaceMediaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkspaceMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteWorkspaceMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteWorkspaceMedia" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceMediaResponse> deleteWorkspaceMedia(
            Consumer<DeleteWorkspaceMediaRequest.Builder> deleteWorkspaceMediaRequest) {
        return deleteWorkspaceMedia(DeleteWorkspaceMediaRequest.builder().applyMutation(deleteWorkspaceMediaRequest).build());
    }

    /**
     * <p>
     * Removes the association between a view and a page in a workspace. The page will display the default view after
     * deletion.
     * </p>
     *
     * @param deleteWorkspacePageRequest
     * @return A Java Future containing the result of the DeleteWorkspacePage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteWorkspacePage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteWorkspacePage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspacePageResponse> deleteWorkspacePage(
            DeleteWorkspacePageRequest deleteWorkspacePageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between a view and a page in a workspace. The page will display the default view after
     * deletion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspacePageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkspacePageRequest#builder()}
     * </p>
     *
     * @param deleteWorkspacePageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteWorkspacePageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkspacePage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DeleteWorkspacePage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteWorkspacePage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspacePageResponse> deleteWorkspacePage(
            Consumer<DeleteWorkspacePageRequest.Builder> deleteWorkspacePageRequest) {
        return deleteWorkspacePage(DeleteWorkspacePageRequest.builder().applyMutation(deleteWorkspacePageRequest).build());
    }

    /**
     * <p>
     * Describes an agent status.
     * </p>
     *
     * @param describeAgentStatusRequest
     * @return A Java Future containing the result of the DescribeAgentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAgentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAgentStatusResponse> describeAgentStatus(
            DescribeAgentStatusRequest describeAgentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an agent status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAgentStatusRequest#builder()}
     * </p>
     *
     * @param describeAgentStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAgentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAgentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAgentStatusResponse> describeAgentStatus(
            Consumer<DescribeAgentStatusRequest.Builder> describeAgentStatusRequest) {
        return describeAgentStatus(DescribeAgentStatusRequest.builder().applyMutation(describeAgentStatusRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change. To request access to this API,
     * contact Amazon Web Services Support.
     * </p>
     * <p>
     * Describes the target authentication profile.
     * </p>
     *
     * @param describeAuthenticationProfileRequest
     * @return A Java Future containing the result of the DescribeAuthenticationProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAuthenticationProfileResponse> describeAuthenticationProfile(
            DescribeAuthenticationProfileRequest describeAuthenticationProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change. To request access to this API,
     * contact Amazon Web Services Support.
     * </p>
     * <p>
     * Describes the target authentication profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuthenticationProfileRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAuthenticationProfileRequest#builder()}
     * </p>
     *
     * @param describeAuthenticationProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeAuthenticationProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAuthenticationProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAuthenticationProfileResponse> describeAuthenticationProfile(
            Consumer<DescribeAuthenticationProfileRequest.Builder> describeAuthenticationProfileRequest) {
        return describeAuthenticationProfile(DescribeAuthenticationProfileRequest.builder()
                .applyMutation(describeAuthenticationProfileRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified contact.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Retrieve contact information such as the caller's phone number and the specific number the caller dialed to
     * integrate into custom monitoring or custom agent experience solutions.
     * </p>
     * </li>
     * <li>
     * <p>
     * Detect when a customer chat session disconnects due to a network issue on the agent's end. Use the
     * DisconnectReason field in the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/ctr-data-model.html#ctr-ContactTraceRecord"
     * >ContactTraceRecord</a> to detect this event and then re-queue the chat for followup.
     * </p>
     * </li>
     * <li>
     * <p>
     * Identify after contact work (ACW) duration and call recordings information when a COMPLETED event is received by
     * using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-events.html">contact event
     * stream</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SystemEndpoint</code> is not populated for contacts with initiation method of MONITOR, QUEUE_TRANSFER, or
     * CALLBACK
     * </p>
     * </li>
     * <li>
     * <p>
     * Contact information remains available in Amazon Connect for 24 months from the <code>InitiationTimestamp</code>,
     * and then it is deleted. Only contact information that is available in Amazon Connect is returned by this API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     *
     * @param describeContactRequest
     * @return A Java Future containing the result of the DescribeContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeContactResponse> describeContact(DescribeContactRequest describeContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified contact.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Retrieve contact information such as the caller's phone number and the specific number the caller dialed to
     * integrate into custom monitoring or custom agent experience solutions.
     * </p>
     * </li>
     * <li>
     * <p>
     * Detect when a customer chat session disconnects due to a network issue on the agent's end. Use the
     * DisconnectReason field in the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/ctr-data-model.html#ctr-ContactTraceRecord"
     * >ContactTraceRecord</a> to detect this event and then re-queue the chat for followup.
     * </p>
     * </li>
     * <li>
     * <p>
     * Identify after contact work (ACW) duration and call recordings information when a COMPLETED event is received by
     * using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-events.html">contact event
     * stream</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SystemEndpoint</code> is not populated for contacts with initiation method of MONITOR, QUEUE_TRANSFER, or
     * CALLBACK
     * </p>
     * </li>
     * <li>
     * <p>
     * Contact information remains available in Amazon Connect for 24 months from the <code>InitiationTimestamp</code>,
     * and then it is deleted. Only contact information that is available in Amazon Connect is returned by this API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeContactRequest#builder()}
     * </p>
     *
     * @param describeContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeContactResponse> describeContact(
            Consumer<DescribeContactRequest.Builder> describeContactRequest) {
        return describeContact(DescribeContactRequest.builder().applyMutation(describeContactRequest).build());
    }

    /**
     * <p>
     * Describes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     *
     * @param describeContactEvaluationRequest
     * @return A Java Future containing the result of the DescribeContactEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContactEvaluationResponse> describeContactEvaluation(
            DescribeContactEvaluationRequest describeContactEvaluationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactEvaluationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContactEvaluationRequest#builder()}
     * </p>
     *
     * @param describeContactEvaluationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeContactEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContactEvaluationResponse> describeContactEvaluation(
            Consumer<DescribeContactEvaluationRequest.Builder> describeContactEvaluationRequest) {
        return describeContactEvaluation(DescribeContactEvaluationRequest.builder()
                .applyMutation(describeContactEvaluationRequest).build());
    }

    /**
     * <p>
     * Describes the specified flow.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     * <p>
     * Use the <code>&#36SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For
     * example, <code>arn:aws:.../contact-flow/{id}:&#36SAVED</code>. After a flow is published, <code>&#36SAVED</code>
     * needs to be supplied to view saved content that has not been published.
     * </p>
     * <p>
     * Use <code>arn:aws:.../contact-flow/{id}:{version}</code> to retrieve the content of a specific flow version.
     * </p>
     * <p>
     * In the response, <b>Status</b> indicates the flow status as either <code>SAVED</code> or <code>PUBLISHED</code>.
     * The <code>PUBLISHED</code> status will initiate validation on the content. <code>SAVED</code> does not initiate
     * validation of the content. <code>SAVED</code> | <code>PUBLISHED</code>
     * </p>
     *
     * @param describeContactFlowRequest
     * @return A Java Future containing the result of the DescribeContactFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ContactFlowNotPublishedException The flow has not been published.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeContactFlowResponse> describeContactFlow(
            DescribeContactFlowRequest describeContactFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified flow.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     * <p>
     * Use the <code>&#36SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For
     * example, <code>arn:aws:.../contact-flow/{id}:&#36SAVED</code>. After a flow is published, <code>&#36SAVED</code>
     * needs to be supplied to view saved content that has not been published.
     * </p>
     * <p>
     * Use <code>arn:aws:.../contact-flow/{id}:{version}</code> to retrieve the content of a specific flow version.
     * </p>
     * <p>
     * In the response, <b>Status</b> indicates the flow status as either <code>SAVED</code> or <code>PUBLISHED</code>.
     * The <code>PUBLISHED</code> status will initiate validation on the content. <code>SAVED</code> does not initiate
     * validation of the content. <code>SAVED</code> | <code>PUBLISHED</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactFlowRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeContactFlowRequest#builder()}
     * </p>
     *
     * @param describeContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeContactFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ContactFlowNotPublishedException The flow has not been published.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeContactFlowResponse> describeContactFlow(
            Consumer<DescribeContactFlowRequest.Builder> describeContactFlowRequest) {
        return describeContactFlow(DescribeContactFlowRequest.builder().applyMutation(describeContactFlowRequest).build());
    }

    /**
     * <p>
     * Describes the specified flow module.
     * </p>
     * <p>
     * Use the <code>&#36SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For
     * example, <code>arn:aws:.../contact-flow/{id}:&#36SAVED</code>. After a flow is published, <code>&#36SAVED</code>
     * needs to be supplied to view saved content that has not been published.
     * </p>
     *
     * @param describeContactFlowModuleRequest
     * @return A Java Future containing the result of the DescribeContactFlowModule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContactFlowModuleResponse> describeContactFlowModule(
            DescribeContactFlowModuleRequest describeContactFlowModuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified flow module.
     * </p>
     * <p>
     * Use the <code>&#36SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For
     * example, <code>arn:aws:.../contact-flow/{id}:&#36SAVED</code>. After a flow is published, <code>&#36SAVED</code>
     * needs to be supplied to view saved content that has not been published.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param describeContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeContactFlowModule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContactFlowModuleResponse> describeContactFlowModule(
            Consumer<DescribeContactFlowModuleRequest.Builder> describeContactFlowModuleRequest) {
        return describeContactFlowModule(DescribeContactFlowModuleRequest.builder()
                .applyMutation(describeContactFlowModuleRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific alias, including which version it currently points to and its
     * metadata.
     * </p>
     *
     * @param describeContactFlowModuleAliasRequest
     * @return A Java Future containing the result of the DescribeContactFlowModuleAlias operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContactFlowModuleAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModuleAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContactFlowModuleAliasResponse> describeContactFlowModuleAlias(
            DescribeContactFlowModuleAliasRequest describeContactFlowModuleAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific alias, including which version it currently points to and its
     * metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactFlowModuleAliasRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeContactFlowModuleAliasRequest#builder()}
     * </p>
     *
     * @param describeContactFlowModuleAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleAliasRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeContactFlowModuleAlias operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeContactFlowModuleAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModuleAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContactFlowModuleAliasResponse> describeContactFlowModuleAlias(
            Consumer<DescribeContactFlowModuleAliasRequest.Builder> describeContactFlowModuleAliasRequest) {
        return describeContactFlowModuleAlias(DescribeContactFlowModuleAliasRequest.builder()
                .applyMutation(describeContactFlowModuleAliasRequest).build());
    }

    /**
     * <p>
     * Returns all properties for a data table except for attributes and values. All properties from CreateDataTable are
     * returned as well as properties for region replication, versioning, and system tables. "Describe" is a deprecated
     * term but is allowed to maintain consistency with existing operations.
     * </p>
     *
     * @param describeDataTableRequest
     * @return A Java Future containing the result of the DescribeDataTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeDataTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeDataTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDataTableResponse> describeDataTable(DescribeDataTableRequest describeDataTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all properties for a data table except for attributes and values. All properties from CreateDataTable are
     * returned as well as properties for region replication, versioning, and system tables. "Describe" is a deprecated
     * term but is allowed to maintain consistency with existing operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataTableRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDataTableRequest#builder()}
     * </p>
     *
     * @param describeDataTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeDataTableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDataTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeDataTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeDataTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDataTableResponse> describeDataTable(
            Consumer<DescribeDataTableRequest.Builder> describeDataTableRequest) {
        return describeDataTable(DescribeDataTableRequest.builder().applyMutation(describeDataTableRequest).build());
    }

    /**
     * <p>
     * Returns detailed information for a specific data table attribute including its configuration, validation rules,
     * and metadata. "Describe" is a deprecated term but is allowed to maintain consistency with existing operations.
     * </p>
     *
     * @param describeDataTableAttributeRequest
     * @return A Java Future containing the result of the DescribeDataTableAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeDataTableAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeDataTableAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataTableAttributeResponse> describeDataTableAttribute(
            DescribeDataTableAttributeRequest describeDataTableAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information for a specific data table attribute including its configuration, validation rules,
     * and metadata. "Describe" is a deprecated term but is allowed to maintain consistency with existing operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataTableAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDataTableAttributeRequest#builder()}
     * </p>
     *
     * @param describeDataTableAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeDataTableAttributeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDataTableAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeDataTableAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeDataTableAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataTableAttributeResponse> describeDataTableAttribute(
            Consumer<DescribeDataTableAttributeRequest.Builder> describeDataTableAttributeRequest) {
        return describeDataTableAttribute(DescribeDataTableAttributeRequest.builder()
                .applyMutation(describeDataTableAttributeRequest).build());
    }

    /**
     * <p>
     * Describe email address form the specified Amazon Connect instance.
     * </p>
     *
     * @param describeEmailAddressRequest
     * @return A Java Future containing the result of the DescribeEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeEmailAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEmailAddressResponse> describeEmailAddress(
            DescribeEmailAddressRequest describeEmailAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe email address form the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEmailAddressRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEmailAddressRequest#builder()}
     * </p>
     *
     * @param describeEmailAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeEmailAddressRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeEmailAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEmailAddressResponse> describeEmailAddress(
            Consumer<DescribeEmailAddressRequest.Builder> describeEmailAddressRequest) {
        return describeEmailAddress(DescribeEmailAddressRequest.builder().applyMutation(describeEmailAddressRequest).build());
    }

    /**
     * <p>
     * Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided,
     * the latest version of the evaluation form is described.
     * </p>
     *
     * @param describeEvaluationFormRequest
     * @return A Java Future containing the result of the DescribeEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEvaluationFormResponse> describeEvaluationForm(
            DescribeEvaluationFormRequest describeEvaluationFormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided,
     * the latest version of the evaluation form is described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEvaluationFormRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEvaluationFormRequest#builder()}
     * </p>
     *
     * @param describeEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeEvaluationFormRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEvaluationForm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEvaluationFormResponse> describeEvaluationForm(
            Consumer<DescribeEvaluationFormRequest.Builder> describeEvaluationFormRequest) {
        return describeEvaluationForm(DescribeEvaluationFormRequest.builder().applyMutation(describeEvaluationFormRequest)
                .build());
    }

    /**
     * <p>
     * Describes the hours of operation.
     * </p>
     *
     * @param describeHoursOfOperationRequest
     * @return A Java Future containing the result of the DescribeHoursOfOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHoursOfOperationResponse> describeHoursOfOperation(
            DescribeHoursOfOperationRequest describeHoursOfOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHoursOfOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param describeHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeHoursOfOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHoursOfOperationResponse> describeHoursOfOperation(
            Consumer<DescribeHoursOfOperationRequest.Builder> describeHoursOfOperationRequest) {
        return describeHoursOfOperation(DescribeHoursOfOperationRequest.builder().applyMutation(describeHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * Describes the hours of operation override.
     * </p>
     *
     * @param describeHoursOfOperationOverrideRequest
     * @return A Java Future containing the result of the DescribeHoursOfOperationOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeHoursOfOperationOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperationOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHoursOfOperationOverrideResponse> describeHoursOfOperationOverride(
            DescribeHoursOfOperationOverrideRequest describeHoursOfOperationOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the hours of operation override.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHoursOfOperationOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeHoursOfOperationOverrideRequest#builder()}
     * </p>
     *
     * @param describeHoursOfOperationOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationOverrideRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeHoursOfOperationOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeHoursOfOperationOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperationOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHoursOfOperationOverrideResponse> describeHoursOfOperationOverride(
            Consumer<DescribeHoursOfOperationOverrideRequest.Builder> describeHoursOfOperationOverrideRequest) {
        return describeHoursOfOperationOverride(DescribeHoursOfOperationOverrideRequest.builder()
                .applyMutation(describeHoursOfOperationOverrideRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created
     * and returns an error status, if applicable.
     * </p>
     * <p>
     * If an instance is not created successfully, the instance status reason field returns details relevant to the
     * reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     * </p>
     *
     * @param describeInstanceRequest
     * @return A Java Future containing the result of the DescribeInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInstanceResponse> describeInstance(DescribeInstanceRequest describeInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created
     * and returns an error status, if applicable.
     * </p>
     * <p>
     * If an instance is not created successfully, the instance status reason field returns details relevant to the
     * reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInstanceRequest#builder()}
     * </p>
     *
     * @param describeInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInstanceResponse> describeInstance(
            Consumer<DescribeInstanceRequest.Builder> describeInstanceRequest) {
        return describeInstance(DescribeInstanceRequest.builder().applyMutation(describeInstanceRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified instance attribute.
     * </p>
     *
     * @param describeInstanceAttributeRequest
     * @return A Java Future containing the result of the DescribeInstanceAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeInstanceAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAttributeResponse> describeInstanceAttribute(
            DescribeInstanceAttributeRequest describeInstanceAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified instance attribute.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceAttributeRequest#builder()}
     * </p>
     *
     * @param describeInstanceAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeInstanceAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeInstanceAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAttributeResponse> describeInstanceAttribute(
            Consumer<DescribeInstanceAttributeRequest.Builder> describeInstanceAttributeRequest) {
        return describeInstanceAttribute(DescribeInstanceAttributeRequest.builder()
                .applyMutation(describeInstanceAttributeRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     * </p>
     *
     * @param describeInstanceStorageConfigRequest
     * @return A Java Future containing the result of the DescribeInstanceStorageConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceStorageConfigResponse> describeInstanceStorageConfig(
            DescribeInstanceStorageConfigRequest describeInstanceStorageConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param describeInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeInstanceStorageConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceStorageConfigResponse> describeInstanceStorageConfig(
            Consumer<DescribeInstanceStorageConfigRequest.Builder> describeInstanceStorageConfigRequest) {
        return describeInstanceStorageConfig(DescribeInstanceStorageConfigRequest.builder()
                .applyMutation(describeInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution
     * group.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region
     * where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the
     * <code>PhoneNumberId</code> URI request parameter. However, if the number is claimed to a traffic distribution
     * group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic
     * distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you receive
     * a <code>ResourceNotFoundException</code>.
     * </p>
     * </important>
     *
     * @param describePhoneNumberRequest
     * @return A Java Future containing the result of the DescribePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePhoneNumberResponse> describePhoneNumber(
            DescribePhoneNumberRequest describePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution
     * group.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region
     * where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the
     * <code>PhoneNumberId</code> URI request parameter. However, if the number is claimed to a traffic distribution
     * group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic
     * distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you receive
     * a <code>ResourceNotFoundException</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePhoneNumberRequest#builder()}
     * </p>
     *
     * @param describePhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePhoneNumberResponse> describePhoneNumber(
            Consumer<DescribePhoneNumberRequest.Builder> describePhoneNumberRequest) {
        return describePhoneNumber(DescribePhoneNumberRequest.builder().applyMutation(describePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Describes a predefined attribute for the specified Amazon Connect instance. A <i>predefined attribute</i> is made
     * up of a name and a value. You can use predefined attributes for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Routing proficiency (for example, agent certification) that has predefined values (for example, a list of
     * possible certifications). For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined
     * attributes for routing contacts to agents</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Contact information that varies between transfers or conferences, such as the name of the business unit handling
     * the contact. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-contact-segment-attributes.html">Use contact
     * segment attributes</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the predefined attributes per instance quota, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas"
     * >Amazon Connect quotas</a>.
     * </p>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     *
     * @param describePredefinedAttributeRequest
     * @return A Java Future containing the result of the DescribePredefinedAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePredefinedAttributeResponse> describePredefinedAttribute(
            DescribePredefinedAttributeRequest describePredefinedAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a predefined attribute for the specified Amazon Connect instance. A <i>predefined attribute</i> is made
     * up of a name and a value. You can use predefined attributes for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Routing proficiency (for example, agent certification) that has predefined values (for example, a list of
     * possible certifications). For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined
     * attributes for routing contacts to agents</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Contact information that varies between transfers or conferences, such as the name of the business unit handling
     * the contact. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-contact-segment-attributes.html">Use contact
     * segment attributes</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the predefined attributes per instance quota, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas"
     * >Amazon Connect quotas</a>.
     * </p>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePredefinedAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePredefinedAttributeRequest#builder()}
     * </p>
     *
     * @param describePredefinedAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribePredefinedAttributeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribePredefinedAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePredefinedAttributeResponse> describePredefinedAttribute(
            Consumer<DescribePredefinedAttributeRequest.Builder> describePredefinedAttributeRequest) {
        return describePredefinedAttribute(DescribePredefinedAttributeRequest.builder()
                .applyMutation(describePredefinedAttributeRequest).build());
    }

    /**
     * <p>
     * Describes the prompt.
     * </p>
     *
     * @param describePromptRequest
     * @return A Java Future containing the result of the DescribePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePromptResponse> describePrompt(DescribePromptRequest describePromptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePromptRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePromptRequest#builder()}
     * </p>
     *
     * @param describePromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribePromptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePromptResponse> describePrompt(Consumer<DescribePromptRequest.Builder> describePromptRequest) {
        return describePrompt(DescribePromptRequest.builder().applyMutation(describePromptRequest).build());
    }

    /**
     * <p>
     * Describes the specified queue.
     * </p>
     *
     * @param describeQueueRequest
     * @return A Java Future containing the result of the DescribeQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueueResponse> describeQueue(DescribeQueueRequest describeQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeQueueRequest#builder()}
     * </p>
     *
     * @param describeQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueueResponse> describeQueue(Consumer<DescribeQueueRequest.Builder> describeQueueRequest) {
        return describeQueue(DescribeQueueRequest.builder().applyMutation(describeQueueRequest).build());
    }

    /**
     * <p>
     * Describes the quick connect.
     * </p>
     *
     * @param describeQuickConnectRequest
     * @return A Java Future containing the result of the DescribeQuickConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeQuickConnectResponse> describeQuickConnect(
            DescribeQuickConnectRequest describeQuickConnectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the quick connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeQuickConnectRequest#builder()}
     * </p>
     *
     * @param describeQuickConnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeQuickConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeQuickConnectResponse> describeQuickConnect(
            Consumer<DescribeQuickConnectRequest.Builder> describeQuickConnectRequest) {
        return describeQuickConnect(DescribeQuickConnectRequest.builder().applyMutation(describeQuickConnectRequest).build());
    }

    /**
     * <p>
     * Describes the specified routing profile.
     * </p>
     * <note>
     * <p>
     * <code>DescribeRoutingProfile</code> does not populate AssociatedQueueIds in its response. The example Response
     * Syntax shown on this page is incorrect; we are working to update it. <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html"
     * >SearchRoutingProfiles</a> does include AssociatedQueueIds.
     * </p>
     * </note>
     *
     * @param describeRoutingProfileRequest
     * @return A Java Future containing the result of the DescribeRoutingProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRoutingProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRoutingProfileResponse> describeRoutingProfile(
            DescribeRoutingProfileRequest describeRoutingProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified routing profile.
     * </p>
     * <note>
     * <p>
     * <code>DescribeRoutingProfile</code> does not populate AssociatedQueueIds in its response. The example Response
     * Syntax shown on this page is incorrect; we are working to update it. <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html"
     * >SearchRoutingProfiles</a> does include AssociatedQueueIds.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRoutingProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRoutingProfileRequest#builder()}
     * </p>
     *
     * @param describeRoutingProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeRoutingProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRoutingProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRoutingProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRoutingProfileResponse> describeRoutingProfile(
            Consumer<DescribeRoutingProfileRequest.Builder> describeRoutingProfileRequest) {
        return describeRoutingProfile(DescribeRoutingProfileRequest.builder().applyMutation(describeRoutingProfileRequest)
                .build());
    }

    /**
     * <p>
     * Describes a rule for the specified Amazon Connect instance.
     * </p>
     *
     * @param describeRuleRequest
     * @return A Java Future containing the result of the DescribeRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRuleResponse> describeRule(DescribeRuleRequest describeRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a rule for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRuleRequest#builder()}
     * </p>
     *
     * @param describeRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRuleResponse> describeRule(Consumer<DescribeRuleRequest.Builder> describeRuleRequest) {
        return describeRule(DescribeRuleRequest.builder().applyMutation(describeRuleRequest).build());
    }

    /**
     * <p>
     * Gets basic information about the security profile.
     * </p>
     * <p>
     * For information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the
     * security profile permissions, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile
     * permissions</a>.
     * </p>
     *
     * @param describeSecurityProfileRequest
     * @return A Java Future containing the result of the DescribeSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeSecurityProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSecurityProfileResponse> describeSecurityProfile(
            DescribeSecurityProfileRequest describeSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets basic information about the security profile.
     * </p>
     * <p>
     * For information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the
     * security profile permissions, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile
     * permissions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSecurityProfileRequest#builder()}
     * </p>
     *
     * @param describeSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeSecurityProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSecurityProfileResponse> describeSecurityProfile(
            Consumer<DescribeSecurityProfileRequest.Builder> describeSecurityProfileRequest) {
        return describeSecurityProfile(DescribeSecurityProfileRequest.builder().applyMutation(describeSecurityProfileRequest)
                .build());
    }

    /**
     * <p>
     * Gets details and status of a traffic distribution group.
     * </p>
     *
     * @param describeTrafficDistributionGroupRequest
     * @return A Java Future containing the result of the DescribeTrafficDistributionGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrafficDistributionGroupResponse> describeTrafficDistributionGroup(
            DescribeTrafficDistributionGroupRequest describeTrafficDistributionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details and status of a traffic distribution group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrafficDistributionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTrafficDistributionGroupRequest#builder()}
     * </p>
     *
     * @param describeTrafficDistributionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTrafficDistributionGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrafficDistributionGroupResponse> describeTrafficDistributionGroup(
            Consumer<DescribeTrafficDistributionGroupRequest.Builder> describeTrafficDistributionGroupRequest) {
        return describeTrafficDistributionGroup(DescribeTrafficDistributionGroupRequest.builder()
                .applyMutation(describeTrafficDistributionGroupRequest).build());
    }

    /**
     * <p>
     * Describes the specified user. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID in the
     * Amazon Connect console</a> (it’s the final part of the ARN). The console does not display the user IDs. Instead,
     * list the users and note the IDs provided in the output.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified user. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID in the
     * Amazon Connect console</a> (it’s the final part of the ARN). The console does not display the user IDs. Instead,
     * list the users and note the IDs provided in the output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Describes the specified hierarchy group.
     * </p>
     *
     * @param describeUserHierarchyGroupRequest
     * @return A Java Future containing the result of the DescribeUserHierarchyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserHierarchyGroupResponse> describeUserHierarchyGroup(
            DescribeUserHierarchyGroupRequest describeUserHierarchyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified hierarchy group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param describeUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeUserHierarchyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserHierarchyGroupResponse> describeUserHierarchyGroup(
            Consumer<DescribeUserHierarchyGroupRequest.Builder> describeUserHierarchyGroupRequest) {
        return describeUserHierarchyGroup(DescribeUserHierarchyGroupRequest.builder()
                .applyMutation(describeUserHierarchyGroupRequest).build());
    }

    /**
     * <p>
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     * </p>
     *
     * @param describeUserHierarchyStructureRequest
     * @return A Java Future containing the result of the DescribeUserHierarchyStructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeUserHierarchyStructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserHierarchyStructureResponse> describeUserHierarchyStructure(
            DescribeUserHierarchyStructureRequest describeUserHierarchyStructureRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserHierarchyStructureRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeUserHierarchyStructureRequest#builder()}
     * </p>
     *
     * @param describeUserHierarchyStructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeUserHierarchyStructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeUserHierarchyStructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserHierarchyStructureResponse> describeUserHierarchyStructure(
            Consumer<DescribeUserHierarchyStructureRequest.Builder> describeUserHierarchyStructureRequest) {
        return describeUserHierarchyStructure(DescribeUserHierarchyStructureRequest.builder()
                .applyMutation(describeUserHierarchyStructureRequest).build());
    }

    /**
     * <p>
     * Retrieves the view for the specified Amazon Connect instance and view identifier.
     * </p>
     * <p>
     * The view identifier can be supplied as a ViewId or ARN.
     * </p>
     * <p>
     * <code>&#36SAVED</code> needs to be supplied if a view is unpublished.
     * </p>
     * <p>
     * The view identifier can contain an optional qualifier, for example, <code>&lt;view-id&gt;:&#36SAVED</code>, which
     * is either an actual version number or an Amazon Connect managed qualifier <code>&#36SAVED | &#36LATEST</code>. If
     * it is not supplied, then <code>&#36LATEST</code> is assumed for customer managed views and an error is returned
     * if there is no published content available. Version 1 is assumed for Amazon Web Services managed views.
     * </p>
     *
     * @param describeViewRequest
     * @return A Java Future containing the result of the DescribeView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeViewResponse> describeView(DescribeViewRequest describeViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the view for the specified Amazon Connect instance and view identifier.
     * </p>
     * <p>
     * The view identifier can be supplied as a ViewId or ARN.
     * </p>
     * <p>
     * <code>&#36SAVED</code> needs to be supplied if a view is unpublished.
     * </p>
     * <p>
     * The view identifier can contain an optional qualifier, for example, <code>&lt;view-id&gt;:&#36SAVED</code>, which
     * is either an actual version number or an Amazon Connect managed qualifier <code>&#36SAVED | &#36LATEST</code>. If
     * it is not supplied, then <code>&#36LATEST</code> is assumed for customer managed views and an error is returned
     * if there is no published content available. Version 1 is assumed for Amazon Web Services managed views.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeViewRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeViewRequest#builder()}
     * </p>
     *
     * @param describeViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeViewRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>TooManyRequestsException Displayed when rate-related API limits are exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeViewResponse> describeView(Consumer<DescribeViewRequest.Builder> describeViewRequest) {
        return describeView(DescribeViewRequest.builder().applyMutation(describeViewRequest).build());
    }

    /**
     * <p>
     * Describes the specified vocabulary.
     * </p>
     *
     * @param describeVocabularyRequest
     * @return A Java Future containing the result of the DescribeVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVocabularyResponse> describeVocabulary(DescribeVocabularyRequest describeVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVocabularyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVocabularyRequest#builder()}
     * </p>
     *
     * @param describeVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVocabularyResponse> describeVocabulary(
            Consumer<DescribeVocabularyRequest.Builder> describeVocabularyRequest) {
        return describeVocabulary(DescribeVocabularyRequest.builder().applyMutation(describeVocabularyRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a workspace, including its configuration and metadata.
     * </p>
     *
     * @param describeWorkspaceRequest
     * @return A Java Future containing the result of the DescribeWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceResponse> describeWorkspace(DescribeWorkspaceRequest describeWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a workspace, including its configuration and metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkspaceRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DescribeWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceResponse> describeWorkspace(
            Consumer<DescribeWorkspaceRequest.Builder> describeWorkspaceRequest) {
        return describeWorkspace(DescribeWorkspaceRequest.builder().applyMutation(describeWorkspaceRequest).build());
    }

    /**
     * <p>
     * Removes the dataset ID associated with a given Amazon Connect instance.
     * </p>
     *
     * @param disassociateAnalyticsDataSetRequest
     * @return A Java Future containing the result of the DisassociateAnalyticsDataSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAnalyticsDataSetResponse> disassociateAnalyticsDataSet(
            DisassociateAnalyticsDataSetRequest disassociateAnalyticsDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the dataset ID associated with a given Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAnalyticsDataSetRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateAnalyticsDataSetRequest#builder()}
     * </p>
     *
     * @param disassociateAnalyticsDataSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateAnalyticsDataSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateAnalyticsDataSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAnalyticsDataSetResponse> disassociateAnalyticsDataSet(
            Consumer<DisassociateAnalyticsDataSetRequest.Builder> disassociateAnalyticsDataSetRequest) {
        return disassociateAnalyticsDataSet(DisassociateAnalyticsDataSetRequest.builder()
                .applyMutation(disassociateAnalyticsDataSetRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes access to integrated applications from Amazon Connect.
     * </p>
     *
     * @param disassociateApprovedOriginRequest
     * @return A Java Future containing the result of the DisassociateApprovedOrigin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateApprovedOriginResponse> disassociateApprovedOrigin(
            DisassociateApprovedOriginRequest disassociateApprovedOriginRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes access to integrated applications from Amazon Connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateApprovedOriginRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateApprovedOriginRequest#builder()}
     * </p>
     *
     * @param disassociateApprovedOriginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateApprovedOrigin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateApprovedOriginResponse> disassociateApprovedOrigin(
            Consumer<DisassociateApprovedOriginRequest.Builder> disassociateApprovedOriginRequest) {
        return disassociateApprovedOrigin(DisassociateApprovedOriginRequest.builder()
                .applyMutation(disassociateApprovedOriginRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     *
     * @param disassociateBotRequest
     * @return A Java Future containing the result of the DisassociateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateBotResponse> disassociateBot(DisassociateBotRequest disassociateBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateBotRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateBotRequest#builder()}
     * </p>
     *
     * @param disassociateBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateBotResponse> disassociateBot(
            Consumer<DisassociateBotRequest.Builder> disassociateBotRequest) {
        return disassociateBot(DisassociateBotRequest.builder().applyMutation(disassociateBotRequest).build());
    }

    /**
     * <p>
     * Removes the alias association between two email addresses in an Amazon Connect instance. After disassociation,
     * emails sent to the former alias email address are no longer forwarded to the primary email address. Both email
     * addresses continue to exist independently and can receive emails directly.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Department separation</b>: Remove alias relationships when splitting a consolidated support queue back into
     * separate department-specific queues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Email address retirement</b>: Cleanly remove forwarding relationships before decommissioning old email
     * addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Organizational restructuring</b>: Reconfigure email routing when business processes change and aliases are no
     * longer needed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Concurrent operations: This API uses distributed locking, so concurrent operations on the same email addresses
     * may be temporarily blocked.
     * </p>
     * </li>
     * <li>
     * <p>
     * Emails sent to the former alias address are still delivered directly to that address if it exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * You do not need to delete the email addresses after disassociation. Both addresses remain active independently.
     * </p>
     * </li>
     * <li>
     * <p>
     * After a successful disassociation, you can immediately create a new alias relationship with the same addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * 200 status means alias was successfully disassociated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>DisassociateEmailAddressAlias</code> does not return the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Details in the response about the email that was disassociated. The response returns an empty body.
     * </p>
     * </li>
     * <li>
     * <p>
     * The timestamp of when the disassociation occurred.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <p>
     * <b>Related operations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateEmailAddressAlias.html">
     * AssociateEmailAddressAlias</a>: Associates an email address alias with an existing email address in an Amazon
     * Connect instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html">
     * DescribeEmailAddress</a>: View current alias configurations for an email address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchEmailAddresses.html">
     * SearchEmailAddresses</a>: Find email addresses and their alias relationships across an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateEmailAddress.html">CreateEmailAddress</
     * a>: Create new email addresses that can participate in alias relationships.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteEmailAddress.html">DeleteEmailAddress</
     * a>: Remove email addresses (automatically removes any alias relationships).
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateEmailAddressMetadata.html">
     * UpdateEmailAddressMetadata</a>: Modify email address properties (does not affect alias relationships).
     * </p>
     * </li>
     * </ul>
     *
     * @param disassociateEmailAddressAliasRequest
     * @return A Java Future containing the result of the DisassociateEmailAddressAlias operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateEmailAddressAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateEmailAddressAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateEmailAddressAliasResponse> disassociateEmailAddressAlias(
            DisassociateEmailAddressAliasRequest disassociateEmailAddressAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the alias association between two email addresses in an Amazon Connect instance. After disassociation,
     * emails sent to the former alias email address are no longer forwarded to the primary email address. Both email
     * addresses continue to exist independently and can receive emails directly.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Department separation</b>: Remove alias relationships when splitting a consolidated support queue back into
     * separate department-specific queues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Email address retirement</b>: Cleanly remove forwarding relationships before decommissioning old email
     * addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Organizational restructuring</b>: Reconfigure email routing when business processes change and aliases are no
     * longer needed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Concurrent operations: This API uses distributed locking, so concurrent operations on the same email addresses
     * may be temporarily blocked.
     * </p>
     * </li>
     * <li>
     * <p>
     * Emails sent to the former alias address are still delivered directly to that address if it exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * You do not need to delete the email addresses after disassociation. Both addresses remain active independently.
     * </p>
     * </li>
     * <li>
     * <p>
     * After a successful disassociation, you can immediately create a new alias relationship with the same addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * 200 status means alias was successfully disassociated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>DisassociateEmailAddressAlias</code> does not return the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Details in the response about the email that was disassociated. The response returns an empty body.
     * </p>
     * </li>
     * <li>
     * <p>
     * The timestamp of when the disassociation occurred.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <p>
     * <b>Related operations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateEmailAddressAlias.html">
     * AssociateEmailAddressAlias</a>: Associates an email address alias with an existing email address in an Amazon
     * Connect instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html">
     * DescribeEmailAddress</a>: View current alias configurations for an email address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchEmailAddresses.html">
     * SearchEmailAddresses</a>: Find email addresses and their alias relationships across an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateEmailAddress.html">CreateEmailAddress</
     * a>: Create new email addresses that can participate in alias relationships.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteEmailAddress.html">DeleteEmailAddress</
     * a>: Remove email addresses (automatically removes any alias relationships).
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateEmailAddressMetadata.html">
     * UpdateEmailAddressMetadata</a>: Modify email address properties (does not affect alias relationships).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateEmailAddressAliasRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateEmailAddressAliasRequest#builder()}
     * </p>
     *
     * @param disassociateEmailAddressAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateEmailAddressAliasRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateEmailAddressAlias operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateEmailAddressAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateEmailAddressAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateEmailAddressAliasResponse> disassociateEmailAddressAlias(
            Consumer<DisassociateEmailAddressAliasRequest.Builder> disassociateEmailAddressAliasRequest) {
        return disassociateEmailAddressAlias(DisassociateEmailAddressAliasRequest.builder()
                .applyMutation(disassociateEmailAddressAliasRequest).build());
    }

    /**
     * <p>
     * Disassociates a connect resource from a flow.
     * </p>
     *
     * @param disassociateFlowRequest
     * @return A Java Future containing the result of the DisassociateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateFlowResponse> disassociateFlow(DisassociateFlowRequest disassociateFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a connect resource from a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFlowRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateFlowRequest#builder()}
     * </p>
     *
     * @param disassociateFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateFlowResponse> disassociateFlow(
            Consumer<DisassociateFlowRequest.Builder> disassociateFlowRequest) {
        return disassociateFlow(DisassociateFlowRequest.builder().applyMutation(disassociateFlowRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes the storage type configurations for the specified resource type and association ID.
     * </p>
     *
     * @param disassociateInstanceStorageConfigRequest
     * @return A Java Future containing the result of the DisassociateInstanceStorageConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateInstanceStorageConfigResponse> disassociateInstanceStorageConfig(
            DisassociateInstanceStorageConfigRequest disassociateInstanceStorageConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes the storage type configurations for the specified resource type and association ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param disassociateInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateInstanceStorageConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateInstanceStorageConfigResponse> disassociateInstanceStorageConfig(
            Consumer<DisassociateInstanceStorageConfigRequest.Builder> disassociateInstanceStorageConfigRequest) {
        return disassociateInstanceStorageConfig(DisassociateInstanceStorageConfigRequest.builder()
                .applyMutation(disassociateInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Remove the Lambda function from the dropdown options available in the relevant flow blocks.
     * </p>
     *
     * @param disassociateLambdaFunctionRequest
     * @return A Java Future containing the result of the DisassociateLambdaFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateLambdaFunctionResponse> disassociateLambdaFunction(
            DisassociateLambdaFunctionRequest disassociateLambdaFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Remove the Lambda function from the dropdown options available in the relevant flow blocks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLambdaFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateLambdaFunctionRequest#builder()}
     * </p>
     *
     * @param disassociateLambdaFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateLambdaFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateLambdaFunctionResponse> disassociateLambdaFunction(
            Consumer<DisassociateLambdaFunctionRequest.Builder> disassociateLambdaFunctionRequest) {
        return disassociateLambdaFunction(DisassociateLambdaFunctionRequest.builder()
                .applyMutation(disassociateLambdaFunctionRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     * </p>
     *
     * @param disassociateLexBotRequest
     * @return A Java Future containing the result of the DisassociateLexBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLexBot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateLexBotResponse> disassociateLexBot(DisassociateLexBotRequest disassociateLexBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLexBotRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateLexBotRequest#builder()}
     * </p>
     *
     * @param disassociateLexBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateLexBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLexBot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateLexBotResponse> disassociateLexBot(
            Consumer<DisassociateLexBotRequest.Builder> disassociateLexBotRequest) {
        return disassociateLexBot(DisassociateLexBotRequest.builder().applyMutation(disassociateLexBotRequest).build());
    }

    /**
     * <p>
     * Removes the flow association from a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important>
     *
     * @param disassociatePhoneNumberContactFlowRequest
     * @return A Java Future containing the result of the DisassociatePhoneNumberContactFlow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumberContactFlowResponse> disassociatePhoneNumberContactFlow(
            DisassociatePhoneNumberContactFlowRequest disassociatePhoneNumberContactFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the flow association from a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePhoneNumberContactFlowRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociatePhoneNumberContactFlowRequest#builder()}
     * </p>
     *
     * @param disassociatePhoneNumberContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociatePhoneNumberContactFlow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumberContactFlowResponse> disassociatePhoneNumberContactFlow(
            Consumer<DisassociatePhoneNumberContactFlowRequest.Builder> disassociatePhoneNumberContactFlowRequest) {
        return disassociatePhoneNumberContactFlow(DisassociatePhoneNumberContactFlowRequest.builder()
                .applyMutation(disassociatePhoneNumberContactFlowRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of quick connects from a queue.
     * </p>
     *
     * @param disassociateQueueQuickConnectsRequest
     * @return A Java Future containing the result of the DisassociateQueueQuickConnects operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateQueueQuickConnectsResponse> disassociateQueueQuickConnects(
            DisassociateQueueQuickConnectsRequest disassociateQueueQuickConnectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of quick connects from a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateQueueQuickConnectsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param disassociateQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateQueueQuickConnects operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateQueueQuickConnectsResponse> disassociateQueueQuickConnects(
            Consumer<DisassociateQueueQuickConnectsRequest.Builder> disassociateQueueQuickConnectsRequest) {
        return disassociateQueueQuickConnects(DisassociateQueueQuickConnectsRequest.builder()
                .applyMutation(disassociateQueueQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of queues from a routing profile.
     * </p>
     * <p>
     * Up to 10 queue references can be disassociated in a single API call. More than 10 queue references results in a
     * single call results in an InvalidParameterException.
     * </p>
     *
     * @param disassociateRoutingProfileQueuesRequest
     * @return A Java Future containing the result of the DisassociateRoutingProfileQueues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateRoutingProfileQueuesResponse> disassociateRoutingProfileQueues(
            DisassociateRoutingProfileQueuesRequest disassociateRoutingProfileQueuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of queues from a routing profile.
     * </p>
     * <p>
     * Up to 10 queue references can be disassociated in a single API call. More than 10 queue references results in a
     * single call results in an InvalidParameterException.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRoutingProfileQueuesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param disassociateRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateRoutingProfileQueues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateRoutingProfileQueuesResponse> disassociateRoutingProfileQueues(
            Consumer<DisassociateRoutingProfileQueuesRequest.Builder> disassociateRoutingProfileQueuesRequest) {
        return disassociateRoutingProfileQueues(DisassociateRoutingProfileQueuesRequest.builder()
                .applyMutation(disassociateRoutingProfileQueuesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the specified security key.
     * </p>
     *
     * @param disassociateSecurityKeyRequest
     * @return A Java Future containing the result of the DisassociateSecurityKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSecurityKeyResponse> disassociateSecurityKey(
            DisassociateSecurityKeyRequest disassociateSecurityKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the specified security key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSecurityKeyRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSecurityKeyRequest#builder()}
     * </p>
     *
     * @param disassociateSecurityKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateSecurityKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSecurityKeyResponse> disassociateSecurityKey(
            Consumer<DisassociateSecurityKeyRequest.Builder> disassociateSecurityKeyRequest) {
        return disassociateSecurityKey(DisassociateSecurityKeyRequest.builder().applyMutation(disassociateSecurityKeyRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates a security profile attached to a Q in Connect AI Agent Entity in an Amazon Connect instance.
     * </p>
     *
     * @param disassociateSecurityProfilesRequest
     * @return A Java Future containing the result of the DisassociateSecurityProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ConditionalOperationFailedException Request processing failed because dependent condition failed.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSecurityProfilesResponse> disassociateSecurityProfiles(
            DisassociateSecurityProfilesRequest disassociateSecurityProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a security profile attached to a Q in Connect AI Agent Entity in an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSecurityProfilesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateSecurityProfilesRequest#builder()}
     * </p>
     *
     * @param disassociateSecurityProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateSecurityProfilesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateSecurityProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ConditionalOperationFailedException Request processing failed because dependent condition failed.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSecurityProfilesResponse> disassociateSecurityProfiles(
            Consumer<DisassociateSecurityProfilesRequest.Builder> disassociateSecurityProfilesRequest) {
        return disassociateSecurityProfiles(DisassociateSecurityProfilesRequest.builder()
                .applyMutation(disassociateSecurityProfilesRequest).build());
    }

    /**
     * <p>
     * Disassociates an agent from a traffic distribution group. This API can be called only in the Region where the
     * traffic distribution group is created.
     * </p>
     *
     * @param disassociateTrafficDistributionGroupUserRequest
     * @return A Java Future containing the result of the DisassociateTrafficDistributionGroupUser operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateTrafficDistributionGroupUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTrafficDistributionGroupUserResponse> disassociateTrafficDistributionGroupUser(
            DisassociateTrafficDistributionGroupUserRequest disassociateTrafficDistributionGroupUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an agent from a traffic distribution group. This API can be called only in the Region where the
     * traffic distribution group is created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateTrafficDistributionGroupUserRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateTrafficDistributionGroupUserRequest#builder()}
     * </p>
     *
     * @param disassociateTrafficDistributionGroupUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateTrafficDistributionGroupUser operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceConflictException A resource already has that name.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateTrafficDistributionGroupUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTrafficDistributionGroupUserResponse> disassociateTrafficDistributionGroupUser(
            Consumer<DisassociateTrafficDistributionGroupUserRequest.Builder> disassociateTrafficDistributionGroupUserRequest) {
        return disassociateTrafficDistributionGroupUser(DisassociateTrafficDistributionGroupUserRequest.builder()
                .applyMutation(disassociateTrafficDistributionGroupUserRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of proficiencies from a user.
     * </p>
     *
     * @param disassociateUserProficienciesRequest
     * @return A Java Future containing the result of the DisassociateUserProficiencies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateUserProficienciesResponse> disassociateUserProficiencies(
            DisassociateUserProficienciesRequest disassociateUserProficienciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of proficiencies from a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateUserProficienciesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateUserProficienciesRequest#builder()}
     * </p>
     *
     * @param disassociateUserProficienciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateUserProficienciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateUserProficiencies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateUserProficienciesResponse> disassociateUserProficiencies(
            Consumer<DisassociateUserProficienciesRequest.Builder> disassociateUserProficienciesRequest) {
        return disassociateUserProficiencies(DisassociateUserProficienciesRequest.builder()
                .applyMutation(disassociateUserProficienciesRequest).build());
    }

    /**
     * <p>
     * Removes the association between a workspace and one or more users or routing profiles.
     * </p>
     *
     * @param disassociateWorkspaceRequest
     * @return A Java Future containing the result of the DisassociateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateWorkspaceResponse> disassociateWorkspace(
            DisassociateWorkspaceRequest disassociateWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between a workspace and one or more users or routing profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWorkspaceRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateWorkspaceRequest#builder()}
     * </p>
     *
     * @param disassociateWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DisassociateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateWorkspaceResponse> disassociateWorkspace(
            Consumer<DisassociateWorkspaceRequest.Builder> disassociateWorkspaceRequest) {
        return disassociateWorkspace(DisassociateWorkspaceRequest.builder().applyMutation(disassociateWorkspaceRequest).build());
    }

    /**
     * <p>
     * Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to
     * receive a new routed contact. Contacts can only be dismissed if they are in a <code>MISSED</code>,
     * <code>ERROR</code>, <code>ENDED</code>, or <code>REJECTED</code> state in the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">Agent Event Stream</a>.
     * </p>
     *
     * @param dismissUserContactRequest
     * @return A Java Future containing the result of the DismissUserContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DismissUserContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DismissUserContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DismissUserContactResponse> dismissUserContact(DismissUserContactRequest dismissUserContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to
     * receive a new routed contact. Contacts can only be dismissed if they are in a <code>MISSED</code>,
     * <code>ERROR</code>, <code>ENDED</code>, or <code>REJECTED</code> state in the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">Agent Event Stream</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DismissUserContactRequest.Builder} avoiding the
     * need to create one manually via {@link DismissUserContactRequest#builder()}
     * </p>
     *
     * @param dismissUserContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DismissUserContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DismissUserContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.DismissUserContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DismissUserContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DismissUserContactResponse> dismissUserContact(
            Consumer<DismissUserContactRequest.Builder> dismissUserContactRequest) {
        return dismissUserContact(DismissUserContactRequest.builder().applyMutation(dismissUserContactRequest).build());
    }

    /**
     * <p>
     * Evaluates values at the time of the request and returns them. It considers the request's timezone or the table's
     * timezone, in that order, when accessing time based tables. When a value is accessed, the accessor's identity and
     * the time of access are saved alongside the value to help identify values that are actively in use. The term
     * "Batch" is not included in the operation name since it does not meet all the criteria for a batch operation as
     * specified in Batch Operations: AWS API Standards.
     * </p>
     *
     * @param evaluateDataTableValuesRequest
     * @return A Java Future containing the result of the EvaluateDataTableValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.EvaluateDataTableValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/EvaluateDataTableValues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EvaluateDataTableValuesResponse> evaluateDataTableValues(
            EvaluateDataTableValuesRequest evaluateDataTableValuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates values at the time of the request and returns them. It considers the request's timezone or the table's
     * timezone, in that order, when accessing time based tables. When a value is accessed, the accessor's identity and
     * the time of access are saved alongside the value to help identify values that are actively in use. The term
     * "Batch" is not included in the operation name since it does not meet all the criteria for a batch operation as
     * specified in Batch Operations: AWS API Standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluateDataTableValuesRequest.Builder} avoiding
     * the need to create one manually via {@link EvaluateDataTableValuesRequest#builder()}
     * </p>
     *
     * @param evaluateDataTableValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the EvaluateDataTableValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.EvaluateDataTableValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/EvaluateDataTableValues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EvaluateDataTableValuesResponse> evaluateDataTableValues(
            Consumer<EvaluateDataTableValuesRequest.Builder> evaluateDataTableValuesRequest) {
        return evaluateDataTableValues(EvaluateDataTableValuesRequest.builder().applyMutation(evaluateDataTableValuesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #evaluateDataTableValues(software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.EvaluateDataTableValuesPublisher publisher = client.evaluateDataTableValuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.EvaluateDataTableValuesPublisher publisher = client.evaluateDataTableValuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #evaluateDataTableValues(software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param evaluateDataTableValuesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.EvaluateDataTableValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/EvaluateDataTableValues"
     *      target="_top">AWS API Documentation</a>
     */
    default EvaluateDataTableValuesPublisher evaluateDataTableValuesPaginator(
            EvaluateDataTableValuesRequest evaluateDataTableValuesRequest) {
        return new EvaluateDataTableValuesPublisher(this, evaluateDataTableValuesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #evaluateDataTableValues(software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.EvaluateDataTableValuesPublisher publisher = client.evaluateDataTableValuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.EvaluateDataTableValuesPublisher publisher = client.evaluateDataTableValuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #evaluateDataTableValues(software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluateDataTableValuesRequest.Builder} avoiding
     * the need to create one manually via {@link EvaluateDataTableValuesRequest#builder()}
     * </p>
     *
     * @param evaluateDataTableValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.EvaluateDataTableValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/EvaluateDataTableValues"
     *      target="_top">AWS API Documentation</a>
     */
    default EvaluateDataTableValuesPublisher evaluateDataTableValuesPaginator(
            Consumer<EvaluateDataTableValuesRequest.Builder> evaluateDataTableValuesRequest) {
        return evaluateDataTableValuesPaginator(EvaluateDataTableValuesRequest.builder()
                .applyMutation(evaluateDataTableValuesRequest).build());
    }

    /**
     * <p>
     * Provides a pre-signed URL for download of an approved attached file. This API also returns metadata about the
     * attached file. It will only return a downloadURL if the status of the attached file is <code>APPROVED</code>.
     * </p>
     *
     * @param getAttachedFileRequest
     *        Request to GetAttachedFile API.
     * @return A Java Future containing the result of the GetAttachedFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetAttachedFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAttachedFileResponse> getAttachedFile(GetAttachedFileRequest getAttachedFileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a pre-signed URL for download of an approved attached file. This API also returns metadata about the
     * attached file. It will only return a downloadURL if the status of the attached file is <code>APPROVED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAttachedFileRequest.Builder} avoiding the need
     * to create one manually via {@link GetAttachedFileRequest#builder()}
     * </p>
     *
     * @param getAttachedFileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetAttachedFileRequest.Builder} to create a request.
     *        Request to GetAttachedFile API.
     * @return A Java Future containing the result of the GetAttachedFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetAttachedFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAttachedFileResponse> getAttachedFile(
            Consumer<GetAttachedFileRequest.Builder> getAttachedFileRequest) {
        return getAttachedFile(GetAttachedFileRequest.builder().applyMutation(getAttachedFileRequest).build());
    }

    /**
     * <p>
     * Retrieves the contact attributes for the specified contact.
     * </p>
     *
     * @param getContactAttributesRequest
     * @return A Java Future containing the result of the GetContactAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetContactAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContactAttributesResponse> getContactAttributes(
            GetContactAttributesRequest getContactAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the contact attributes for the specified contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetContactAttributesRequest#builder()}
     * </p>
     *
     * @param getContactAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetContactAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContactAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetContactAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContactAttributesResponse> getContactAttributes(
            Consumer<GetContactAttributesRequest.Builder> getContactAttributesRequest) {
        return getContactAttributes(GetContactAttributesRequest.builder().applyMutation(getContactAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves the position of the contact in the queue.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for position in queue:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Understand the expected wait experience of a contact.
     * </p>
     * </li>
     * <li>
     * <p>
     * Inform customers of their position in queue and potentially offer a callback.
     * </p>
     * </li>
     * <li>
     * <p>
     * Make data-driven routing decisions between primary and alternative queues.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enhance queue visibility and leverage agent proficiencies to streamline contact routing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The only way to retrieve the position of the contact in queue is by using this API. You can't retrieve the
     * position by using flows and attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html">Position in queue</a>
     * metric in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     *
     * @param getContactMetricsRequest
     * @return A Java Future containing the result of the GetContactMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetContactMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContactMetricsResponse> getContactMetrics(GetContactMetricsRequest getContactMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the position of the contact in the queue.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for position in queue:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Understand the expected wait experience of a contact.
     * </p>
     * </li>
     * <li>
     * <p>
     * Inform customers of their position in queue and potentially offer a callback.
     * </p>
     * </li>
     * <li>
     * <p>
     * Make data-driven routing decisions between primary and alternative queues.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enhance queue visibility and leverage agent proficiencies to streamline contact routing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The only way to retrieve the position of the contact in queue is by using this API. You can't retrieve the
     * position by using flows and attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html">Position in queue</a>
     * metric in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link GetContactMetricsRequest#builder()}
     * </p>
     *
     * @param getContactMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetContactMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContactMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetContactMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContactMetricsResponse> getContactMetrics(
            Consumer<GetContactMetricsRequest.Builder> getContactMetricsRequest) {
        return getContactMetrics(GetContactMetricsRequest.builder().applyMutation(getContactMetricsRequest).build());
    }

    /**
     * <p>
     * Gets the real-time metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html">Metrics definitions</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * When you make a successful API request, you can expect the following metric values in the response:
     * </p>
     * <ol>
     * <li>
     * <p>
     * <b>Metric value is null</b>: The calculation cannot be performed due to divide by zero or insufficient data
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Metric value is a number (including 0) of defined type</b>: The number provided is the calculation result
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MetricResult list is empty</b>: The request cannot find any data in the system
     * </p>
     * </li>
     * </ol>
     * <p>
     * The following guidelines can help you work with the API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each dimension in the metric response must contain a value
     * </p>
     * </li>
     * <li>
     * <p>
     * Each item in MetricResult must include all requested metrics
     * </p>
     * </li>
     * <li>
     * <p>
     * If the response is slow due to large result sets, try these approaches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Add filters to reduce the amount of data returned
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note>
     *
     * @param getCurrentMetricDataRequest
     * @return A Java Future containing the result of the GetCurrentMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCurrentMetricDataResponse> getCurrentMetricData(
            GetCurrentMetricDataRequest getCurrentMetricDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the real-time metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html">Metrics definitions</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * When you make a successful API request, you can expect the following metric values in the response:
     * </p>
     * <ol>
     * <li>
     * <p>
     * <b>Metric value is null</b>: The calculation cannot be performed due to divide by zero or insufficient data
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Metric value is a number (including 0) of defined type</b>: The number provided is the calculation result
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MetricResult list is empty</b>: The request cannot find any data in the system
     * </p>
     * </li>
     * </ol>
     * <p>
     * The following guidelines can help you work with the API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each dimension in the metric response must contain a value
     * </p>
     * </li>
     * <li>
     * <p>
     * Each item in MetricResult must include all requested metrics
     * </p>
     * </li>
     * <li>
     * <p>
     * If the response is slow due to large result sets, try these approaches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Add filters to reduce the amount of data returned
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentMetricDataRequest#builder()}
     * </p>
     *
     * @param getCurrentMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCurrentMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCurrentMetricDataResponse> getCurrentMetricData(
            Consumer<GetCurrentMetricDataRequest.Builder> getCurrentMetricDataRequest) {
        return getCurrentMetricData(GetCurrentMetricDataRequest.builder().applyMutation(getCurrentMetricDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataPublisher publisher = client.getCurrentMetricDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataPublisher publisher = client.getCurrentMetricDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCurrentMetricDataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataPublisher getCurrentMetricDataPaginator(GetCurrentMetricDataRequest getCurrentMetricDataRequest) {
        return new GetCurrentMetricDataPublisher(this, getCurrentMetricDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataPublisher publisher = client.getCurrentMetricDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataPublisher publisher = client.getCurrentMetricDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentMetricDataRequest#builder()}
     * </p>
     *
     * @param getCurrentMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataPublisher getCurrentMetricDataPaginator(
            Consumer<GetCurrentMetricDataRequest.Builder> getCurrentMetricDataRequest) {
        return getCurrentMetricDataPaginator(GetCurrentMetricDataRequest.builder().applyMutation(getCurrentMetricDataRequest)
                .build());
    }

    /**
     * <p>
     * Gets the real-time active user data from the specified Amazon Connect instance.
     * </p>
     *
     * @param getCurrentUserDataRequest
     * @return A Java Future containing the result of the GetCurrentUserData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetCurrentUserData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCurrentUserDataResponse> getCurrentUserData(GetCurrentUserDataRequest getCurrentUserDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the real-time active user data from the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentUserDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentUserDataRequest#builder()}
     * </p>
     *
     * @param getCurrentUserDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCurrentUserData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetCurrentUserData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCurrentUserDataResponse> getCurrentUserData(
            Consumer<GetCurrentUserDataRequest.Builder> getCurrentUserDataRequest) {
        return getCurrentUserData(GetCurrentUserDataRequest.builder().applyMutation(getCurrentUserDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCurrentUserData(software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataPublisher publisher = client.getCurrentUserDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataPublisher publisher = client.getCurrentUserDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentUserData(software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCurrentUserDataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetCurrentUserData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentUserDataPublisher getCurrentUserDataPaginator(GetCurrentUserDataRequest getCurrentUserDataRequest) {
        return new GetCurrentUserDataPublisher(this, getCurrentUserDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCurrentUserData(software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataPublisher publisher = client.getCurrentUserDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataPublisher publisher = client.getCurrentUserDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentUserData(software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentUserDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentUserDataRequest#builder()}
     * </p>
     *
     * @param getCurrentUserDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetCurrentUserData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentUserDataPublisher getCurrentUserDataPaginator(
            Consumer<GetCurrentUserDataRequest.Builder> getCurrentUserDataRequest) {
        return getCurrentUserDataPaginator(GetCurrentUserDataRequest.builder().applyMutation(getCurrentUserDataRequest).build());
    }

    /**
     * <p>
     * Get the hours of operations with the effective override applied.
     * </p>
     *
     * @param getEffectiveHoursOfOperationsRequest
     * @return A Java Future containing the result of the GetEffectiveHoursOfOperations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetEffectiveHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetEffectiveHoursOfOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEffectiveHoursOfOperationsResponse> getEffectiveHoursOfOperations(
            GetEffectiveHoursOfOperationsRequest getEffectiveHoursOfOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the hours of operations with the effective override applied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEffectiveHoursOfOperationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetEffectiveHoursOfOperationsRequest#builder()}
     * </p>
     *
     * @param getEffectiveHoursOfOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetEffectiveHoursOfOperationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEffectiveHoursOfOperations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetEffectiveHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetEffectiveHoursOfOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEffectiveHoursOfOperationsResponse> getEffectiveHoursOfOperations(
            Consumer<GetEffectiveHoursOfOperationsRequest.Builder> getEffectiveHoursOfOperationsRequest) {
        return getEffectiveHoursOfOperations(GetEffectiveHoursOfOperationsRequest.builder()
                .applyMutation(getEffectiveHoursOfOperationsRequest).build());
    }

    /**
     * <p>
     * Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect
     * user which corresponds to the IAM credentials that were used to invoke this action.
     * </p>
     * <p>
     * For more information about how SAML sign-in works in Amazon Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/configure-saml.html ">Configure SAML with IAM for
     * Amazon Connect in the <i>Amazon Connect Administrator Guide</i>.</a>
     * </p>
     * <note>
     * <p>
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error
     * message similar to the following one appears:
     * </p>
     * <p>
     * <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code>
     * </p>
     * </note>
     *
     * @param getFederationTokenRequest
     * @return A Java Future containing the result of the GetFederationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>UserNotFoundException No user with the specified credentials was found in the Amazon Connect
     *         instance.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetFederationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFederationTokenResponse> getFederationToken(GetFederationTokenRequest getFederationTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect
     * user which corresponds to the IAM credentials that were used to invoke this action.
     * </p>
     * <p>
     * For more information about how SAML sign-in works in Amazon Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/configure-saml.html ">Configure SAML with IAM for
     * Amazon Connect in the <i>Amazon Connect Administrator Guide</i>.</a>
     * </p>
     * <note>
     * <p>
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error
     * message similar to the following one appears:
     * </p>
     * <p>
     * <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code>
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFederationTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetFederationTokenRequest#builder()}
     * </p>
     *
     * @param getFederationTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetFederationTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFederationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>UserNotFoundException No user with the specified credentials was found in the Amazon Connect
     *         instance.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetFederationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFederationTokenResponse> getFederationToken(
            Consumer<GetFederationTokenRequest.Builder> getFederationTokenRequest) {
        return getFederationToken(GetFederationTokenRequest.builder().applyMutation(getFederationTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves the flow associated for a given resource.
     * </p>
     *
     * @param getFlowAssociationRequest
     * @return A Java Future containing the result of the GetFlowAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFlowAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFlowAssociationResponse> getFlowAssociation(GetFlowAssociationRequest getFlowAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the flow associated for a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link GetFlowAssociationRequest#builder()}
     * </p>
     *
     * @param getFlowAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetFlowAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFlowAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFlowAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFlowAssociationResponse> getFlowAssociation(
            Consumer<GetFlowAssociationRequest.Builder> getFlowAssociationRequest) {
        return getFlowAssociation(GetFlowAssociationRequest.builder().applyMutation(getFlowAssociationRequest).build());
    }

    /**
     * <p>
     * Gets historical metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each historical metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html">Metrics definitions</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * We recommend using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html">GetMetricDataV2</a> API.
     * It provides more flexibility, features, and the ability to query longer time ranges than
     * <code>GetMetricData</code>. Use it to retrieve historical agent and contact metrics for the last 3 months, at
     * varying intervals. You can also use it to build custom dashboards to measure historical queue and agent
     * performance. For example, you can track the number of incoming contacts for the last 7 days, with data split by
     * day, to see how contact volume changed per day of the week.
     * </p>
     * </note>
     *
     * @param getMetricDataRequest
     * @return A Java Future containing the result of the GetMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMetricDataResponse> getMetricData(GetMetricDataRequest getMetricDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets historical metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each historical metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html">Metrics definitions</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * We recommend using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html">GetMetricDataV2</a> API.
     * It provides more flexibility, features, and the ability to query longer time ranges than
     * <code>GetMetricData</code>. Use it to retrieve historical agent and contact metrics for the last 3 months, at
     * varying intervals. You can also use it to build custom dashboards to measure historical queue and agent
     * performance. For example, you can track the number of incoming contacts for the last 7 days, with data split by
     * day, to see how contact volume changed per day of the week.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetMetricDataRequest#builder()}
     * </p>
     *
     * @param getMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetMetricDataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMetricDataResponse> getMetricData(Consumer<GetMetricDataRequest.Builder> getMetricDataRequest) {
        return getMetricData(GetMetricDataRequest.builder().applyMutation(getMetricDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataPublisher publisher = client.getMetricDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataPublisher publisher = client.getMetricDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.GetMetricDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.GetMetricDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)} operation.</b>
     * </p>
     *
     * @param getMetricDataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataPublisher getMetricDataPaginator(GetMetricDataRequest getMetricDataRequest) {
        return new GetMetricDataPublisher(this, getMetricDataRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataPublisher publisher = client.getMetricDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataPublisher publisher = client.getMetricDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.GetMetricDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.GetMetricDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetMetricDataRequest#builder()}
     * </p>
     *
     * @param getMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetMetricDataRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataPublisher getMetricDataPaginator(Consumer<GetMetricDataRequest.Builder> getMetricDataRequest) {
        return getMetricDataPaginator(GetMetricDataRequest.builder().applyMutation(getMetricDataRequest).build());
    }

    /**
     * <p>
     * Gets metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * <code>GetMetricDataV2</code> offers more features than <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html">GetMetricData</a>, the
     * previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to
     * filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve
     * historical data for the last 3 months, at varying intervals. It does not support agent queues.
     * </p>
     * <p>
     * For a description of the historical metrics that are supported by <code>GetMetricDataV2</code> and
     * <code>GetMetricData</code>, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html">Metrics definitions</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * When you make a successful API request, you can expect the following metric values in the response:
     * </p>
     * <ol>
     * <li>
     * <p>
     * <b>Metric value is null</b>: The calculation cannot be performed due to divide by zero or insufficient data
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Metric value is a number (including 0) of defined type</b>: The number provided is the calculation result
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MetricResult list is empty</b>: The request cannot find any data in the system
     * </p>
     * </li>
     * </ol>
     * <p>
     * The following guidelines can help you work with the API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each dimension in the metric response must contain a value
     * </p>
     * </li>
     * <li>
     * <p>
     * Each item in MetricResult must include all requested metrics
     * </p>
     * </li>
     * <li>
     * <p>
     * If the response is slow due to large result sets, try these approaches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Narrow the time range of your request
     * </p>
     * </li>
     * <li>
     * <p>
     * Add filters to reduce the amount of data returned
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note>
     *
     * @param getMetricDataV2Request
     * @return A Java Future containing the result of the GetMetricDataV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetMetricDataV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMetricDataV2Response> getMetricDataV2(GetMetricDataV2Request getMetricDataV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * <code>GetMetricDataV2</code> offers more features than <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html">GetMetricData</a>, the
     * previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to
     * filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve
     * historical data for the last 3 months, at varying intervals. It does not support agent queues.
     * </p>
     * <p>
     * For a description of the historical metrics that are supported by <code>GetMetricDataV2</code> and
     * <code>GetMetricData</code>, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html">Metrics definitions</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * When you make a successful API request, you can expect the following metric values in the response:
     * </p>
     * <ol>
     * <li>
     * <p>
     * <b>Metric value is null</b>: The calculation cannot be performed due to divide by zero or insufficient data
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Metric value is a number (including 0) of defined type</b>: The number provided is the calculation result
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MetricResult list is empty</b>: The request cannot find any data in the system
     * </p>
     * </li>
     * </ol>
     * <p>
     * The following guidelines can help you work with the API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each dimension in the metric response must contain a value
     * </p>
     * </li>
     * <li>
     * <p>
     * Each item in MetricResult must include all requested metrics
     * </p>
     * </li>
     * <li>
     * <p>
     * If the response is slow due to large result sets, try these approaches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Narrow the time range of your request
     * </p>
     * </li>
     * <li>
     * <p>
     * Add filters to reduce the amount of data returned
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataV2Request.Builder} avoiding the need
     * to create one manually via {@link GetMetricDataV2Request#builder()}
     * </p>
     *
     * @param getMetricDataV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetMetricDataV2Request.Builder} to create a request.
     * @return A Java Future containing the result of the GetMetricDataV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetMetricDataV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMetricDataV2Response> getMetricDataV2(
            Consumer<GetMetricDataV2Request.Builder> getMetricDataV2Request) {
        return getMetricDataV2(GetMetricDataV2Request.builder().applyMutation(getMetricDataV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getMetricDataV2(software.amazon.awssdk.services.connect.model.GetMetricDataV2Request)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Publisher publisher = client.getMetricDataV2Paginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Publisher publisher = client.getMetricDataV2Paginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.GetMetricDataV2Response>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.GetMetricDataV2Response response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricDataV2(software.amazon.awssdk.services.connect.model.GetMetricDataV2Request)} operation.</b>
     * </p>
     *
     * @param getMetricDataV2Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetMetricDataV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataV2Publisher getMetricDataV2Paginator(GetMetricDataV2Request getMetricDataV2Request) {
        return new GetMetricDataV2Publisher(this, getMetricDataV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getMetricDataV2(software.amazon.awssdk.services.connect.model.GetMetricDataV2Request)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Publisher publisher = client.getMetricDataV2Paginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Publisher publisher = client.getMetricDataV2Paginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connect.model.GetMetricDataV2Response>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connect.model.GetMetricDataV2Response response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricDataV2(software.amazon.awssdk.services.connect.model.GetMetricDataV2Request)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataV2Request.Builder} avoiding the need
     * to create one manually via {@link GetMetricDataV2Request#builder()}
     * </p>
     *
     * @param getMetricDataV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetMetricDataV2Request.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetMetricDataV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataV2Publisher getMetricDataV2Paginator(Consumer<GetMetricDataV2Request.Builder> getMetricDataV2Request) {
        return getMetricDataV2Paginator(GetMetricDataV2Request.builder().applyMutation(getMetricDataV2Request).build());
    }

    /**
     * <p>
     * Gets the prompt file.
     * </p>
     *
     * @param getPromptFileRequest
     * @return A Java Future containing the result of the GetPromptFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetPromptFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetPromptFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPromptFileResponse> getPromptFile(GetPromptFileRequest getPromptFileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the prompt file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPromptFileRequest.Builder} avoiding the need to
     * create one manually via {@link GetPromptFileRequest#builder()}
     * </p>
     *
     * @param getPromptFileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetPromptFileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPromptFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetPromptFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetPromptFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPromptFileResponse> getPromptFile(Consumer<GetPromptFileRequest.Builder> getPromptFileRequest) {
        return getPromptFile(GetPromptFileRequest.builder().applyMutation(getPromptFileRequest).build());
    }

    /**
     * <p>
     * Gets details about a specific task template in the specified Amazon Connect instance.
     * </p>
     *
     * @param getTaskTemplateRequest
     * @return A Java Future containing the result of the GetTaskTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTaskTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTaskTemplateResponse> getTaskTemplate(GetTaskTemplateRequest getTaskTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a specific task template in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaskTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetTaskTemplateRequest#builder()}
     * </p>
     *
     * @param getTaskTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTaskTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidParameterException One or more of the specified parameters are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTaskTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTaskTemplateResponse> getTaskTemplate(
            Consumer<GetTaskTemplateRequest.Builder> getTaskTemplateRequest) {
        return getTaskTemplate(GetTaskTemplateRequest.builder().applyMutation(getTaskTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the current traffic distribution for a given traffic distribution group.
     * </p>
     *
     * @param getTrafficDistributionRequest
     * @return A Java Future containing the result of the GetTrafficDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetTrafficDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTrafficDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrafficDistributionResponse> getTrafficDistribution(
            GetTrafficDistributionRequest getTrafficDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current traffic distribution for a given traffic distribution group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrafficDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link GetTrafficDistributionRequest#builder()}
     * </p>
     *
     * @param getTrafficDistributionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTrafficDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServiceException Request processing failed because of an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectAsyncClient.GetTrafficDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTrafficDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrafficDistributionResponse> getTrafficDistribution(
            Consumer<GetTrafficDistributionRequest.Builder> getTrafficDistributionRequest) {
        return getTrafficDistribution(GetTrafficDistributionRequest.builder().applyMutation(getTrafficDistributionRequest)
                .build());
    }

    /**
     * <p>
     * Imports a claimed phone number from an external service, such as Amazon Web Services End User Messaging, into an
     * Amazon Connect instance. You can call this API only in the same Amazon Web Services Region where the Amazon
     * Connect instance was created.
     * </p>
     * <important>
     * <p>
     * Call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber
     * </a> API to verify the status of a previous <code>ImportPhoneNumber</code> operation.
     * </p>
     * </important>
     * <p>
     * If you plan to claim or import numbers and then release numbers frequently, contact us for a service quota
     * exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until up to
     * 180 days past the oldest number released has expired.
     * </p>
     * <p>
     * By default you can claim or import and then release up to 200% of your maximum number of active phone numbers. If
     * you claim or import and then release phone numbers using the UI or API during a rolling 180 day cycle that
     * exceeds 200% of your phone number service level quota, you will be blocked from claiming or importing any more
     * numbers until 180 days past the oldest number released has expired.
     * </p>
     * <p>
     * For example, if you already have 99 claimed or imported numbers and a service level quota of 99 phone numbers,
     * and in any 180 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit.
     * At that point you are blocked from claiming any more numbers until you open an Amazon Web Services Support
     * ticket.
     * </p>
     *
     * @param importPhoneNumberRequest
     * @return A Java Future containing the result of the ImportPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally