/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Credentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Credentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Credentials.getter(Credentials::accessToken)).setter(Credentials.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<Instant> ACCESS_TOKEN_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Credentials.getter(Credentials::accessTokenExpiration)).setter(Credentials.setter(Builder::accessTokenExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTokenExpiration").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Credentials.getter(Credentials::refreshToken)).setter(Credentials.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()}).build();
    private static final SdkField<Instant> REFRESH_TOKEN_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Credentials.getter(Credentials::refreshTokenExpiration)).setter(Credentials.setter(Builder::refreshTokenExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshTokenExpiration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, ACCESS_TOKEN_EXPIRATION_FIELD, REFRESH_TOKEN_FIELD, REFRESH_TOKEN_EXPIRATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final Instant accessTokenExpiration;
    private final String refreshToken;
    private final Instant refreshTokenExpiration;

    private Credentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.accessTokenExpiration = builder.accessTokenExpiration;
        this.refreshToken = builder.refreshToken;
        this.refreshTokenExpiration = builder.refreshTokenExpiration;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public Instant accessTokenExpiration() {
        return this.accessTokenExpiration;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public Instant refreshTokenExpiration() {
        return this.refreshTokenExpiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTokenExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshTokenExpiration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)obj;
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.accessTokenExpiration(), other.accessTokenExpiration()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.refreshTokenExpiration(), other.refreshTokenExpiration());
    }

    public String toString() {
        return ToString.builder((String)"Credentials").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessTokenExpiration", (Object)this.accessTokenExpiration()).add("RefreshToken", (Object)(this.refreshToken() == null ? null : "*** Sensitive Data Redacted ***")).add("RefreshTokenExpiration", (Object)this.refreshTokenExpiration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "AccessTokenExpiration": {
                return Optional.ofNullable(clazz.cast(this.accessTokenExpiration()));
            }
            case "RefreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "RefreshTokenExpiration": {
                return Optional.ofNullable(clazz.cast(this.refreshTokenExpiration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Credentials, T> g) {
        return obj -> g.apply((Credentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessToken;
        private Instant accessTokenExpiration;
        private String refreshToken;
        private Instant refreshTokenExpiration;

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            this.accessToken(model.accessToken);
            this.accessTokenExpiration(model.accessTokenExpiration);
            this.refreshToken(model.refreshToken);
            this.refreshTokenExpiration(model.refreshTokenExpiration);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final Instant getAccessTokenExpiration() {
            return this.accessTokenExpiration;
        }

        @Override
        public final Builder accessTokenExpiration(Instant accessTokenExpiration) {
            this.accessTokenExpiration = accessTokenExpiration;
            return this;
        }

        public final void setAccessTokenExpiration(Instant accessTokenExpiration) {
            this.accessTokenExpiration = accessTokenExpiration;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public final Instant getRefreshTokenExpiration() {
            return this.refreshTokenExpiration;
        }

        @Override
        public final Builder refreshTokenExpiration(Instant refreshTokenExpiration) {
            this.refreshTokenExpiration = refreshTokenExpiration;
            return this;
        }

        public final void setRefreshTokenExpiration(Instant refreshTokenExpiration) {
            this.refreshTokenExpiration = refreshTokenExpiration;
        }

        public Credentials build() {
            return new Credentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Credentials> {
        public Builder accessToken(String var1);

        public Builder accessTokenExpiration(Instant var1);

        public Builder refreshToken(String var1);

        public Builder refreshTokenExpiration(Instant var1);
    }
}

