/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ParticipantType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantMetrics> {
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantId").getter(ParticipantMetrics.getter(ParticipantMetrics::participantId)).setter(ParticipantMetrics.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()}).build();
    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantType").getter(ParticipantMetrics.getter(ParticipantMetrics::participantTypeAsString)).setter(ParticipantMetrics.setter(Builder::participantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()}).build();
    private static final SdkField<Boolean> CONVERSATION_ABANDON_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConversationAbandon").getter(ParticipantMetrics.getter(ParticipantMetrics::conversationAbandon)).setter(ParticipantMetrics.setter(Builder::conversationAbandon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversationAbandon").build()}).build();
    private static final SdkField<Integer> MESSAGES_SENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MessagesSent").getter(ParticipantMetrics.getter(ParticipantMetrics::messagesSent)).setter(ParticipantMetrics.setter(Builder::messagesSent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagesSent").build()}).build();
    private static final SdkField<Integer> NUM_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumResponses").getter(ParticipantMetrics.getter(ParticipantMetrics::numResponses)).setter(ParticipantMetrics.setter(Builder::numResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResponses").build()}).build();
    private static final SdkField<Integer> MESSAGE_LENGTH_IN_CHARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MessageLengthInChars").getter(ParticipantMetrics.getter(ParticipantMetrics::messageLengthInChars)).setter(ParticipantMetrics.setter(Builder::messageLengthInChars)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageLengthInChars").build()}).build();
    private static final SdkField<Long> TOTAL_RESPONSE_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalResponseTimeInMillis").getter(ParticipantMetrics.getter(ParticipantMetrics::totalResponseTimeInMillis)).setter(ParticipantMetrics.setter(Builder::totalResponseTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResponseTimeInMillis").build()}).build();
    private static final SdkField<Long> MAX_RESPONSE_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxResponseTimeInMillis").getter(ParticipantMetrics.getter(ParticipantMetrics::maxResponseTimeInMillis)).setter(ParticipantMetrics.setter(Builder::maxResponseTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResponseTimeInMillis").build()}).build();
    private static final SdkField<Instant> LAST_MESSAGE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastMessageTimestamp").getter(ParticipantMetrics.getter(ParticipantMetrics::lastMessageTimestamp)).setter(ParticipantMetrics.setter(Builder::lastMessageTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMessageTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ID_FIELD, PARTICIPANT_TYPE_FIELD, CONVERSATION_ABANDON_FIELD, MESSAGES_SENT_FIELD, NUM_RESPONSES_FIELD, MESSAGE_LENGTH_IN_CHARS_FIELD, TOTAL_RESPONSE_TIME_IN_MILLIS_FIELD, MAX_RESPONSE_TIME_IN_MILLIS_FIELD, LAST_MESSAGE_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParticipantMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String participantId;
    private final String participantType;
    private final Boolean conversationAbandon;
    private final Integer messagesSent;
    private final Integer numResponses;
    private final Integer messageLengthInChars;
    private final Long totalResponseTimeInMillis;
    private final Long maxResponseTimeInMillis;
    private final Instant lastMessageTimestamp;

    private ParticipantMetrics(BuilderImpl builder) {
        this.participantId = builder.participantId;
        this.participantType = builder.participantType;
        this.conversationAbandon = builder.conversationAbandon;
        this.messagesSent = builder.messagesSent;
        this.numResponses = builder.numResponses;
        this.messageLengthInChars = builder.messageLengthInChars;
        this.totalResponseTimeInMillis = builder.totalResponseTimeInMillis;
        this.maxResponseTimeInMillis = builder.maxResponseTimeInMillis;
        this.lastMessageTimestamp = builder.lastMessageTimestamp;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final ParticipantType participantType() {
        return ParticipantType.fromValue(this.participantType);
    }

    public final String participantTypeAsString() {
        return this.participantType;
    }

    public final Boolean conversationAbandon() {
        return this.conversationAbandon;
    }

    public final Integer messagesSent() {
        return this.messagesSent;
    }

    public final Integer numResponses() {
        return this.numResponses;
    }

    public final Integer messageLengthInChars() {
        return this.messageLengthInChars;
    }

    public final Long totalResponseTimeInMillis() {
        return this.totalResponseTimeInMillis;
    }

    public final Long maxResponseTimeInMillis() {
        return this.maxResponseTimeInMillis;
    }

    public final Instant lastMessageTimestamp() {
        return this.lastMessageTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationAbandon());
        hashCode = 31 * hashCode + Objects.hashCode(this.messagesSent());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageLengthInChars());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResponseTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResponseTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastMessageTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantMetrics)) {
            return false;
        }
        ParticipantMetrics other = (ParticipantMetrics)obj;
        return Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.participantTypeAsString(), other.participantTypeAsString()) && Objects.equals(this.conversationAbandon(), other.conversationAbandon()) && Objects.equals(this.messagesSent(), other.messagesSent()) && Objects.equals(this.numResponses(), other.numResponses()) && Objects.equals(this.messageLengthInChars(), other.messageLengthInChars()) && Objects.equals(this.totalResponseTimeInMillis(), other.totalResponseTimeInMillis()) && Objects.equals(this.maxResponseTimeInMillis(), other.maxResponseTimeInMillis()) && Objects.equals(this.lastMessageTimestamp(), other.lastMessageTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantMetrics").add("ParticipantId", (Object)this.participantId()).add("ParticipantType", (Object)this.participantTypeAsString()).add("ConversationAbandon", (Object)this.conversationAbandon()).add("MessagesSent", (Object)this.messagesSent()).add("NumResponses", (Object)this.numResponses()).add("MessageLengthInChars", (Object)this.messageLengthInChars()).add("TotalResponseTimeInMillis", (Object)this.totalResponseTimeInMillis()).add("MaxResponseTimeInMillis", (Object)this.maxResponseTimeInMillis()).add("LastMessageTimestamp", (Object)this.lastMessageTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParticipantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "ParticipantType": {
                return Optional.ofNullable(clazz.cast(this.participantTypeAsString()));
            }
            case "ConversationAbandon": {
                return Optional.ofNullable(clazz.cast(this.conversationAbandon()));
            }
            case "MessagesSent": {
                return Optional.ofNullable(clazz.cast(this.messagesSent()));
            }
            case "NumResponses": {
                return Optional.ofNullable(clazz.cast(this.numResponses()));
            }
            case "MessageLengthInChars": {
                return Optional.ofNullable(clazz.cast(this.messageLengthInChars()));
            }
            case "TotalResponseTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.totalResponseTimeInMillis()));
            }
            case "MaxResponseTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.maxResponseTimeInMillis()));
            }
            case "LastMessageTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastMessageTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ParticipantId", PARTICIPANT_ID_FIELD);
        map.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
        map.put("ConversationAbandon", CONVERSATION_ABANDON_FIELD);
        map.put("MessagesSent", MESSAGES_SENT_FIELD);
        map.put("NumResponses", NUM_RESPONSES_FIELD);
        map.put("MessageLengthInChars", MESSAGE_LENGTH_IN_CHARS_FIELD);
        map.put("TotalResponseTimeInMillis", TOTAL_RESPONSE_TIME_IN_MILLIS_FIELD);
        map.put("MaxResponseTimeInMillis", MAX_RESPONSE_TIME_IN_MILLIS_FIELD);
        map.put("LastMessageTimestamp", LAST_MESSAGE_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantMetrics, T> g) {
        return obj -> g.apply((ParticipantMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String participantId;
        private String participantType;
        private Boolean conversationAbandon;
        private Integer messagesSent;
        private Integer numResponses;
        private Integer messageLengthInChars;
        private Long totalResponseTimeInMillis;
        private Long maxResponseTimeInMillis;
        private Instant lastMessageTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantMetrics model) {
            this.participantId(model.participantId);
            this.participantType(model.participantType);
            this.conversationAbandon(model.conversationAbandon);
            this.messagesSent(model.messagesSent);
            this.numResponses(model.numResponses);
            this.messageLengthInChars(model.messageLengthInChars);
            this.totalResponseTimeInMillis(model.totalResponseTimeInMillis);
            this.maxResponseTimeInMillis(model.maxResponseTimeInMillis);
            this.lastMessageTimestamp(model.lastMessageTimestamp);
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantType() {
            return this.participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final Boolean getConversationAbandon() {
            return this.conversationAbandon;
        }

        public final void setConversationAbandon(Boolean conversationAbandon) {
            this.conversationAbandon = conversationAbandon;
        }

        @Override
        public final Builder conversationAbandon(Boolean conversationAbandon) {
            this.conversationAbandon = conversationAbandon;
            return this;
        }

        public final Integer getMessagesSent() {
            return this.messagesSent;
        }

        public final void setMessagesSent(Integer messagesSent) {
            this.messagesSent = messagesSent;
        }

        @Override
        public final Builder messagesSent(Integer messagesSent) {
            this.messagesSent = messagesSent;
            return this;
        }

        public final Integer getNumResponses() {
            return this.numResponses;
        }

        public final void setNumResponses(Integer numResponses) {
            this.numResponses = numResponses;
        }

        @Override
        public final Builder numResponses(Integer numResponses) {
            this.numResponses = numResponses;
            return this;
        }

        public final Integer getMessageLengthInChars() {
            return this.messageLengthInChars;
        }

        public final void setMessageLengthInChars(Integer messageLengthInChars) {
            this.messageLengthInChars = messageLengthInChars;
        }

        @Override
        public final Builder messageLengthInChars(Integer messageLengthInChars) {
            this.messageLengthInChars = messageLengthInChars;
            return this;
        }

        public final Long getTotalResponseTimeInMillis() {
            return this.totalResponseTimeInMillis;
        }

        public final void setTotalResponseTimeInMillis(Long totalResponseTimeInMillis) {
            this.totalResponseTimeInMillis = totalResponseTimeInMillis;
        }

        @Override
        public final Builder totalResponseTimeInMillis(Long totalResponseTimeInMillis) {
            this.totalResponseTimeInMillis = totalResponseTimeInMillis;
            return this;
        }

        public final Long getMaxResponseTimeInMillis() {
            return this.maxResponseTimeInMillis;
        }

        public final void setMaxResponseTimeInMillis(Long maxResponseTimeInMillis) {
            this.maxResponseTimeInMillis = maxResponseTimeInMillis;
        }

        @Override
        public final Builder maxResponseTimeInMillis(Long maxResponseTimeInMillis) {
            this.maxResponseTimeInMillis = maxResponseTimeInMillis;
            return this;
        }

        public final Instant getLastMessageTimestamp() {
            return this.lastMessageTimestamp;
        }

        public final void setLastMessageTimestamp(Instant lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
        }

        @Override
        public final Builder lastMessageTimestamp(Instant lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
            return this;
        }

        public ParticipantMetrics build() {
            return new ParticipantMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantMetrics> {
        public Builder participantId(String var1);

        public Builder participantType(String var1);

        public Builder participantType(ParticipantType var1);

        public Builder conversationAbandon(Boolean var1);

        public Builder messagesSent(Integer var1);

        public Builder numResponses(Integer var1);

        public Builder messageLengthInChars(Integer var1);

        public Builder totalResponseTimeInMillis(Long var1);

        public Builder maxResponseTimeInMillis(Long var1);

        public Builder lastMessageTimestamp(Instant var1);
    }
}

